      SUBROUTINE REORDR
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE SWAPS ROWS IN THE COEFFICIENT MATRIX TO ELIMINATE
C SINGULARITY PROBLEMS WHICH CAN BE RECOGNIZED BY EXAMINING THE CIRCUIT
C TOPOLOGY.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C  ALLOCATE AND INITIALIZE STORAGE
C
      CALL GETM4(IRSWPF,NSTOP)
      CALL GETM4(IRSWPR,NSTOP)
      CALL GETM4(ICSWPF,NSTOP)
      CALL GETM4(ICSWPR,NSTOP)
C
      DO 10 I=1,NSTOP
      NODPLC(IRSWPF+I)=I
   10 CONTINUE
      CALL COPY4(NODPLC(IRSWPF+1),NODPLC(IRSWPR+1),NSTOP)
      CALL COPY4(NODPLC(IRSWPF+1),NODPLC(ICSWPF+1),NSTOP)
      CALL COPY4(NODPLC(IRSWPF+1),NODPLC(ICSWPR+1),NSTOP)
C
C  SWAP CURRENT EQUATIONS INTO ADMITTANCE PART OF EQUATION MATRIX
C
      NEXTV=1
C
C  FIND SUITABLE VOLTAGE SOURCE
C
  100 IF (NEXTV.GT.NUMVS) GO TO 600
      IX=0
      DO 130 I=NEXTV,NUMVS
      LOC=NODPLC(ISEQ+I)
      NODE=NODPLC(LOC+2)
      NFLAG=NODPLC(ISEQ1+I)
      IF (NFLAG.EQ.1) NODE=NODPLC(LOC+6)
      IF (NFLAG.EQ.2) NODE=NODPLC(LOC+7)
      IF (NODE.EQ.1) GO TO 110
      IF (NODPLC(NODEVS+NODE).GE.2) GO TO 110
      IF (NODPLC(NDIAG+NODE).EQ.0) GO TO 145
      IX=I
      LOCX=LOC
      NODEX=NODE
  110 NODE=NODPLC(LOC+3)
      IF (NFLAG.EQ.2) NODE=NODPLC(LOC+5)
      IF (NODE.EQ.1) GO TO 130
      IF (NODPLC(NODEVS+NODE).GE.2) GO TO 130
  120 IF (NODPLC(NDIAG+NODE).EQ.0) GO TO 145
      IX=I
      LOCX=LOC
      NODEX=NODE
  130 CONTINUE
      IF (IX.EQ.0) GO TO 590
      I=IX
      LOC=LOCX
      NODE=NODEX
C
C  RESEQUENCE VOLTAGE SOURCES
C
  145 NODPLC(ISEQ+I)=NODPLC(ISEQ+NEXTV)
      NODPLC(ISEQ+NEXTV)=LOC
      LTEMP=NODPLC(ISEQ1+I)
      NODPLC(ISEQ1+I)=NODPLC(ISEQ1+NEXTV)
      NODPLC(ISEQ1+NEXTV)=LTEMP
      IBR=NODPLC(NEQN+I)
      NODPLC(NEQN+I)=NODPLC(NEQN+NEXTV)
      NODPLC(NEQN+NEXTV)=IBR
      NODE1=NODPLC(LOC+2)
      IF (LTEMP.EQ.1) NODE1=NODPLC(LOC+6)
      IF (LTEMP.EQ.2) NODE1=NODPLC(LOC+7)
      NODE2=NODPLC(LOC+3)
      IF (LTEMP.EQ.1) NODE2=NODPLC(LOC+3)
      IF (LTEMP.EQ.2) NODE2=NODPLC(LOC+5)
      NODPLC(NODEVS+NODE1)=NODPLC(NODEVS+NODE1)-1
      NODPLC(NODEVS+NODE2)=NODPLC(NODEVS+NODE2)-1
C
C  SET ROW SWAP INDICATORS
C
      L=NODPLC(IRSWPF+IBR)
      J=NODPLC(IRSWPR+NODE)
      NODPLC(IRSWPF+J)=L
      NODPLC(IRSWPR+L)=J
      NODPLC(IRSWPF+IBR)=NODE
      NODPLC(IRSWPR+NODE)=IBR
      CALL SWAPIJ(IBR,J,1,1)
      NEXTV=NEXTV+1
      GO TO 100
C
C
C  ERROR - VOLTAGE-SOURCE/INDUCTOR/TRANSMISSION-LINE LOOP DETECTED ...
C
  590 NOGO=1
      WRITE (IOFILE,591)
C...  LOOP SHOULD HAVE BEEN DETECTED IN TOPCHK
  591 FORMAT('0*ABORT*:  SPICE INTERNAL ERROR IN REORDR'/)
C
C  FINISHED
C
  600 RETURN
      END
