      SUBROUTINE RUNCON(ID)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE PROCESSES RUN CONTROL CARDS.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CJE 3/15/83
      COMMON /CJE/ MAXTIM,ITIME,ICOST
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=DC 3/15/83
      COMMON /DC/ TCSTAR(2),TCSTOP(2),TCINCR(2),ICVFLG,ITCELM(2),KSSOP,
     1   KINEL,KIDIN,KOVAR,KIDOUT
C SPICE VERSION 2G.6  SCCSID=AC 3/15/83
      COMMON /AC/ FSTART,FSTOP,FINCR,SKW2,REFPRL,SPW2,JACFLG,IDFREQ,
     1   INOISE,NOSPRT,NOSOUT,NOSIN,IDIST,IDPRT
C SPICE VERSION 2G.6  SCCSID=TRAN 3/15/83
      COMMON /TRAN/ TSTEP,TSTOP,TSTART,DELMAX,TDMAX,FORFRE,JTRFLG
C SPICE VERSION 2G.6  SCCSID=OUTINF 3/15/83
      COMMON /OUTINF/ XINCR,STRING(15),XSTART,YVAR(8),ITAB(8),ITYPE(8),
     1   ILOGY(8),NPOINT,NUMOUT,KNTR,NUMDGT
C SPICE VERSION 2G.6  SCCSID=DEBUG 3/15/83
      COMMON/DEBUG/ IDEBUG(20)
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
      DIMENSION IPRNT(5),LIMITS(4),ITRLIM(6),CONTOL(6),DFLTS(4)
      EQUIVALENCE (IPRNT(1),IPRNTA),(LIMITS(1),LIMTIM),(ITRLIM(1),ITL1),
     1   (CONTOL(1),GMIN),(DFLTS(1),DEFL)
C
C
      INTEGER XXOR
C
C  PRINT/PLOT KEYWORDS
C
      DIMENSION AOPT(5)
      DIMENSION AOPTS(34),LSETOP(5)
      DIMENSION AIDE(20)
      DATA AOPT / 2HDC, 2HTR, 2HAC, 2HNO, 2HDI /
C
C  OPTIONS CARD KEYWORDS
C
      DATA AOPTS / 6HACCT  , 6HLIST  , 6HNOMOD , 6HNODE  , 6HOPTS  ,
     1             6HITL1  , 6HITL2  , 6HITL3  , 6HITL4  , 6HITL5  ,
     2             6HITL6  , 6HLIMTIM, 6HLIMPTS, 6HLVLCOD, 6HLVLTIM,
     3             6HGMIN  , 6HRELTOL, 6HABSTOL, 6HVNTOL , 6HTRTOL ,
     4             6HCHGTOL, 6HTNOM  , 6HNUMDGT, 6HMAXORD, 6HMETHOD,
     5             6HNOPAGE, 6HMU    , 6HCPTIME, 6HDEFL  , 6HDEFW  ,
     6             6HDEFAD , 6HDEFAS , 6HPIVTOL, 6HPIVREL /
      DATA LSETOP / 1 ,1, 0, 1, 1 /
C
C
      DATA AIDE / 1HR,1HC,1HL,1HK,1HG,1HE,1HF,1HH,1HV,1HI,1HD,1HQ,1HJ,
     1   1HM,1HS,1HY,1HT,4HTEMP,1HX,0.0D0 /
      DATA ALSDE,ALSOC,ALSLI / 3HDEC, 3HOCT, 3HLIN /
      DATA ATRAP, AGEAR, AUIC / 4HTRAP, 4HGEAR, 3HUIC /
      DATA ABLNK, AIN, AOUT / 1H , 2HIN, 3HOUT /
      DATA AMISS / 8H*MISSING /
      DATA AMS / 2HMS /
      DATA MINPTS / 1 /
C
C
      GO TO (1200,1100,1650,6000,6000,1700,6000,1600,1550,2000,3600,
     1   3500,6000,1750,1300,1500,1800,4000,4100,4200,5900), ID
C
C  DC TRANSFER CURVES
C
 1100 IFLD=2
      ICVFLG=0
      INUM=1
 1105 ANAM=VALUE(IFIELD+IFLD)
      IF(INUM.GT.2) GO TO 6000
      ID=0
      CALL MOVE(ANAM,2,ABLNK,1,7)
      IF (ANAM.EQ.AIDE(1)) ID=1
      IF (ANAM.EQ.AIDE(9)) ID=9
      IF (ANAM.EQ.AIDE(10)) ID=10
      IF (ANAM.EQ.AIDE(17)) GO TO 1108
      IF (ID.EQ.0) GO TO 1130
      CALL FIND(VALUE(IFIELD+IFLD),ID,ITCELM(INUM),0)
      GO TO 1115
 1108 ANAM=VALUE(IFIELD+IFLD)
      CALL MOVE(ANAM,5,ABLNK,1,4)
      IF (ANAM.NE.AIDE(18)) GO TO 1130
      ID=18
      CALL FIND(ANAM,ID,ITCELM(INUM),1)
      LOCS=NODPLC(ITCELM(INUM)+1)
      NODPLC(ITCELM(INUM)+2)=0
      VALUE(LOCS)=ANAM
      VALUE(LOCS+1)=VALUE(ITEMPS+1)
      CALL EXTMEM(ITEMPS,2)
      VALUE(ITEMPS+2)=VALUE(ITEMPS+1)
 1115 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1130
      TCSTAR(INUM)=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1130
      TCSTOP(INUM)=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1130
      TCINCR(INUM)=VALUE(IFIELD+IFLD)
      IF (TCINCR(INUM).EQ.0.0D0) GO TO 1130
      TEMP=(TCSTOP(INUM)-TCSTAR(INUM))/TCINCR(INUM)
      IF (TEMP.GT.0.0D0) GO TO 1110
      TCINCR(INUM)=-TCINCR(INUM)
      TEMP=-TEMP
 1110 ITEMP=IDINT(TEMP+0.5D0)+1
      ITEMP=MAX0(ITEMP,MINPTS)
      IF(INUM.EQ.1) ICVFLG=ITEMP
      IF(INUM.EQ.2) ICVFLG=ITEMP*ICVFLG
      IFLD=IFLD+1
      INUM=2
      IF(NODPLC(ICODE+IFLD)) 6000,1130,1105
 1130 WRITE (IOFILE,1131)
      ICVFLG=0
 1131 FORMAT('0WARNING:  MISSING PARAMETER(S) ... ANALYSIS OMITTED'/)
      GO TO 6000
C
C  FREQUENCY SPECIFICATION
C
 1200 IFLD=2
      IF (NODPLC(ICODE+2)) 1250,1250,1210
 1210 ID=0
      IF (VALUE(IFIELD+IFLD).EQ.ALSDE) ID=1
      IF (VALUE(IFIELD+IFLD).EQ.ALSOC) ID=2
      IF (VALUE(IFIELD+IFLD).EQ.ALSLI) ID=3
      IF (ID.EQ.0) GO TO 1240
      IDFREQ=ID
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1250
      IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 1250
      FINCR=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1250
      IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 1250
      FSTART=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1250
      IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 1250
      FSTOP=VALUE(IFIELD+IFLD)
      IF (FSTART.GT.FSTOP) GO TO 1260
      JACFLG=FINCR
      IF (IDFREQ-2) 1215,1220,1235
 1215 FINCR=DEXP(XLOG10/FINCR)
      GO TO 1230
 1220 FINCR=DEXP(XLOG2/FINCR)
 1230 TEMP=DLOG(FSTOP/FSTART)/DLOG(FINCR)
      JACFLG=IDINT(TEMP+0.999D0)+1
 1235 JACFLG=MAX0(JACFLG,MINPTS)
      IF (IDFREQ.NE.3) GO TO 6000
      FINCR=(FSTOP-FSTART)/DFLOAT(MAX0(JACFLG-1,1))
      GO TO 6000
 1240 WRITE (IOFILE,1241) VALUE(IFIELD+IFLD)
 1241 FORMAT('0WARNING:  UNKNOWN FREQUENCY FUNCTION:  ',A8,' ... ANALYS'
     1   ,'IS OMITTED'/)
      GO TO 6000
 1250 WRITE (IOFILE,1251)
 1251 FORMAT('0WARNING:  FREQUENCY PARAMETERS INCORRECT ... ANALYSIS OM'
     1   ,'ITTED'/)
      GO TO 6000
 1260 WRITE (IOFILE,1261)
 1261 FORMAT('0WARNING:  START FREQ > STOP FREQ ... ANALYSIS OMITTED'/)
      GO TO 6000
C
C  TIME SPECIFICATION
C
 1300 IFLD=2
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1430
      IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 1430
      TSTEP=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1430
      IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 1430
      TSTOP=VALUE(IFIELD+IFLD)
      TSTART=0.0D0
      DELMAX=TSTOP/50.0D0
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1310
      IF (VALUE(IFIELD+IFLD).LT.0.0D0) GO TO 1430
      TSTART=VALUE(IFIELD+IFLD)
      DELMAX=(TSTOP-TSTART)/50.0D0
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1310
      IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 1430
      DELMAX=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
 1310 IF (NODPLC(ICODE+IFLD).NE.1) GO TO 1320
      IF (VALUE(IFIELD+IFLD).NE.AUIC) GO TO 1320
      NOSOLV=1
 1320 IF (TSTART.GT.TSTOP) GO TO 1440
      IF (TSTEP.GT.TSTOP) GO TO 1430
      JTRFLG=IDINT((TSTOP-TSTART)/TSTEP+0.5D0)+1
      JTRFLG=MAX0(JTRFLG,MINPTS)
      GO TO 6000
 1430 WRITE (IOFILE,1431)
 1431 FORMAT('0WARNING:  TIME PARAMETERS INCORRECT ... ANALYSIS OMITTED'
     1   /)
      GO TO 6000
 1440 WRITE (IOFILE,1441)
 1441 FORMAT('0WARNING:  START TIME > STOP TIME ... ANALYSIS OMITTED'/)
      GO TO 6000
C
C  TRANSFER FUNCTION
C
 1500 KSSOP=1
      IFLD=2
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 1530
      CALL OUTDEF(IFLD,1,KOVAR,KTYPE)
      IF (IGOOF.NE.0) GO TO 1530
      IF (KTYPE.NE.1) GO TO 1540
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 1530
      ANAM=VALUE(IFIELD+IFLD)
      CALL MOVE(ANAM,2,ABLNK,1,7)
      ID=0
      IF (ANAM.EQ.AIDE(9)) ID=9
      IF (ANAM.EQ.AIDE(10)) ID=10
      IF (ID.EQ.0) GO TO 1530
      CALL FIND(VALUE(IFIELD+IFLD),ID,KINEL,0)
      KIDIN=ID
      GO TO 6000
 1530 KOVAR=0
      KINEL=0
      WRITE (IOFILE,1131)
      IGOOF=0
      GO TO 6000
 1540 KOVAR=0
      KINEL=0
      WRITE (IOFILE,1541)
 1541 FORMAT('0WARNING:  ILLEGAL OUTPUT VARIABLE ... ANALYSIS OMITTED'/)
      IGOOF=0
      GO TO 6000
C
C  OPERATING POINT
C
 1550 KSSOP=1
      GO TO 6000
C
C  NOISE ANALYSIS
C
 1600 IFLD=2
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 1610
      CALL OUTDEF(IFLD,2,NOSOUT,NTYPE)
      IF (IGOOF.NE.0) GO TO 1610
      IF (NTYPE.NE.1) GO TO 1610
      IF (NODPLC(NOSOUT+5).NE.0) GO TO 1610
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 1620
      ANAM=VALUE(IFIELD+IFLD)
      CALL MOVE(ANAM,2,ABLNK,1,7)
      ID=0
      IF (ANAM.EQ.AIDE(9)) ID=9
      IF (ANAM.EQ.AIDE(10)) ID=10
      IF (ID.EQ.0) GO TO 1620
      CALL FIND(VALUE(IFIELD+IFLD),ID,NOSIN,0)
      NOSPRT=0
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1605
      NOSPRT=DMAX1(0.0D0,VALUE(IFIELD+IFLD))
 1605 INOISE=1
      GO TO 6000
 1610 WRITE (IOFILE,1611)
 1611 FORMAT('0WARNING:  VOLTAGE OUTPUT UNRECOGNIZABLE ... ANALYSIS OMIT
     1TED'/)
      IGOOF=0
      GO TO 6000
 1620 WRITE (IOFILE,1621)
 1621 FORMAT('0WARNING:  INVALID INPUT SOURCE ... ANALYSIS OMITTED'/)
      IGOOF=0
      GO TO 6000
C
C  DISTORTION ANALYSIS
C
 1650 IFLD=2
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 1660
      ANAM=VALUE(IFIELD+IFLD)
      CALL MOVE(ANAM,2,ABLNK,1,7)
      IF (ANAM.NE.AIDE(1)) GO TO 1660
      CALL FIND(VALUE(IFIELD+IFLD),1,IDIST,0)
      IDPRT=0
      SKW2=0.9D0
      REFPRL=1.0D-3
      SPW2=1.0D0
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 6000
      IDPRT=VALUE(IFIELD+IFLD)
      IDPRT=MAX0(IDPRT,0)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 6000
      IF (VALUE(IFIELD+IFLD).LE.0.001D0) GO TO 1670
      IF (VALUE(IFIELD+IFLD).GT.0.999D0) GO TO 1670
      SKW2=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 6000
      IF (VALUE(IFIELD+IFLD).LT.1.0D-10) GO TO 1670
      REFPRL=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 6000
      IF (VALUE(IFIELD+IFLD).LT.0.001D0) GO TO 1670
      SPW2=VALUE(IFIELD+IFLD)
      GO TO 6000
 1660 WRITE (IOFILE,1661)
 1661 FORMAT('0WARNING:  DISTORTION LOAD RESISTOR MISSING ... ANALYSIS '
     1   ,'OMITTED'/)
      GO TO 6000
 1670 IDIST=0
      WRITE (IOFILE,1671)
 1671 FORMAT('0WARNING:  DISTORTION PARAMETERS INCORRECT ... ANALYSIS O'
     1   ,'MITTED'/)
      GO TO 6000
C
C  FOURIER ANALYSIS
C
 1700 IFLD=2
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 1720
      IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 1720
      FORFRE=VALUE(IFIELD+IFLD)
 1705 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 1710
      CALL OUTDEF(IFLD,2,LOCT,LTYPE)
      IF (IGOOF.NE.0) GO TO 1720
      IF (LTYPE.NE.1) GO TO 1720
      CALL EXTMEM(IFOUR,1)
      NFOUR=NFOUR+1
      NODPLC(IFOUR+NFOUR)=LOCT
      GO TO 1705
 1710 IF (NFOUR.GE.1) GO TO 6000
 1720 WRITE (IOFILE,1721)
 1721 FORMAT('0WARNING:  FOURIER PARAMETERS INCORRECT ... ANALYSIS OMIT'
     1   ,'TED'/)
      IGOOF=0
      NFOUR=0
      CALL CLRMEM(IFOUR)
      CALL GETM4(IFOUR,0)
      GO TO 6000
C
C  SENSITIVITY ANALYSIS
C
 1750 KSSOP=1
      IFLD=1
 1760 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 6000
      CALL OUTDEF(IFLD,1,LOCT,LTYPE)
      IF (IGOOF.NE.0) GO TO 1780
      IF (LTYPE.NE.1) GO TO 1780
      CALL EXTMEM(ISENS,1)
      NSENS=NSENS+1
      NODPLC(ISENS+NSENS)=LOCT
      GO TO 1760
 1780 WRITE (IOFILE,1781)
 1781 FORMAT('0WARNING:  OUTPUT VARIABLE UNRECOGNIZABLE ... ANALYSIS OM'
     1   ,'MITTED'/)
      IGOOF=0
      NSENS=0
      CALL CLRMEM(ISENS)
      CALL GETM4(ISENS,0)
      GO TO 6000
C
C  TEMPERATURE VARIATION
C
 1800 IFLD=1
 1810 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 6000
      IF (VALUE(IFIELD+IFLD).LE.-223.0D0) GO TO 1810
      CALL EXTMEM(ITEMPS,1)
      NUMTEM=NUMTEM+1
      VALUE(ITEMPS+NUMTEM)=VALUE(IFIELD+IFLD)
      GO TO 1810
C
C  OPTIONS CARD
C
 2000 IFLD=1
 2010 IFLD=IFLD+1
 2020 IF (NODPLC(ICODE+IFLD)) 6000,2010,2030
 2030 ANAM=VALUE(IFIELD+IFLD)
      DO 2040 I=1,5
      IF (ANAM.NE.AOPTS(I)) GO TO 2040
      IPRNT(I)=LSETOP(I)
      IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD).NE.0) GO TO 2020
      IPRNT(I)=VALUE(IFIELD+IFLD)
      GO TO 2010
 2040 CONTINUE
      IF (ANAM.EQ.AOPTS(25)) GO TO 2110
      IF (ANAM.EQ.AOPTS(26)) GO TO 2120
      IF (ANAM.EQ.AOPTS(27)) GO TO 2130
      IF (ANAM.EQ.AOPTS(28)) GO TO 2150
      IF (ANAM.EQ.AOPTS(33)) GO TO 2200
      IF (ANAM.EQ.AOPTS(34)) GO TO 2250
      IF (NODPLC(ICODE+IFLD+1).NE.0) GO TO 2510
      IFLD=IFLD+1
      AVAL=VALUE(IFIELD+IFLD)
      DO 2050 I=6,11
      IF (ANAM.NE.AOPTS(I)) GO TO 2050
      IF(AVAL.LE.0.0D0.AND.I.NE.10) GO TO 2510
      ITRLIM(I-5)=AVAL
      GO TO 2010
 2050 CONTINUE
      IF (AVAL.LE.0.0D0) GO TO 2510
      DO 2060 I=12,15
      IF (ANAM.NE.AOPTS(I)) GO TO 2060
      LIMITS(I-11)=AVAL
      GO TO 2010
 2060 CONTINUE
      DO 2070 I=16,21
      IF (ANAM.NE.AOPTS(I)) GO TO 2070
      CONTOL(I-15)=AVAL
      GO TO 2010
 2070 CONTINUE
      DO 2075 I=29,32
      IF(ANAM.NE.AOPTS(I)) GO TO 2075
      DFLTS(I-28)=AVAL
      GO TO 2010
 2075 CONTINUE
      IF (ANAM.NE.AOPTS(22)) GO TO 2080
      IF (AVAL.LT.-223.0D0) GO TO 2510
      VALUE(ITEMPS+1)=AVAL
      GO TO 2010
 2080 IF (ANAM.NE.AOPTS(23)) GO TO 2100
      NDIGIT=AVAL
      IF (NDIGIT.LE.7) GO TO 2090
      NDIGIT=7
      WRITE (IOFILE,2081) NDIGIT
 2081 FORMAT('0WARNING:  NUMDGT MAY NOT EXCEED',I2,
     1 ';  MAXIMUM VALUE ASSUMED'/)
 2090 NUMDGT=NDIGIT
      GO TO 2010
 2100 IF (ANAM.NE.AOPTS(24)) GO TO 2500
      N=AVAL
      IF ((N.LE.1).OR.(N.GE.7)) GO TO 2510
      MAXORD=N
      GO TO 2010
 2110 IF (NODPLC(ICODE+IFLD+1).NE.1) GO TO 2510
      IFLD=IFLD+1
      ANAM=VALUE(IFIELD+IFLD)
      CALL MOVE(ANAM,5,ABLNK,1,4)
      JTYPE=0
      IF (ANAM.EQ.ATRAP) JTYPE=1
      IF (ANAM.EQ.AGEAR) JTYPE=2
      IF (JTYPE.EQ.0) GO TO 2510
      METHOD=JTYPE
      GO TO 2010
 2120 NOPAGE=1
      GO TO 2010
 2130 IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD)) 6000,2140,2030
 2140 AVAL=VALUE(IFIELD+IFLD)
      IF(AVAL.LT.0.0D0.OR.AVAL.GT.0.500001D0) GO TO 2510
      XMU=AVAL
      GO TO 2010
 2150 IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD)) 6000,2160,2030
 2160 AVAL=VALUE(IFIELD+IFLD)
      MAXTIM=AVAL
      GO TO 2010
 2200 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 6000,2210,2030
 2210 AVAL=VALUE(IFIELD+IFLD)
      IF (AVAL.GT.1.0D0) GO TO 2510
      PIVTOL=AVAL
      GO TO 2010
 2250 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 6000,2260,2030
 2260 AVAL=VALUE(IFIELD+IFLD)
      IF (AVAL.GT.1.0D0) GO TO 2510
      PIVREL=AVAL
      GO TO 2010
 2500 WRITE (IOFILE,2501) ANAM
 2501 FORMAT('0WARNING:  UNKNOWN OPTION:  ',A8,' ... IGNORED'/)
      GO TO 2010
 2510 WRITE (IOFILE,2511) ANAM
 2511 FORMAT('0WARNING:  ILLEGAL VALUE SPECIFIED FOR OPTION:  ',A8,' ...
     1 IGNORED'/)
      GO TO 2010
C
C  PRINT CARD
C
 3500 IPRPL=0
      GO TO 3610
C
C  PLOT (AND PRINT) CARD
C
 3600 IPRPL=1
 3610 IFLD=2
 3613 ANAM=AMISS
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 3950
      ANAM=VALUE(IFIELD+IFLD)
      MS=0
      IF (XXOR(ANAM,AMS).NE.0) GO TO 3615
      MS=1
      IFLD=3
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 3970
      ANAM=VALUE(IFIELD+IFLD)
 3615 CALL MOVE(ANAM,3,ABLNK,1,6)
      DO 3620 I=1,5
      IF (ANAM.NE.AOPT(I)) GO TO 3620
      KTYPE=I
      GO TO 3630
 3620 CONTINUE
      GO TO 3950
 3630 ID=30+5*IPRPL+KTYPE
      CALL FIND(DFLOAT(JELCNT(ID)),ID,LOC,1)
      NODPLC(LOC+2)=KTYPE
      IF (MS.EQ.0) GO TO 3635
      LOCV=NODPLC(LOC+1)
      VALUE(LOCV)=0.0D0
 3635 NUMOUT=0
 3640 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 3900,3640,3650
 3650 CALL OUTDEF(IFLD,KTYPE,LOCT,LTYPE)
      IF (IGOOF.NE.0) GO TO 3970
      IF (IPRPL.EQ.0) GO TO 3660
      PLIMLO=0.0D0
      PLIMHI=0.0D0
      IF (NODPLC(ICODE+IFLD+1).NE.0) GO TO 3660
      IF (NODPLC(ICODE+IFLD+2).NE.0) GO TO 3660
      PLIMLO=VALUE(IFIELD+IFLD+1)
      PLIMHI=VALUE(IFIELD+IFLD+2)
      IFLD=IFLD+2
 3660 NUMOUT=NUMOUT+1
      LSPOT=LOC+2*NUMOUT+2
      NODPLC(LSPOT)=LOCT
      NODPLC(LSPOT+1)=LTYPE
      IF (IPRPL.EQ.0) GO TO 3670
      LOCV=NODPLC(LOC+1)
      LSPOT=LOCV+2*NUMOUT-1
      VALUE(LSPOT)=PLIMLO
      VALUE(LSPOT+1)=PLIMHI
 3670 IF (NUMOUT.EQ.8) GO TO 3900
      GO TO 3640
 3900 NODPLC(LOC+3)=NUMOUT
      IF (IPRPL.EQ.0) GO TO 6000
C...  PROPOGATE PLOT LIMITS DOWNWARD
      IF (NUMOUT.LE.1) GO TO 6000
      LOCV=NODPLC(LOC+1)
      LSPOT=LOCV+2*NUMOUT-1
      PLIMLO=VALUE(LSPOT)
      PLIMHI=VALUE(LSPOT+1)
      I=NUMOUT-1
 3905 LSPOT=LSPOT-2
      IF (VALUE(LSPOT).NE.0.0D0) GO TO 3910
      IF (VALUE(LSPOT+1).NE.0.0D0) GO TO 3910
      VALUE(LSPOT)=PLIMLO
      VALUE(LSPOT+1)=PLIMHI
      GO TO 3920
 3910 PLIMLO=VALUE(LSPOT)
      PLIMHI=VALUE(LSPOT+1)
 3920 I=I-1
      IF (I.GE.1) GO TO 3905
      GO TO 6000
C
C     ERRORS
C
 3950 WRITE (IOFILE,3951) ANAM
 3951 FORMAT('0WARNING:  UNKNOWN ANALYSIS MODE:  ',A8,
     1  ' ... LINE IGNORED'/)
      GO TO 6000
 3970 WRITE (IOFILE,3971)
 3971 FORMAT('0WARNING:  UNRECOGNIZABLE OUTPUT VARIABLE ON ABOVE LINE'/)
      IGOOF=0
      GO TO 3640
C
C  WIDTH CARD
C
 4000 IFLD=1
 4010 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 6000
 4020 ANAM=VALUE(IFIELD+IFLD)
      IF (ANAM.NE.AIN) GO TO 4040
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 6000,4030,4020
 4030 IWIDTH=VALUE(IFIELD+IFLD)
      IWIDTH=MIN0(MAX0(IWIDTH,10),120)
      GO TO 4010
 4040 IF (ANAM.NE.AOUT) GO TO 6000
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 6000,4050,4020
 4050 LWIDTH=DMIN1(DMAX1(VALUE(IFIELD+IFLD),72.0D0),132.0D0)
      GO TO 4010
C
C  NODESET STATEMENT
C
 4100 IFLD=1
 4110 IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD)) 6000,4120,4110
 4120 NODNUM=VALUE(IFIELD+IFLD)
      IF(NODNUM.LE.0) GO TO 4190
      IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD)) 4180,4130,4170
 4130 CALL SIZMEM(NSNOD,NIC)
      CALL EXTMEM(NSNOD,1)
      CALL EXTMEM(NSVAL,1)
      NODPLC(NSNOD+NIC+1)=NODNUM
      VALUE(NSVAL+NIC+1)=VALUE(IFIELD+IFLD)
      GO TO 4110
C
C  ERRORS ON .NODESET STATEMENT
C
 4170 WRITE(IOFILE,4171) VALUE(IFIELD+IFLD)
 4171 FORMAT('0WARNING: OUT-OF-PLACE NON-NUMERIC FIELD ',A8,
     1 ' SKIPPED'/)
      GO TO 4110
 4180 WRITE(IOFILE,4181) NODNUM
 4181 FORMAT('0WARNING: INITIAL VALUE MISSING FOR NODE ',I5,/)
      GO TO 6000
 4190 WRITE(IOFILE,4191)
 4191 FORMAT('0WARNING: ATTEMPT TO SPECIFY INITIAL CONDITION FOR ',
     1 'GROUND INGNORED',/)
      IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD)) 6000,4110,4170
C
C  INITIAL CONDITIONS STATEMENT
C
 4200 IFLD=1
 4210 IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD)) 6000,4220,4210
 4220 NODNUM=VALUE(IFIELD+IFLD)
      IF(NODNUM.LE.0) GO TO 4290
      IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD)) 4280,4230,4270
 4230 CALL SIZMEM(ICNOD,NIC)
      CALL EXTMEM(ICNOD,1)
      CALL EXTMEM(ICVAL,1)
      NODPLC(ICNOD+NIC+1)=NODNUM
      VALUE(ICVAL+NIC+1)=VALUE(IFIELD+IFLD)
      GO TO 4210
C
C  ERRORS ON .IC STATEMENT
C
 4270 WRITE(IOFILE,4271) VALUE(IFIELD+IFLD)
 4271 FORMAT('0WARNING: OUT-OF-PLACE NON-NUMERIC FIELD ',A8,
     1 ' SKIPPED'/)
      GO TO 4210
 4280 WRITE(IOFILE,4281) NODNUM
 4281 FORMAT('0WARNING: INITIAL VALUE MISSING FOR NODE ',I5,/)
      GO TO 6000
 4290 WRITE(IOFILE,4291)
 4291 FORMAT('0WARNING: ATTEMPT TO SPECIFY INITIAL CONDITION FOR ',
     1 'GROUND IGNORED',/)
      IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD)) 6000,4210,4270
C
C     :DEBUG: STATEMENT
C     SAMPLE DEBUG LINE: .:DEBUG: 5=3 17=5
C
 5900 IFLD=1
 5910 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 6000,5920,5910
 5920 INDEX=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 6000,5930,5910
 5930 IVAL=VALUE(IFIELD+IFLD)
      IF (INDEX.LT.1) GO TO 5910
      IF (INDEX.GT.20) GO TO 5910
      WRITE(IOFILE,5931) INDEX,IVAL
 5931 FORMAT(' *DEBUG*:  RUNCON - IDEBUG(',I2,') SET TO ',I10)
      IDEBUG(INDEX)=IVAL
      GO TO 5910
C
C  FINISHED
C
 6000 RETURN
      END
