      SUBROUTINE SCALE(XMIN,XMAX,N,XMINP,XMAXP,DEL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE DETERMINES THE 'OPTIMAL' SCALE TO USE FOR THE PLOT OF
C SOME OUTPUT VARIABLE.
C
C
C  ADAPTED FROM ALGORITHM 463 OF 'COLLECTED ALGORITHMS OF THE CACM'
C
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
      INTEGER XXOR
      DIMENSION VINT(5)
      DATA VINT / 1.0D0,2.0D0,5.0D0,10.0D0,20.0D0 /
      DATA EPS / 1.0D-12 /
C
C
C...  TRAP TOO-SMALL DATA SPREAD
C***********************************************************
C  TEMPORILY CHECK 'EQUALITY' THIS WAY
      IF(XMIN.EQ.0.0D0.AND.XMAX.EQ.0.0D0) GO TO 4
      IF(DABS((XMAX-XMIN)/DMAX1(DABS(XMIN),DABS(XMAX))).GE.1.0D-4)
     1  GO TO 10
    4 CONTINUE
      IF (XMIN.GE.0.0D0) GO TO 5
      XMAX=0.5D0*XMIN+EPS
      XMIN=1.5D0*XMIN-EPS
      GO TO 10
    5 XMAX=1.5D0*XMIN+EPS
      XMIN=0.5D0*XMIN-EPS
C...  FIND APPROXIMATE INTERVAL SIZE, NORMALIZED TO [1,10]
   10 A=(XMAX-XMIN)/DFLOAT(N)
      NAL=IDINT(DLOG10(A))
      IF (A.LT.1.0D0) NAL=NAL-1
      XFACT=DEXP(XLOG10*DFLOAT(NAL))
      B=A/XFACT
C...  FIND CLOSEST PERMISSIBLE INTERVAL SIZE
      DO 20 I=1,3
      IF (B.LT.(VINT(I)+EPS)) GO TO 30
   20 CONTINUE
      I=4
C...  COMPUTE INTERVAL SIZE
   30 DEL=VINT(I)*XFACT
      FM1=XMIN/DEL
      M1=FM1
      IF (FM1.LT.0.0D0) M1=M1-1
      IF (DABS(DFLOAT(M1)+1.0D0-FM1).LT.EPS) M1=M1+1
C...  COMPUTE NEW MAXIMUM AND MINIMUM LIMITS
      XMINP=DEL*DFLOAT(M1)
      FM2=XMAX/DEL
      M2=FM2+1.0D0
      IF (FM2.LT.(-1.0D0)) M2=M2-1
      IF (DABS(FM2+1.0D0-DFLOAT(M2)).LT.EPS) M2=M2-1
      XMAXP=DEL*DFLOAT(M2)
      NP=M2-M1
C...  CHECK WHETHER ANOTHER LOOP REQUIRED
      IF (NP.LE.N) GO TO 40
      I=I+1
      GO TO 30
C...  DO FINAL ADJUSTMENTS AND CORRECT FOR ROUNDOFF ERROR(S)
   40 NX=(N-NP)/2
      XMINP=DMIN1(XMIN,XMINP-DFLOAT(NX)*DEL)
      XMAXP=DMAX1(XMAX,XMINP+DFLOAT(N)*DEL)
      RETURN
      END
