      SUBROUTINE SENCAL
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE COMPUTES THE DC SENSITIVITIES OF CIRCUIT ELEMENTS
C WITH RESPECT TO USER SPECIFIED OUTPUTS.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=DC 3/15/83
      COMMON /DC/ TCSTAR(2),TCSTOP(2),TCINCR(2),ICVFLG,ITCELM(2),KSSOP,
     1   KINEL,KIDIN,KOVAR,KIDOUT
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DIMENSION STRING(5),SENTIT(4)
      DATA ALSRS,ALSIS,ALSN,ALSRB,ALSRC,ALSRE / 2HRS,2HIS,1HN,2HRB,2HRC,
     1   2HRE /
      DATA ALSBF,ALSISE,ALSBR,ALSISC,ALSNE,ALSNC,ALSIK,ALSIKR,ALSVA,ALSVB
     1   / 2HBF,3HISE,2HBR,3HISC,2HNE,2HNC,3HIKF,3HIKR,3HVAF,3HVAR/
      DATA ALSJS /2HJS/
      DATA SENTIT / 8HDC SENSI, 8HTIVITY A, 8HNALYSIS , 8H         /
      DATA ABLNK / 1H  /
C
C
      IF (KINEL.NE.0) GO TO 8
    4 CALL DCDCMP
C
C
    8 DO 1000 N=1,NSENS
C
C  PREPARE ADJOINT EXCITATION VECTOR
C
      CALL ZERO8(VALUE(LVN+1),NSTOP)
      LOCS=NODPLC(ISENS+N)
      IOUTYP=NODPLC(LOCS+5)
      IF (IOUTYP.NE.0) GO TO 10
C...  VOLTAGE OUTPUT
      IVOLTS=1
      NOPOSO=NODPLC(LOCS+2)
      NONEGO=NODPLC(LOCS+3)
      VALUE(LVN+NOPOSO)=-1.0D0
      VALUE(LVN+NONEGO)=+1.0D0
      GO TO 20
C...  CURRENT OUTPUT (THROUGH VOLTAGE SOURCE)
   10 IPTRO=NODPLC(LOCS+2)
      IVOLTS=0
      IPTRO=NODPLC(IPTRO+6)
      VALUE(LVN+IPTRO)=-1.0D0
C
C  OBTAIN ADJOINT SOLUTION BY DOING FORWARD/BACKWARD SUBSTITUTION ON
C  THE TRANSPOSE OF THE Y MATRIX
C
   20 CALL ASOL
      VALUE(LVN+1)=0.0D0
C
C  REAL SOLUTION IN LVNIM1;  ADJOINT SOLUTION IN LVN ...
C
      CALL TITLE(0,LWIDTH,1,SENTIT)
      IPOS=1
      CALL OUTNAM(LOCS,1,STRING,IPOS)
      CALL MOVE(STRING,IPOS,ABLNK,1,7)
      JSTOP=(IPOS+6)/8
      WRITE (IOFILE,36) (STRING(J),J=1,JSTOP)
   36 FORMAT('0DC SENSITIVITIES OF OUTPUT ',5A8)
      IF(IVOLTS.NE.0) WRITE (IOFILE,41)
      IF(IVOLTS.EQ.0) WRITE(IOFILE,42)
   41 FORMAT(1H0,8X,'ELEMENT',9X,'ELEMENT',7X,'ELEMENT',7X,'NORMALIZED'/
     1   10X,'NAME',12X,'VALUE',6X,'SENSITIVITY    SENSITIVITY'/35X,
     2   ' (VOLTS/UNIT) (VOLTS/PERCENT)'/)
   42 FORMAT(1H0,8X,'ELEMENT',9X,'ELEMENT',7X,'ELEMENT',7X,'NORMALIZED'/
     1   10X,'NAME',12X,'VALUE',6X,'SENSITIVITY    SENSITIVITY'/35X,
     2   '  (AMPS/UNIT)  (AMPS/PERCENT)'/)
C
C  RESISTORS
C
      LOC=LOCATE(1)
  100 IF ((LOC.EQ.0).OR.(NODPLC(LOC+8).NE.0)) GO TO 110
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      VAL=1.0D0/VALUE(LOCV+1)
      SENS=-(VALUE(LVNIM1+NODE1)-VALUE(LVNIM1+NODE2))*
     1      (VALUE(LVN   +NODE1)-VALUE(LVN   +NODE2))/(VAL*VAL)
      SENSN=VAL*SENS/100.0D0
      WRITE (IOFILE,101) VALUE(LOCV),VAL,SENS,SENSN
  101 FORMAT(10X,A8,4X,1PD10.3,5X,D10.3,5X,D10.3)
  105 LOC=NODPLC(LOC)
      GO TO 100
C
C  VOLTAGE SOURCES
C
  110 LOC=LOCATE(9)
  140 IF ((LOC.EQ.0).OR.(NODPLC(LOC+11).NE.0)) GO TO 150
      LOCV=NODPLC(LOC+1)
      VAL=VALUE(LOCV+1)
      IPTRV=NODPLC(LOC+6)
      SENS=-VALUE(LVN+IPTRV)
      SENSN=VAL*SENS/100.0D0
      WRITE (IOFILE,101) VALUE(LOCV),VAL,SENS,SENSN
  145 LOC=NODPLC(LOC)
      GO TO 140
C
C  CURRENT SOURCES
C
  150 LOC=LOCATE(10)
  160 IF ((LOC.EQ.0).OR.(NODPLC(LOC+6).NE.0)) GO TO 170
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      VAL=VALUE(LOCV+1)
      SENS=VALUE(LVN+NODE1)-VALUE(LVN+NODE2)
      SENSN=VAL*SENS/100.0D0
      WRITE (IOFILE,101) VALUE(LOCV),VAL,SENS,SENSN
  165 LOC=NODPLC(LOC)
      GO TO 160
C
C  DIODES
C
  170 LOC=LOCATE(11)
  180 IF ((LOC.EQ.0).OR.(NODPLC(LOC+16).NE.0)) GO TO 210
      LOCV=NODPLC(LOC+1)
      WRITE (IOFILE,181) VALUE(LOCV)
  181 FORMAT(1X,A8)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      LOCM=NODPLC(LOC+5)
      LOCM=NODPLC(LOCM+1)
      AREA=VALUE(LOCV+1)
C
C  SERIES RESISTANCE (RS)
C
      VAL=VALUE(LOCM+2)*AREA
      IF (VAL.NE.0.0D0) GO TO 190
      WRITE (IOFILE,186) ALSRS
  186 FORMAT(10X,A8,5X,2H0.,13X,2H0.,13X,2H0.)
      GO TO 200
  190 VAL=1.0D0/VAL
      SENS=-(VALUE(LVNIM1+NODE1)-VALUE(LVNIM1+NODE3))*
     1      (VALUE(LVN   +NODE1)-VALUE(LVN   +NODE3))/(VAL*VAL)
      SENSN=VAL*SENS/100.0D0
      WRITE (IOFILE,101) ALSRS,VAL,SENS,SENSN
C
C  INTRINSIC PARAMETERS
C
  200 CSAT=VALUE(LOCM+1)*AREA
      XN=VALUE(LOCM+3)
      VBE=VALUE(LVNIM1+NODE3)-VALUE(LVNIM1+NODE2)
      VTE=XN*VT
      EVBE=DEXP(VBE/VTE)
      VABE=VALUE(LVN+NODE3)-VALUE(LVN+NODE2)
C
C  SATURATION CURRENT (IS)
C
      SENS=VABE*(EVBE-1.0D0)
      SENSN=CSAT*SENS/100.0D0
      WRITE (IOFILE,101) ALSIS,CSAT,SENS,SENSN
C
C  IDEALITY FACTOR (N)
C
      SENS=-VABE*(CSAT/XN)*(VBE/VTE)*EVBE
      IF (DABS(SENS).LT.1.0D-30) SENS=0.0D0
      SENSN=XN*SENS/100.0D0
      WRITE (IOFILE,101) ALSN,XN,SENS,SENSN
  205 LOC=NODPLC(LOC)
      GO TO 180
C
C  BIPOLAR JUNCTION TRANSISTORS
C
  210 LOC=LOCATE(12)
  220 IF ((LOC.EQ.0).OR.(NODPLC(LOC+36).NE.0)) GO TO 1000
      LOCV=NODPLC(LOC+1)
      WRITE (IOFILE,181) VALUE(LOCV)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      NODE4=NODPLC(LOC+5)
      NODE5=NODPLC(LOC+6)
      NODE6=NODPLC(LOC+7)
      LOCM=NODPLC(LOC+8)
      TYPE=NODPLC(LOCM+2)
      LOCM=NODPLC(LOCM+1)
      LOCT=LX0+NODPLC(LOC+22)
      AREA=VALUE(LOCV+1)
C
C  BASE RESISTANCE (RB)
C
      VAL=VALUE(LOCT+16)
      IF (VAL.NE.0.0D0) GO TO 230
      WRITE (IOFILE,186) ALSRB
      GO TO 240
  230 VAL=1.0D0/VAL
      SENS=-(VALUE(LVNIM1+NODE2)-VALUE(LVNIM1+NODE5))*
     1      (VALUE(LVN   +NODE2)-VALUE(LVN   +NODE5))/(VAL*VAL)
      SENSN=VAL*SENS/100.0D0
      WRITE (IOFILE,101) ALSRB,VAL,SENS,SENSN
C
C  COLLECTOR RESISTANCE (RC)
C
  240 VAL=VALUE(LOCM+20)*AREA
      IF (VAL.NE.0.0D0) GO TO 250
      WRITE (IOFILE,186) ALSRC
      GO TO 260
  250 VAL=1.0D0/VAL
      SENS=-(VALUE(LVNIM1+NODE1)-VALUE(LVNIM1+NODE4))*
     1      (VALUE(LVN   +NODE1)-VALUE(LVN   +NODE4))/(VAL*VAL)
      SENSN=VAL*SENS/100.0D0
      WRITE (IOFILE,101) ALSRC,VAL,SENS,SENSN
C
C  EMITTER RESISTANCE (RE)
C
  260 VAL=VALUE(LOCM+19)*AREA
      IF (VAL.NE.0.0D0) GO TO 270
      WRITE (IOFILE,186) ALSRE
      GO TO 280
  270 VAL=1.0D0/VAL
      SENS=-(VALUE(LVNIM1+NODE3)-VALUE(LVNIM1+NODE6))*
     1      (VALUE(LVN   +NODE3)-VALUE(LVN   +NODE6))/(VAL*VAL)
      SENSN=VAL*SENS/100.0D0
      WRITE (IOFILE,101) ALSRE,VAL,SENS,SENSN
C
C  INTRINSIC PARAMETERS
C
  280 BF=VALUE(LOCM+2)
      BR=VALUE(LOCM+8)
      CSAT=VALUE(LOCM+1)*AREA
      OVA=VALUE(LOCM+4)
      OVB=VALUE(LOCM+10)
      OIK=VALUE(LOCM+5)/AREA
      ISE=VALUE(LOCM+6)*AREA
      XNE=VALUE(LOCM+7)
      VTE=XNE*VT
      OIKR=VALUE(LOCM+11)/AREA
      ISC=VALUE(LOCM+12)*AREA
      XNC=VALUE(LOCM+13)
      VTC=XNC*VT
      VBE=TYPE*(VALUE(LVNIM1+NODE5)-VALUE(LVNIM1+NODE6))
      VBC=TYPE*(VALUE(LVNIM1+NODE5)-VALUE(LVNIM1+NODE4))
      VABE=TYPE*(VALUE(LVN+NODE5)-VALUE(LVN+NODE6))
      VABC=TYPE*(VALUE(LVN+NODE5)-VALUE(LVN+NODE4))
      VACE=VABE-VABC
      IF (VBE.LE.-VT) GO TO 320
      EVBE=DEXP(VBE/VT/VALUE(LOCM+3))
      CBE=CSAT*(EVBE-1.0D0)
      GBE=CSAT*EVBE/VT/VALUE(LOCM+3)
      IF (ISE.NE.0.0D0) GO TO 310
      CBEN=0.0D0
      GBEN=0.0D0
      GO TO 350
  310 EVBEN=DEXP(VBE/VTE)
      CBEN=ISE     *(EVBEN-1.0D0)
      GBEN=ISE     *EVBEN/VTE
      GO TO 350
  320 GBE=-CSAT/VBE
      CBE=GBE*VBE
      GBEN=-ISE/VBE
      CBEN=GBEN*VBE
  350 IF (VBC.LE.-VT) GO TO 370
      EVBC=DEXP(VBC/VT/VALUE(LOCM+9))
      CBC=CSAT*(EVBC-1.0D0)
      GBC=CSAT*EVBC/VT/VALUE(LOCM+9)
      IF (ISC.NE.0.0D0) GO TO 360
      CBCN=0.0D0
      GBCN=0.0D0
      GO TO 400
  360 EVBCN=DEXP(VBC/VTC)
      CBCN=ISC     *(EVBCN-1.0D0)
      GBCN=ISC     *EVBCN/VTC
      GO TO 400
  370 GBC=-CSAT/VBC
      CBC=GBC*VBC
      GBCN=-ISC/VBC
      CBCN=GBCN*VBC
  400 Q1=1.0D0/(1.0D0-OVA*VBC-OVB*VBE)
      Q2=OIK*CBE+OIKR*CBC
      SQARG=DSQRT(1.0D0+4.0D0*Q2)
      QB=Q1*(1.0D0+SQARG)/2.0D0
      DQB=(CBE-CBC)/(QB*QB)
      SQARG=DSQRT(1.0D0+4.0D0*Q2)
      DQ1=DQB*(1.0D0+SQARG)/2.0D0
      DQ2=Q1*DQB/SQARG
C
C  COMPUTE SENSITIVITIES
C
C...  BF
      SENS=-VABE*CBE/BF/BF
      SENSN=BF*SENS/100.0D0
      WRITE (IOFILE,101) ALSBF,BF,SENS,SENSN
C...  ISE
      IF (ISE.NE.0.0D0) GO TO 430
      WRITE (IOFILE,186) ALSISE
      GO TO 440
  430 SENS=VABE*CBEN/ISE
      SENSN=ISE*SENS/100.0D0
      WRITE (IOFILE,101) ALSISE,ISE,SENS,SENSN
C...  BR
  440 SENS=-VABC*CBC/BR/BR
      SENSN=BR*SENS/100.0D0
      WRITE (IOFILE,101) ALSBR,BR,SENS,SENSN
C...  ISC
      IF (ISC.NE.0.0D0) GO TO 450
      WRITE (IOFILE,186) ALSISC
      GO TO 460
  450 SENS=VABC*CBCN/ISC
      SENSN=ISC*SENS/100.0D0
      WRITE (IOFILE,101) ALSISC,ISC,SENS,SENSN
C...  IS
  460 SENS=(VABE*(CBE/BF)+VABC*(CBC/BR)
     1   +VACE*(DQB*QB-DQ2*Q2))/CSAT
      SENSN=CSAT*SENS/100.0D0
      WRITE (IOFILE,101) ALSJS,CSAT,SENS,SENSN
C...  NE
      SENS=-VABE*GBEN*VBE/XNE
      SENSN=XNE*SENS/100.0D0
      WRITE (IOFILE,101) ALSNE,XNE,SENS,SENSN
C...  NC
      SENS=-VABC*GBCN*VBC/XNC
      SENSN=XNC*SENS/100.0D0
      WRITE (IOFILE,101) ALSNC,XNC,SENS,SENSN
C...  IK
      IF (OIK.NE.0.0D0) GO TO 470
      WRITE (IOFILE,186) ALSIK
      GO TO 480
  470 VAL=1.0D0/OIK
      SENS=VACE*DQ2*CBE/(VAL*VAL)
      SENSN=VAL*SENS/100.0D0
      WRITE (IOFILE,101) ALSIK,VAL,SENS,SENSN
C...  IKR
  480 IF (OIKR.NE.0.0D0) GO TO 490
      WRITE (IOFILE,186) ALSIKR
      GO TO 500
  490 VAL=1.0D0/OIKR
      SENS=VACE*DQ2*CBC/(VAL*VAL)
      SENSN=VAL*SENS/100.0D0
      WRITE (IOFILE,101) ALSIKR,VAL,SENS,SENSN
C...  VA
  500 IF (OVA.NE.0.0D0) GO TO 510
      WRITE (IOFILE,186) ALSVA
      GO TO 520
  510 VA=1.0D0/OVA
      SENS=VACE*Q1*Q1*DQ1*VBC/(VA*VA)
      SENSN=VA*SENS/100.0D0
      WRITE (IOFILE,101) ALSVA,VA,SENS,SENSN
C...  VB
  520 IF (OVB.NE.0.0D0) GO TO 530
      WRITE (IOFILE,186) ALSVB
      GO TO 540
  530 VB=1.0D0/OVB
      SENS=VACE*Q1*Q1*DQ1*VBE/(VB*VB)
      SENSN=VB*SENS/100.0D0
      WRITE (IOFILE,101) ALSVB,VB,SENS,SENSN
C
C
  540 LOC=NODPLC(LOC)
      GO TO 220
C
C  FINISHED
C
 1000 CONTINUE
      RETURN
      END
