      SUBROUTINE SETMEM(IPNTR,KSIZE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE PERFORMS DYNAMIC MEMORY MANAGEMENT.  IT IS USED IN
C     SPICE2, AND USEABLE IN ANY PROGRAM.
C
C     MEMORY IS MANAGED WITHIN AN ARRAY SELECTED BY THE CALLING PROGRAM.
C     ONE MAY EITHER DIMENSION THIS ARRAY TO THE 'MAXMEM' SIZE, OR MORE
C     DESIRABLY, FIND THE ADDRESS OF THE FIRST AVAILABLE WORD OF MEMORY
C     ABOVE YOUR PROGRAM, AND DIMENSION YOUR ARRAY TO '1'.  PASSING THE
C     ADDRESS OF THE FIRST DATA WORD AVAILABLE PERMITS THE MANAGER TO
C     USE 'ILLEGAL' INDICES INTO THE DATA AREA.
C
C     THIS ROUTINE MUST HAVE ACCESS TO AN INTEGER FUNCTION CALLED 'LOCF'
C     WHICH RETURNS THE ADDRESS OF ITS ARGUMENT.  ADDRESSES AS USED BY THIS
C     PROGRAM REFER TO 'INTEGER' ADDRESSES, NOT BYTE ADDRESSES.
C
C ENTRY POINTS:
C      SETMEM - SET INITIAL MEMORY
C      GETM4  - GET BLOCK FOR TABLE OF INTEGERS
C      GETM8  - GET BLOCK FOR TABLE OF FLOATING POINT VARIABLES
C      GETM16 - GET BLOCK FOR TABLE OF COMPLEX VARIABLES
C      RELMEM - RELEASE PART OF BLOCK
C      EXTMEM - EXTEND SIZE OF EXISTING BLOCK
C      SIZMEM - DETERMINE SIZE OF EXISTING BLOCK
C      CLRMEM - RELEASE BLOCK
C      PTRMEM - RESET MEMORY POINTER
C      CRUNCH - FORCE MEMORY COMPACTION
C      AVLM4  - AMOUNT OF SPACE AVAILABLE (INTEGERS)
C      AVLM8  - AMOUNT OF SPACE AVAILABLE (REAL)
C      AVLM16 - AMOUNT OF SPACE AVAILABLE (COMPLEX)
C
C CALLING SEQUENCES:
C      CALL SETMEM(IMEM(1),MAXMEM)
C      CALL SETMEM(IMEM(1),MAXMEM,KFAMWA)  CDC MACHINES RUNNING UNDER
C                                          CALIDOSCOPE KFAMWA IS THE ADDRESS
C                                          OF THE FIRST AVAILABLE WORD
C      CALL GETM4 (IPNTR,BLKSIZ)  WHERE BLKSIZE IS THE NUMBER OF ENTRIES
C      CALL GETM8 (IPNTR,BLKSIZ)
C      CALL GETM16(IPNTR,BLKSIZ)
C      CALL RELMEM(IPNTR,RELSIZ)
C      CALL EXTMEM(IPNTR,EXTSIZ)  EXTSIZ IS THE NUMBER OF ENTRIES TO BE ADDED
C      CALL SIZMEM(IPNTR,BLKSIZ)
C      CALL CLRMEM(IPNTR)
C      CALL PTRMEM(IPNTR1,IPNTR2)
C      CALL AVLM4(ISPACE)
C      CALL AVLM8(ISPACE)
C      CALL AVLM16(ISPACE)
C      CALL CRUNCH
C      CALL SLPMEM(IPNTR,SLPSIZ)  EXPRESS DESIRE FOR *SLPSIZ* EXTRA ENTRIES
C
C
C GENERAL COMMENTS:
C      FOR EACH BLOCK WHICH IS ALLOCATED, A MULTI-WORD ENTRY IS MAINTAINED
C IN A TABLE KEPT IN HIGH MEMORY, OF THE FORM
C
C        WORD      CONTENTS
C        ----      --------
C
C          1       INDEX OF IMEM(.) INTO ORIGIN OF BLOCK
C                    I.E. CONTENTS OF POINTER (USED FOR ERROR CHECK)
C          2       BLOCK SIZE (IN WORDS)
C          3       NUMBER OF WORDS IN USE
C          4       ADDRESS OF VARIABLE CONTAINING BLOCK ORIGIN
C          5       NUMBER OF WORDS USED PER TABLE ENTRY
C          6       SLOP SIZE (IN WORDS)
C
C      ALL ALLOCATED BLOCKS ARE AN 'EVEN' (NXTEVN) NUMBER OF WORDS IN LENGTH,
C WHERE A 'WORD' IS THE STORAGE UNIT REQUIRED FOR AN 'INTEGER' VARIABLE.
C      SINCE BLOCK REPOSITIONING MAY BE NECESSARY, THE CONVENTION THAT
C ONLY ONE VARIABLE CONTAIN A BLOCK ORIGIN SHOULD BE OBSERVED.
C      FOR *GETMEM*, *IPNTR* IS SET SUCH THAT *ARRAY(IPNTR+1)* IS THE
C FIRST WORD OF THE ALLOCATED BLOCK.  'IPNTR' IS SET TO ADDRESS THE FIRST
C ENTRY OF THE TABLE WHEN USED WITH THE APPROPRIATE VARIABLE TYPE, I.E.,
C NODPLC(IPNTR+1), VALUE(IPNTR+1), OR CVALUE(IPNTR+1).
C      FOR *CLRMEM*, *IPNTR* IS SET TO 'INVALID' TO ENABLE RAPID DETECTION
C OF AN ATTEMPT TO USE A CLEARED BLOCK.
C      IF ANY FATAL ERRORS ARE FOUND, A MESSAGE IS PRINTED AND A FLAG
C SET INHIBITING FURTHER ACTION UNTIL *SETMEM* IS CALLED.  (IN THIS
C CONTEXT, INSUFFICIENT MEMORY IS CONSIDERED A FATAL ERROR.)
C      THROUGHOUT THIS ROUTINE, *LDVAL* ALWAYS CONTAINS THE SUBSCRIPT OF
C THE LAST ADDRESSABLE WORD OF MEMORY, *MEMAVL* ALWAYS CONTAINS THE
C NUMBER OF AVAILABLE WORDS OF MEMORY, *NUMBLK* ALWAYS CONTAINS THE
C NUMBER OF ALLOCATED BLOCKS, AND ISTACK(*LOCTAB* +1) ALWAYS CONTAINS
C THE FIRST WORD OF THE BLOCK TABLE.
C
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
C SPICE VERSION 2G.6  SCCSID=MEMMGR 3/15/83
      COMMON /MEMMGR/ CPYKNT,ISTACK(1),LORG,ICORE,MAXCOR,MAXUSE,MEMAVL,
     1   LDVAL,NUMBLK,LOCTAB,LTAB,IFWA,NWOFF,NTAB,MAXMEM,MEMERR,NWD4,
     2   NWD8,NWD16
      DIMENSION IPNTR(1)
C
      LOGICAL MEMPTR
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),CVALUE(1))
C
C...  APPROXIMATE TIME REQUIRED TO COPY *NWORDS* INTEGER VALUES
C
C  NXTEVN ROUNDS THE NUMBER UP TO THE NEXT 'EVEN' VALUE.  THE VALUE
C  USED FOR THIS 'EVEN' NUMBER IS THE SMALLEST NUMBER INTO WHICH ONE
C  CAN DIVIDE NWD4,NWD8,AND NWD16.
C
C
C  NXTMEM  RETURNS NEXT HIGHER MEMORY SIZE
C
C
C
C***  SETMEM - SET INITIAL MEMORY
C
      NWD4=1
      NWD8=LOCF(VALUE(2))-LOCF(VALUE(1))
      NWD16=LOCF(CVALUE(2))-LOCF(CVALUE(1))
      MEMERR=0
      NEVN=NXTEVN(1)
C     CHECK THAT NXTEVN FUNCTION RETURNS A NUMBER DIVISIBLE BY
C     NWD4, NWD8, NWD16; ALSO CHECK THAT THE MEMORY INCREMENT
C     NXTMEM(.) IS AN INTEGER MULTIPLE OF NXTEVN(1)
      ICHECK=MOD(NEVN,NWD4)+MOD(NEVN,NWD8)+MOD(NEVN,NWD16)+
     1  MOD(NXTMEM(1),NEVN)
      IF(ICHECK.EQ.0) GO TO 2
      MEMERR=1
      CALL ERRMEM(6,MEMERR,IPNTR(1))
    2 CPYKNT=0.0D0
      IFAMWA=LOCF(IPNTR(1))
      MAXMEM=KSIZE
      NTAB=NXTEVN(6)
C... ADD 'LORG' TO AN ADDRESS AND YOU GET THE 'ISTACK' INDEX TO THAT WORD
      LORG=1-LOCF(ISTACK(1))
      IFWA=IFAMWA+LORG-1
      NWOFF=LOCF(IPNTR(1))+LORG-1
      ICORE=NXTMEM(1)
C... DON'T TAKE CHANCES, BACK OFF FROM 'END OF MEMORY' BY NXTEVN(1)
      LDVAL=IFWA+NXTMEM(1)-NXTEVN(1)
      MEMAVL=LDVAL-NTAB-IFWA
      MAXCOR=0
      MAXUSE=0
      CALL MEMORY
      IF(MEMERR.NE.0) CALL ERRMEM(6,MEMERR,IPNTR(1))
      NUMBLK=1
      LOCTAB=LDVAL-NTAB
      ISTACK(LOCTAB+1)=0
      ISTACK(LOCTAB+2)=MEMAVL
      ISTACK(LOCTAB+3)=0
      ISTACK(LOCTAB+4)=-1
      ISTACK(LOCTAB+5)=1
      ISTACK(LOCTAB+6)=0
      RETURN
      END
