E c********************************************************************  c234567 "       subroutine setup_task_arrays)       implicit double precision (a-h,o-z)  c G c This routine sets up the arrays defining the tasks to be performed by A c the subprocesses in the parallel implementation of the program. 5 c Tasks arrays are used for statically defined tasks.  c D       COMMON /AC/ FSTART,FSTOP,FINCR,SKW2,REFPRL,SPW2,JACFLG,IDFREQ,/      1   INOISE,NOSPRT,NOSOUT,NOSIN,IDIST,IDPRT  c # c Set up task array for load1 phase  c !       call setup_load1_task_array  c $ c Set up task array for load2 phase./ c (the same array is used for ac analysis also)  c !       call setup_load2_task_array  c = c If ac analysis, setup the task array for the acload1 phase. > c The routine used is the same as the one for the load1 phase,? c except for the weight given to the work required to load each 
 c element. c 4       if (jacflg.ne.0) call setup_acload1_task_array c 6 c Set up task array for the next time step computation c        call setup_lte_task_array  c        return	       end  c F c********************************************************************* c  c234567 '       subroutine setup_load1_task_array )       implicit double precision (a-h,o-z)  c F c This routine sets up the array defining the tasks to be performed by@ c the subprocesses in the parallel implementation of the program c for the load1 phase.D c For each task, the task array will contain the id and the locationB c of the first element to be loaded and the id and location of theC c element after the last element to be loaded. Id's are incremented 4 c by one. Locations are obtained from a linked list. c  c declarations c G       COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP, :      1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC"       COMMON /BLANK/ VALUE(200000)       INTEGER NODPLC(64)       COMPLEX CVALUE(32)0       EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1)) c        include 'shared.cmn'       include 'local.cmn'  c        logical memptr       logical first_time3       integer process_work,unit_work,id,last_id,loc 1       integer id_start,loc_start,id_stop,loc_stop 0       integer task_process_ratio,number_of_tasks       integer task_array_size "       integer load1_work,work_done       integer work(50) c        parameter (last_id=17) c        DIMENSION LALT(50)/       DATA LALT /10,14,16, 8,15,16,15,16,13, 8, /      1           18,38,27,35, 8, 8,35, 5, 5, 5, /      2            5, 5, 5, 5, 0, 0, 0, 0, 0, 0, /      3           21,21,21,21,21,21,21,21,21,21, 0      4            8, 8, 8, 8, 8, 0, 0, 0, 0, 0 /       data work >      1    /   1,   5,   5,   5,  10,   10,  10,  10,   1,   1,>      2       50, 100, 100, 100,   0,    0,  50,   0,   0,   0,>      3        0,   0,   0,   0,   0,    0,   0,   0,   0,   0,>      4        0,   0,   0,   0,   0,    0,   0,   0,   0,   0,>      5        0,   0,   0,   0,   0,    0,   0,   0,   0,   0/ c  c no subprocesses  c +       if (number_of_subprocesses.eq.0) then           task_array_size=40          if (memptr(italo1)) call clrmem(italo1)+          call getm4(italo1,task_array_size)           nodplc(italo1+1)=1 #          nodplc(italo1+2)=locate(1) !          nodplc(italo1+3)=last_id           nodplc(italo1+4)=0           return        endif  c * c define number of tasks and work per task c 1       task_process_ratio=load1_task_process_ratio ?       number_of_tasks=number_of_subprocesses*task_process_ratio        load1_work=0       do i=1,last_id0          load1_work=load1_work+jelcnt(i)*work(i)       enddo *       unit_work=load1_work/number_of_tasks%       if (unit_work.eq.0) unit_work=1  c  c create task array  c .       task_array_size=load1_work/unit_work + 1'       task_array_size=4*task_array_size -       if (memptr(italo1)) call clrmem(italo1) (       call getm4(italo1,task_array_size)2       call zero4(nodplc(italo1+1),task_array_size) c  c load task array  c 
       id=1       loc=locate(id)       numalt=0       loc_start=0        work_done=0 	       i=0 (       do while (work_done.lt.load1_work)          process_work=0           first_time=.TRUE.3          do while ((process_work.lt.unit_work).and. ,      1            (work_done.lt.load1_work))8             do while (((loc.eq.0).or.(numalt.ne.0)).and.%      1               (id.lt.last_id))                 id=id+1                loc=locate(id)                 numalt=0              enddo               if (first_time) then                id_start=id                loc_start=loc!                first_time=.FALSE.              endif 9             do while (((loc.ne.0).and.(numalt.eq.0)).and. 1      1               (process_work.lt.unit_work)) 1                process_work=process_work+work(id) +                work_done=work_done+work(id)                 loc=nodplc(loc)                numalt=0 :                if (loc.ne.0) numalt=nodplc(loc+lalt(id)-2)             enddo           enddo          id_stop=id           loc_stop=loc &          nodplc(italo1+4*i+1)=id_start'          nodplc(italo1+4*i+2)=loc_start %          nodplc(italo1+4*i+3)=id_stop &          nodplc(italo1+4*i+4)=loc_stop          i=i+1       enddo        if (loc_start.eq.0) i=i-1        load1_last_task_number=i c        return	       end  c F c********************************************************************* c  c234567 '       subroutine setup_load2_task_array )       implicit double precision (a-h,o-z)  c F c This routine sets up the array defining the tasks to be performed by@ c the subprocesses in the parallel implementation of the program c for the load2 phase.9 c For each task, the task array will contain the location C c of the first element to be loaded and the location of the element ' c after the last element to be loaded.  H c A task will consist in adding up the contributions to a matrix element, c and writing the sum in the matrix location c  c  c declarations c G       COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP, :      1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYCG       COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM, C      1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE, G      2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR, G      3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1, F      4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,=      5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL, @      6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,)      7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP "       COMMON /BLANK/ VALUE(200000)       INTEGER NODPLC(64)       COMPLEX CVALUE(32)0       EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1)) c        include 'shared.cmn'       include 'local.cmn'  c 5       integer process_work,unit_work,index,last_index        integer index_start 0       integer task_process_ratio,number_of_tasks       integer task_array_size        integer load2_work,work  c  c no subprocesses  c +       if (number_of_subprocesses.eq.0) then           task_array_size=20          if (memptr(italo2)) call clrmem(italo2)+          call getm4(italo2,task_array_size)           nodplc(italo2+1)=1 '          nodplc(italo2+2)=nstop+nttar+1           return        endif  c * c define number of tasks and work per task c 1       task_process_ratio=load2_task_process_ratio ?       number_of_tasks=number_of_subprocesses*task_process_ratio #       load2_work=additional_space-1 *       unit_work=load2_work/number_of_tasks%       if (unit_work.eq.0) unit_work=1  c  c create task array  c .       task_array_size=load2_work/unit_work + 1'       task_array_size=task_array_size+1 -       if (memptr(italo2)) call clrmem(italo2) (       call getm4(italo2,task_array_size)2       call zero4(nodplc(italo2+1),task_array_size) c  c load task array  c        last_index=nstop+nttar       work_done=0 	       i=0 
       index=2 $       do while (index.le.last_index)          process_work=0           index_start=index3          do while ((process_work.lt.unit_work).and. )      1             (index.le.last_index)) :             work=nodplc(lcont+index+1)-nodplc(lcont+index)*             process_work=process_work+work             index=index+1           enddo'          nodplc(italo2+i+1)=index_start           i=i+1       enddo %       nodplc(italo2+i+1)=last_index+1  c        load2_last_task_number=i c H c  the next statement is present for and only for static task allocation8 c  it must be commented out for dynamic task allocation. c :       nodplc(italo2+number_of_subprocesses+1)=last_index+1 c        return	       end  c F c********************************************************************* c  c234567 )       subroutine setup_acload1_task_array )       implicit double precision (a-h,o-z)  c F c This routine sets up the array defining the tasks to be performed by@ c the subprocesses in the parallel implementation of the program) c for the load1 phase of the ac analysis. D c For each task, the task array will contain the id and the locationB c of the first element to be loaded and the id and location of theC c element after the last element to be loaded. Id's are incrementedd4 c by one. Locations are obtained from a linked list. ce c declarations ceG       COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,t:      1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC"       COMMON /BLANK/ VALUE(200000)       INTEGER NODPLC(64)       COMPLEX CVALUE(32)0       EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1)) c        include 'shared.cmn'       include 'local.cmn'l ct       logical first_time3       integer process_work,unit_work,id,last_id,loca1       integer id_start,loc_start,id_stop,loc_stopt0       integer task_process_ratio,number_of_tasks       integer task_array_sizep"       integer load1_work,work_done       integer work(50) c        parameter (last_id=17) ci       DIMENSION LALT(50)/       DATA LALT /10,14,16, 8,15,16,15,16,13, 8,./      1           18,38,27,35, 8, 8,35, 5, 5, 5,s/      2            5, 5, 5, 5, 0, 0, 0, 0, 0, 0, /      3           21,21,21,21,21,21,21,21,21,21, 0      4            8, 8, 8, 8, 8, 0, 0, 0, 0, 0 /       data work >      1    /   4,   4,  10,   4,   8,   12,   8,  10,   6,   4,>      2       11,  34,  22,  33,   0,    0,  40,   0,   0,   0,>      3        0,   0,   0,   0,   0,    0,   0,   0,   0,   0,>      4        0,   0,   0,   0,   0,    0,   0,   0,   0,   0,>      5        0,   0,   0,   0,   0,    0,   0,   0,   0,   0/ c  c no subprocesses  c +       if (number_of_subprocesses.eq.0) then           task_array_size=40          if (memptr(itaacl)) call clrmem(itaacl)+          call getm4(itaacl,task_array_size)           nodplc(itaacl+1)=1 #          nodplc(itaacl+2)=locate(1) !          nodplc(itaacl+3)=last_id           nodplc(itaacl+4)=0           return        endif  c * c define number of tasks and work per task c 1       task_process_ratio=load1_task_process_ratio ?       number_of_tasks=number_of_subprocesses*task_process_ratio        load1_work=0       do i=1,last_id0          load1_work=load1_work+jelcnt(i)*work(i)       enddo *       unit_work=load1_work/number_of_tasks%       if (unit_work.eq.0) unit_work=1  c  c create task array  c .       task_array_size=load1_work/unit_work + 1'       task_array_size=4*task_array_size -       if (memptr(itaacl)) call clrmem(itaacl) (       call getm4(itaacl,task_array_size)2       call zero4(nodplc(itaacl+1),task_array_size) c  c load task array  c 
       id=1       loc=locate(id)       numalt=0       loc_start=0        work_done=0 	       i=0 (       do while (work_done.lt.load1_work)          process_work=0           first_time=.TRUE.3          do while ((process_work.lt.unit_work).and. ,      1            (work_done.lt.load1_work))8             do while (((loc.eq.0).or.(numalt.ne.0)).and.%      1               (id.lt.last_id))                 id=id+1                loc=locate(id)                 numalt=0              enddo               if (first_time) then                id_start=id                loc_start=loc!                first_time=.FALSE.              endif 9             do while (((loc.ne.0).and.(numalt.eq.0)).and. 1      1               (process_work.lt.unit_work)) 1                process_work=process_work+work(id) +                work_done=work_done+work(id)                 loc=nodplc(loc)                numalt=0 :                if (loc.ne.0) numalt=nodplc(loc+lalt(id)-2)             enddo           enddo          id_stop=id           loc_stop=loc &          nodplc(itaacl+4*i+1)=id_start'          nodplc(itaacl+4*i+2)=loc_start %          nodplc(itaacl+4*i+3)=id_stop &          nodplc(itaacl+4*i+4)=loc_stop          i=i+1       enddo        if (loc_start.eq.0) i=i-1         acload1_last_task_number=i c        return	       end  c F c********************************************************************* c  c234567 %       subroutine setup_lte_task_array )       implicit double precision (a-h,o-z)  c F c This routine sets up the array defining the tasks to be performed by@ c the subprocesses in the parallel implementation of the program- c for the lte (local truncation error) phase. D c For each task, the task array will contain the id and the location= c of the first element and the id and location of the element B c after the last element whose truncation error is estimated. Id'sD c are incremented by one. Locations are obtained from a linked list. c  c declarations c G       COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP, :      1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC"       COMMON /BLANK/ VALUE(200000)       INTEGER NODPLC(64)       COMPLEX CVALUE(32)0       EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1)) c        include 'shared.cmn'       include 'local.cmn'  c        logical first_time3       integer process_work,unit_work,id,last_id,loc 1       integer id_start,loc_start,id_stop,loc_stop 0       integer task_process_ratio,number_of_tasks       integer task_array_size        integer work_done        integer work(10) c        parameter (last_id=6)  c        DIMENSION LALT(50)/       DATA LALT /10,14,16, 8,15,16,15,16,13, 8, /      1           18,38,27,35, 8, 8,35, 5, 5, 5, /      2            5, 5, 5, 5, 0, 0, 0, 0, 0, 0, /      3           21,21,21,21,21,21,21,21,21,21, 0      4            8, 8, 8, 8, 8, 0, 0, 0, 0, 0 /       data work >      1    /   1,   1,   1,   3,   2,    3,   0,   0,   0,   0/ c ; c setup translation array for the energy storage element id  c        lteid(1) =2        lteid(2) =3        lteid(3) =11       lteid(4) =12       lteid(5) =13       lteid(6) =14       lteid(7) =0        lteid(8) =0        lteid(9) =0        lteid(10)=0  c * c define number of tasks and work per task c        lte_work=0       do i=1,last_id3          lte_work=lte_work+jelcnt(lteid(i))*work(i)        enddo  c  c no subprocesses  c +       if (number_of_subprocesses.eq.0) then           task_array_size=40          if (memptr(italte)) call clrmem(italte)+          call getm4(italte,task_array_size)           nodplc(italte+1)=1 *          nodplc(italte+2)=locate(lteid(1))!          nodplc(italte+3)=last_id           nodplc(italte+4)=0           return        endif  c E c create array to store minimum time step computed by each subprocess  c -       if (memptr(itstep)) call clrmem(itstep) /       call getm8(itstep,number_of_subprocesses) 8       call zero8(value(itstep+1),number_of_subprocesses) c  c create task array  c /       task_process_ratio=lte_task_process_ratio ?       number_of_tasks=number_of_subprocesses*task_process_ratio (       unit_work=lte_work/number_of_tasks%       if (unit_work.eq.0) unit_work=1 ,       task_array_size=lte_work/unit_work + 1'       task_array_size=4*task_array_size -       if (memptr(italte)) call clrmem(italte) (       call getm4(italte,task_array_size)2       call zero4(nodplc(italte+1),task_array_size) c  c lte task array c 
       id=1       loc=locate(lteid(id))        numalt=0       loc_start=0        work_done=0 	       i=0 &       do while (work_done.lt.lte_work)          process_work=0           first_time=.TRUE.3          do while ((process_work.lt.unit_work).and. *      1            (work_done.lt.lte_work))8             do while (((loc.eq.0).or.(numalt.ne.0)).and.%      1               (id.lt.last_id))                 id=id+1$                loc=locate(lteid(id))                numalt=0              enddo               if (first_time) then                id_start=id                loc_start=loc!                first_time=.FALSE.              endif 9             do while (((loc.ne.0).and.(numalt.eq.0)).and. 1      1               (process_work.lt.unit_work)) 1                process_work=process_work+work(id) +                work_done=work_done+work(id)                 loc=nodplc(loc)                numalt=0 A                if (loc.ne.0) numalt=nodplc(loc+lalt(lteid(id))-2)              enddo           enddo          id_stop=id           loc_stop=loc &          nodplc(italte+4*i+1)=id_start'          nodplc(italte+4*i+2)=loc_start %          nodplc(italte+4*i+3)=id_stop &          nodplc(italte+4*i+4)=loc_stop          i=i+1       enddo*       if (loc_start.eq.0) i=i-1*       lte_last_task_number=i c ? c  the next statements are present for and only for static taskcE c  allocation they must be commented out for dynamic task allocation.f cn7       nodplc(italte+4*number_of_subprocesses+3)=id_stop 8       nodplc(italte+4*number_of_subprocesses+4)=loc_stop c.       return	       ends crF c*********************************************************************