      SUBROUTINE SLPMEM(IPNTR,KSIZE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C      THIS ROUTINE MAY BE USED TO DEFINE A CERTAIN AMOUNT OF `SLOP' TO
C BE ASSOCIATED WITH A PARTICULAR TABLE MANAGED BY THE MEMORY MANAGER.
C THIS *SLOP* IS DEFINED AS A NUMBER OF ENTRIES IN THE TABLE FOR WHICH
C SPACE IS TO BE HELD ***IF POSSIBLE*** DURING COMPACTION OF THE MANAGED
C AREA OF MEMORY.  THIS FEATURE CAN ELIMINATE THE OVERHEAD INCURRED BY
C ALTERNATIVELY EXTENDING MORE THAN ONE TABLE AT A TIME.  (FOR EXAMPLE,
C IF THE PROGRAM CONTAINS A CODE SEQUENCE
C
C                  DO 100 I=1,500
C                     ...
C                  CALL EXTMEM(TABLE1,1)
C                     ...
C                  CALL EXTMEM(TABLE2,1)
C                     ...
C              100 CONTINUE
C
C THEN THE OVERHEAD INCURRED BY THIS MEMORY MANAGER CAN BE REDUCED TO
C ESSENTIALLY NOTHING IF PRIOR TO THE ABOVE CODE SEQUENCE THE PROGRAM
C EXECUTES
C
C                  CALL SLPMEM(TABLE1,20)
C                  CALL SLPMEM(TABLE2,20)
C
C WHERE `20' IS A TYPICAL NUMBER (FOR THE ABOVE EXAMPLE, THE MEMORY-TO-
C MEMORY COPYING OVERHEAD OF THE MEMORY MANAGER WOULD BE REDUCED BY A
C FACTOR OF 20).
C
C SPICE VERSION 2G.6  SCCSID=MEMMGR 3/15/83
      COMMON /MEMMGR/ CPYKNT,ISTACK(1),LORG,ICORE,MAXCOR,MAXUSE,MEMAVL,
     1   LDVAL,NUMBLK,LOCTAB,LTAB,IFWA,NWOFF,NTAB,MAXMEM,MEMERR,NWD4,
     2   NWD8,NWD16
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
      DIMENSION IPNTR(1)
      ISLP=NXTEVN(KSIZE)
      CALL EXTMEM(IPNTR,ISLP)
      ISLP=ISLP*ISTACK(LTAB+5)
      ISTACK(LTAB+3)=ISTACK(LTAB+3)-ISLP
      MEMAVL=MEMAVL+ISTACK(LTAB+6)
      ISTACK(LTAB+6)=ISLP
      RETURN
      END
