      SUBROUTINE SORUPD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE UPDATES THE INDEPENDENT VOLTAGE AND CURRENT SOURCES
C USED IN THE CIRCUIT.  IT ALSO UPDATES THE LTD TABLE (WHICH CONTAINS
C PREVIOUS (DELAYED) VALUES OF THE SOURCES USED TO MODEL TRANSMISSION
C LINES).
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DO 500 ID=9,10
      LOC=LOCATE(ID)
   10 IF (LOC.EQ.0) GO TO 500
      IF ((ID.EQ.9).AND.(NODPLC(LOC+11).NE.0)) GO TO 500
      IF ((ID.EQ.10).AND.(NODPLC(LOC+6).NE.0)) GO TO 500
      LOCV=NODPLC(LOC+1)
      LOCP=NODPLC(LOC+5)
      ITYPE=NODPLC(LOC+4)+1
      GO TO (490,100,200,300,400,450), ITYPE
C
C  PULSE SOURCE
C
  100 V1=VALUE(LOCP+1)
      V2=VALUE(LOCP+2)
      T1=VALUE(LOCP+3)
      T2=VALUE(LOCP+4)
      T3=VALUE(LOCP+5)
      T4=VALUE(LOCP+6)
      PERIOD=VALUE(LOCP+7)
      TIME1=TIME
      IF (TIME1.LE.0.0D0) GO TO 160
  110 IF (TIME1.LT.T1+PERIOD) GO TO 120
      TIME1=TIME1-PERIOD
      GO TO 110
  120 IF (TIME1.LT.T4) GO TO 130
      VALUE(LOCV+1)=V1
      GO TO 490
  130 IF (TIME1.LT.T3) GO TO 140
      VALUE(LOCV+1)=V2+(TIME1-T3)*(V1-V2)/(T4-T3)
      GO TO 490
  140 IF (TIME1.LT.T2) GO TO 150
      VALUE(LOCV+1)=V2
      GO TO 490
  150 IF (TIME1.LT.T1) GO TO 160
      VALUE(LOCV+1)=V1+(TIME1-T1)*(V2-V1)/(T2-T1)
      GO TO 490
  160 VALUE(LOCV+1)=V1
      GO TO 490
C
C  SINUSOIDAL SOURCE
C
  200 V1=VALUE(LOCP+1)
      V2=VALUE(LOCP+2)
      OMEG=VALUE(LOCP+3)
      T1=VALUE(LOCP+4)
      THETA=VALUE(LOCP+5)
      TIME1=TIME-T1
      IF (TIME1.GT.0.0D0) GO TO 210
      VALUE(LOCV+1)=V1
      GO TO 490
  210 IF (THETA.NE.0.0D0) GO TO 220
      VALUE(LOCV+1)=V1+V2*DSIN(OMEG*TIME1)
      GO TO 490
  220 VALUE(LOCV+1)=V1+V2*DSIN(OMEG*TIME1)*DEXP(-TIME1*THETA)
      GO TO 490
C
C  EXPONENTIAL SOURCE
C
  300 V1=VALUE(LOCP+1)
      V2=VALUE(LOCP+2)
      T1=VALUE(LOCP+3)
      TAU1=VALUE(LOCP+4)
      T2=VALUE(LOCP+5)
      TAU2=VALUE(LOCP+6)
      TIME1=TIME
      IF (TIME1.GT.T1) GO TO 310
      VALUE(LOCV+1)=V1
      GO TO 490
  310 IF (TIME1.GT.T2) GO TO 320
      VALUE(LOCV+1)=V1+(V2-V1)*(1.0D0-DEXP((T1-TIME1)/TAU1))
      GO TO 490
  320 VALUE(LOCV+1)=V1+(V2-V1)*(1.0D0-DEXP((T1-TIME1)/TAU1))
     1   +(V1-V2)*(1.0D0-DEXP((T2-TIME1)/TAU2))
      GO TO 490
C
C  PIECEWISE-LINEAR SOURCE
C
  400 T1=VALUE(LOCP+1)
      V1=VALUE(LOCP+2)
      T2=VALUE(LOCP+3)
      V2=VALUE(LOCP+4)
      IKNT=4
  410 IF (TIME.LE.T2) GO TO 420
      T1=T2
      V1=V2
      T2=VALUE(LOCP+IKNT+1)
      V2=VALUE(LOCP+IKNT+2)
      IKNT=IKNT+2
      GO TO 410
  420 VALUE(LOCV+1)=V1+((TIME-T1)/(T2-T1))*(V2-V1)
      GO TO 490
C
C  SINGLE-FREQUENCY FM
C
  450 V1=VALUE(LOCP+1)
      V2=VALUE(LOCP+2)
      OMEGC=VALUE(LOCP+3)
      XMOD=VALUE(LOCP+4)
      OMEGS=VALUE(LOCP+5)
      VALUE(LOCV+1)=V1+V2*DSIN(OMEGC*TIME+XMOD*DSIN(OMEGS*TIME))
  490 LOC=NODPLC(LOC)
      GO TO 10
  500 CONTINUE
C
C  UPDATE TRANSMISSION LINE SOURCES
C
      IF (JELCNT(17).EQ.0) GO TO 1000
      IF (MODE.NE.2) GO TO 1000
      CALL SIZMEM(LTD,LTDSIZ)
      NUMTD=LTDSIZ/NTLIN
      IF (NUMTD.LT.3) GO TO 900
      LOC=LOCATE(17)
  610 IF (LOC.EQ.0) GO TO 1000
      LOCV=NODPLC(LOC+1)
      TD=VALUE(LOCV+2)
      BAKTIM=TIME-TD
      IF (BAKTIM.LT.0.0D0) GO TO 640
      LTDPTR=NODPLC(LOC+30)
      ICNTR=2
      L1=LTD
      L2=L1+NTLIN
      L3=L2+NTLIN
      T1=VALUE(L1+1)
      T2=VALUE(L2+1)
  620 T3=VALUE(L3+1)
      ICNTR=ICNTR+1
      IF (BAKTIM.LE.T3) GO TO 630
      IF (ICNTR.EQ.NUMTD) GO TO 900
      L1=L2
      L2=L3
      L3=L2+NTLIN
      T1=T2
      T2=T3
      GO TO 620
  630 DT1T2=T1-T2
      DT1T3=T1-T3
      DT2T3=T2-T3
      TDNOM1=1.0D0/(DT1T2*DT1T3)
      TDNOM2=-1.0D0/(DT1T2*DT2T3)
      TDNOM3=1.0D0/(DT2T3*DT1T3)
      DTT1=BAKTIM-T1
      DTT2=BAKTIM-T2
      DTT3=BAKTIM-T3
      TFACT1=DTT2*DTT3*TDNOM1
      TFACT2=DTT1*DTT3*TDNOM2
      TFACT3=DTT1*DTT2*TDNOM3
      VALUE(LOCV+3)=VALUE(L1+LTDPTR+0)*TFACT1+VALUE(L2+LTDPTR+0)*TFACT2
     1   +VALUE(L3+LTDPTR+0)*TFACT3
      VALUE(LOCV+4)=VALUE(L1+LTDPTR+1)*TFACT1+VALUE(L2+LTDPTR+1)*TFACT2
     1   +VALUE(L3+LTDPTR+1)*TFACT3
  640 LOC=NODPLC(LOC)
      GO TO 610
C
C  INTERNAL LOGIC ERROR:  LESS THAN 3 ENTRIES IN LTD
C
  900 NOGO=1
      WRITE (IOFILE,901) NUMTD,ICNTR
  901 FORMAT('0*ABORT*:  INTERNAL SPICE ERROR:  SORUPD:  ',2I5/)
C
C  FINISHED
C
 1000 RETURN
      END
