      SUBROUTINE SSTF
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE COMPUTES THE VALUE OF THE SMALL-SIGNAL TRANSFER
C FUNCTION SPECIFIED BY THE USER.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=DC 3/15/83
      COMMON /DC/ TCSTAR(2),TCSTOP(2),TCINCR(2),ICVFLG,ITCELM(2),KSSOP,
     1   KINEL,KIDIN,KOVAR,KIDOUT
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DIMENSION STRING(5),SAVE(3)
      DATA ASLASH, ABLNK / 1H/, 1H  /
C
C  SETUP CURRENT VECTOR FOR INPUT RESISTANCE AND TRANSFER FUNCTION
C
      CALL ZERO8(VALUE(LVN+1),NSTOP)
      IF (KIDIN.EQ.10) GO TO 5
C...  VOLTAGE SOURCE INPUT
      IPTRI=NODPLC(KINEL+6)
      VALUE(LVN+IPTRI)=+1.0D0
      GO TO 20
C...  CURRENT SOURCE INPUT
    5 NOPOSI=NODPLC(KINEL+2)
      NONEGI=NODPLC(KINEL+3)
      VALUE(LVN+NOPOSI)=-1.0D0
      VALUE(LVN+NONEGI)=+1.0D0
C
C  LU DECOMPOSE AND SOLVE THE SYSTEM OF CIRCUIT EQUATIONS
C
C...  REORDER THE RIGHT-HAND SIDE
   20 CALL DCDCMP
      CALL DCSOL
      VALUE(LVN+1)=0.0D0
      DO 25 I=1,NSTOP
      J=NODPLC(ICSWPR+I)
      K=NODPLC(IRSWPF+J)
      VALUE(LVNTMP+I)=VALUE(LVN+K)
   25 CONTINUE
      CALL COPY8(VALUE(LVNTMP+1),VALUE(LVN+1),NSTOP)
C
C  EVALUATE TRANSFER FUNCTION
C
      IF (NODPLC(KOVAR+5).NE.0) GO TO 30
C...  VOLTAGE OUTPUT
      NOPOSO=NODPLC(KOVAR+2)
      NONEGO=NODPLC(KOVAR+3)
      TRFN=VALUE(LVN+NOPOSO)-VALUE(LVN+NONEGO)
      GO TO 40
C...  CURRENT OUTPUT (THROUGH VOLTAGE SOURCE)
   30 IPTRO=NODPLC(KOVAR+2)
      IPTRO=NODPLC(IPTRO+6)
      TRFN=VALUE(LVN+IPTRO)
C
C  EVALUATE INPUT RESISTANCE
C
   40 IF (KIDIN.EQ.9) GO TO 50
C...  CURRENT SOURCE INPUT
      ZIN=VALUE(LVN+NONEGI)-VALUE(LVN+NOPOSI)
      GO TO 70
C...  VOLTAGE SOURCE INPUT
   50 CREAL=VALUE(LVN+IPTRI)
      IF (DABS(CREAL).GE.1.0D-20) GO TO 60
      ZIN=1.0D20
      GO TO 70
   60 ZIN=-1.0D0/CREAL
C
C  SETUP CURRENT VECTOR FOR OUTPUT RESISTANCE
C
   70 CALL ZERO8(VALUE(LVN+1),NSTOP)
      IF (NODPLC(KOVAR+5).NE.0) GO TO 80
C...  VOLTAGE OUTPUT
      VALUE(LVN+NOPOSO)=-1.0D0
      VALUE(LVN+NONEGO)=+1.0D0
      GO TO 90
   80 IF (NODPLC(KOVAR+2).NE.KINEL) GO TO 85
      ZOUT=ZIN
      GO TO 200
C...  CURRENT OUTPUT (THROUGH VOLTAGE SOURCE)
   85 VALUE(LVN+IPTRO)=+1.0D0
C
C  PERFORM NEW FORWARD AND BACKWARD SUBSTITUTION
C
C...  REORDER THE RIGHT-HAND SIDE
   90 CALL DCSOL
      VALUE(LVN+1)=0.0D0
      DO 95 I=1,NSTOP
      J=NODPLC(ICSWPR+I)
      K=NODPLC(IRSWPF+J)
      VALUE(LVNTMP+I)=VALUE(LVN+K)
   95 CONTINUE
      CALL COPY8(VALUE(LVNTMP+1),VALUE(LVN+1),NSTOP)
C
C  EVALUATE OUTPUT RESISTANCE
C
  100 IF (NODPLC(KOVAR+5).NE.0) GO TO 110
C...  VOLTAGE OUTPUT
      ZOUT=VALUE(LVN+NONEGO)-VALUE(LVN+NOPOSO)
      GO TO 200
C...  CURRENT OUTPUT (THROUGH VOLTAGE SOURCE)
  110 CREAL=VALUE(LVN+IPTRO)
      IF (DABS(CREAL).GE.1.0D-20) GO TO 120
      ZOUT=1.0D20
      GO TO 200
  120 ZOUT=-1.0D0/CREAL
C
C  PRINT RESULTS
C
  200 DO 210 I=1,5
      STRING(I)=ABLNK
  210 CONTINUE
      IPOS=1
      CALL OUTNAM(KOVAR,1,STRING,IPOS)
      CALL COPY8(STRING,SAVE,3)
      CALL MOVE(STRING,IPOS,ASLASH,1,1)
      IPOS=IPOS+1
      LOCV=NODPLC(KINEL+1)
      ANAM=VALUE(LOCV)
      CALL MOVE(STRING,IPOS,ANAM,1,8)
      WRITE (IOFILE,231) STRING,TRFN,ANAM,ZIN,SAVE,ZOUT
  231 FORMAT(////,'0****     SMALL-SIGNAL CHARACTERISTICS'//,
     1   1H0,5X,5A8,3H = ,1PD10.3,/,
     2   1H0,5X,'INPUT RESISTANCE AT ',A8,12X,3H = ,D10.3,/,
     3   1H0,5X,'OUTPUT RESISTANCE AT ',2A8,A3,3H = ,D10.3)
      RETURN
      END
