      SUBROUTINE SUBNAM(LOCE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE CONSTRUCTS THE NAMES OF ELEMENTS ADDED AS A RESULT OF
C SUBCIRCUIT EXPANSION.  THE FULL ELEMENT NAMES ARE OF THE FORM
C                  NAME.XN. --- XD.XC.XB.XA
C WHERE 'NAME' IS THE NOMINAL ELEMENT NAME, AND THE 'X'*S DENOTE THE
C SEQUENCE OF SUBCIRCUIT CALLS (FROM TOP OR CIRCUIT LEVEL DOWN THROUGH
C NESTED SUBCIRCUIT CALLS) WHICH CAUSED THE PARTICULAR ELEMENT TO BE
C ADDED.  AT PRESENT, SPICE RESTRICTS ALL ELEMENT NAMES TO BE 8 CHARAC-
C TERS OR LESS.  THEREFORE, THE NAME USED CONSISTS OF THE LEFTMOST 8
C CHARACTERS OF THE FULL ELEMENT NAME, WITH THE RIGHTMOST CHARACTER
C REPLACED BY AN ASTERISK ('*') IF THE FULL ELEMENT NAME IS LONGER THAN
C 8 CHARACTERS.
C
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DATA ABLANK, APER, ASTK / 1H , 1H., 1H* /
C
C  CONSTRUCT SUBCIRCUIT ELEMENT NAME
C
      IF (NODPLC(LOCE-1).EQ.0) GO TO 100
      LOCVE=NODPLC(LOCE+1)
      LOC=LOCE
      NCHAR=0
      SNAME=ABLANK
      ACHAR=ABLANK
   10 LOCV=NODPLC(LOC+1)
      ELNAME=VALUE(LOCV)
      DO 20 ICHAR=1,8
      CALL MOVE(ACHAR,1,ELNAME,ICHAR,1)
      IF (ACHAR.EQ.ABLANK) GO TO 30
      IF (NCHAR.EQ.8) GO TO 40
      NCHAR=NCHAR+1
      CALL MOVE(SNAME,NCHAR,ACHAR,1,1)
   20 CONTINUE
   30 LOC=NODPLC(LOC-1)
      IF (LOC.EQ.0) GO TO 60
      IF (NCHAR.EQ.8) GO TO 40
      NCHAR=NCHAR+1
      CALL MOVE(SNAME,NCHAR,APER,1,1)
      GO TO 10
C
C  NAME IS LONGER THAN 8 CHARACTERS:  FLAG WITH ASTERISK
C
   40 CALL MOVE(SNAME,8,ASTK,1,1)
   60 VALUE(LOCVE)=SNAME
C
C  FINISHED
C
  100 RETURN
      END
