      SUBROUTINE TERR(LOCT,DELNEW)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE ESTIMATES THE LOCAL TRUNCATION ERROR FOR A PARTICULAR
C CIRCUIT ELEMENT.  IT THEN COMPUTES THE APPROPRIATE STEPSIZE WHICH
C SHOULD BE USED.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DIMENSION QCAP(1),CCAP(1),DIFF(8),DELTMP(7),COEF(6)
      EQUIVALENCE (QCAP(1),VALUE(1)),(CCAP(1),VALUE(2))
      DATA COEF / 5.000000000D-1, 2.222222222D-1, 1.363636364D-1,
     1            9.600000000D-2, 7.299270073D-2, 5.830903790D-2 /
      DATA XTWELV / 8.333333333D-2 /
C
C
      TOL=RELTOL*DMAX1(DABS(CCAP(LX0+LOCT)),DABS(CCAP(LX1+LOCT)))+ABSTOL
      CTOL=RELTOL*DMAX1(DABS(QCAP(LX0+LOCT)),DABS(QCAP(LX1+LOCT)),
     1   CHGTOL)/DELTA
      TOL=DMAX1(TOL,CTOL)
C
C  DETERMINE DIVIDED DIFFERENCES
C
      GO TO (6,5,4,3,2,1), IORD
    1 DIFF(8)=QCAP(LX7+LOCT)
    2 DIFF(7)=QCAP(LX6+LOCT)
    3 DIFF(6)=QCAP(LX5+LOCT)
    4 DIFF(5)=QCAP(LX4+LOCT)
    5 DIFF(4)=QCAP(LX3+LOCT)
    6 DIFF(3)=QCAP(LX2+LOCT)
      DIFF(2)=QCAP(LX1+LOCT)
      DIFF(1)=QCAP(LX0+LOCT)
      ISTOP=IORD+1
      DO 10 I=1,ISTOP
      DELTMP(I)=DELOLD(I)
   10 CONTINUE
   20 DO 30 I=1,ISTOP
      DIFF(I)=(DIFF(I)-DIFF(I+1))/DELTMP(I)
   30 CONTINUE
      ISTOP=ISTOP-1
      IF (ISTOP.EQ.0) GO TO 100
      DO 40 I=1,ISTOP
      DELTMP(I)=DELTMP(I+1)+DELOLD(I)
   40 CONTINUE
      GO TO 20
C
C  DIFF(1) CONTAINS DIVIDED DIFFERENCE
C
  100 CONST=COEF(IORD)
      IF ((METHOD.EQ.1).AND.(IORD.EQ.2)) CONST=XTWELV
      DEL=TRTOL*TOL/DMAX1(ABSTOL,CONST*DABS(DIFF(1)))
      IF (IORD.EQ.1) GO TO 200
      IF (IORD.GE.3) GO TO 150
      DEL=DSQRT(DEL)
      GO TO 200
  150 DEL=DEXP(DLOG(DEL)/DFLOAT(IORD))
  200 DELNEW=DMIN1(DELNEW,DEL)
      RETURN
      END
