	SUBROUTINE TIMRB	!	Note beginning of timed interval
C
C	Save current process statistics in variables in common
C  Usage:
C	CALL TIMRB	! Start of timed interval
C
	COMMON /STAT_VARS/ T0, BUFIO, CPUTIME, DIRIO, PFLTS
	INTEGER*4	BUFIO,CPUTIME,DIRIO,PFLTS
C
C  The following common establishes the parameter list
C  for SYS$GETJPI.  BEWARE of modifying any variables or
C  changing their postion.
C
	COMMON /JOB_PARAM/	LEN4A, BUFIO_CODE, BUFIO_ADR,ZERO,
	2	LEN4B, CPUTIME_CODE, CPUTIME_ADR, ZERO1,
	2	LEN4C, DIRIO_CODE, DIRIO_ADR, ZERO2,
	2	LEN4D, PFLTS_CODE, PFLTS_ADR, ZER03,
	2	ZERO4
	INTEGER*2	LEN4A, LEN4B, LEN4C, LEN4D
	INTEGER*2	BUFIO_CODE, CPUTIME_CODE, DIRIO_CODE, PFLTS_CODE
	INTEGER*4	BUFIO_ADR, CPUTIME_ADR, DIRIO_ADR, PFLTS_ADR
	INTEGER*4	NEW_BUFIO, NEW_CPUTIME, NEW_DIRIO, NEW_PFLTS
	INTEGER*4	ZERO, ZERO1, ZERO2, ZERO3, ZERO4, SYS$GETJPI
	INTEGER*2	SYS$GETMSG, MSGLEN
	CHARACTER	MSGBUF*80
C
C****	Note:  The following codes are VMS symbolic params.
C	....They may change in future versions of VMS...Beware!
C
	DATA	BUFIO_CODE /1036/	! JPI$_BUFIO
	DATA	CPUTIME_CODE /1031/	! JPI$_CPUTIM
	DATA	DIRIO_CODE /1035/	! JPI$_DIRIO
	DATA	PFLTS_CODE /1034/	! JPI$_PAGEFLTS
	DATA	LEN4A, LEN4B, LEN4C, LEN4D /4, 4, 4, 4/
C
C=========================================================================
C
	BUFIO_ADR = %LOC(BUFIO)
	CPUTIME_ADR = %LOC(CPUTIME)
	DIRIO_ADR = %LOC(DIRIO)
	PFLTS_ADR = %LOC(PFLTS)
	I = SYS$GETJPI(,,,LEN4A,,,)
	IF(.NOT.I) THEN
		TYPE *, ' Error from SYS$GETJPI, TIMRB.'
		J = SYS$GETMSG(%VAL(I), MSGLEN, MSGBFR,,)
		IF(J) THEN
			STOP ' PANIC!!! '
		ELSE
			TYPE *, MSGBFR
		ENDIF
	ENDIF
	T0 = SECNDS(0.)
	RETURN
	ENTRY TIMRE	! Print execution statistics for interval
	IFLAG=1
	GO TO 1000
	ENTRY SECOND(TIME) !Return in TIME the number of exe. seconds so far
	IFLAG=0
C
C  Usage:
C	CALL TIMRE 	!  End of timed interval
C  TIMRE obtains process statistics and subtracts the beginning
C  of interval statistics recorded by TIMRB.  The incremental values
C  are written to "TTY", (Fortran unit 6).
1000	CLKTIME = SECNDS(T0)
	BUFIO_ADR = %LOC(NEW_BUFIO)
	CPUTIME_ADR = %LOC(NEW_CPUTIME)
	DIRIO_ADR = %LOC(NEW_DIRIO)
	PFLTS_ADR = %LOC(NEW_PFLTS)
	I = SYS$GETJPI(,,,LEN4A,,,)
	IF(.NOT.I) THEN
		TYPE *, ' Error from SYS$GETJPI, TIMRE. '
		J = SYS$GETMSG(%VAL(I), MSGLEN, MSGBFR,,)
		IF(J) THEN
			STOP ' PANIC!!! '
		ELSE
			TYPE *, MSGBFR
		ENDIF
	ENDIF
	IF(IFLAG.EQ.0) THEN
		TIME=(NEW_CPUTIME-CPUTIME)/100.
		RETURN
		ENDIF
	ICLKHRS = CLKTIME/3600
	ICLKMIN = MOD(IFIX(CLKTIME/60.),60)
	CLKSECS = AMOD(CLKTIME,60.)
C
	CPUSECS = (NEW_CPUTIME - CPUTIME)/100.
	ICPUHRS = CPUSECS/3600
	ICPUMIN = MOD(IFIX(CPUSECS/60),60)
	CPUSECS = AMOD(CPUSECS,60.)
	BUFIO = NEW_BUFIO - BUFIO
	DIRIO = NEW_DIRIO - DIRIO
	PFLTS = NEW_PFLTS - PFLTS
	WRITE(6,99) ICPUHRS,ICPUMIN,CPUSECS,ICLKHRS,ICLKMIN,CLKSECS,
     1        PFLTS, DIRIO, BUFIO
99	FORMAT(//
	1 '        TIME'      ,T28,' PAGE ',T38,'DIRECT',T48,'BUFFERED'/
	2 '    CPU          ELAPSED',T28,'FAULTS',T38,' I/O  ',T48,'  I/O   '/
	3 2(I2,':',I2,':',F5.2,3X),T27,I7,T37,I7,T49,I7/)
C       3 2X, F6.2, 3X, F6.2, T27, I7, T37, I7, T49, I7 /)
C
C  Save the state for the next time around.  The user is supposed to
C  call TIMRB again, but in case he doesn't ...
C
	CPUTIME = NEW_CPUTIME
	BUFIO = NEW_BUFIO
	DIRIO = NEW_DIRIO
	PFLTS = NEW_PFLTS
	T0 = SECNDS(0.)
	RETURN
	END
