      SUBROUTINE TMPUPD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE UPDATES THE TEMPERATURE-DEPENDENT PARAMETERS IN THE
C DEVICE MODELS.  IT ALSO UPDATES THE VALUES OF TEMPERATURE-DEPENDENT
C RESISTORS.  THE UPDATED VALUES ARE PRINTED.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DIMENSION TMPTIT(4)
      DATA TMPTIT / 8HTEMPERAT, 8HURE-ADJU, 8HSTED VAL, 8HUES      /
C
C
      REFTMP=27.0D0+CTOK
      TEMP1=VALUE(ITEMPS+ITEMNO-1)+CTOK
      TEMP2=VALUE(ITEMPS+ITEMNO)+CTOK
      XKT=BOLTZ*TEMP2
      OLDVT=VT
      VT=XKT/CHARGE
      OLDEG=EGFET
      EGFET=1.16D0-(7.02D-4*TEMP2*TEMP2)/(TEMP2+1108.0D0)
      ARG=-EGFET/(XKT+XKT)+1.1150877D0/(BOLTZ*(REFTMP+REFTMP))
      RATIO=TEMP2/TEMP1
      RATLOG=DLOG(RATIO)
      RATIO1=RATIO-1.0D0
      DTEMP=TEMP2-REFTMP
      DELT=VALUE(ITEMPS+ITEMNO)-VALUE(ITEMPS+1)
      DELTSQ=DELT*DELT
      FACT2=TEMP2/REFTMP
      XNI=1.45D16*FACT2*DSQRT(FACT2)*DEXP(CHARGE*ARG)
      PBFACT=-2*VT*(1.5D0*DLOG(FACT2)+CHARGE*ARG)
      XKT1=BOLTZ*TEMP1
      VT1=XKT1/CHARGE
      EGFET1=1.16D0-(7.02D-4*TEMP1*TEMP1)/(TEMP1+1108.0D0)
      ARG1=-EGFET1/(XKT1+XKT1)+1.1150877D0/(BOLTZ*(REFTMP+REFTMP))
      FACT1=TEMP1/REFTMP
      PBFAT1=-2*VT1*(1.5D0*DLOG(FACT1)+CHARGE*ARG1)
    5 CALL TITLE(0,LWIDTH,1,TMPTIT)
C
C  RESISTORS
C
      LOC=LOCATE(1)
      ITITLE=0
   10 IF (LOC.EQ.0) GO TO 100
      LOCV=NODPLC(LOC+1)
      TC1=VALUE(LOCV+3)
      TC2=VALUE(LOCV+4)
      IF (TC1.NE.0.0D0) GO TO 20
      IF (TC2.EQ.0.0D0) GO TO 40
   20 IF (ITITLE.NE.0) GO TO 30
      WRITE (IOFILE,21)
   21 FORMAT(//'0**** RESISTORS',/,'0NAME',8X,'VALUE',//)
      ITITLE=1
   30 RNEW=VALUE(LOCV+2)*(1.0D0+TC1*DELT+TC2*DELTSQ)
      VALUE(LOCV+1)=1.0D0/RNEW
      WRITE (IOFILE,31) VALUE(LOCV),RNEW
   31 FORMAT(1X,A8,1P6D11.3)
   40 LOC=NODPLC(LOC)
      GO TO 10
C
C  DIODE MODEL
C
  100 LOC=LOCATE(21)
      IF (LOC.EQ.0) GO TO 200
      WRITE (IOFILE,101)
  101 FORMAT(//'0**** DIODE MODEL PARAMETERS',/,'0NAME',9X,'IS',9X,'VJ',
     1   8X,'CJO',//)
  110 IF (LOC.EQ.0) GO TO 200
      LOCV=NODPLC(LOC+1)
C...  IS(T2)=IS(T1)*DEXP(EG/(N*VT)*(T2/T1-1))*(T2/T1)**(XTI/N)
      XN=VALUE(LOCV+3)
      FACTOR=RATIO1*VALUE(LOCV+8)/(XN*VT)+VALUE(LOCV+9)/XN*RATLOG
      FACTOR=DEXP(FACTOR)
      VALUE(LOCV+1)=VALUE(LOCV+1)*FACTOR
      OLDPB=VALUE(LOCV+6)
      PBO=(VALUE(LOCV+6)-PBFAT1)/FACT1
      GMAOLD=(OLDPB-PBO)/PBO
      VALUE(LOCV+5)=VALUE(LOCV+5)/(1.0D0+VALUE(LOCV+7)
     1     *(400.0D-6*(TEMP1-REFTMP)-GMAOLD))
  120 VALUE(LOCV+6)=FACT2*PBO+PBFACT
      GMANEW=(VALUE(LOCV+6)-PBO)/PBO
      VALUE(LOCV+5)=VALUE(LOCV+5)
     1   *(1.0D0+VALUE(LOCV+7)*(400.0D-6*DTEMP-GMANEW))
      PBRAT=VALUE(LOCV+6)/OLDPB
      VALUE(LOCV+12)=VALUE(LOCV+12)*PBRAT
      VALUE(LOCV+15)=VALUE(LOCV+15)*PBRAT
      VTE=VALUE(LOCV+3)*VT
      VALUE(LOCV+18)=VTE*DLOG(VTE/(ROOT2*VALUE(LOCV+1)))
      WRITE (IOFILE,31) VALUE(LOCV),VALUE(LOCV+1),VALUE(LOCV+6),
     1                  VALUE(LOCV+5)
      LOC=NODPLC(LOC)
      GO TO 110
C
C  BIPOLAR TRANSISTOR MODEL
C
  200 LOC=LOCATE(22)
      IF (LOC.EQ.0) GO TO 300
      WRITE (IOFILE,201)
  201 FORMAT(//'0**** BJT MODEL PARAMETERS',/,'0NAME',9X,'JS',8X,'BF ',
     1   7X,'ISE',7X,'BR ',7X,'ISC',7X,'VJE',7X,'CJE',7X,'VJC',
     2   7X,'CJC',//)
  210 IF (LOC.EQ.0) GO TO 300
      LOCV=NODPLC(LOC+1)
C...  IS(T2)=IS(T1)*DEXP(EG/VT*(T2/T1-1))*(T2/T1)**XTI
      FACTLN=RATIO1*VALUE(LOCV+42)/VT+VALUE(LOCV+43)*RATLOG
      FACTOR=DEXP(FACTLN)
      VALUE(LOCV+1)=VALUE(LOCV+1)*FACTOR
      TB=VALUE(LOCV+41)
      BFACTR=DEXP(TB*RATLOG)
      VALUE(LOCV+2)=VALUE(LOCV+2)*BFACTR
      VALUE(LOCV+8)=VALUE(LOCV+8)*BFACTR
      VALUE(LOCV+6)=VALUE(LOCV+6)*DEXP(FACTLN/VALUE(LOCV+7))/BFACTR
      VALUE(LOCV+12)=VALUE(LOCV+12)*DEXP(FACTLN/VALUE(LOCV+13))
     1               /BFACTR
      OLDPB=VALUE(LOCV+22)
      PBO=(VALUE(LOCV+22)-PBFAT1)/FACT1
      GMAOLD=(OLDPB-PBO)/PBO
      VALUE(LOCV+21)=VALUE(LOCV+21)/(1.0D0+VALUE(LOCV+23)
     1     *(400.0D-6*(TEMP1-REFTMP)-GMAOLD))
  220 VALUE(LOCV+22)=FACT2*PBO+PBFACT
      GMANEW=(VALUE(LOCV+22)-PBO)/PBO
      VALUE(LOCV+21)=VALUE(LOCV+21)
     1   *(1.0D0+VALUE(LOCV+23)*(400.0D-6*DTEMP-GMANEW))
      PBRAT=VALUE(LOCV+22)/OLDPB
      VALUE(LOCV+46)=VALUE(LOCV+46)*PBRAT
      VALUE(LOCV+47)=VALUE(LOCV+47)*PBRAT
      OLDPB=VALUE(LOCV+30)
      PBO=(VALUE(LOCV+30)-PBFAT1)/FACT1
      GMAOLD=(OLDPB-PBO)/PBO
      VALUE(LOCV+29)=VALUE(LOCV+29)/(1.0D0+VALUE(LOCV+31)
     1     *(400.0D-6*(TEMP1-REFTMP)-GMAOLD))
  230 VALUE(LOCV+30)=FACT2*PBO+PBFACT
      GMANEW=(VALUE(LOCV+30)-PBO)/PBO
      VALUE(LOCV+29)=VALUE(LOCV+29)
     1   *(1.0D0+VALUE(LOCV+31)*(400.0D-6*DTEMP-GMANEW))
      PBRAT=VALUE(LOCV+30)/OLDPB
      VALUE(LOCV+50)=VALUE(LOCV+50)*PBRAT
      VALUE(LOCV+51)=VALUE(LOCV+51)*PBRAT
      VALUE(LOCV+54)=VT*DLOG(VT/(ROOT2*VALUE(LOCV+1)))
      WRITE (IOFILE,211) VALUE(LOCV),VALUE(LOCV+1),VALUE(LOCV+2),
     1   VALUE(LOCV+6),VALUE(LOCV+8),VALUE(LOCV+12),VALUE(LOCV+22),
     2   VALUE(LOCV+21),VALUE(LOCV+30),VALUE(LOCV+29)
  211 FORMAT(1X,A8,1P9D10.3)
      LOC=NODPLC(LOC)
      GO TO 210
C
C  JFET MODEL
C
  300 LOC=LOCATE(23)
      IF (LOC.EQ.0) GO TO 400
      WRITE (IOFILE,301)
  301 FORMAT(//'0**** JFET MODEL PARAMETERS',/,'0NAME',9X,'IS',9X,'PB',
     1   8X,'CGS',8X,'CGD',//)
  310 IF (LOC.EQ.0) GO TO 400
      LOCV=NODPLC(LOC+1)
      VALUE(LOCV+9)=VALUE(LOCV+9)*DEXP(RATIO1*1.11D0/VT)
      OLDPB=VALUE(LOCV+8)
      PBO=(VALUE(LOCV+8)-PBFAT1)/FACT1
      GMAOLD=(OLDPB-PBO)/PBO
      OLDCJF=1.0D0+0.5D0*(400.0D-6*(TEMP1-REFTMP)-GMAOLD)
      VALUE(LOCV+6)=VALUE(LOCV+6)/OLDCJF
      VALUE(LOCV+7)=VALUE(LOCV+7)/OLDCJF
  320 VALUE(LOCV+8)=FACT2*PBO+PBFACT
      GMANEW=(VALUE(LOCV+8)-PBO)/PBO
      CJFACT=1.0D0+0.5D0*(400.0D-6*DTEMP-GMANEW)
      VALUE(LOCV+6)=VALUE(LOCV+6)*CJFACT
      VALUE(LOCV+7)=VALUE(LOCV+7)*CJFACT
      PBRAT=VALUE(LOCV+8)/OLDPB
      VALUE(LOCV+12)=VALUE(LOCV+12)*PBRAT
      VALUE(LOCV+13)=VALUE(LOCV+13)*PBRAT
      VALUE(LOCV+16)=VT*DLOG(VT/(ROOT2*VALUE(LOCV+9)))
      WRITE (IOFILE,31) VALUE(LOCV),VALUE(LOCV+9),VALUE(LOCV+8),
     1   VALUE(LOCV+6),VALUE(LOCV+7)
      LOC=NODPLC(LOC)
      GO TO 310
C
C  MOSFET MODEL
C
  400 LOC=LOCATE(24)
      IPRNT=1
  410 IF (LOC.EQ.0) GO TO 1000
      LOCV=NODPLC(LOC+1)
      TYPE=NODPLC(LOC+2)
      IF(IPRNT.NE.0) WRITE (IOFILE,401)
  401 FORMAT(//'0**** MOSFET MODEL PARAMETERS',/,'0NAME',8X,'VTO',8X,
     1   'PHI',9X,'PB',7X,'IS(JS)',7X,'KP',9X,'UO'//)
      IPRNT=0
      RATIO4=RATIO*DSQRT(RATIO)
      VALUE(LOCV+3)=VALUE(LOCV+3)/RATIO4
      VALUE(LOCV+29)=VALUE(LOCV+29)/RATIO4
      OLDPHI=VALUE(LOCV+5)
      PHIO=(VALUE(LOCV+5)-PBFAT1)/FACT1
  415 VALUE(LOCV+5)=FACT2*PHIO+PBFACT
      PHI=VALUE(LOCV+5)
      VFB=VALUE(LOCV+44)-TYPE*0.5D0*OLDPHI
      VFB=VFB+0.5D0*(OLDEG-EGFET)
      VALUE(LOCV+44)=VFB+TYPE*0.5D0*PHI
      VALUE(LOCV+2)=VALUE(LOCV+44)+TYPE*VALUE(LOCV+4)*DSQRT(PHI)
      VALUE(LOCV+11)=VALUE(LOCV+11)*DEXP(-EGFET/VT+OLDEG/OLDVT)
      VALUE(LOCV+21)=VALUE(LOCV+21)*DEXP(-EGFET/VT+OLDEG/OLDVT)
      OLDPB=VALUE(LOCV+12)
      PBO=(VALUE(LOCV+12)-PBFAT1)/FACT1
      GMAOLD=(OLDPB-PBO)/PBO
      COEOLD=1.0D0+VALUE(LOCV+18)*(400.0D-6*(TEMP1-REFTMP)-GMAOLD)
      VALUE(LOCV+9)=VALUE(LOCV+9)/COEOLD
      VALUE(LOCV+10)=VALUE(LOCV+10)/COEOLD
      VALUE(LOCV+17)=VALUE(LOCV+17)/COEOLD
      VALUE(LOCV+19)=VALUE(LOCV+19)/(1.0D0+VALUE(LOCV+20)
     1     *(400.0D-6*(TEMP1-REFTMP)-GMAOLD))
  420 VALUE(LOCV+12)=FACT2*PBO+PBFACT
      GMANEW=(VALUE(LOCV+12)-PBO)/PBO
      COENEW=1.0D0+VALUE(LOCV+18)*(400.0D-6*DTEMP-GMANEW)
      VALUE(LOCV+9)=VALUE(LOCV+9)*COENEW
      VALUE(LOCV+10)=VALUE(LOCV+10)*COENEW
      VALUE(LOCV+17)=VALUE(LOCV+17)*COENEW
      VALUE(LOCV+19)=VALUE(LOCV+19)*
     1   (1.0D0+VALUE(LOCV+20)*(400.0D-6*DTEMP-GMANEW))
      PBRAT=VALUE(LOCV+12)/OLDPB
      VALUE(LOCV+37)=VALUE(LOCV+37)*PBRAT
      VALUE(LOCV+38)=VALUE(LOCV+38)*PBRAT
      CSAT=DMAX1(VALUE(LOCV+11),VALUE(LOCV+21))
      WRITE (IOFILE,31) VALUE(LOCV),VALUE(LOCV+2),VALUE(LOCV+5),
     1   VALUE(LOCV+12),CSAT,VALUE(LOCV+3),VALUE(LOCV+29)
  430 LOC=NODPLC(LOC)
      GO TO 410
C
C  FINISHED
C
 1000 RETURN
      END
