      SUBROUTINE TOPCHK
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE CONSTRUCTS THE ELEMENT NODE TABLE.  IT ALSO CHECKS
C FOR VOLTAGE SOURCE/INDUCTOR LOOPS, CURRENT SOURCE/CAPACITOR CUTSETS,
C AND THAT EVERY NODE HAS A DC (CONDUCTIVE) PATH TO GROUND
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
      INTEGER CHANGE
C
C
      DIMENSION ATABLE(12),AIDE(20),NNODS(20)
      DIMENSION IDLIST(4),IDLIS2(4)
      DIMENSION TOPTIT(4)
      DATA TOPTIT / 8HELEMENT , 8HNODE TAB, 8HLE      , 8H         /
      DATA IDLIST / 3, 6, 8, 9 /
      DATA IDLIS2 /14,14,14,11 /
      DATA AIDE / 1HR,0.0D0,1HL,2*0.0D0,1HE,0.0D0,1HH,1HV,0.0D0,1HD,
     1   1HQ,1HJ,1HM,0.0D0,0.0D0,1HT,0.0D0,0.0D0,0.0D0 /
      DATA NNODS / 2,2,2,0,2,2,2,2,2,2,2,4,3,4,4,4,4,0,0,0 /
      DATA ABLNK /1H /
C
C  ALLOCATE STORAGE
C
      CALL GETM4(IORDER,NCNODS)
      CALL GETM4(IUR,NCNODS+1)
C
C  CONSTRUCT NODE TABLE
C
      KNTLIM=LWIDTH/11
 1300 CALL GETM4(ITABLE,0)
      CALL GETM4(ITABID,0)
      ISTOP=NCNODS+1
      DO 1310 I=1,ISTOP
 1310 NODPLC(IUR+I)=1
      DO 1370 ID=1,18
      IF (NNODS(ID).EQ.0) GO TO 1370
      LOC=LOCATE(ID)
 1320 IF (LOC.EQ.0) GO TO 1370
      NLOC=LOC+1
      JSTOP=NNODS(ID)
 1330 DO 1360 J=1,JSTOP
      NODE=NODPLC(NLOC+J)
      ISPOT=NODPLC(IUR+NODE+1)
      K=NODPLC(IUR+NCNODS+1)
      CALL EXTMEM(ITABLE,1)
      CALL EXTMEM(ITABID,1)
      IF (K.LE.ISPOT) GO TO 1340
      CALL COPY4(NODPLC(ITABLE+ISPOT),NODPLC(ITABLE+ISPOT+1),K-ISPOT)
      CALL COPY4(NODPLC(ITABID+ISPOT),NODPLC(ITABID+ISPOT+1),K-ISPOT)
 1340 NODPLC(ITABLE+ISPOT)=LOC
      NODPLC(ITABID+ISPOT)=ID
C...  TREAT THE SUBSTRATE NODE OF A MOSFET AS IF IT WERE A TRANSMISSION
C...  LINE NODE, I.E. LET IT DANGLE IF DESIRED
      IF(ID.EQ.14.AND.J.EQ.4) NODPLC(ITABID+ISPOT)=17
      K=NODE
      KSTOP=NCNODS+1
 1350 K=K+1
      IF (K.GT.KSTOP) GO TO 1360
      NODPLC(IUR+K)=NODPLC(IUR+K)+1
      GO TO 1350
 1360 CONTINUE
      LOC=NODPLC(LOC)
      GO TO 1320
 1370 CONTINUE
C
C  CHECK THAT EVERY NODE HAS A DC PATH TO GROUND
C
      CALL ZERO4(NODPLC(IORDER+1),NCNODS)
      NODPLC(IORDER+1)=1
 1420 IFLAG=0
      DO 1470 I=2,NCNODS
      IF (NODPLC(IORDER+I).EQ.1) GO TO 1470
      JSTART=NODPLC(IUR+I)
      JSTOP=NODPLC(IUR+I+1)-1
      IF (JSTART.GT.JSTOP) GO TO 1470
      DO 1450 J=JSTART,JSTOP
      LOC=NODPLC(ITABLE+J)
      ID=NODPLC(ITABID+J)
      IF (AIDE(ID).EQ.0.0D0) GO TO 1450
      IF (ID.EQ.17) GO TO 1445
      KSTOP=LOC+NNODS(ID)-1
      DO 1440 K=LOC,KSTOP
      NODE=NODPLC(K+2)
      IF (NODPLC(IORDER+NODE).EQ.1) GO TO 1460
 1440 CONTINUE
      GO TO 1450
 1445 IF (NODPLC(LOC+2).EQ.I) NODE=NODPLC(LOC+3)
      IF (NODPLC(LOC+3).EQ.I) NODE=NODPLC(LOC+2)
      IF (NODPLC(LOC+4).EQ.I) NODE=NODPLC(LOC+5)
      IF (NODPLC(LOC+5).EQ.I) NODE=NODPLC(LOC+4)
      IF (NODPLC(IORDER+NODE).EQ.1) GO TO 1460
 1450 CONTINUE
      GO TO 1470
 1460 NODPLC(IORDER+I)=1
      IFLAG=1
 1470 CONTINUE
      IF (IFLAG.EQ.1) GO TO 1420
C
C  PRINT NODE TABLE AND TOPOLOGY ERROR MESSAGES
C
      IF (IPRNTN.EQ.0) GO TO 1510
      CALL TITLE(0,LWIDTH,1,TOPTIT)
 1510 DO 1590 I=1,NCNODS
      JSTART=NODPLC(IUR+I)
      JSTOP=NODPLC(IUR+I+1)-1
      IF (IPRNTN.EQ.0) GO TO 1550
      IF (JSTART.LE.JSTOP) GO TO 1520
      WRITE (IOFILE,1511) NODPLC(JUNODE+I)
 1511 FORMAT(1H0,I7)
      GO TO 1550
 1520 KNTR=0
      JFLAG=1
      DO 1540 J=JSTART,JSTOP
      LOC=NODPLC(ITABLE+J)
      LOCV=NODPLC(LOC+1)
      KNTR=KNTR+1
      ATABLE(KNTR)=VALUE(LOCV)
      IF (KNTR.LT.KNTLIM) GO TO 1540
      IF (JFLAG.EQ.0) GO TO 1525
      JFLAG=0
      WRITE (IOFILE,1521) NODPLC(JUNODE+I),(ATABLE(K),K=1,KNTR)
 1521 FORMAT(1H0,I7,3X,12(1X,A8))
      GO TO 1530
 1525 WRITE (IOFILE,1526) (ATABLE(K),K=1,KNTR)
 1526 FORMAT(11X,12(1X,A8))
 1530 KNTR=0
 1540 CONTINUE
      IF (KNTR.EQ.0) GO TO 1550
      IF (JFLAG.EQ.0) GO TO 1545
      WRITE (IOFILE,1521) NODPLC(JUNODE+I),(ATABLE(K),K=1,KNTR)
      GO TO 1550
 1545 WRITE (IOFILE,1526) (ATABLE(K),K=1,KNTR)
 1550 IF (JSTART-JSTOP) 1560,1552,1556
C
C  ALLOW NODE WITH ONLY ONE CONNECTION IFF ELEMENT IS A T-LINE
C
 1552 IF (NODPLC(ITABID+JSTART).EQ.17) GO TO 1560
 1556 NOGO=1
      WRITE (IOFILE,1557) NODPLC(JUNODE+I)
 1557 FORMAT('0*ERROR*:  LESS THAN 2 CONNECTIONS AT NODE ',I6/)
      GO TO 1590
 1560 IF (NODPLC(IORDER+I).EQ.1) GO TO 1590
      NOGO=1
      WRITE (IOFILE,1561) NODPLC(JUNODE+I)
 1561 FORMAT('0*ERROR*:  NO DC PATH TO GROUND FROM NODE ',I6/)
 1590 CONTINUE
C
C  CHECK FOR INDUCTOR/VOLTAGE SOURCE LOOPS
C
      DO 1700 I=1,NCNODS
      CALL ZERO4(NODPLC(IORDER+1),NCNODS)
      NODPLC(IORDER+I)=-1
 1605 CHANGE=0
      DO 1690 IDCNTR=1,4
      ID=IDLIST(IDCNTR)
      LOC=LOCATE(ID)
 1610 IF ((LOC.EQ.0).OR.(NODPLC(LOC+IDLIS2(IDCNTR)).NE.0)) GO TO 1690
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      IF (NODPLC(IORDER+NODE1).EQ.LOC.OR.
     1   NODPLC(IORDER+NODE2).EQ.LOC) GO TO 1680
      IF (NODPLC(IORDER+NODE1)) 1620,1640,1630
 1620 NODPLC(IORDER+NODE1)=LOC
      CHANGE=1
 1630 NODE=NODE2
      GO TO 1670
 1640 IF (NODPLC(IORDER+NODE2)) 1650,1680,1660
 1650 NODPLC(IORDER+NODE2)=LOC
      CHANGE=1
 1660 NODE=NODE1
 1670 IF (NODPLC(IORDER+NODE).NE.0) GO TO 1710
      NODPLC(IORDER+NODE)=LOC
      CHANGE=1
 1680 LOC=NODPLC(LOC)
      GO TO 1610
 1690 CONTINUE
      IF (CHANGE.EQ.1) GO TO 1605
 1700 CONTINUE
      GO TO 1900
C ... LOOP FOUND
 1710 LOCV=NODPLC(LOC+1)
      WRITE (IOFILE,1711) VALUE(LOCV)
 1711 FORMAT('0*ERROR*:  INDUCTOR/VOLTAGE SOURCE LOOP FOUND, CONTAINING
     1',A8/)
      NOGO=1
C
C
 1900 CALL CLRMEM(IORDER)
      CALL CLRMEM(IUR)
      CALL CLRMEM(ITABLE)
      CALL CLRMEM(ITABID)
 2000 RETURN
      END
