#include <stdio.h>
#include <descrip.h>
#include <ssdef.h>

#define step 4
#define limit 2
#define index 1

unsigned int softcrc(int crctbl[16],int init,char *tststr)
{
   register char *s;
   register unsigned int tmp,tmp2,i;
   s = tststr;
   tmp = init;
   while (*s)
      {
         tmp = tmp^((int)*s);
         for (i=0;i<limit;i++)
            {
               tmp2 = tmp>>step;
               tmp2 = tmp2^crctbl[(tmp-(tmp2<<step))*index];
               tmp = tmp2;
            };
         s++;
      };
   return tmp;
}

void lib$crc_table();
int lib$crc();

#define tststr "This is a stupid test-string choosen random"
#ifdef CRC16
int poly = 0x0000A001;
int init = 0x00000000;
#endif
#ifdef CCITT
int poly = 0x00008408;
int init = 0x0000FFFF;
#endif
#ifdef AUTODINII
int poly = 0xEDB88320;
int init = 0xFFFFFFFF;
#endif
int crctbl[16];

main()
{
   $DESCRIPTOR(tstdes,tststr);
   lib$crc_table(&poly,&crctbl);
   printf("CRC of >>%s<< is  %8X\n",tststr,lib$crc(&crctbl,&init,&tstdes));
   printf("soft-CRC of >>%s<< is  %8X\n",tststr,softcrc(crctbl,init,tststr));
   return SS$_NORMAL;
}
