/* start of special IO module */

#include <string.h>
#include <descrip.h>
#include <iodef.h>
#include <ttdef.h>
#include <tt2def.h>
#include <libclidef.h>

#define TRUE 1
#define FALSE 0

long lib$asn_wth_mbx();
long sys$qiow();
long sys$dassgn();
long lib$disable_ctrl();
long lib$enable_ctrl();

#define NBYT 100

short chan,mbx;
long ctrlint = FALSE;
long bcasttrap = FALSE;
char bcastmsg[NBYT];
long restore[3];

void catcher()
{
   ctrlint = TRUE;
   return;
}

void trapper()
{
   char tmp[NBYT];
   sys$qiow(0,mbx,IO$_READVBLK,0,0,0,tmp,sizeof(tmp),0,0,0,0);
   memcpy(&bcastmsg,&tmp[22],tmp[20]);
   bcastmsg[tmp[20]] = '\0';
   bcasttrap = TRUE;
   return;
}

void ttopen()
{
   $DESCRIPTOR(ttdesc,"TT:");
   long mask,charac[3];
   long maxmsgsiz = NBYT;
   long bufquo = 5*NBYT;
   lib$asn_wth_mbx(&ttdesc,&maxmsgsiz,&bufquo,&chan,&mbx);
   mask = LIB$M_CLI_CTRLY;
   lib$disable_ctrl(&mask);
   sys$qiow(0,chan,IO$_SETMODE|IO$M_CTRLYAST,0,0,0,catcher,0,0,0,0,0);
   sys$qiow(0,chan,IO$_SENSEMODE,0,0,0,charac,12,0,0,0,0);
   restore[0] = charac[0];
   restore[1] = charac[1];
   restore[2] = charac[2];
   charac[1] = charac[1] | TT$M_NOBRDCST | TT$M_MBXDSABL;
   charac[2] = charac[2] | TT2$M_BRDCSTMBX;
   sys$qiow(0,chan,IO$_SETMODE,0,0,0,charac,12,0,0,0,0);
   sys$qiow(0,mbx,IO$_SETMODE|IO$M_WRTATTN,0,0,0,trapper,0,0,0,0,0);
   return;
}

void putch(char k)
{
   sys$qiow(0,chan,IO$_WRITEVBLK,0,0,0,&k,1,0,0,0,0);
   return;
}

void putstr(char *s)
{
   sys$qiow(0,chan,IO$_WRITEVBLK,0,0,0,s,strlen(s),0,0,0,0);
   return;
}

long kbhit()
{
   short charac[4];
   sys$qiow(0,chan,IO$_SENSEMODE|IO$M_TYPEAHDCNT,0,0,0,&charac,8,0,0,0,0);
   if (charac[0]>0)
      return TRUE;
   else
      return FALSE;
}

long ctrlychit()
{
   return ctrlint;
}

long bcastreceiv()
{
   return bcasttrap;
}

long getch()
{
   long k = 0;
   sys$qiow(0,chan,IO$_READVBLK|IO$M_NOECHO|IO$M_NOFILTR,0,0,0,&k,1,0,0,0,0);
   return k;
}

void ttclose()
{
   long mask;
   putch('\r');
   sys$qiow(0,chan,IO$_SETMODE,0,0,0,restore,12,0,0,0,0);
   mask = LIB$M_CLI_CTRLY;
   lib$enable_ctrl(&mask);
   sys$dassgn(chan);
   return;
}

/* end of special IO module */

#include <stdio.h>
#include <ssdef.h>

long lib$wait();

main(long argc,char *argv[])
{
   long i;
   float t;
   char k;
   char pmt[]="Enter 1,2 or 3 ? ";
   ttopen();
   putstr(pmt);
   t = 1.0;
   do {
      putch('.');
      lib$wait(&t);
   } while (!(kbhit()||ctrlychit()||bcastreceiv()));
   if (ctrlychit()) {
      ttclose();
      printf("Interrupted by user !\n");
   } else if (bcastreceiv()) {
      ttclose();
      printf("Broadcast received = %s !\n",bcastmsg);
   } else {
      k=getch();
      ttclose();
      printf("You entered : %c\n",k);
   };
   return SS$_NORMAL;
}
