$ fortran/object=z1.obj sys$input
      PROGRAM Z1
      REAL*16 TWO,THREE,RES
      DATA TWO/2.0Q6/
      DATA THREE/3.0Q6/
      RES=TWO+THREE
      RES=TWO*RES
      WRITE(*,*) RES
      END
$
$ link z1
$ run z1
$ macro/object=z sys$input
        .title  i8
        .psect  $LOCAL quad,pic,con,lcl,noshr,noexe,wrt
space:  .blkh   1
        .psect  $CODE quad,pic,con,lcl,shr,exe,nowrt
;***************************************
;
;  I8_ADD ( ADD1 , ADD2 , RES )
;
;  integer*8 addition
;
;***************************************
        .entry  i8_add,^m<r2>
        movl    B^4(ap),r0
        movl    B^8(ap),r1
        movl    B^12(ap),r2
        movl    (r1),(r2)
        movl    B^4(r1),B^4(r2)
        addl2   (r0),(r2)               ; add low bits
        adwc    B^4(r0),B^4(r2)         ; add high bits
        ret
;***************************************
;
;  I8_SUB ( SUB1 , SUB2 , RES )
;
;  integer*8 subtraction
;
;***************************************
        .entry  i8_sub,^m<r2>
        movl    B^4(ap),r0
        movl    B^8(ap),r1
        movl    B^12(ap),r2
        movl    (r1),(r2)
        movl    B^4(r1),B^4(r2)
        subl2   (r0),(r2)               ; subtract low bits
        sbwc    B^4(r0),B^4(r2)         ; subtract high bits
        ret
;***************************************
;
;  I8_MUL ( MUL1 , MUL2 , RES )
;
;  integer*8 multiplikation
;
;***************************************
        .entry  i8_mul,^m<r2,r3,r4,r5,r6,r7,r8>
        movl    B^4(ap),r6
        movl    B^8(ap),r7
        movl    B^12(ap),r8
        jsb     G^COB$MULQ_R8           ; use COBOL routine
        ret
;***************************************
;
;  I8_DIV ( DIV1 , DIV2 , RES )
;
;  integer*8 division ( RES=DIV2 DIV DIV1 )
;
;***************************************
        .entry  i8_div,^m<r2,r3,r4,r5,r6,r7,r8>
        movl    B^4(ap),r6
        movl    B^8(ap),r7
        movl    B^12(ap),r8
        jsb     G^COB$DIVQ_R8           ; use COBOL routine
        ret
;***************************************
;
;  I8_MOD ( DIV1 , DIV2 , RES )
;
;  integer*8 modulus ( RES=DIV2 MOD DIV1 )
;
;***************************************
        .entry  i8_mod,^m<r2,r3,r4,r5,r6,r7,r8>
        movl    B^4(ap),r6
        movl    B^8(ap),r7
        movl    B^12(ap),r8
        jsb     G^COB$DIVQ_R8           ; use COBOL routine
        movl    B^12(ap),r6
        movl    B^4(ap),r7
        movl    B^12(ap),r8
        jsb     G^COB$MULQ_R8           ; use COBOL routine
        movl    B^12(ap),r0
        movl    B^8(ap),r1
        moval   space,r2
        movl    (r1),(r2)
        movl    B^4(r1),B^4(r2)
        subl2   (r0),(r2)               ; subtract low bits
        sbwc    B^4(r0),B^4(r2)         ; subtract high bits
        movl    B^12(ap),r0
        movl    space,(r0)
        movl    space+4,B^4(r0)
        ret
;***************************************
;
;  I8_FROMREAL ( I8VAL , XVAL )
;
;  integer*8 conversion from real
;
;***************************************
        .entry  i8_fromreal,^m<r2,r3,r4,r5,r6,r7,r8>
        pushab  space
        pushl   B^8(ap)
        calls   #2,G^MTH$CVT_G_D
        movl    #0,r6
        moval   space,r7
        movl    B^4(ap),r8
        jsb     G^COB$CVTDQ_R8          ; use COBOL routine
        ret
;***************************************
;
;  I8_TOREAL ( I8VAL , XVAL )
;
;  integer*8 conversion to real
;
;***************************************
        .entry  i8_toreal,^m<r2,r3,r4,r5,r6,r7,r8>
        movl    #0,r6
        movl    B^4(ap),r7
        moval   space,r8
        jsb     G^COB$CVTQD_R8          ; use COBOL routine
        pushl   B^8(ap)
        pushab  space
        calls   #2,G^MTH$CVT_D_G
        ret
        .end
$
$ fortran/object=z2.obj sys$input
      PROGRAM Z2
      INTEGER*4 TWO(2),THREE(2),RES(2)
      DATA TWO/2000000,0/
      DATA THREE/3000000,0/
      CALL I8_ADD(TWO,THREE,RES)
      CALL I8_MUL(TWO,RES,RES)
      WRITE(*,*) RES
      END
$
$ link z2+z
$ run z2
$ cc/object=z3.obj sys$input
#include <stdio.h>

void i8_add();
void i8_mul();

main()
{
   long two[2] = {2000000,0};
   long three[2] = {3000000,0};
   long res[2];
   i8_add(two,three,res);
   i8_mul(two,res,res);
   printf("%d %d\n",res[0],res[1]);
}
$
$ link z3+z+sys$input/opt
sys$share:vaxcrtl/share
$
$ run z3
$ copy sys$input z4.cc
#include <Integer.h>

main()
{
   Integer Two(2000000),Three(3000000),Res;
   Res=Two+Three;
   Res=Two*Res;
   cout << Res;
};
$
$ gcc/plus z4
$ cxshare z4
$ run z4
$ exit
