program normal(input,output);

function stat_norm_dens(x:double):double;

begin
   stat_norm_dens:=exp(-(x*x)/2)/sqrt(2*3.141592653589793);
end;

function stat_norm_acc(x:double):double;

var
   i       : integer;
   tmp,add : double;
   done    : boolean;

begin
   done:=false;
   if (x=0) then begin
      stat_norm_acc:=0.5;
      done:=true;
   end;
   if (x<-6) then begin
      stat_norm_acc:=0;
      done:=true;
   end;
   if (x>6) then begin
      stat_norm_acc:=1;
      done:=true;
   end;
   if not(done) then begin
      if(abs(x)>2.5) then begin
         tmp:=abs(x);
         for i:=10 downto 1 do tmp:=abs(x)+i/tmp;
         if (x>0) then begin
            stat_norm_acc:=1-stat_norm_dens(x)/tmp;
         end else begin
            stat_norm_acc:=stat_norm_dens(x)/tmp;
         end;
      end else begin
         tmp:=0;
         add:=abs(x);
         for i:=1 to 11 do begin
            tmp:=tmp+add;
            add:=add*x*x/(2*i+1);
         end;
         if (x>0) then begin
            stat_norm_acc:=0.5+stat_norm_dens(x)*tmp;
         end else begin
            stat_norm_acc:=0.5-stat_norm_dens(x)*tmp;
         end;
      end;
   end;
end;

function stat_norm_invacc(x:double):double;

var
   z,znew,relcha : double;
   done          : boolean;

begin
   done:=false;
   if (x=0.5) then begin
      stat_norm_invacc:=0;
      done:=true;
   end;
   if not(done) then begin
      if (x<0.5) then begin
         z:=-1;
      end else begin
         z:=1;
      end;
      repeat
         znew:=z-(stat_norm_acc(z)-x)/stat_norm_dens(z);
         relcha:=znew/z;
         z:=znew;
      until (relcha>0.99999) and (relcha<1.00001);
   end;
   stat_norm_invacc:=znew;
end;

var
   i : integer;
   x : array [1..15] of double := (-3.5,-3.0,-2.5,-2.0,-1.5,-1.0,-0.5,
                                   0.0,
                                   0.5,1.0,1.5,2.0,2.5,3.0,3.5);
   y : array [1..15] of double := (0.0002,0.0014,0.0062,0.0228,0.0668,
                                   0.1587,0.3085,0.5000,0.6915,0.8413,
                                   0.9332,0.9772,0.9938,0.9986,0.9998);

begin
   for i:=1 to 15 do writeln(y[i]:7:4,'=',stat_norm_acc(x[i]):7:4);
   for i:=1 to 15 do writeln(x[i]:7:4,'=',stat_norm_invacc(y[i]):7:4);
end.
