/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : february 1996
 *
 *  Purpose    : send POST request HTTP-server
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <socket.h>
#include <netdb.h>

#include <unixio.h>
#include <errno.h>

void postaction(char *hostname,int port,char *path,char *data)
{
   int sd,status,len,tmp,active;
   char cmd[512],resp[512];
   struct sockaddr local,remote;
   struct hostent *hostinfo;
   /* create socket */
   sd=socket(AF_INET,SOCK_STREAM,0);
   if(sd<0) {
      printf("Error creating socket: %s\n",strerror(errno));
      goto fin;
   }
   /* bind socket */
   local.sa_family=AF_INET;
   memset(local.sa_data,0,sizeof(local.sa_data));
   status=bind(sd,&local,sizeof(local));
   if(status<0) {
      printf("Error binding socket: %s\n",strerror(errno));
      goto fin;
   }
   /* lookup host */
   hostinfo=gethostbyname(hostname);
   if(!hostinfo) {
      printf("Error looking up host: %s\n",hostname);
      goto fin;
   }
   /* connect to host */
   remote.sa_family=hostinfo->h_addrtype;
   memcpy(remote.sa_data+2,hostinfo->h_addr_list[0],hostinfo->h_length);
   *((short *)remote.sa_data)=port;
   tmp=remote.sa_data[0];
   remote.sa_data[0]=remote.sa_data[1];
   remote.sa_data[1]=tmp;
   status=connect(sd,&remote,sizeof(remote));
   if(status!=0) {
      printf("Error connecting to host: %s port: %d\n",hostname,port);
      goto fin;
   }
   /* send POST request */
   sprintf(cmd,"POST %s HTTP/1.0\r\n"
               "Content-Encoding: 8bit\r\n"
               "Content-Length: %d\r\n"
               "Content-Type: application/x-www-form-urlencoded\r\n"
               "\r\n"
               "%s\r\n"
               "\r\n",
               path,strlen(data),data);
   status=send(sd,cmd,strlen(cmd),0);
   if(status<0) {
      printf("Error sending POST request\n");
      goto fin;
   }
   /* read response */
   active=0;
   while ((len=recv(sd,resp,sizeof(resp)-1,0))>0) {
      resp[len]='\0';
      if(active) printf("%s",resp);
      if(strstr(resp,"\r\n\r\n")!=NULL) active=1;
   }
fin:
   close(sd);
   return;
}

main(int argc,char *argv[])
{
   if(argc==5) postaction(argv[1],atoi(argv[2]),argv[3],argv[4]);
}
