program test_acl(input,output);

type
   fstring = packed array [1..12] of char;
   string  = varying [12] of char;
   actyp   = array [1..5] of integer;

type
   fstring25 = array [1..25] of fstring;
   integer25 = array [1..25] of integer;
   actyp25   = array [1..25] of actyp;

[external] procedure delacl(%STDESCR fnm:fstring); external;

[external] procedure deloneacl(%STDESCR fnm:fstring;%STDESCR un:fstring;
                               %REF ac:actyp); external;

[external] procedure getacl(%STDESCR fnm:fstring;%REF n:integer;
                            %STDESCR un:fstring25;%REF unlen:integer25;
                            %REF ac:actyp25); external;

[external] procedure putacl(%STDESCR fnm:fstring;%STDESCR un:fstring;
                            %REF ac:actyp); external;

procedure test;

var
   n,i,j : integer;
   un    : fstring25;
   unlen : integer25;
   ac    : actyp25;
   tmp   : string;

begin
   getacl('tst.dat          ',n,un,unlen,ac);
   writeln('NO ACL=',n);
   for i:=1 to n do begin
      tmp.body:=un[i];
      tmp.length:=unlen[i];
      write(un[i]);
      for j:=1 to 5 do write(ac[i,j]);
      writeln;
   end;
end;

var
   ac : actyp;

value
   ac := (-1,-1,0,0,0);

begin
   test;
   putacl('tst.dat     ','ecoav       ',ac);
   test;
   putacl('tst.dat     ','ecoappel    ',ac);
   test;
   putacl('tst.dat     ','ecopeter    ',ac);
   test;
   deloneacl('tst.dat     ','ecoav       ',ac);
   test;
   delacl('tst.dat     ');
   test;
end.
