(*
 *  Purpose       : test all username for is password=username
 *  Author        : Arne Vajhj
 *  Last modified : 16/02/93
 *  Usage         : RUN UN_PW_CHECK
 *  Remarks       : need SYSPRV priv
 *)

[inherit('sys$library:starlet')]

program un_pw_check(input,output);

type
   identifier = unsigned;
   username   = packed array [1..12] of char;
   item       = record
                   case boolean of
                      true  : (
                              buflen,itmcod : [word] 0..65535;
                              bufadr,retlenadr : unsigned;
                              );
                      false : (
                              zero : integer;
                              );
                end;
   itemlist   = array [1..4] of item;
   quadword   = record
                   l0,l1 : unsigned;
                end;
   privmask   = quadword;
   password   = quadword;

var
   id1,id2                  : identifier;
   un                       : username;
   un2                      : array [1..2] of integer;
   ctx                      : unsigned;
   pwdata                   : itemlist;
   sysprv                   : privmask;
   algo,ransalt             : integer;
   binpwd,calcpwd           : password;

begin
   id1:=-1;
   ctx:=0;
   pwdata[1].buflen:=8;
   pwdata[1].itmcod:=UAI$_PWD;
   pwdata[1].bufadr:=iaddress(binpwd);
   pwdata[1].retlenadr:=0;
   pwdata[2].buflen:=2;
   pwdata[2].itmcod:=UAI$_SALT;
   pwdata[2].bufadr:=iaddress(ransalt);
   pwdata[2].retlenadr:=0;
   pwdata[3].buflen:=1;
   pwdata[3].itmcod:=UAI$_ENCRYPT;
   pwdata[3].bufadr:=iaddress(algo);
   pwdata[3].retlenadr:=0;
   pwdata[4].zero:=0;
   sysprv.l0:=PRV$M_SYSPRV;
   sysprv.l1:=0;
   $setprv(enbflg:=1,prvadr:=sysprv,prmflg:=0);
   while odd($idtoasc(id:=id1,nambuf:=un,resid:=id2,contxt:=ctx)) do begin
      if id2<maxint then begin
         if odd($getuai(usrnam:=un,itmlst:=pwdata)) then begin
            un2[1]:=index(un,' ')-1;
            if un2[1]=-1 then un2[1]:=12;
            un2[2]:=iaddress(un);
            $hash_password(pwd:=%REF un2,alg:=algo,salt:=ransalt,
                           usrnam:=%REF un2,hash:=calcpwd);
            if (binpwd.l0=calcpwd.l0) and (binpwd.l1=calcpwd.l1) then begin
               writeln(un,' har risikabelt password');
            end;
         end;
      end;
   end;
end.
