	implicit none

	integer channel,terch

	integer status,sys$assign,sys$qiow,sys$alloc

	integer iosb( 2 )

	include '($iodef)'

	character*132 Buffer
	integer length

	Integer Controller
	Integer Unit
	Integer I

C	Allocate the device

	Status = Sys$Alloc( %descr( '_LPA0:' ), , , , )

	if( .not. Status ) then
	  print *,'Could not allocate LPA0:'
	  call lib$stop( %val( Status ) )
	endif

C	Assign a channel to the device

	Status = sys$assign( %descr( '_LPA0:' ), Channel, , , )
	if( .not. Status ) then
	  print *,'Could not assign channel to LPA0:.'
	  call lib$stop( %val( Status ) )
	endif

C	Find out which terminal we're monitoring.

1	print '(1h+,$,A)','Controller (e.g. TXA)? '
	accept '(Q,A)',I,Buffer

	if( I .NE. 3 ) then
	  print '(X,A)','I need three letters.'
	  print '(X)'
	  goto 1
	endif

	Controller = 0

	Do I = 3, 1, -1
	  Controller = ( Controller * 256 ) +
	1	IChar( Buffer( I : I ) )
	EndDo

	Controller = Controller * 256 + 3	! Add in length code

	Print '(1h+,$,A)','Unit? '
	Accept '(I)', Unit

c	assign a channel to the terminal

	Status = sys$assign( 'SYS$OUTPUT', TerCh, , , )
	if( .not. Status ) then
	  print *,'Could not assign channel to sys$output.'
	  call lib$stop( %val( Status ) )
	endif

C	Connect to the terminal

	Status = Sys$QioW(
	1	,				! Efn
	1	%val( Channel ),		! Channel
	1	%val( IO$_ConIntRead ),		! Function
	1	Iosb,				! Iosb
	1	, ,				! Ast, AstParm
	1	%val( Controller ),		! Controller
	1	%val( Unit ),			! Unit number
	1	, , , , )			! P2 - P6

	if( .not. Status ) then
	  print *,'Could not issue QIO.'
	  call Lib$Stop( %val( Status ) )
	endif

	print '(X,A,2(X,Z8.8))','IOSB: ', IOSB

	if( .not. IOSB( 1 ) ) then
	  print *,'Error from QIO.'
	  Call Lib$Stop( %val( IOSB( 1 ) .AND. 'ffff'x ) )
	endif

C	Read data and display it

5	Status = Sys$QioW(
	1	,				! Efn
	1	%val( Channel ),		! Channel
	1	%val( IO$_ReadVBlk ),		! Function
	1	Iosb,				! Iosb
	1	, ,				! Ast, AstParm
	1	%ref( Buffer ),			! Controller
	1	%val( 132 ),			! Unit number
	1	, , , , )			! P2 - P6

	if( .not. Status ) then
	  print *,'Could not issue QIO.'
	  call Lib$Stop( %val( Status ) )
	endif

	if( .not. IOSB( 1 ) ) then
	  print *,'Error from QIO.'
	  Call Lib$Stop( %val( IOSB( 1 ) .AND. 'ffff'x ) )
	endif

C	print '(X,A,2(X,Z8.8))','IOSB: ', IOSB

	Length = IOSB( 1 ) / 65536

	if( Length .NE. 0 ) Then
	  Status = Sys$QioW(
	1	,				! Efn
	1	%val( TerCh ),			! Channel
	1	%val( IO$_WriteVBlk .OR. Io$M_NoFormat),! Function
	1	Iosb,				! Iosb
	1	, ,				! Ast, AstParm
	1	%ref( Buffer ),			! Controller
	1	%val( Length ),			! Unit number
	1	, , , , )			! P2 - P6
	endif

	if( .not. Status ) then
	  print *,'Could not issue QIO.'
	  call Lib$Stop( %val( Status ) )
	endif

	if( .not. IOSB( 1 ) ) then
	  print *,'Error from QIO.'
	  Call Lib$Stop( %val( IOSB( 1 ) .AND. 'ffff'x ) )
	endif

	goto 5

	end

