#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

int decode_b64char( int ch )
{
    int		sextet;

    if( ('A' <= ch) && (ch <= 'Z') )
	sextet = ch - 'A';
    else if( ('a' <= ch) && (ch <= 'z') )
	sextet = (ch - 'a') + 26;
    else if( ('0' <= ch) && (ch <= '9') )
	sextet = (ch - '0') + 52;
    else if( ch == '+' )
	sextet = 62;
    else if( ch == '/' )
	sextet = 63;
    else {
	fprintf( stderr, (isprint(ch) ? "Illegal base64 character '%c'\n" :
					"Illegal base64 character 0x%02x\n"),
		 ch );
	exit( EXIT_FAILURE );
    }

    return( sextet );
}


main( int argc, char *argv[] )
{
    FILE	*fin;
    FILE	*fout;
    int		flushing = 0;
    int		temp = 0;
    int		bits = 0;
    int		ch;

    if( argc < 2 ) {
	fprintf( stderr, "Usage: b64decode <infile> [outfile]\n" );
	exit( EXIT_SUCCESS );
    }

    fin = fopen( argv[1], "r" );
    if( fin == NULL ) {
	perror( "openin" );
	exit( EXIT_FAILURE );
    }

    if( argc < 3 )
	fout = stdout;
    else {
	fout = fopen( argv[2], "wb" );
	if( fout == NULL ) {
	    perror( "openout" );
	    fclose( fin );
	    exit( EXIT_FAILURE );
	}
    }

    while( (ch = fgetc( fin )) != EOF ) {
	if( !isspace(ch) ) {
	    if( flushing ) {
		if( ch != '=' ) {
		    fprintf( stderr, "Illegal character in EOF padding\n" );
		    exit( EXIT_FAILURE );
		}
	    }
	    else {
		if( ch == '=' )
		    flushing = 1;
		else {
		    temp <<= 6;
		    temp |= decode_b64char( ch );
		    bits += 6;
		    if( bits >= 8 ) {
			bits -= 8;
			fputc( (0xff & (temp >> bits)), fout );
		    }
		}
	    }
	}
    }

    fclose( fout );
    fclose( fin );
}
