#include <stdlib.h>
#include <stdio.h>

#define	MAXLINELEN	76

static const char	b64chars[] = 
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
/*   0000000000000000111111111111111122222222222222223333333333333333	*/
/*   0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF	*/

main( int argc, char *argv[] )
{
    FILE	*fin;
    FILE	*fout;
    int		octet;
    int		temp = 0;
    int		bits = 0;
    int		linelen = 0;

    if( argc < 2 ) {
	fprintf( stderr, "Usage: b64encode <infile> [outfile]\n" );
	exit( EXIT_SUCCESS );
    }

    fin = fopen( argv[1], "rb" );
    if( fin == NULL ) {
	perror( "openin" );
	exit( EXIT_FAILURE );
    }

    if( argc < 3 )
	fout = stdout;
    else {
	fout = fopen( argv[2], "w" );
	if( fout == NULL ) {
	    perror( "openout" );
	    fclose( fin );
	    exit( EXIT_FAILURE );
	}
    }

    while( (octet = fgetc( fin )) != EOF ) {
	temp <<= 8;
	temp |= 0xff & octet;
	bits += 8;
	while( bits >= 6 ) {
	    bits -= 6;
	    fputc( b64chars[ 0x3f & (temp >> bits) ], fout );
	    if( ++linelen >= MAXLINELEN ) {
		fputc( '\n', fout );
		linelen = 0;
	    }
	}
    }
    if( bits > 0 ) {
	temp <<= 6 - bits;
	fputc( b64chars[ 0x3f & temp ], fout );
	if( bits == 4 )
	    fputc( '=', fout );
	else if( bits == 2 ) {
	    fputc( '=', fout );
	    fputc( '=', fout );
	}
	fputc( '\n', fout );
    }

    fclose( fout );
    fclose( fin );
    exit( EXIT_SUCCESS );
}
