	.enable substitution
	.disable display
;    UUDECODE.CMD -- UU Decoder for RSX-11M V4 Systems
;    Copyright (C) 1994 John Otis Lene Comeau
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
.;    You should have received a copy of the GNU General Public License
.;    along with this program; if not, write to the Free Software
.;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.;
.;    A copy of the GNU General Public License is appended to the end of
.;    this command file.
.;
.;    John Lene-Comeau, ICT, POB 100632, Ft. Lauderdale, FL 33310-0632
.;    jcomeau@world.std.com  or  CompuServe: 70641,57
.;
.;This program is meant as a one-shot image loader for a "locked" system, that
.;is, an RSX system with no development software nor accessable removable media.
.;All that is needed is serial port access, and an RSX V4.0 or better system
.;with INDIRECT (AT.) running, PIP, and a device driver in SYSUIC. This looks
.;for the console logger driver CODRV, but this file can be edited to look for
.;another if necessary. Get this file to your system by:
.;DCL>copy ti: uudecode.cmd
.;DCL>		(use your communications program to upload this as ASCII)
.;DCL>^Z	(hold CTRL and hit Z)
.;or MCR>pip uudecode.cmd=ti:
.;MCR>		(start ASCII upload)
.;MCR>^Z
.;Then do the same with your UUENCODED RSX Task file, e.g.
.;DCL>copy ti: k11rsx.uuc (send UUencoded Kermit to the PDP, then ^Z as above)
.;
.;Finally, @UUDECODE K11RSX.UUC will decode the Kermit and make it executable.
.;You can then RUN K11RSX to invoke Kermit.
.;***WARNING*** this program is VERY S-L-O-W!!! It will easily tie up a terminal
.;for hours or even DAYS for a big file & slow system.
.;Please direct all comments, bug reports, etc. to the author.
	.setn <errctl> 7 !trap all errors
	.onerr quit !set things back to normal before exit
	.setn n 27. !escape character
	.sets esc "'n%v'"
	.sets st esc+"\" !string terminator, so debugging doesn't blank screen
	.setf ansi !assume non-ANSI terminal
	.test "15,35,36" "'<titype>'" !is terminal VT100, PRO, or VT200-series?
	.if <strlen> gt 0 .sett ansi !if so, we can do rapid display updates
	.setf dcl !assume DCL is not the CLI, we'll use MCR
	.if <cli> eq "DCL" .sett dcl
	.sets debug ".;" !no debug unless trace on
	.setf trace
	.ifenabled trace .sets debug "" !turn debugging on if trace on
	.sets upline "'esc'M"
	.if debug eq "" .sets upline ""
	'debug'.sett trace !comment out when major debugging done
	'debug'.iff trace .disable trace !when worst bugs gone, turn off trace
	.setn n 34.
	.gosub quote 'n%v' !make character string for decoding
.;I couldn't find a way to "make" a null using any kind of substitution methods.
.;And the whole idea of this program is to be able to create binaries on
.;"locked" systems, on which all the development and hacking software have been
.;removed, such as MAC, TKB, ZAP, PAT, etc. So this kludge of reading the high
.;byte of the record type number of a must-be-there symbol table file is a
.;fairly sure, if schlock, way of getting a null character.
	.testfile '<sysuic>'codrv.stb
	.if <filerr> ne <succes> ;UUDECODE -- *Fatal* - Can''t create NULL char
	.if <filerr> ne <succes> .goto quit
	.openr '<sysuic>'codrv.stb
	.read line
	.sets null$ line[2:2]
	.close
	.sets 3nulls null$+null$+null$
	.sets 45nuls 3nulls+3nulls+3nulls+3nulls+3nulls+3nulls+3nulls !21 so far
	.sets 45nuls 45nuls+45nuls+3nulls !now we have 45
	.sets 4nulls "````" !actually, the UUENCODEd represenation of 3 nulls
	.sets nulls "M````````````````````````````````````````````````````````"
	.sets nulls nulls+4nulls !now it's the UUENCODED string for 45 nulls
	.if p1 eq "" .goto help
	.gosub getnam !get output filename and protection bits
	.ifndf wlp .goto quit !if it didn't fly, quit now
	.gosub crefil !create the output file
	.opena #1 'outfil'
	'debug';<filerr>='<filerr>'
	.if <filerr> ne <succes> .goto quit
	.setn size 'blocks'. !it's a decimal number returned in <FILATR>
	.setn ovhead 2+('mrs'.&1) !if rec size odd, make overhead 3 bytes/rec
	.setn size (size*3)/4 !first reduce by UUENCODE ratio of 4 out/3 in
	'debug';size='size'
	.setn size size-((size*ovhead)/(ovhead+'mrs'.))
	;UUDECODE -- File 'outfil' created, will be approx. 'size%d'. blocks
	.setn blknum 1 !current block number
	.setn chars 0 !current number of chars in block
	.ift ansi ;UUDECODE -- Working on block 'blknum%zr3d' of 'outfil'
	.gosub decode
	.if line eq "end" ;UUDECODE -- File 'outfil' successfully decoded.
	.close #1
	.iff dcl pip/co='outfil'
	.ift dcl copy/contiguous 'outfil' 'outfil'
.;finally, set the protection according to that passed by UUENCODE:
	.iff dcl pip 'outfil'/pr/sy:'syp%c'/ow:'owp%c'/gr:'grp%c'/wo:'wlp%c'
	.ift dcl set prot 'outfil' (sy:'syp%c',ow:'owp%c',gr:'grp%c',wo:'wlp%c')
.quit:
	.close
	.exit
.;
.crefil:
.;Originally used RMSDEF, but then decided it would be better to use PIP,
.;making the program independent of DEF's presence on the system.
	.testfile '<sysuic>'codrv.tsk
	.if <filerr> ne <succes> ;UUDECODE -- *Fatal* Cannot find necessary file
	.if <filerr> ne <succes> .goto quit
	.iff dcl pip 'outfil'/noco='<sysuic>'codrv.tsk
	.ift dcl copy '<sysuic>'codrv.tsk 'outfil'/nocontiguous
.;Now we've got the file, trim it to 0 size...
	.iff dcl pip 'outfil'/eof:1:0
	.ift dcl set file 'outfil'/end_of_file=(block:1,byte:0)
.;Kludge for my P/OS system that wouldn't recognize SET FILE:
	.if <succes> ne <exstat>&7 .ift dcl run $pip/comm:"pip 'outfil'/eof:1:0"
.;next step is to copy it again, otherwise .OPENA may fail...
.;	.iff dcl pip ='outfil'
.;	.ift dcl copy 'outfil' 'outfil'
	.return
.;
.getnam:
	.openr #2 'p1' !try to open the file
	.if <filerr> ne <succes> .return
	.parse <filatr> "," junk junk mrs blocks junk
	.read #2 line !get first line
	'debug';Subroutine GETNAM: line="'line'"
	.parse line " " begin prot outfil !split into expected components
	.test prot !see if it's what we expect
	.iff <number> .return !quit if not
.;	R = unix r = 4
.;	W,D = unix w = 2
.;	E = unix x = 1
.;	             RWEDRWEDRWEDRWEDRWEDRWEDRWEDRWED
.;	             00001111222233334444555566667777
	.sets prot$ "    E   WD  WED R   RE  RWD RWED"
	.sets syp "RWED" !unix systems don't restrict system privs
	'debug';System protection="'syp'"
	.sets owp prot$[(('prot'/100)*4)+1:(('prot'/100)*4)+4]
	'debug';Owner protection="'owp'"
	.sets grp prot$[((('prot'/10)&7)*4)+1:((('prot'/10)&7)*4)+4]
	'debug';Group protection="'grp'"
	.sets wlp prot$[(('prot'&7)*4)+1:(('prot'&7)*4)+4]
	'debug';World protection="'wlp'"
	.return
.decode:
	.sets out$ "" !initialize output string
	.setf eof !set eof on actual EOF
.2:	.read #2 line
	.ift <eof> .sett eof
	.ift <eof> .goto 90 !finish up if end of input file
	.ift ansi ;'upline'UUDECODE -- Working on block 'blknum%zr3d'
	'debug';Subroutine DECODE: line="'line'"
	.if <filerr> ne <succes> .return !quit on any other error condition
	.if line eq "end" .goto 90 !finish up if lowercase "end" seen
	.if line eq nulls .goto 91 !output 45 nulls if that's what it is
	.sets c line[1:1] !first char is length of precoded byte string
	.gosub dec 'c' !decode it
	.if n eq 0 .goto 2 !loop on null input line
	.test line !now let's check
	.;from one to three chars will be encoded as 4 output chars by UUENCODE
	.if <strlen> ne ((n+2)/3)*4+1 .return !quit if check fails
	.setn outlen n !save, EOF may have less than 3 chars
	.setn length <strlen> !save length for later check
	.setn pos 2 !start with first group of four chars
.10:	.if pos gt length .goto 2 !go get more input if end of line
	.if 4nulls eq line[pos:pos+3] .goto 92
	.gosub xlate4 !translate next 4 chars
.89:
	.test out$ !see if time to output
	'debug';Output string length is now '<strlen>%d'.
	'debug'.if <strlen> ne (<strlen>/3)*3 .goto quit !quit if not div by 3
	.if <strlen> ne 90. .goto 10 !loop until time
.90:
	'debug'.ift trace .disable trace
	.data #1 'out$'
	'debug'.ift trace .enable trace
	.gosub count !keep running total of decoded blocks
	.sets out$ "" !reinit output string
	.iff eof .if line ne "end" .goto 10 !loop after output
	.return
.91:
.;here if entire line is nulls
	'debug';Whole string of nulls found
	.sets out$ out$+45nuls
	.setn pos 62.
	.setn length 61.
	.goto 89
.92:
.;here if next 4 chars are nulls
	'debug';4 nulls found
	.sets out$ out$+3nulls
	.setn pos pos+4
	.goto 89
.;
.dec:
	.if comman ne "" .goto 100 !exclamation point taken as comment, chopped
	.setn n 1
	'debug';Subroutine DEC: ! decodes to 1.
	.return
.100:	.setn n ('comman%v'-40)&77
	'debug';Subroutine DEC: 'comman' decodes to 'n%d'.
	.sets comman "" !reinit
	.return
.append:
	.parse comman " " strvar value
	.setn val 'value'
	.if val eq 34. .sets 'strvar' 'strvar'+quote$
	.if val eq 34. .return
	.if val eq 0 .sets 'strvar' 'strvar'+null$
	.if val eq 0 .return
	.sets 'strvar' 'strvar'+"'val%v'" ;'st'append char to output string
	.return
.quote:
	.sets quote$ comman[1:1]
	'debug';Quote character is '''quote$'''
	.return
.xlate4:
	.sets comman "" !reinit, otherwise COMMAN will still contain OUT$ XXX
			.;from last .GOSUB APPEND
	.sets c1 line[pos:pos]
	.sets c2 line[pos+1:pos+1]
	.sets c3 line[pos+2:pos+2]
	.sets c4 line[pos+3:pos+3]
	.setn pos pos+4 !update position
	.gosub dec 'c1'
	.setn n1 n*4 !shift result left 2 places, high 6 bits of 1st char
	'debug';n1='n1'
	.gosub dec 'c2'
	.setn n1 n1!((n/20)&3) !merge in low 2 bits
	'debug';n1='n1'
	.setn n2 (n&17)*20 !now high 4 bits of 2nd char
	'debug';n2='n2'
	.gosub dec 'c3'
	.setn n2 n2!((n/4)&17) !low 4 bits of 2nd char
	'debug';n2='n2'
	.setn n3 (n&3)*100 !high 2 bits of 3rd char
	'debug';n3='n3'
	.gosub dec 'c4'
	.setn n3 n3!n !low 6 bits of 3rd char
	'debug';n3='n3'
	.gosub append out$ 'n1'
	.gosub append out$ 'n2'
	.gosub append out$ 'n3'
	.return
.count:
	.setn chars chars+90. !add length of last string output
	.if chars gt 512. .inc blknum !up the block count
	.if chars gt 512. .setn chars chars-512. !and subtract block's worth
	.return
.help:
	;Usage: @UUDECODE FILENAME.EXT where FILENAME.EXT is the UUENCODED file
	;you wish to decode. For more information, you may TYPE, PRINT, or
	;EDIT/READ this program.
	.exit 3	!exit with INFO status
.;
		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                          675 Mass Ave, Cambridge, MA 02139, USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	Appendix: How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 19yy  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) 19yy name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.
