[IDENT('V1.0'),
 INHERIT('sys$share:starlet',
	 'sys$share:pascal$lib_routines')]
MODULE sdlifdl;

{
PROGRAM DESCRIPTION:

    SDL back end modelled on sdlpli.pli from Freeware V2.0 CD

+++
 This software may be copied and distributed provided that this notice is
 included and no charge is made other than reasonable media costs. The source
 is provided on an 'as is' basis, and no warranty is either given or implied. 
 
 No responsibility is accepted for any damage done to programs or data or any
 other consequential loss caused either directly or indirectly as a result of
 using this software. 
 
 I would be pleased to hear of any bugs, solutions, or suggested enhancements
 at the address below. 
 
 Chris Sharman, CCA Stationery, Eastway, Fulwood, Preston, PR2 9WS, ENGLAND
 email chris@ccagroup.co.uk
---

CREATION DATE: 28-FEB-1996

MODIFICATION HISTORY:

Date          Name
        Description
%[change_entry]%...
}

[HIDDEN] CONST
    lang_name = 'IFDL';
    myver = lang_name + ' V1.0';

%include 'sdlnodef'
%include 'sdltypdef'
%include 'sdlshr'
%include 'sdlmsg'

[HIDDEN] TYPE
    pnod = [UNSAFE] ^nod$_node;
    vs = VARYING [255] OF CHAR;
    pvs = [UNSAFE] ^vs;

[HIDDEN] VAR
    outf, outf1: TEXT;
    specname, prefname: vs;

    nodtypnames: [STATIC,READONLY] ARRAY [1..15] OF VARYING [8] OF CHAR VALUE [
	nod$k_rootnode: 'root';
	nod$k_commnode: 'comment';
	nod$k_constnode: 'const';
	nod$k_entrynode: 'entry';
	nod$k_itemnode: 'item';
	nod$k_modulnode: 'module';
	nod$k_parmnode: 'parm';
	nod$k_dummynode: 'dummy';
	nod$k_objnode: 'obj';
	nod$k_headnode: 'head';
	nod$k_typnode: 'type';
	nod$k_endnode: 'end';
	nod$k_condnode: 'cond';
	nod$k_litnode: 'literal';
	nod$k_symbnode: 'symb'];

    datatypnames: ARRAY [1..36] OF VARYING [32] OF CHAR VALUE [
	typ$k_byte: 'UNSIGNED BYTE';
	typ$k_integer_byte: 'BYTE INTEGER';
	typ$k_word: 'UNSIGNED WORD';
	typ$k_integer_word: 'WORD INTEGER';
	typ$k_longword: 'UNSIGNED LONGWORD';
	typ$k_integer_long: 'LONGWORD INTEGER';
	typ$k_quadword: 'ADT';! VMSdate
	typ$k_integer_quad: 'QUADWORD INTEGER';
	typ$k_octaword: 'UNSIGNED OCTAWORD';! unsupported

	typ$k_integer: 'LONGWORD INTEGER';
	typ$k_hardware_integer: 'LONGWORD INTEGER';
	typ$k_integer_hw: 'LONGWORD INTEGER';

	typ$k_double: 'DFLOATING';
	typ$k_float: 'SHORT FLOAT';
	typ$k_grand: 'LONG FLOAT';
	typ$k_huge: 'HFLOATING';

	typ$k_char: 'CHARACTER';
	typ$k_decimal: 'CHARACTER';

	typ$k_structure: 'structure';
	typ$k_union: 'union';

	typ$k_address: 'POINTER';
	typ$k_boolean: 'BOOLEAN';
	typ$k_vield: 'vield';
	typ$k_any: 'any';
	typ$k_entry: 'entry';
	typ$k_double_complex: 'DCOMPLEX';
	typ$k_float_complex: 'COMPLEX';
	typ$k_grand_complex: 'GCOMPLEX';
	typ$k_huge_complex: 'HCOMPLEX';
	typ$k_user: 'user';
	typ$k_void: 'void';
	typ$k_hardware_address: 'POINTER';
	typ$k_pointer_hw: 'POINTER';
	typ$k_pointer_long: 'POINTER';
	typ$k_pointer: 'POINTER';
	typ$k_pointer_quad: 'POINTER'];

[HIDDEN] CONST
    dimtypes = [typ$k_char, typ$k_decimal];

[HIDDEN] FUNCTION nodtypname( t: INTEGER8 ): vs;
    BEGIN
    IF (t<LOWER(nodtypnames)) OR_ELSE (t>UPPER(nodtypnames)) THEN
	nodtypname := '*Unk'+DEC(t,4)+'*'
    ELSE
	nodtypname := nodtypnames[t];
    END;

[HIDDEN] FUNCTION datatypqual( this: pnod ): vs;
    VAR
	s: vs;
    BEGIN
    WITH this^ DO
	IF nod$v_vardim THEN
	    s := ' Occurs *Var*'
	ELSE IF (nod$l_hidim<>nod$l_lodim) THEN
	    BEGIN
	    IF (nod$l_lodim<>1) THEN
		WRITEV(s, ' Occurs ', nod$l_hidim+1-nod$l_lodim:1,
			    ' Base ', nod$l_lodim:1)
	    ELSE
		WRITEV(s, ' Occurs ', nod$l_hidim:1);
	    END;
    datatypqual := s; {ignore UNCERTAIN}
    END;

[HIDDEN] FUNCTION datatypname( this: pnod ): vs;
    VAR
	s: vs;
    BEGIN
    WITH this^ DO
	BEGIN
	IF (nod$w_datatype<LOWER(datatypnames)) OR_ELSE
		(nod$w_datatype>UPPER(datatypnames)) THEN
	    WRITEV(s, '*Unk', nod$w_datatype:1, '*')
	ELSE IF NOT (nod$w_datatype IN dimtypes) THEN
	    s := datatypnames[nod$w_datatype]
	ELSE
	    BEGIN
	    IF nod$v_desc OR_ELSE (nod$l_typeinfo=sdl$k_unknown_length) THEN
		s := datatypnames[nod$w_datatype] + ' (*unknown*)'
	    ELSE
		WRITEV(s, datatypnames[nod$w_datatype], ' (', nod$l_typeinfo:1,
			')');
	    IF nod$v_varying THEN s := s + ' Varying';
	    END;
	IF nod$v_dimen THEN s := s + datatypqual(this);
	END;
    datatypname := s;
    END;

[HIDDEN] PROCEDURE _header( VAR outf: TEXT;
			    VAR shr: sdl$_shr_data; name: vs;
			    intro: [TRUNCATE] VARYING [u] OF CHAR;
			    term: [TRUNCATE] VARYING [v] OF CHAR;
			    multiline: [TRUNCATE] BOOLEAN );
    VAR
	dt: PACKED ARRAY [1..17] OF CHAR;
	lterm: vs;
    BEGIN
    $asctim (timbuf := dt);
    IF PRESENT(multiline) AND_THEN multiline THEN
	BEGIN
	WRITELN(outf, intro);
	intro := '';
	lterm := '';
	END
    ELSE IF PRESENT(term) AND_THEN (term<>'') THEN
	lterm := ' ' + term
    ELSE
	lterm := '';
    WRITELN(outf, intro, ' Created ', dt, ' by OpenVMS SDL ', shr.sdl_version,
	myver, lterm);
    WRITELN(outf, intro, ' Source: ', shr.full_source, lterm);
    IF PRESENT(multiline) AND_THEN multiline THEN WRITELN(outf, term);
    WRITELN(outf);
    END;

[HIDDEN] PROCEDURE open1( VAR outf: TEXT;
			  VAR shr: sdl$_shr_data;
			  suf: vs );
    BEGIN
    OPEN( FILE_VARIABLE     := outf,
    	  FILE_NAME         := specname,
    	  HISTORY           := NEW,
    	  DEFAULT           := prefname + suf + '.IFDL' );
    REWRITE(outf);
    WITH shr DO
	IF NOT sdl$v_noheader_opt THEN
	    _header(outf, shr, prefname, '{', '}', TRUE);
    END;

[HIDDEN] PROCEDURE outputnode ( VAR shr: sdl$_shr_data;
				this, finish: pnod; lvl: INTEGER);

    PROCEDURE do_comment(VAR outf: TEXT;
			 VAR shr: sdl$_shr_data;
			 this: pnod;
			 incomment: BOOLEAN := FALSE);
	BEGIN
	IF shr.sdl$v_comment_opt AND_THEN (this^.nod$a_comment<>NIL) THEN
	    BEGIN
	    IF NOT incomment THEN WRITE(outf, ' {');
	    WRITE(outf, this^.nod$a_comment::pvs^, ' }');
	    END
	ELSE IF incomment THEN
	    WRITE(outf, ' }');
	WRITELN(outf);
	END;

    PROCEDURE do_cond( VAR shr: sdl$_shr_data;
			lvl: INTEGER;
			ccode, langs: pnod );
	BEGIN
	WHILE (langs<>NIL) AND_THEN
		(langs^.nod$b_type=nod$k_objnode) AND_THEN
		(langs^.nod$t_name<>lang_name) DO
	    langs := langs^.nod$a_flink;
	IF (langs<>NIL) AND_THEN (langs^.nod$b_type=nod$k_objnode) THEN
	    outputnode(shr, ccode^.nod$a_flink, ccode, lvl);
	END;

    PROCEDURE do_log(this: pnod);
	BEGIN
	WRITELN(outf, '{ ', nodtypname(this^.nod$b_type), ' node ',
		this^.nod$t_name, ' }');
	END;

    PROCEDURE do_unsup(this: pnod; s: [TRUNCATE] VARYING [u] OF CHAR);
	BEGIN
	WRITE(outf, '{ *Unsupported* ', nodtypname(this^.nod$b_type), ' node ',
		this^.nod$t_name);
	IF PRESENT(s) THEN WRITE(outf, ' (', s, ')');
	WRITELN(outf, ' }');
	END;

    PROCEDURE do_item( VAR shr: sdl$_shr_data; this: pnod; lvl: INTEGER);
	VAR
	    p, pe: pnod;
	FUNCTION indent( lvl: INTEGER ): vs;
	    BEGIN
	    indent := PAD('', CHR(9), (lvl-1) DIV 2) +
			PAD('', ' ', 4*((lvl-1) MOD 2));
	    END;

	BEGIN
	IF (this^.nod$w_datatype=typ$k_structure) THEN
	    BEGIN
!	    lib$signal(ss$_debug);
	    IF (lvl=1) THEN WRITE(outf1, '{ ');
	    WRITE(outf1, indent(lvl), 'Group ', this^.nod$t_name);
	    IF this^.nod$v_dimen THEN WRITE(outf1, datatypqual(this));
	    do_comment(outf1, shr, this, (lvl=1));
	    IF ((this^.nod$w_datatype=typ$k_structure) OR_ELSE
		     (this^.nod$w_datatype=typ$k_union)) THEN
		BEGIN
		pe := this^.nod$a_child;
		IF (pe=NIL) AND_THEN (lvl>1) AND_THEN
			(this^.nod$a_typeinfo2<>NIL) AND_THEN
			(this^.nod$a_typeinfo2::pnod^.nod$a_child<>NIL) THEN
		    pe := this^.nod$a_typeinfo2::pnod^.nod$a_child;
		IF (pe<>NIL) THEN
		    BEGIN
		    p := pe^.nod$a_flink;
		    WHILE (p<>NIL) AND_THEN (p<>pe) DO
			BEGIN
			do_item(shr, p, lvl+1);
			p := p^.nod$a_flink;
			END;
		    END;
		END;
	    IF (lvl=1) THEN WRITE(outf1, '{ ');
	    WRITE(outf1, indent(lvl), 'End Group ');
	    IF (lvl<>1) THEN WRITE(outf1, '{ ');
	    WRITELN(outf1, this^.nod$t_name, ' }');
	    END
	ELSE IF (this^.nod$w_datatype=typ$k_union) THEN
	    BEGIN
	    WRITE(outf1, '{ Union ', this^.nod$t_name);
	    do_comment(outf1, shr, this, TRUE);
	    do_item(shr, this^.nod$a_child::pnod^.nod$a_flink, lvl);
	    END
	ELSE
	    BEGIN
	    WRITE(outf1, indent(lvl), this^.nod$t_name, ' ', datatypname(this));
	    do_comment(outf1, shr, this);
	    END;
	END;
    CONST
	commentset = [nod$k_commnode, nod$k_litnode{, nod$k_constnode}];
	childset = commentset +
	    [nod$k_headnode, nod$k_rootnode, nod$k_modulnode{, nod$k_parmnode}];
    BEGIN
    WHILE (this<>NIL) AND_THEN (this<>finish) DO
	WITH shr, this^ DO
	    BEGIN
	    CASE nod$b_type OF
		nod$k_rootnode, nod$k_commnode, nod$k_headnode,
		    nod$k_modulnode: do_log(this);
		nod$k_itemnode:
		    IF nod$v_declared THEN
			do_unsup(this, 'declared')
		    ELSE IF nod$v_forward THEN
			do_unsup(this, 'forward')
		    ELSE
			BEGIN
			IF (lvl=1) THEN
			    BEGIN
			    do_log(this);
			    open1(outf1, shr, '-' + nod$t_name);
			    END;
			do_item(shr, this, lvl);
			IF (lvl=1) THEN CLOSE(outf1);
			END;
		nod$k_condnode: do_cond(shr, lvl, nod$a_child,
					nod$a_typeinfo2::pnod^.nod$a_flink);
		nod$k_litnode:
		    WRITE(outf, nod$a_typeinfo::pvs^);
		OTHERWISE
		    do_unsup(this);
		END;
	    IF (nod$b_type IN commentset) THEN
		do_comment(outf, shr, this);
	    IF (nod$a_child<>NIL) AND_THEN (nod$b_type IN childset) THEN
		outputnode(shr, nod$a_child::pnod^.nod$a_flink,
					nod$a_child, lvl + 1);
	    this := nod$a_flink;
	    END;

    END;

[GLOBAL] PROCEDURE sdl$output ( out_file, def_filename: vs;
				VAR shr: sdl$_shr_data );
    BEGIN
    WITH shr DO
	IF (shrdata_version<>sdl$k_shrdata_rev) OR_ELSE
		(node_version<>sdl$k_node_rev) THEN
	    lib$stop(sdl$_revcheck);
    specname := out_file;
    prefname := def_filename;
    open1(outf, shr, '');
    WITH shr DO
	outputnode(shr, tree_root::pnod^.nod$a_flink, tree_root, 0);
    CLOSE(outf);
    END;

END.
