$!                                                   
$! SYSUAF2UID - Create a /etc/passwd style uid-translation file for the 
$!              MultiNet NFS Server
$!
$! John McMahon
$! TGV Technical Support
$! January 1993
$!
$! This command procedure is for when you are using the MultiNet NFS server
$! and have no established UID/GID mappings (e.g. Using the NFS server with
$! a group of PCs using PCNFS).  This command procedure reads the SYSUAF
$! and generates a set of Uid/Gid mappings.  The Gid is mapped directly to the
$! UIC Group number, the Uid is assigned sequentially starting at 1000.
$!
$! The output file SYS$SCRATCH:ETC.PASSWD can be used as an NFS PASSWD file
$! in the MultiNet Configure/NFS utility.
$!
$ On Warning Then Goto CleanUp
$! Where is the UAF ?
$ Sysuaf_File = F$Trnlnm("SYSUAF")
$ If Sysuaf_File .Eqs. "" Then Sysuaf_File = "Sys$System:Sysuaf.Dat"
$ Define Sysuaf 'Sysuaf_File'
$! Authorize SHOW/BRIEF into a file
$ Define Sys$Output Sys$Scratch:SYSUAF2UID.TMP
$ Mcr Authorize
SHOW/BRIEF * 
$ Deassign Sys$Output
$ Deassign Sysuaf
$ Open/Read InputFile Sys$Scratch:SYSUAF2UID.TMP
$ Open/Write OutputFile Sys$Scratch:ETC.PASSWD
$ Uid = 1000
$ ReadLoop:
$	Read/End=EndReadLoop InputFile Dataline
$	Real_Name = F$Edit(F$Extract(0,20,Dataline),"Trim")
$	If Real_Name .Eqs. "" Then Real_Name = "No Name"
$	PartOfLine = F$Extract(21,29,Dataline)
$	PartOfLine = F$Edit(PartOfLine,"COMPRESS")
$	Username = F$Element(0," ",PartOfLine)
$	Uic = F$Element(1," ",PartOfLine)
$! Extraneous lines will not have "[" in the UIC zone
$	If F$Extract(0,1,Uic) .Nes. "[" Then Goto Readloop
$	Uic_Group = F$Element(0,",",Uic) - "["
$	Write Sys$Output F$FAO("!16AS (!20AS) Gid:!5AS Uid:!5AS",-
	 Username,Real_Name,Uic_Group,F$String(Uid))
$	Write OutputFile F$FAO(-
	 "!24<!AS:------------------------!>:!AS:!AS:!AS:------:------",-
	 F$Edit(Username,"Lowercase"),F$String(Uid),Uic_Group,Real_Name )
$	Uid = Uid + 2
$	Goto Readloop
$ EndReadLoop:
$ Close InputFile
$ Close OutputFile
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ Cleanup:
$ Set NoON
$ Deassign Sys$Output
$ If F$Trnlnm("Sysuaf") .Nes. "" Then Deassign Sysuaf
$ If F$Trnlnm("InputFile") .Nes. "" Then Close InputFile
$ If F$Trnlnm("OutputFile") .Nes. "" Then Close OutputFile
$ Delete/Log Sys$Scratch:SYSUAF2UID.TMP.*
$ Exit
                                                                                                                                                                                                                            