unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, auto, afdd, help, StdCtrls, ExtCtrls, ClUnit, Sockets,
  Saver, ExpUnit;

type
  TMainForm = class(TForm)
    StatBox: TGroupBox;
    AutoButt: TButton;
    AFDDButt: TButton;
    HelpButt: TButton;
    LegendBox: TGroupBox;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Image5: TImage;
    Image6: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Img1: TImage;
    Img2: TImage;
    Img3: TImage;
    Img4: TImage;
    Img5: TImage;
    Img6: TImage;
    Img7: TImage;
    Img8: TImage;
    Lab1: TLabel;
    Lab2: TLabel;
    Lab3: TLabel;
    Lab4: TLabel;
    Lab5: TLabel;
    Lab6: TLabel;
    Lab7: TLabel;
    Lab8: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Happening: TGroupBox;
    Timer1: TTimer;
    HappMemo: TMemo;
    MerlinSock: TSockets;
    Image7: TImage;
    Label7: TLabel;
    Label8: TLabel;
    NowButt: TButton;
    HappImage1: TImage;
    HappImage2: TImage;
    procedure AutoButtClick(Sender: TObject);
    procedure AFDDButtClick(Sender: TObject);
    procedure HelpButtClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Timer1Timer(Sender: TObject);
    procedure MerlinSockSessionConnected(Sender: TObject; Socket: Word);
    procedure MerlinSockDataAvailable(Sender: TObject; Socket: Word);
    procedure NowButtClick(Sender: TObject);
    procedure Img1Click(Sender: TObject);
    procedure Img2Click(Sender: TObject);
    procedure Img3Click(Sender: TObject);
    procedure Img4Click(Sender: TObject);
    procedure Img5Click(Sender: TObject);
    procedure Img6Click(Sender: TObject);
    procedure Img7Click(Sender: TObject);
    procedure Img8Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
end;

const
  HappDir   = 'c:\data\kiosk\';
  HOST_NAME = 'merlin.arc.nasa.gov';
  HOST_PORT = '3000';

var
  MainForm: TMainForm;
  Images: array[1..8] of TImage;
  Names:  array[1..8] of string;
  Istats: array[1..8] of integer;
  tick, tock: integer;
  clicked: integer;
  HappNum: Integer;
  Empty: TBitmap;
  MaxHappening: integer;

implementation

{$R *.DFM}

procedure GetSetStats;
{ Get the status from the server for each system...
  if the server can't be raised, set network to down - others to unknown
  Change the images to reflect status }
begin
   MainForm.MerlinSock.IPAddr := HOST_NAME;
   MainForm.MerlinSock.Port := HOST_PORT;
   MainForm.MerlinSock.SConnect;
   { Actual setting of flags is now done in MerlinSockDataAvailable }
   end;


procedure CountFiles;
var s,t: string;
begin
   MaxHappening := 0;
   repeat
      MaxHappening := MaxHappening + 1;
      str(MaxHappening, t);
      s := HappDir + 'hap' + t + '.txt';
   until not FileExists (s);
   MaxHappening := MaxHappening - 1;
end;


procedure GetShowHappening;
var
   temp, fname: string[80];
   F: text;

begin
   if MaxHappening <> 0 then begin
     HappNum := HappNum + 1;
     if HappNum > MaxHappening then HappNum := 1;
     str(HappNum, temp);
     fname := HappDir + 'hap' + temp + '.txt';
     MainForm.HappMemo.Clear;
     MainForm.HappMemo.Lines.LoadFromFile (fname);
     fname := HappDir + temp + '.bmp';
     if FileExists (fname) then begin
       MainForm.HappImage1.Picture.LoadFromFile (fname);
       fname := HappDir + temp + 'a.bmp';
       if FileExists (fname) then
          MainForm.HappImage2.Picture.LoadFromFile (fname)
       else
          MainForm.HappImage2.Picture.Graphic := Empty;
       end
     else begin
        MainForm.HappImage1.Picture.Graphic := Empty;
        MainForm.HappImage2.Picture.Graphic := Empty;
        end;
     end;
  end;



procedure TMainForm.AutoButtClick(Sender: TObject);
begin
   AutoForm.ShowModal;
end;

procedure TMainForm.AFDDButtClick(Sender: TObject);
begin
   AFDDForm.ShowModal;
end;

procedure TMainForm.HelpButtClick(Sender: TObject);
begin
   HelpForm.ShowModal;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   Images[1] := Img1;
   Images[2] := Img2;
   Images[3] := Img3;
   Images[4] := Img4;
   Images[5] := Img5;
   Images[6] := Img6;
   Images[7] := Img7;
   Images[8] := Img8;

   Names[1] := 'Merlin';
   Names[2] := 'Mickey';
   Names[3] := 'Optic';
   Names[4] := 'Morgan';
   Names[5] := 'WorkStations';
   Names[6] := 'Network';
   Names[7] := 'Printers';
   Names[8] := 'Web Server';
   Istats[1] := 6;
   Istats[2] := 6;
   Istats[3] := 6;
   Istats[4] := 6;
   Istats[5] := 6;
   Istats[6] := 6;
   Istats[7] := 6;
   Istats[8] := 6;

   {This doesn't make much sense, but it may be necessary later. }
   Lab1.Caption := Names[1];
   Lab2.Caption := Names[2];
   Lab3.Caption := Names[3];
   Lab4.Caption := Names[4];
   Lab5.Caption := Names[5];
   Lab6.Caption := Names[6];
   Lab7.Caption := Names[7];
   Lab8.Caption := Names[8];
   Empty := TBitmap.Create;
   GetSetStats;
   CountFiles;
   GetShowHappening;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
   CloseForm.ShowModal;
   CanClose := MyCanClose;
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
var
   hour, min, sec, mill: word;
begin
   {The interval is set to 30 seconds}
   if not SSaver.Visible then GetShowHappening;
   tick := tick + 1;
   if tick >= 7 then begin {Update status from Merlin}
      tick := 0;
      {if later than 5 PM or earlier than 6 AM, go into screen saver}
      DecodeTime (Time, hour, min, sec, mill);
      if SSaver.Visible then begin
         tock := tock + 30;
         if tock > 400 then tock := 10;
         SSaver.OKButt.Left := tock;
         SSaver.OKButt.Top := tock;
         if (hour >= 7) and (hour <=16) then begin  {Always blank weekend}
            min := DayOfWeek(Date);
            if ((min <> 1) and (min <> 7)) then SSaver.visible := false;
            end
         end
      else begin
         GetSetStats;
         {if daytime <7:00 am or >= 5:00 PM}
         if (hour < 7) or
            (hour >= 17) then SSaver.ShowModal;
      end;
   end;
end;

procedure TMainForm.MerlinSockSessionConnected(Sender: TObject;
  Socket: Word);
begin
   MerlinSock.Text := 'sPC17';
   {Need to put a timeout here to verify that MerlinSockDataAvailable
    does indeed get called within a reasonable time ??? }
end;

procedure TMainForm.MerlinSockDataAvailable(Sender: TObject; Socket: Word);
var
   temp, stemp: string;
   i: integer;
begin
   temp := MerlinSock.Text;
   MerlinSock.SClose;
   for i := 1 to 8 do begin
      istats[i] := ord(temp[i+2]);  {This should be i+1... I don't know if
                                     the bug is in KIOSK or GPSERVER! }
      if (istats[i] > 6) then istats[i] := 7;
      if (istats[i] < 1) then istats[i] := 7;
   end;

   for i := 1 to 8 do
      case istats[i] of
      1: Images[i].Picture.Graphic := MainForm.Image1.Picture.Graphic;
      2: Images[i].Picture.Graphic := MainForm.Image2.Picture.Graphic;
      3: Images[i].Picture.Graphic := MainForm.Image3.Picture.Graphic;
      4: Images[i].Picture.Graphic := MainForm.Image4.Picture.Graphic;
      5: Images[i].Picture.Graphic := MainForm.Image5.Picture.Graphic;
      6: Images[i].Picture.Graphic := MainForm.Image6.Picture.Graphic;
      7: Images[i].Picture.Graphic := MainForm.Image7.Picture.Graphic;
   end;
   if temp[11] = 'u' then { Copy new files to local directory };
   {DeleteFile ('c:\data\kiosk\*.*'); }
   {CopyFile ('m:*.*', 'c:\data\kiosk\');}
   {CountFiles;}
end;

procedure TMainForm.NowButtClick(Sender: TObject);
begin
   GetSetStats;
end;

procedure explain;
var fname, ns: string;
begin
   ExplainForm.Memo1.Clear;
   if istats[clicked] = 1 then
      ExplainForm.Memo1.Lines.Add('That system is up, you silly person.')
   else begin
      str(clicked, ns);
      fname := HappDir + 'explain.' + ns;
      if FileExists(fname) then
         ExplainForm.Memo1.Lines.LoadFromFile(fname)
      else
         ExplainForm.Memo1.Lines.Add('No additional information available.');
   end;
   ExplainForm.ShowModal;
end;

procedure TMainForm.Img1Click(Sender: TObject);
begin
   clicked := 1;
   explain;
end;

procedure TMainForm.Img2Click(Sender: TObject);
begin
   clicked := 2;
   explain;
end;

procedure TMainForm.Img3Click(Sender: TObject);
begin
   clicked := 3;
   explain;
end;

procedure TMainForm.Img4Click(Sender: TObject);
begin
   clicked := 4;
   explain;
end;

procedure TMainForm.Img5Click(Sender: TObject);
begin
   clicked := 5;
   explain;
end;

procedure TMainForm.Img6Click(Sender: TObject);
begin
   clicked := 6;
   explain; 
end;

procedure TMainForm.Img7Click(Sender: TObject);
begin
   clicked := 7;
   explain;
end;

procedure TMainForm.Img8Click(Sender: TObject);
begin
   clicked := 8;
   explain;
end;

initialization
   tick := 0;     { Number of ticks on timer ~= 1 second }
   tock := 10;    { location of screen saver button }
   HappNum := 0;  { Number of Happening Events file to display }
   end.

end.
