//**************************************************************************
// Blastit.C
//
//  This routine is responsible for blasting data from the PC side (as filled
//  in by the user of the custom control), to the VAX server.
//
//
//  VBRMS TCP/IP Custom Control designed and developed by:
//  J. Wren Hunt
//  As You Like It...
//  wrenh@mindspring.com
//  
//  (404) 943-3804
//
//  Copyright (C) 1994 by J. Wren Hunt. All Rights Reserved.
//
//  MODIFICATION HISTORY:
//
//  V001-11/10/94-JWH	Added KEYPOS, KEYLEN.
//
//**************************************************************************
#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <string.h>
#include <alloc.h>
#include "c:\vb\cdk\vbapi.h"
#include "rms2.h"

#define DEBUG 0

typedef RMS FAR * LPRMS2;


extern SOCKET PASCAL FAR sock;
extern SOCKADDR_IN fsock;			// foreign host
extern struct hostent *hent;

/* This is the record layout for the packets we send to the VAX. You gotta
	be real careful in that there are no binary zeroes as these are considered
	by the VAX C server as NULLs and hence will foul up string operations.
*/


typedef struct
{
 BYTE  packet_type;
 char  datatosend[500];
 char  filename[255];
 char  protection[30];
 char  UIC[13];
 char  device[16];
 char  directory[255];
 unsigned long  keylen;				// these are in 'network byte order'
 unsigned long  keypos;                          // an INT on the PC is not an INT on the VAX!
 unsigned long RMSstatus;
} OUT_PACKET;

typedef OUT_PACKET PACKET;

PACKET packet;
char FAR * packet_ptr;






VOID Blastit(HCTL hctl, LPRMS2 lprms, int string_len, LPSTR lpstr)
{

char *ptr;
int length;


		packet_ptr = &packet;         // get address of packet in memory

		memset(packet_ptr,'\0',sizeof(OUT_PACKET));

		 //**************************************************************
		// Fill in the OUT_PACKET structure full of the information we
		// want returned.
		//***************************************************************


		// OPERATION

		packet.packet_type = lprms -> operation;

		 // DATATOSEND

		lprms = (LPRMS2)VBDerefControl(hctl);
		lpstr = VBDerefHlstr(lprms -> datatosend);
		if (lpstr != NULL) strcpy(packet.datatosend, lpstr);

//    Get the length and null-terminate.

		lprms = (LPRMS2)VBDerefControl(hctl);
		length = VBGetHlstrLen(lprms -> datatosend);
		packet.datatosend[length] = '\0';


		// FILENAME

		lprms = (LPRMS2)VBDerefControl(hctl);
		lpstr = VBDerefHlstr(lprms -> filename);
		if (lpstr != NULL) strcpy(packet.filename, lpstr);

//    Get the length and null-terminate.

		lprms = (LPRMS2)VBDerefControl(hctl);
		length = VBGetHlstrLen(lprms -> filename);
		packet.filename[length] = '\0';

		// UIC

		lprms = (LPRMS2)VBDerefControl(hctl);
		lpstr = VBDerefHlstr(lprms -> UIC);
		if (lpstr != NULL) strcpy(packet.UIC, lpstr);

		lprms = (LPRMS2)VBDerefControl(hctl);
		length = VBGetHlstrLen(lprms -> UIC);
		packet.UIC[length] = '\0';


		// PROTECTION

		lprms = (LPRMS2)VBDerefControl(hctl);
		lpstr = VBDerefHlstr(lprms -> protection);
		if (lpstr != NULL) strcpy(packet.protection, lpstr);

		lprms = (LPRMS2)VBDerefControl(hctl);
		length = VBGetHlstrLen(lprms -> protection);
		packet.protection[length] = '\0';


		// DEVICE

		lprms = (LPRMS2)VBDerefControl(hctl);
		lpstr = VBDerefHlstr(lprms -> device);
		if (lpstr != NULL) strcpy(packet.device, lpstr);

		lprms = (LPRMS2)VBDerefControl(hctl);
		length = VBGetHlstrLen(lprms -> device);
		packet.device[length] = '\0';


		// DIRECTORY

		lprms = (LPRMS2)VBDerefControl(hctl);
		lpstr = VBDerefHlstr(lprms -> directory);
		if (lpstr != NULL) strcpy(packet.directory, lpstr);

		lprms = (LPRMS2)VBDerefControl(hctl);
		length = VBGetHlstrLen(lprms -> directory);
		packet.directory[length] = '\0';
		ptr = strstr(packet.directory,"]");
		if (ptr != NULL)
		{
		 ptr++;
		 *ptr = '\0';
		}

		// KEY POSITION, LENGTH, NUMBER...

		lprms = (LPRMS2)VBDerefControl(hctl);

		packet.keypos = htonl(lprms -> keypos);		// Host to network byte order.
		packet.keylen = htonl(lprms -> keylen);      // 3/5/95-jwh

// Now use the SEND() function to send data over the TCP/IP socket.

		 send(sock,packet_ptr,sizeof(OUT_PACKET),0);


	return;
}