#ifndef __FAB_LOADED
#define __FAB_LOADED	1
#pragma nostandard

/*** MODULE $fabdef ***/
/*+++++*****                                                                */
/*   the fields thru ctx must not be modified due to                        */
/*   commonality between fab/rab/xab                                        */
#define FAB$C_BID 3                     /* code for fab                     */
#define FAB$M_PPF_RAT 16320
#define FAB$M_PPF_IND 16384
#define FAB$M_ASY 1
#define FAB$M_MXV 2
#define FAB$M_SUP 4
#define FAB$M_TMP 8
#define FAB$M_TMD 16
#define FAB$M_DFW 32
#define FAB$M_SQO 64
#define FAB$M_RWO 128
#define FAB$M_POS 256
#define FAB$M_WCK 512
#define FAB$M_NEF 1024
#define FAB$M_RWC 2048
#define FAB$M_DMO 4096
#define FAB$M_SPL 8192
#define FAB$M_SCF 16384
#define FAB$M_DLT 32768
#define FAB$M_NFS 65536
#define FAB$M_UFO 131072
#define FAB$M_PPF 262144
#define FAB$M_INP 524288
#define FAB$M_CTG 1048576
#define FAB$M_CBT 2097152
#define FAB$M_SYNCSTS 4194304
#define FAB$M_RCK 8388608
#define FAB$M_NAM 16777216
#define FAB$M_CIF 33554432
#define FAB$M_ESC 134217728
#define FAB$M_TEF 268435456
#define FAB$M_OFP 536870912
#define FAB$M_KFO 1073741824
#define FAB$M_PUT 1
#define FAB$M_GET 2
#define FAB$M_DEL 4
#define FAB$M_UPD 8
#define FAB$M_TRN 16
#define FAB$M_BIO 32
#define FAB$M_BRO 64
#define FAB$M_EXE 128
#define FAB$M_SHRPUT 1
#define FAB$M_SHRGET 2
#define FAB$M_SHRDEL 4
#define FAB$M_SHRUPD 8
#define FAB$M_MSE 16
#define FAB$M_NIL 32
#define FAB$M_UPI 64
#define FAB$M_ORG 240
#define FAB$C_SEQ 0                     /* sequential                       */
#define FAB$C_REL 16                    /* relative                         */
#define FAB$C_IDX 32                    /* indexed                          */
#define FAB$C_HSH 48                    /* hashed                           */
#define FAB$M_FTN 1
#define FAB$M_CR 2
#define FAB$M_PRN 4
#define FAB$M_BLK 8
#define FAB$C_RFM_DFLT 2                /* var len is default               */
#define FAB$C_UDF 0                     /* undefined (also stream binary)   */
#define FAB$C_FIX 1                     /* fixed length records             */
#define FAB$C_VAR 2                     /* variable length records          */
#define FAB$C_VFC 3                     /* variable fixed control           */
#define FAB$C_STM 4                     /* RMS-11 stream (valid only for sequential org)  */
#define FAB$C_STMLF 5                   /* LF stream (valid only for sequential org)  */
#define FAB$C_STMCR 6                   /* CR stream (valid only for sequential org)  */
#define FAB$C_MAXRFM 6                  /* maximum rfm supported            */
#define FAB$M_ONLY_RU 1
#define FAB$M_RU 2
#define FAB$M_BI 4
#define FAB$M_AI 8
#define FAB$M_AT 16
#define FAB$M_NEVER_RU 32
#define FAB$M_JOURNAL_FILE 64
#define FAB$M_RCF_RU 1
#define FAB$M_RCF_AI 2
#define FAB$M_RCF_BI 4
#define FAB$K_BLN 80                    /* length of fab                    */
#define FAB$C_BLN 80                    /* length of fab                    */
struct FAB {
    unsigned char fab$b_bid;            /* block id                         */
    unsigned char fab$b_bln;            /* block len                        */
    variant_union  {
        unsigned short int fab$w_ifi;   /* internal file index              */
        variant_struct  {
            unsigned fabdef$$_fill_1 : 6; /* move to bit 6                  */
            unsigned fab$v_ppf_rat : 8; /* rat value for process-permanent files  */
            unsigned fab$v_ppf_ind : 1; /* indirect access to process-permanent file  */
/* (i.e., restricted operations)                                            */
            unsigned fab$v_fill_0 : 1;
            } fab$r_ifi_bits;
        } fab$r_ifi_overlay;
    variant_union  {
        unsigned long int fab$l_fop;    /* file options                     */
        variant_struct  {
            unsigned fab$v_asy : 1;     /* asynchronous operations          */
            unsigned fab$v_mxv : 1;     /* maximize version number          */
            unsigned fab$v_sup : 1;     /* supersede existing file          */
            unsigned fab$v_tmp : 1;     /* create temporary file            */
            unsigned fab$v_tmd : 1;     /* create temp file marked for delete  */
            unsigned fab$v_dfw : 1;     /* deferred write (rel and idx)     */
            unsigned fab$v_sqo : 1;     /* sequential access only           */
            unsigned fab$v_rwo : 1;     /* rewind mt on open                */
            unsigned fab$v_pos : 1;     /* use next magtape position        */
            unsigned fab$v_wck : 1;     /* write checking                   */
            unsigned fab$v_nef : 1;     /* inhibit end of file positioning  */
            unsigned fab$v_rwc : 1;     /* rewind mt on close               */
            unsigned fab$v_dmo : 1;     /* dismount mt on close (not implemented)  */
            unsigned fab$v_spl : 1;     /* spool file on close              */
            unsigned fab$v_scf : 1;     /* submit command file on close     */
            unsigned fab$v_dlt : 1;     /* delete sub-option                */
            unsigned fab$v_nfs : 1;     /* non-file structured operation    */
            unsigned fab$v_ufo : 1;     /* user file open - no rms operations  */
            unsigned fab$v_ppf : 1;     /* process permanent file (pio segment)  */
            unsigned fab$v_inp : 1;     /* process-permanent file is 'input'  */
            unsigned fab$v_ctg : 1;     /* contiguous extension             */
            unsigned fab$v_cbt : 1;     /* contiguous best try              */
            unsigned fab$v_syncsts : 1; /* Synchronous status notification for asynchronous routines. */
            unsigned fab$v_rck : 1;     /* read checking                    */
            unsigned fab$v_nam : 1;     /* use name block dvi, did, and/or fid fields for open  */
            unsigned fab$v_cif : 1;     /* create if non-existent           */
            unsigned fabdef$$_fill_3 : 1; /* reserved (was UFM bitfield)    */
            unsigned fab$v_esc : 1;     /* 'escape' to non-standard function ($modify)  */
            unsigned fab$v_tef : 1;     /* truncate at eof on close (write-accessed seq. disk file only)  */
            unsigned fab$v_ofp : 1;     /* output file parse (only name type sticky)  */
            unsigned fab$v_kfo : 1;     /* known file open (image activator only release 1)  */
            unsigned fabdef$$_fill_4 : 1; /* reserved (not implemented)     */
            } fab$r_fop_bits;
        } fab$r_fop_overlay;
    unsigned long int fab$l_sts;        /* status                           */
    unsigned long int fab$l_stv;        /* status value                     */
    unsigned long int fab$l_alq;        /* allocation quantity              */
    unsigned short int fab$w_deq;       /* default allocation quantity      */
    variant_union  {
        unsigned char fab$b_fac;        /* file access                      */
        variant_struct  {
            unsigned fab$v_put : 1;     /* put access                       */
            unsigned fab$v_get : 1;     /* get access                       */
            unsigned fab$v_del : 1;     /* delete access                    */
            unsigned fab$v_upd : 1;     /* update access                    */
            unsigned fab$v_trn : 1;     /* truncate access                  */
            unsigned fab$v_bio : 1;     /* block i/o access                 */
            unsigned fab$v_bro : 1;     /* block and record i/o access      */
            unsigned fab$v_exe : 1;     /* execute access (caller must be exec or kernel mode,  */
/*  ufo must also be set)                                                   */
            } fab$r_fac_bits;
        } fab$r_fac_overlay;
    variant_union  {
        unsigned char fab$b_shr;        /* file sharing                     */
        variant_struct  {
            unsigned fab$v_shrput : 1;  /* put access                       */
            unsigned fab$v_shrget : 1;  /* get access                       */
            unsigned fab$v_shrdel : 1;  /* delete access                    */
            unsigned fab$v_shrupd : 1;  /* update access                    */
            unsigned fab$v_mse : 1;     /* multi-stream connects enabled    */
            unsigned fab$v_nil : 1;     /* no sharing                       */
            unsigned fab$v_upi : 1;     /* user provided interlocking (allows multiple  */
/*  writers to seq. files)                                                  */
            unsigned fab$v_fill_1 : 1;
            } fab$r_shr_bits;
        } fab$r_shr_overlay;
    unsigned long int fab$l_ctx;        /* user context                     */
/*-----*****                                                                */
    char fab$b_rtv;                     /* retrieval window size            */
    variant_union  {
        unsigned char fab$b_org;        /* file organization                */
        variant_struct  {
            unsigned fabdef$$_fill_5 : 4;
            unsigned fab$v_org : 4;
            } fab$r_org_bits;
        } fab$r_org_overlay;
    variant_union  {
        unsigned char fab$b_rat;        /* record format                    */
        variant_struct  {
            unsigned fab$v_ftn : 1;     /* fortran carriage-ctl             */
            unsigned fab$v_cr : 1;      /* lf-record-cr carriage ctl        */
            unsigned fab$v_prn : 1;     /* print-file carriage ctl          */
            unsigned fab$v_blk : 1;     /* records don't cross block boundaries  */
            unsigned fab$v_fill_2 : 4;
            } fab$r_rat_bits;
        } fab$r_rat_overlay;
    unsigned char fab$b_rfm;            /* record format                    */
    variant_union  {
	unsigned int fab$l_jnl;		/* lcb address */
	variant_struct {
	    variant_union  {
		unsigned char fab$b_journal;    /* journaling options (from FH2$B_JOURNAL) */
		variant_struct  {               /* note: only one of RU, ONLY_RU, NEVER_RU */
/* may be set at a time                                                     */
		    unsigned fab$v_only_ru : 1; /* file is accessible only in recovery unit  */
	            unsigned fab$v_ru : 1;      /* enable recovery unit journal     */
	            unsigned fab$v_bi : 1;      /* enable before image journal      */
	            unsigned fab$v_ai : 1;      /* enable after image journal       */
	            unsigned fab$v_at : 1;      /* enable audit trail journal       */
	            unsigned fab$v_never_ru : 1; /* file is never accessible in recovery unit */
	            unsigned fab$v_journal_file : 1; /* this is a journal file      */
	            unsigned fab$v_fill_3 : 1;
	            } fab$r_journal_bits;
	        } fab$r_journal_overlay;
	    unsigned char fab$b_ru_facility;    /* recoverable facility id number   */
	    short int fabdef$$_fill_7;          /* (spare)                          */
	    } fab$l_jnl_real_stuff;
	} fab$l_jnl_overlay;
    char *fab$l_xab;		        /* xab address                      */
    struct NAM *fab$l_nam;      	/* nam block address                */
    char *fab$l_fna;			/* file name string address         */
    char *fab$l_dna;			/* default file name string addr    */
    unsigned char fab$b_fns;            /* file name string size            */
    unsigned char fab$b_dns;            /* default name string size         */
    unsigned short int fab$w_mrs;       /* maximum record size              */
    unsigned long int fab$l_mrn;        /* maximum record number            */
    unsigned short int fab$w_bls;       /* blocksize for tape               */
    unsigned char fab$b_bks;            /* bucket size                      */
    unsigned char fab$b_fsz;            /* fixed header size                */
    unsigned long int fab$l_dev;        /* device characteristics           */
    unsigned long int fab$l_sdc;        /* spooling device characteristics  */
    unsigned short int fab$w_gbc;       /* Global buffer count              */
    variant_union  {
        unsigned char fab$b_acmodes;    /* agent access modes               */
        variant_struct  {
            unsigned fab$v_lnm_mode : 2; /* ACMODE for log nams             */
            unsigned fab$v_chan_mode : 2; /* ACMODE for channel             */
            unsigned fab$v_file_mode : 2; /* ACMODE to use for determining file accessibility */
            unsigned fab$v_callers_mode : 2; /* ACMODE for user structure probing; */
/* maximized with actual mode of caller                                     */
            } fab$r_acmodes_bits;
        } fab$r_acmodes_overlay;
    variant_union  {                    /* recovery control flags           */
        unsigned char fab$b_rcf;        /* (only for use by RMS Recovery)   */
        variant_struct  {
            unsigned fab$v_rcf_ru : 1;  /* recovery unit recovery           */
            unsigned fab$v_rcf_ai : 1;  /* after image recovery             */
            unsigned fab$v_rcf_bi : 1;  /* before image recovery            */
            unsigned fab$v_fill_4 : 5;
            } fab$r_rcf_bits;
        } fab$r_rcf_overlay;
    long int fabdef$$_fill_9;           /* (spare)                          */
    } ;
 
/* These are tradtional macros that should be hand-maintained for compatibility */
#define FAB$V_PPF_RAT	6		/* rat value for process-permanent files */
#define FAB$S_PPF_RAT	8
#define FAB$V_PPF_IND	14		/* indirect access to process-permanent file */
#define FAB$V_MXV	1		/* maximize version number */
#define FAB$V_SUP	2		/* supersede existing file */
#define FAB$V_TMP	3		/* create temporary file */
#define FAB$V_TMD	4		/* temporary file marked for delete */
#define FAB$V_DFW	5		/* deferred write (rel and idx) */
#define FAB$V_SQO	6		/* sequential access only */
#define FAB$V_RWO	7		/* rewind magnetic tape on open */
#define FAB$V_POS	8		/* use next magnetic tape position */
#define FAB$V_WCK	9		/* write checking */
#define FAB$V_NEF	10		/* not end of file, inihibit eof positioning */
#define FAB$V_RWC	11		/* rewind magnetic tape on close */
#define FAB$V_DMO	12		/* dismount mt on close (not implemented) */
#define FAB$V_SPL	13		/* spool file on close */
#define FAB$V_SCF	14		/* submit command file on close */
#define FAB$V_DLT	15		/* delete file */
#define FAB$V_NFS	16		/* non-file-structured operation */
#define FAB$V_UFO	17		/* user file open - no rms operation */
#define FAB$V_PPF	18		/* process permanent file (pio segment) */
#define FAB$V_INP	19		/* process permanent file is 'input' */
#define FAB$V_CTG	20		/* contiguous extension */
#define FAB$V_CBT	21		/* contiguous best try */
#define FAB$V_JNL	22		/* explicit logging (not implemented) */
#define FAB$M_JNL	(1 << FAB$V_JNL)
#define FAB$V_RCK	23		/* read checking */
#define FAB$V_NAM	24		/* use NAM block device, file and/or directory id */
#define FAB$V_CIF	25		/* create if non-existent */
#define FAB$V_UFM	26		/* user file open mode (user if 1, super if 0) enable only if esc and (ufo or nfs) are also on */
#define FAB$M_UFM	(1 << FAB$V_UFM)
#define FAB$V_ESC	27		/* 'escape' to non-standard functions ($modify) */
#define FAB$V_TEF	28		/* truncate at end-of-file on close (write-accessed seq. disk file only) */
#define FAB$V_OFP	29		/* output file parse (only name type sticky) */
#define FAB$V_KFO	30		/* known file open (image activator only release 1) */
#define FAB$V_PUT	0		/* put access */
#define FAB$V_GET	1		/* get access */
#define FAB$V_DEL	2		/* delete access */
#define FAB$V_UPD	3		/* update access */
#define FAB$V_TRN	4		/* truncate access */
#define FAB$V_BIO	5		/* block i/o access */
#define FAB$V_BRO	6		/* block and record i/o access */
#define FAB$V_EXE	7		/* execute access (caller must be exec or kernel mode, ufo must also be set) */
#define FAB$V_SHRPUT	0		/* put access */
#define FAB$V_SHRGET	1		/* get access */
#define FAB$V_SHRDEL	2		/* delete access */
#define FAB$V_SHRUPD	3		/* update access */
#define FAB$V_MSE	4		/* multi-stream connects enabled */
#define FAB$V_NIL	5		/* no sharing */
#define FAB$V_UPI	6		/* user provided interlocking (allows multiple */
#define FAB$V_ORG	4		/* file organization */
#define FAB$S_ORG	4
#define FAB$V_FTN	0		/* FORTRAN carriage control character */
#define FAB$V_CR	1		/* line feed - record -carriage return */
#define FAB$V_PRN	2		/* print-file carriage control */
#define FAB$V_BLK	3		/* records don't cross block boundaries */
#define fab$b_dsbmsk	fab$b_acmodes	/* saved for backwards compatibility */
#define FAB$S_LNM_MODE	2		/* logical names */
#define FAB$V_LNM_MODE	0
#define FAB$S_CHAN_MODE	2		/* channel */
#define FAB$V_CHAN_MODE	2
#define FAB$S_FILE_MODE	2		/* files accessability */
#define FAB$V_FILE_MODE	4
/* The following defines were scrambled before VAX C V3.1 */
#define FAB$V_RU	1		/* (was 0) recovery unit recovery */
#define FAB$V_BI	2		/* (was 2) before image recovery */
#define FAB$V_AI	3		/* (was 1) after image recovery */

globalref struct FAB cc$rms_fab;	/* Declare initialized prototype data structure */

#pragma standard
#endif					/* __FAB_LOADED */
