//**************************************************************************
// LOGOFFVAX.C
//
// This procedure is responsible for logging off the VAX
// and shutting everything down.
//
//
//  VBRMS TCP/IP Custom Control designed and developed by:
//  J. Wren Hunt
//  As You Like It...
//  wrenh@mindspring.com
//  
//  (404) 943-3804
//
//  Copyright (C) 1994 by J. Wren Hunt. All Rights Reserved.
//
//  MODIFICATION HISTORY:
//
//**************************************************************************
#include <windows.h>
#include <winsock.h>
#include "c:\vb\cdk\vbapi.h"

#define IEVENT_RMS_DISCONNECTED 1


extern SOCKET PASCAL FAR sock;



VOID LogoffVAX(HCTL hctl)
{
int status;

	status = closesocket(sock);
	if (status == SOCKET_ERROR)
	{
//	 MessageBox(NULL,"Error on closesocket()","LOGOFVAX.C",MB_OK | MB_ICONHAND);
	}


	status = WSACleanup();    // Terminate use of the Windows Sockets DLL
	if (status == SOCKET_ERROR)
	{
//	 MessageBox(NULL,"Error with WSACleanup","LOGOFVAX.C",MB_OK | MB_ICONHAND);
	}

	// Now let user know that we're well and truly disconnected.
	VBFireEvent(hctl, IEVENT_RMS_DISCONNECTED,NULL);
	return;
}