//**************************************************************************
// LOGONVAX.C
//
// This procedure is responsible for logging onto the VAX
// either by TCP/IP or DEC PATHWORKS.
//
//
//  VBRMS TCP/IP Custom Control designed and developed by:
//  J. Wren Hunt
//  As You Like It...
//  wrenh@mindspring.com
//
//  (404) 943-3804
//
//  Copyright (C) 1994 by J. Wren Hunt. All Rights Reserved.
//
//  MODIFICATION HISTORY:
//
// V001-03/03/95-JWH	Removed hardcoded TCP/IP Port#
//
//**************************************************************************

#define DEBUG 0

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <string.h>
#include "c:\vb\cdk\vbapi.h"



#define TCPIP 0
#define PATHWORKS 1
#define IEVENT_RMS_CONNECTED 0
#define WM_DATA_ARRIVED WM_USER + 01

#define MAKEWORD(a,b) \
	((WORD)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))




char FAR *cBuf[50],*cBuf2[20];
char *ptr;

// Stuff for TCP/IP interaction

WORD wVersionRequested;
WSADATA wsaData;
int PASCAL FAR WSAStartup (WORD wVersionRequired, LPWSADATA lpWSAData);

char     EntBuf[MAXGETHOSTSTRUCT];     // buf for service & resolve returns

extern SOCKET PASCAL FAR sock;
SOCKADDR_IN fsock;			// foreign host
struct hostent *hent;

HWND debug_window;








VOID LogonVAX(HCTL hctl, HWND hWnd)
{
#include "rms2.h"

typedef RMS FAR * LPRMS;

LPRMS lprms;

LPSTR lpstr;
unsigned long IPA;   // IP address of host
int status;



// Subroutine Code....


lprms = (LPRMS)VBDerefControl(hctl);

if (lprms -> debug)
{
  // If user wants to debug, then setup a listbox window and output debug info to it...
  debug_window = CreateWindow("LISTBOX","Debug Listbox",WS_CHILD | WS_VISIBLE, 10,10,
					CW_USEDEFAULT,CW_USEDEFAULT,NULL,NULL,hWnd,NULL);

// TextOut();
 MessageBox(NULL,"Debugging: Start of LOGONVAX.C","LOGONVAX.C",MB_OK);
}



// Does the user want to use TCP/IP or DEC PATHWORKS?

	if (lprms -> transport == TCPIP)
	{
		wVersionRequested = MAKEWORD(1,1);

		status = WSAStartup(wVersionRequested,&wsaData);
		if (status != 0)
		{
			MessageBox(NULL,"Error on WSAStartup","LOGONVAX.C",
						  MB_OK | MB_ICONHAND);
		}

		// What hostname did the user provide?

		  lprms = (LPRMS)VBDerefControl(hctl);


		  // Get a pointer to the BASIC string. Copy this to a null
		  // terminated 'C' string.

		  VBGetHlstr(lprms -> hostname, &cBuf2, 50);


		  // Get hostaddress (if specified)

		  lprms = (LPRMS)VBDerefControl(hctl);
		  lpstr = VBDerefHsz(lprms -> hostaddr);

		  IPA = inet_addr(lpstr);  // This merely checks syntax of a.b.c.d
		  if (IPA == INADDR_NONE)
		  {
			MessageBox(NULL,"Invalid or Unknown host address.", "LOGONVAX.C",
						  MB_OK);
			return;
		  }

		      //	MessageBox(NULL,cBuf2,"Hostname",MB_OK);	// 02/23/95
			hent = gethostbyname(cBuf2);


		// Allocate a socket and connect to the VAX

		sock = socket(AF_INET, SOCK_STREAM, 0);
		if (sock == INVALID_SOCKET)
		{
		 MessageBox(NULL,"Error creating socket.","LOGONVAX.C",MB_OK | MB_ICONHAND);
		 return;
		}


		// Specify foreign host's address and port. 

		lprms = (LPRMS)VBDerefControl(hctl);


		fsock.sin_addr.s_addr = *(long *) hent -> h_addr;
		fsock.sin_port = htons(lprms -> port);

		fsock.sin_family = AF_INET;



		status = connect(sock, &fsock, sizeof(fsock));
		if (status == SOCKET_ERROR)
		{
		 MessageBox(NULL,"Error connecting socket. Please ensure that your TCP/IP stack is\nconfigured on your PC and that you have the correct port number\n setup on your VAX",
		 		"LOGONVAX.C", MB_OK);
		 return;
		}

		// Now we're connected. Set up an asynchronous notification when
		// network data comes in. This will fire the WM_DATA_ARRIVED message
		// which is handled in the RMS1.C module. Interested in the FD_CLOSE
		// event in case the VAX server dies unexpectedly.

		status = WSAAsyncSelect(sock,hWnd,WM_DATA_ARRIVED, FD_READ | FD_CLOSE);
		if (status == SOCKET_ERROR)
			MessageBox(NULL,"Error in WSAAsyncSelect","LOGONVAX.C",MB_OK);
			
	}
	else		// Pathworks
	{
	  MessageBox(NULL,"Inside Pathworks connect","LOGONVAX.C",MB_OK);
	}

	// Let the VB programmer know we're connected no matter
	// the protocol type.

	VBFireEvent(hctl, IEVENT_RMS_CONNECTED,NULL);
	return;
}