#ifndef __RAB_LOADED
#define __RAB_LOADED	1
#pragma nostandard

/*** MODULE $rabdef ***/
/*                                                                          */
/*         record access block (rab) definitions                            */
/*                                                                          */
/*  there is one rab per connected stream                                   */
/*  it is used for all communications between the user                      */
/*  and rms concerning operations on the stream                             */
/*                                                                          */
/*+++++*****                                                                */
/*  the fields thru ctx cannot be changed due to commonality                */
/*  with the fab                                                            */
/*                                                                          */
#define RAB$C_BID 1                     /* code for rab                     */
#define RAB$M_PPF_RAT 16320
#define RAB$M_PPF_IND 16384
#define RAB$M_ASY 1
#define RAB$M_TPT 2
#define RAB$M_REA 4
#define RAB$M_RRL 8
#define RAB$M_UIF 16
#define RAB$M_MAS 32
#define RAB$M_FDL 64
#define RAB$M_HSH 128
#define RAB$M_EOF 256
#define RAB$M_RAH 512
#define RAB$M_WBH 1024
#define RAB$M_BIO 2048
#define RAB$M_CDK 4096
#define RAB$M_LOA 8192
#define RAB$M_LIM 16384
#define RAB$M_SYNCSTS 32768
#define RAB$M_LOC 65536
#define RAB$M_WAT 131072
#define RAB$M_ULK 262144
#define RAB$M_RLK 524288
#define RAB$M_NLK 1048576
#define RAB$M_KGE 2097152
#define RAB$M_KGT 4194304
#define RAB$M_NXR 8388608
#define RAB$M_RNE 16777216
#define RAB$M_TMO 33554432
#define RAB$M_CVT 67108864
#define RAB$M_RNF 134217728
#define RAB$M_ETO 268435456
#define RAB$M_PTA 536870912
#define RAB$M_PMT 1073741824
#define RAB$M_CCO -2147483648
#define RAB$M_EQNXT 2097152
#define RAB$M_NXT 4194304
#define RAB$C_SEQ 0                     /* sequential access                */
#define RAB$C_KEY 1                     /* keyed access                     */
#define RAB$C_RFA 2                     /* rfa access                       */
#define RAB$C_STM 3                     /* stream access (valid only for sequential org)  */
#define RAB$C_MAXRAC 2                  /* Maximum RAC value currently supported by RMS */
#define RAB$K_BLN 68                    /* length of rab                    */
#define RAB$C_BLN 68                    /* length of rab                    */

struct RAB {
    unsigned char rab$b_bid;            /* block id                         */
    unsigned char rab$b_bln;            /* block length                     */
    variant_union  {
        unsigned short int rab$w_isi;   /* internal stream index            */
/* (ifi in fab)                                                             */
        variant_struct  {
            unsigned rabdef$$_fill_1 : 6; /* move to bit 6                  */
            unsigned rab$v_ppf_rat : 8; /* rat value for process-permanent files  */
            unsigned rab$v_ppf_ind : 1; /* indirect access to process-permanent file  */
/* (i.e., restricted operations)                                            */
            unsigned rab$v_fill_5 : 1;
            } rab$r_isi_bits;
        } rab$r_isi_overlay;
    variant_union  {
        unsigned long int rab$l_rop;    /* record options                   */
        variant_struct  {
            unsigned rab$v_asy : 1;     /* asynchronous operations          */
            unsigned rab$v_tpt : 1;     /* truncate put - allow sequential put not at  */
/*   eof, thus truncating file (seq. org only)                              */
/*                                                                          */
/* these next two should be in the byte for bits                            */
/* input to $find or $get, but there is no room there                       */
/*                                                                          */
            unsigned rab$v_rea : 1;     /* lock record for read only, allow other readers  */
            unsigned rab$v_rrl : 1;     /* read record regardless of lock   */
/*                                                                          */
            unsigned rab$v_uif : 1;     /* update if existent               */
            unsigned rab$v_mas : 1;     /* mass-insert mode                 */
            unsigned rab$v_fdl : 1;     /* fast record deletion             */
            unsigned rab$v_hsh : 1;     /* use hash code in bkt             */
/*                                                                          */
            unsigned rab$v_eof : 1;     /* connect to eof                   */
            unsigned rab$v_rah : 1;     /* read ahead                       */
            unsigned rab$v_wbh : 1;     /* write behind                     */
            unsigned rab$v_bio : 1;     /* connect for bio only             */
            unsigned rab$v_cdk : 1;     /* check for duplicate keys on $GET */
            unsigned rab$v_loa : 1;     /* use bucket fill percentage       */
            unsigned rab$v_lim : 1;     /* compare for key limit reached on $get/$find seq. (idx only)  */
            unsigned rab$v_syncsts : 1; /* Synchronous status notification for asynchronous routines. */
/*                                                                          */
/* the following bits are input to                                          */
/* $find or $get, (see above also REA and RRL)                              */
/* (separate byte)                                                          */
/*                                                                          */
            unsigned rab$v_loc : 1;     /* use locate mode                  */
            unsigned rab$v_wat : 1;     /* wait if record not available     */
            unsigned rab$v_ulk : 1;     /* manual unlocking                 */
            unsigned rab$v_rlk : 1;     /* allow readers for this locked record  */
            unsigned rab$v_nlk : 1;     /* do not lock record               */
            unsigned rab$v_kge : 1;     /* key > or =                       */
            unsigned rab$v_kgt : 1;     /* key greater than                 */
            unsigned rab$v_nxr : 1;     /* get non-existent record          */
/*                                                                          */
/*  the following bits are terminal qualifiers only                         */
/*  (separate byte)                                                         */
/*                                                                          */
            unsigned rab$v_rne : 1;     /* read no echo                     */
            unsigned rab$v_tmo : 1;     /* use time-out period              */
            unsigned rab$v_cvt : 1;     /* convert to upper case            */
            unsigned rab$v_rnf : 1;     /* read no filter                   */
            unsigned rab$v_eto : 1;     /* extended terminal operation      */
            unsigned rab$v_pta : 1;     /* purge type ahead                 */
            unsigned rab$v_pmt : 1;     /* use prompt buffer                */
            unsigned rab$v_cco : 1;     /* cancel control o on output       */
            } rab$r_rop_bits0;
        variant_struct  {
            unsigned rabdef$$_fill_6 : 21;
            unsigned rab$v_eqnxt : 1;   /* Synonyms for KGE and             */
            unsigned rab$v_nxt : 1;     /*   KGT                            */
            unsigned rab$v_fill_6 : 1;
            } rab$r_rop_bits1;
/* the following bits may be                                                */
/* input to various rab-related                                             */
/* operations                                                               */
/*                                                                          */
        variant_struct  {
            char rabdef$$_fill_3;
            unsigned char rab$b_rop1;   /* various options                  */
            unsigned char rab$b_rop2;   /* get/find options (use of this field discouraged  */
/* due to REA and RRL being in a different byte)                            */
            unsigned char rab$b_rop3;   /* terminal read options            */
/*                                                                          */
            } rab$r_rop_fields;
        } rab$r_rop_overlay;
    unsigned long int rab$l_sts;        /* status                           */
    variant_union  {
        unsigned long int rab$l_stv;    /* status value                     */
        variant_struct  {
            unsigned short int rab$w_stv0; /* low word of stv               */
            unsigned short int rab$w_stv2; /* high word of stv              */
            } rab$r_stv_fields;
        } rab$r_stv_overlay;
    variant_union  {
        unsigned short int rab$w_rfa [3]; /* record's file address          */
        variant_struct  {
            unsigned long int rab$l_rfa0;
            unsigned short int rab$w_rfa4;
            } rab$r_rfa_fields;
        } rab$r_rfa_overlay;
    short int rabdef$$_fill_4;          /* (reserved - rms release 1 optimizes stores  */
/*  to the rfa field to be a move quad, overwriting                         */
/*  this reserved word)                                                     */
    unsigned long int rab$l_ctx;        /* user context                     */
/*-----*****                                                                */
    short int rabdef$$_fill_5;          /* (spare)                          */
    unsigned char rab$b_rac;            /* record access                    */
    unsigned char rab$b_tmo;            /* time-out period                  */
    unsigned short int rab$w_usz;       /* user buffer size                 */
    unsigned short int rab$w_rsz;       /* record buffer size               */
    char *rab$l_ubf;			/* user buffer address              */
    char *rab$l_rbf;			/* record buffer address            */
    char *rab$l_rhb;			/* record header buffer addr        */
    variant_union  {
        char *rab$l_kbf;		/* key buffer address               */
        char *rab$l_pbf;		/* prompt buffer addr               */
        } rab$r_kbf_overlay;
    variant_union  {
        unsigned char rab$b_ksz;        /* key buffer size                  */
        unsigned char rab$b_psz;        /* prompt buffer size               */
        } rab$r_ksz_overlay;
    unsigned char rab$b_krf;            /* key of reference                 */
    char rab$b_mbf;                     /* multi-buffer count               */
    unsigned char rab$b_mbc;            /* multi-block count                */
    variant_union  {
        unsigned long int rab$l_bkt;    /* bucket hash code, vbn, or rrn    */
        unsigned long int rab$l_dct;    /* duplicates count on key accessed on alternate key  */
        } rab$r_bkt_overlay;
    struct FAB *rab$l_fab;		/* related fab for connect          */
    char *rab$l_xab;			/* XAB address                      */
    } ;
 
/* These are tradtional macros that should be hand-maintained for compatibility */
#define RAB$V_PPF_RAT	6		/* rat value for process-permanent files */
#define RAB$S_PPF_RAT	8
#define RAB$V_PPF_IND	14		/* indirect access to process-permanent file */
#define RAB$V_ASY	0		/* asynchronous operations */
#define RAB$V_TPT	1		/* truncate-on-put - allow sequential put not at eof */
#define RAB$V_REA	2		/* lock record for read only, allow other readers */
#define RAB$V_RRL	3		/* read record regardless of lock */
#define RAB$V_UIF	4		/* update if existent */
#define RAB$V_MAS	5		/* mass-insert mode */
#define RAB$V_FDL	6		/* fast record deletion */
#define RAB$V_HSH	7		/* use hash code in bkt */
#define RAB$V_EOF	8		/* connect to end-of-file */
#define RAB$V_RAH	9		/* read ahead */
#define RAB$V_WBH	10		/* write behind */
#define RAB$V_BIO	11		/* connect for block I/O only */
#define RAB$V_LV2	12		/* level 2 RU lock consistency */
#define RAB$M_LV2	(1 << RAB$V_LV2)
#define RAB$V_LOA	13		/* load buckets according to the file size */
#define RAB$V_LIM	14		/* compare for key limit reached on $get/$find seq.(idx only) */
#define RAB$V_LOC	16		/* use locate mode */
#define RAB$V_WAT	17		/* wait if record not available */
#define RAB$V_ULK	18		/* manual unlocking */
#define RAB$V_RLK	19		/* allow readers for this locked record */
#define RAB$V_NLK	20		/* do not lock record */
#define RAB$V_KGE	21		/* key is greater than or equal to */
#define RAB$V_KGT	22		/* key is greater than */
#define RAB$V_NXR	23		/* non-existent record processing */
#define RAB$V_RNE	24		/* read no echo */
#define RAB$V_TMO	25		/* use time-out period */
#define RAB$V_CVT	26		/* convert to upper case */
#define RAB$V_RNF	27		/* read no filter */
#define RAB$V_ETO	28		/* extended terminal operation */
#define RAB$V_PTA	29		/* purge type ahead */
#define RAB$V_PMT	30		/* use prompt buffer */
#define RAB$V_CCO	31		/* cancel control O on output */
#define RAB$V_EQNXT 	21		/*  Synonym for KGE */
#define RAB$V_NXT  	22		/*  Synonym for KGT */

globalref struct RAB cc$rms_rab;	/* Declare initialized prototype data structure */

#pragma standard
#endif					/* __RAB_LOADED */
