//**************************************************************************
// RMS1.C
//
//  VBRMS TCP/IP Custom Control designed and developed by:
//  J. Wren Hunt
//  As You Like It...
//  wrenh@mindspring.com
// 
//  (404) 943-3804
//
//  Copyright (C) 1994 by J. Wren Hunt. All Rights Reserved.
//
//
// NOTE:
//
// 	Make sure you load the VBX into Visual Basic *WHILE YOUR NETWORK
//		IS LOADED* (i.e., do not use WIN/N)
//
//
//  INTERNALS:
//
//  IEVENT_RMS_CONNECTED event is fired from within LOGONVAX.C after
//                       successful connection.
//
//  IEVENT_RMS_DISCONNECTED event is fired from within LOGOFFVAX.C after
//                          closesocket() and WSACleanup() is performed.
//
//  IEVENT_RMS_DATAIN    event is fired from within this module (RMS1.C)
//                       when the asynchronous custom defined windows
//                       message (WM_DATA_ARRIVED) is received after having
//                       been set in the LOGONVAX.C routine immediately
//                       after connection.
//
//  MODIFICATION HISTORY:
//
//**************************************************************************

#include <windows.h>
#include <string.h>
#include <winsock.h>
#include <alloc.h>					// memory management routines
#include "c:\vb\cdk\vbapi.h"

#include "rms1.h"

typedef RMS FAR * LPRMS;

LPRMS lprms;


//---------------------------------------------------------------------------
// Global Variables
//---------------------------------------------------------------------------
HANDLE hmodDLL;
WORD cVbxUsers = 0;
BOOL fDevTimeInited = FALSE;
BOOL firsttimethru = TRUE;

SOCKET PASCAL FAR sock;

int i,j;
WORD wEvent;

char  FAR cData[9000];      // this is an arbitrary number. Really need to MALLOC correct amt.
char  FAR *sptr;
char  FAR *start;
char *cPtr;

u_long ulBytes;


typedef struct tagDATAINPARAMS
{

// float far *dataaddr;		// Address of data in memory. 6/1695-jwh
 long  *dataaddr;
 HLSTR datainstring;
}
DATAINPARAMS;


DATAINPARAMS params;


int status;
HANDLE hsz;
LPSTR lpstr;
int string_len;
HWND NEAR HwndInitAbout(VOID);
VOID LogonVAX(HCTL, HWND);
VOID LogoffVAX(HCTL);
VOID Blastit(HCTL, LPRMS lprms, int, LPSTR);


BOOL _export FAR PASCAL AboutDlgProc(HWND hDlg, USHORT msg, USHORT wp, LONG lp);
LONG FAR PASCAL _export FlashPopupWndProc(HWND hwnd, USHORT msg, USHORT wp, LONG lp);
#define CLASS_FLASHPOPUP    "FCPopup"

float floatjunk = 531;


// Global variables for About dialog

BOOL fDlgInUse = FALSE;
HCTL hctlDialog;
USHORT ipropDialog;

//---------------------------------------------------------------------------
// Private messages
//---------------------------------------------------------------------------
#define CM_OPENFLASHDLG     WM_USER
#define WM_DATA_ARRIVED     WM_USER + 01

//---------------------------------------------------------------------------
// RMS Control Procedure
//---------------------------------------------------------------------------
LONG FAR PASCAL _export RMSCtlProc
(
	 HCTL   hctl,
	 HWND   hwnd,
	 USHORT msg,
	 USHORT wp,
	 LONG   lp
)


{
	 switch (msg)
	{

	  case WM_DATA_ARRIVED:

	  // We got here via the graces of WSAAsyncSelect which was fired
	  // right after we connected to the TCP host in LOGONVAX.C.
	  // Now read the data, and pass it to the Visual Basic DATAIN event.

	    	for (i=0; i < 9000; i++)
	  		cData[i] = '\0';

	  // Get the number of bytes to recv()...

	  ioctlsocket(sock, FIONREAD, &ulBytes);
	  if (ulBytes > 10000)
	  {
		MessageBox(NULL,"Attempt to read more than 10000 bytes", "RMS1.C",MB_OK);
	  }


	  // Allocate enough memory to hold the just-read message.

	//  cPtr = malloc(ulBytes);
	//  MessageBox(NULL,"MALLOCed memory","RMS1.C",MB_OK);

	//  memset(cPtr,'\0',ulBytes-1);
	//  MessageBox(NULL,"MEMSETed memory","RMS1.C",MB_OK);


	  status = recv(sock,cData,(int)ulBytes,0);		// Read the data from VAX
	  if (status == SOCKET_ERROR)
	  {
		MessageBox(NULL,"Error on recv()","RMS1.C",MB_OK);
		return 0L;
	  }

	  // If we're interested in debugging events, spill it out now...

	  if (lprms -> debug)
	  {
		MessageBox(NULL,"Inside debug event","RMS1.C",MB_OK);
		//TextOut();
	  }


	  // Now that we have the 'C' string, construct a Visual Basic
	  // HLSTR string to pass that as a parameter to our DATAIN event.


				//dataelement1\ndataelement2\n

			  sptr =  &cData;
			  start = &cData;
			  j = 0;
			  for (i=0; i<= ulBytes; i++)
			  {
				if (cData[i] == '\n')
				{
					cData[i] = ' ';	// convert \n to blank.
					params.datainstring = VBCreateHlstr(start, (USHORT)j);
				     //	MessageBox(NULL,"Right before float assignment","RM1.C",MB_OK);

					params.dataaddr = start; // &params.datainstring;

					// Now let the VB programmer know there's data in...
					// Need to pass dataaddr here... 5/8/95-jwh
				      //	MessageBox(NULL,"Right before VBFireEvent","RMS1.C",MB_OK);

					VBFireEvent(hctl, IEVENT_RMS_DATAIN, &params);

					// The VBFireEvent function does not return until the event
					// procedure, if any, is completely executed. (pp 9-81).

					VBDestroyHlstr(params.datainstring);
					//free(cPtr);
					start = sptr+1;
					j = 0;
				}

				sptr++;
				j++;
			  }

	  break;

      //	  case FD_CLOSE:
     //	  {
     //		MessageBox(NULL,"Received FD_CLOSE event","RMS1.C",MB_OK);
     //	  }
     //	  break;


	  case VBM_SETPROPERTY: 	// we get here courtesy of the PF_fSetMsg flag
	  switch(wp)
	  {

		 case IPROP_RMS_DATATOSEND:
		 //-------------------------------------------------------------------
		 // The VB user has just stuffed something in the DATATOSEND property
		 // for us to blast to the applicable transport.
		 //-------------------------------------------------------------------

		 // Dereference the pointer to get the string address of the data to
		 // send.


		  lprms = (LPRMS)VBDerefControl(hctl);

		  // Get the string length...

		  string_len = VBGetHlstrLen(lprms -> datatosend);

		  lpstr = VBDerefHlstr(lprms -> datatosend);
		  Blastit(hctl, lprms, string_len, lpstr);

		  return 0L;




		  case IPROP_RMS_OPERATION:
//		  MessageBox(NULL,"Inside IPROP_RMS_OPERATION","RMS1.C",MB_OK);
		  return 0L;



		 case IPROP_RMS_CONNECTED:
		 //----------------------------------------------------------------------
		 // The VB application explicitly enabled/disabled the Connected property
		 //----------------------------------------------------------------------

		 // Don't let 'em setit at design time.

		 if (VBGetMode() == MODE_DESIGN)
			return 0L;

		 lprms = (LPRMS)VBDerefControl(hctl); // pp 7-59

	   	  if (!firsttimethru)
	 	  {
		   if (lprms -> connected)   // If true, then user wants to connect.
			LogonVAX(hctl, hwnd);
		   else
			LogoffVAX(hctl);
		   return 0L;
		  }
	 	 firsttimethru = FALSE;


	} // wp for VBM_SETPROPERTY
	break;




	case VBM_INITPROPPOPUP:
	switch(wp)
	{
	  case IPROP_RMS_ABOUT:
	  {
			 if (fDlgInUse)
				// Our dialog is already in use, so return NULL here
				// to avoid bringing up a 2nd instance of the dialog.
				// We could get around this restriction by storing
				// hctlDialog, ipropDialog, and colorOldDialog as
				// window words of hwndPopup.
				// NOTE: In this specific case, because FlashColor
				// is DT_COLOR, we could also just "break;" to go
				// through default processing which would bring up
				// the default color palette.
				return NULL;

			 // Tell the hwndPopup which control and iprop we want
			 // the dialog to change

			 fDlgInUse	= TRUE;
			 hctlDialog	= hctl;
			 ipropDialog = wp;

			 return HwndInitAbout();
	  }



	}   //switch(np)
	break;


	case WM_NCCREATE:
		 {
		 // Get a pointer to the programmer-defined structure
		 // by dereferencing the control.

		 lprms = (LPRMS)VBDerefControl(hctl); // pp 7-59

		 // Assign control default values for numeric/boolean properties.

		 lprms -> connected = FALSE;
		 // 03/03/95 lprms -> port = 501L;
		 lprms -> inbufsize = 2048L;
		 lprms -> outbufsize = 2048L;
		 lprms -> EOL = 10;
	    	 lprms -> debug = FALSE;



		 // Set default string properties.

		 VBSetControlProperty(hctl, IPROP_RMS_ABOUT,(LONG)"Click on '...' for About box");


		// *** lprms may now be invalid due to call to VB API ***


		 break;
		 }

		  case WM_LBUTTONDOWN:
		  case WM_LBUTTONDBLCLK:


			break;


		  case WM_PAINT:
				break;


		  case WM_SIZE:
				break;


	}	// switch on MSG

	 return VBDefControlProc(hctl, hwnd, msg, wp, lp);
}



//---------------------------------------------------------------------------
// Initialize library. This routine is called when the first client loads
// the DLL.
//---------------------------------------------------------------------------
int FAR PASCAL LibMain
(
	 HANDLE hModule,
	 WORD   wDataSeg,
	 WORD   cbHeapSize,
	 LPSTR  lpszCmdLine
)
{
	 // Avoid warnings on unused (but required) formal parameters
	 wDataSeg	= wDataSeg;
	 cbHeapSize	= cbHeapSize;
	 lpszCmdLine = lpszCmdLine;

	 hmodDLL = hModule;

	 return 1;
}


//---------------------------------------------------------------------------
// Register custom control.  This routine is called by VB when the custom
// control DLL is loaded for use.
//---------------------------------------------------------------------------
BOOL FAR PASCAL _export VBINITCC
(
	 USHORT usVersion,
	 BOOL   fRuntime
)
{
	usVersion = usVersion;	// avoid warning on unused param

	 // Count the number of hosts using this VBX.  A host can be vb.exe,
	 // any .exe compiled from vb which uses this custom control, or any
	 // other program which loads and uses VBX files.
	 ++cVbxUsers;

	 // Register popup class if this is from the development environment.
	 if (!fRuntime && !fDevTimeInited)
	{
	WNDCLASS class;

	class.style	    = 0;
	class.lpfnWndProc   = (FARPROC)FlashPopupWndProc;
	class.cbClsExtra    = 0;
	class.cbWndExtra    = 0;
	class.hInstance     = hmodDLL;
	class.hIcon	    	  = NULL;
	class.hCursor	     = NULL;
	class.hbrBackground = NULL;
	class.lpszMenuName  = NULL;
	class.lpszClassName = CLASS_FLASHPOPUP;

	if (!RegisterClass(&class))
		 return FALSE;

	// We successfully initialized the stuff we need at dev time
	fDevTimeInited = TRUE;
	}




	 // Register control(s)
	 return VBRegisterModel(hmodDLL, &modelRMS);
}


//---------------------------------------------------------------------------
// WEP
//---------------------------------------------------------------------------
// C7 and QCWIN provide default a WEP:
//---------------------------------------------------------------------------
#if (_MSC_VER < 610)

int FAR PASCAL WEP(int fSystemExit);

//---------------------------------------------------------------------------
// For Windows 3.0 it is recommended that the WEP function reside in a
// FIXED code segment and be exported as RESIDENTNAME.  This is
// accomplished using the alloc_text pragma below and the related EXPORTS
// and SEGMENTS directives in the .DEF file.
//
// Read the comments section documenting the WEP function in the Windows
// 3.1 SDK "Programmers Reference, Volume 2: Functions" before placing
// any additional code in the WEP routine for a Windows 3.0 DLL.
//---------------------------------------------------------------------------
#pragma alloc_text(WEP_TEXT,WEP)

//---------------------------------------------------------------------------
// Performs cleanup tasks when the DLL is unloaded.  WEP() is
// called automatically by Windows when the DLL is unloaded (no
// remaining tasks still have the DLL loaded).	It is strongly
// recommended that a DLL have a WEP() function, even if it does
// nothing but returns success (1), as in this example.
//---------------------------------------------------------------------------
int FAR PASCAL WEP
(
	 int fSystemExit
)
{
	 // Avoid warnings on unused (but required) formal parameters
	 fSystemExit = fSystemExit;

	 return 1;
}
#endif // C6

//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Create our property popup-window.  Since we want to put up a dialog, this
// window never becomes visible.  Instead, when asked to become visible, it
// will post a message to itself, remining it to put up our dialog.
//
// NOTE: May return NULL!
//---------------------------------------------------------------------------
HWND NEAR HwndInitAbout
(
	 VOID
)
{
	 return CreateWindow(CLASS_FLASHPOPUP, NULL, WS_POPUP,
			0, 0, 0, 0, NULL, NULL,
			hmodDLL, NULL);
}


//---------------------------------------------------------------------------
// We asked to show ourself, remain invisible and post a CM_OPENFLASHDLG to
// ourself.  When we receive this message, open the dialog box.
//---------------------------------------------------------------------------
LONG _export FAR PASCAL FlashPopupWndProc
(
	 HWND   hwnd,
	 USHORT msg,
	 USHORT wp,
	 LONG   lp
)
{
	 extern HANDLE hmodDLL;

	 switch (msg)
	{
	case WM_DESTROY:
		 fDlgInUse = FALSE;
		 break;

		  case WM_SHOWWINDOW:
		 if (wp)
		{
		PostMessage(hwnd, CM_OPENFLASHDLG, 0, 0L);
		return 0L;
		}
				break;

	case CM_OPENFLASHDLG:
		 VBDialogBoxParam(hmodDLL, "ABOUT_DIALOG", (FARPROC)AboutDlgProc, 0L);
		 return 0L;
	}

	 return DefWindowProc(hwnd, msg, wp, lp);
}



//---------------------------------------------------------------------------
// The Dialog Procedure for the About property dialog.
//---------------------------------------------------------------------------
BOOL FAR PASCAL _export AboutDlgProc
(
	 HWND   hDlg,
	 USHORT msg,
	 USHORT wp,
	 LONG   lp
)

{
	lp = lp;		// 10/20/94-jwh avoid warning on required param

	 switch (msg)
	{
		  case WM_COMMAND:
		 switch (wp)
		{
		  case IDOK:
			 EndDialog(hDlg, TRUE);
			 return TRUE;

		}
				break;
	}
	 return FALSE;
}


//---------------------------------------------------------------------------
// Unregister custom control.  This routine is called by VB when the custom
// control DLL is being unloaded.
//---------------------------------------------------------------------------
VOID FAR PASCAL _export VBTERMCC
(
	 VOID
)
{
	 --cVbxUsers;
	 if (cVbxUsers == 0 && fDevTimeInited)
	{
	// Free any resources created for Dev environment
	UnregisterClass(CLASS_FLASHPOPUP, hmodDLL);
	}
	 return;
}


