//---------------------------------------------------------------------------
// RMS1.h
//
//  VBRMS TCP/IP Custom Control designed and developed by:
//  J. Wren Hunt
//  As You Like It...
//  wrenh@mindspring.com
//
//  (404) 943-3804
//
//  Copyright (C) 1994 by J. Wren Hunt. All Rights Reserved.
//
// MODIFICATION HISTORY:
//
// V003-03/05/95-JWH		Added DEBUG property.
// V002-10/27/94-JWH		Added INBUFSIZE, OUTBUFSIZE and EOL.
// V001-10/22/94-JWH		Added TRANSPORT property.
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Resource Information
//---------------------------------------------------------------------------

#define RMS_NORMAL	1
#define RMS_EOF	2
#define IDM_OK 1

// Toolbox bitmap resource IDs numbers.
//---------------------------------------------------------------------------
#define IDBMP_RMS			8000
#define IDBMP_RMSDOWN	8001
#define IDBMP_RMSMONO	8003
#define IDBMP_RMSEGA 	8006


//---------------------------------------------------------------------------
// Change these for each new VBX file
//---------------------------------------------------------------------------
#define VBX_COMPANYNAME 	   "As You Like It...\0"
#define VBX_FILEDESCRIPTION	"VAX/VMS RMS TCP/IP Custom Control\0"
#define VBX_INTERNALNAME	   "RMS\0"
#define VBX_LEGALCOPYRIGHT	   "Copyright \251 J. Wren Hunt 1994-95\0"
#define VBX_LEGALTRADEMARKS	"Microsoft\256 is a registered trademark of Microsoft Corporation. Visual Basic\231 is a trademark of Microsoft Corporation. Windows\231 is a trademark of Microsoft Corporation.\0"
#define VBX_ORIGINALFILENAME	"VBRMS.VBX\0"
#define VBX_PRODUCTNAME 		"As You Like It...VAX/VMS RMS TCP/IP Custom Control\0"

//---------------------------------------------------------------------------
// Update these fields for each build.
//---------------------------------------------------------------------------
#define VBX_VERSION		    3,00,0,00
#define VBX_VERSION_STR 	   "3.00.000\0"


#ifndef RC_INVOKED

#define OFFSETIN(struc, field) ((USHORT)&(((struc *)0)->field))

//---------------------------------------------------------------------------
// Control Procedure
//---------------------------------------------------------------------------
LONG FAR PASCAL _export RMSCtlProc(HCTL, HWND, USHORT, USHORT, LONG);



//typedef struct
//{
//  long rms_status;
//  char data[32767];
//} IN_PACKET;

#include "rms2.h"

#define LprmsDEREF(hctl)     ((LPRMS)VBDerefControl(hctl))

//---------------------------------------------------------------------------
// Property list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
//---------------------------------------------------------------------------
#define IPROP_RMS_CTLNAME              0
#define IPROP_RMS_INDEX                1
#define IPROP_RMS_TAG                  2
#define IPROP_RMS_TOP		       3
#define IPROP_RMS_LEFT                 4
#define IPROP_RMS_PARENT               5
#define IPROP_RMS_HWND		       6
#define IPROP_RMS_ABOUT     	       7
#define IPROP_RMS_PORT                 8
#define IPROP_RMS_HOSTADDR	       9
#define IPROP_RMS_HOSTNAME            10
#define IPROP_RMS_DIRECTORY           11
#define IPROP_RMS_DEVICE              12
#define IPROP_RMS_FILENAME            13
#define IPROP_RMS_OPERATION           14
#define IPROP_RMS_UIC                 15
#define IPROP_RMS_PROTECTION          16
#define IPROP_RMS_RMS_STATUS          17
#define IPROP_RMS_CONNECTED           18
#define IPROP_RMS_TRANSPORT           19
#define IPROP_RMS_DATATOSEND          20
#define IPROP_RMS_INBUFSIZE           21
#define IPROP_RMS_OUTBUFSIZE	      22
#define IPROP_RMS_EOL                 23
#define IPROP_RMS_KEYPOS              24
#define IPROP_RMS_KEYLEN              25
#define IPROP_RMS_KEYNUM              26
#define IPROP_RMS_DEBUG               27



/************************************************************************/

// Datatypes are described on pp 6-46.


PROPINFO Property_RMSABOUT =
{
 "About",
 DT_HSZ | PF_fGetData | PF_fSetData | PF_fSaveData,
 OFFSETIN(RMS, about),
};

PROPINFO Property_Connected =
{
 "Connected",
 DT_BOOL | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fSetMsg,
 OFFSETIN(RMS, connected),
};

PROPINFO Property_DataToSend =
{
 "DataToSend",
 DT_HLSTR | PF_fGetData | PF_fSetData | PF_fSetMsg,
 OFFSETIN(RMS, datatosend),
};


PROPINFO Property_Debug =
{
 "Debug",
 DT_BOOL | PF_fGetData | PF_fSetData | PF_fSetMsg,
 OFFSETIN(RMS, debug),
};

PROPINFO Property_Device =
{
"Device",
DT_HLSTR | PF_fGetData | PF_fSetData | PF_fSaveData,
OFFSETIN(RMS, device),
};


PROPINFO Property_Directory =
{
"Directory",
DT_HLSTR | PF_fGetData | PF_fSetData | PF_fSaveData,
OFFSETIN(RMS, directory),
};

PROPINFO Property_EOL =
{
"EOL",
DT_SHORT | PF_fGetData | PF_fSetData | PF_fSaveData,
OFFSETIN(RMS, EOL),
};


PROPINFO Property_Filename =
{
"Filename",
DT_HLSTR | PF_fGetData | PF_fSetData | PF_fSaveData,
OFFSETIN(RMS, filename),
};


PROPINFO Property_Hostaddr =
{
 "HostAddress",
  DT_HSZ | PF_fGetData | PF_fSetData | PF_fSaveData,
  OFFSETIN(RMS,hostaddr),
};

PROPINFO Property_Hostname =
{
 "HostName",
 DT_HLSTR | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
 OFFSETIN(RMS,hostname),
};

PROPINFO Property_Inbufsize =
{
 "InBufSize",
 DT_LONG | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
 OFFSETIN(RMS,inbufsize),
};

PROPINFO Property_KeyPos =
{
 "KeyPosition",
 DT_SHORT | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
 OFFSETIN(RMS,keypos),
};

PROPINFO Property_KeyLen =
{
 "KeyLength",
 DT_SHORT | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
 OFFSETIN(RMS,keylen),
};

PROPINFO Property_KeyNum =
{
 "KeyNumber",
 DT_SHORT | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
 OFFSETIN(RMS,keynum),
};


// These constants MUST MATCH those on the VAX side.
// Their BASIC equivalents are stored in the file VBRMS.TXT

#define VBRMS_READ_SEQ 		0
#define VBRMS_READ_DIRECT  1
#define VBRMS_READ_RFA     2
#define VBRMS_READ_KEYEQ   3
#define VBRMS_READ_KEYGT   4
#define VBRMS_READ_KEYGE   5
#define VBRMS_DELETE_FILE  6
#define VBRMS_RENAME_FILE  7
#define VBRMS_CREATE_SEQ   8
#define VBRMS_CREATE_DIRECT 9
#define VBRMS_CREATE_INDXD 10
#define VBRMS_TYPE_FILE    11
#define VBRMS_DIRECTORY    12
#define VBRMS_WRITE_RECORD 13
#define VBRMS_UPDATE_RECORD 14
#define VBRMS_RETURN_DEVICES 15

char szOperationTypes[] = "0 - Read Sequentially\0" \
								  "1 - Read Random/Direct\0" \
								  "2 - RFA access\0" \
								  "3 - Key: Equal\0" \
								  "4 - Key: Greater Than\0" \
								  "5 - Key: Greater Than or Equal\0" \
								  "6 - Delete file\0" \
								  "7 - Rename file\0" \
								  "8 - Create Sequential file\0" \
								  "9 - Create Random file\0" \
								  "10 - Create Indexed file\0" \
								  "11 - Type file\0"\
								  "12 - Directory\0"\
								  "13 - Write Record\0"\
								  "14 - Update Record\0"\
								  "15 - Return Devices\0"\
								  "";

PROPINFO Property_Operation =
{
"Operation",
DT_ENUM | PF_fGetData | PF_fSetData | PF_fSetMsg,
OFFSETIN(RMS,operation),
0,									// Infodata: used for packing
3,                         // data default
szOperationTypes,          // Enumerated list
120                         // maximum value. NOTE: 120 IS JUST FOR TESTING!
};


PROPINFO Property_Outbufsize =
{
 "OutBufSize",
 DT_LONG | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
 OFFSETIN(RMS,outbufsize),
};


PROPINFO Property_Port =
{
 "Port",
 DT_SHORT | PF_fGetData | PF_fSetData | PF_fSaveData,
 OFFSETIN(RMS,port),
};

PROPINFO Property_Protection =
{
"Protection",
DT_HLSTR | PF_fGetData | PF_fSetData | PF_fSaveData,
OFFSETIN(RMS,protection),
};

PROPINFO Property_RMS_Status =
{
"RMS_Status",
DT_LONG | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fNoRuntimeW,
OFFSETIN(RMS,rms_status),
};

PROPINFO Property_UIC =
{
"UIC",
DT_HLSTR | PF_fGetData | PF_fSetData | PF_fSaveData,
OFFSETIN(RMS,UIC),
};


char szTransportTypes[] = "0 - TCP/IP\0"\
								  "1 - Pathworks\0"\
								  "";

PROPINFO Property_Transport =
{
"Transport",
DT_ENUM | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fSetMsg,
OFFSETIN(RMS,transport),
0,									// Infodata: used for packing
0,									// data default
szTransportTypes,				// Enumerated list
1									// maximum value
};

/********************************************************************/

PPROPINFO RMS_Properties[] =
	 {
	 PPROPINFO_STD_CTLNAME,    // Required and should be 1st.
	 PPROPINFO_STD_INDEX,      // Required and should be 2nd.
	 PPROPINFO_STD_TAG,
	 PPROPINFO_STD_TOPNORUN, 	// Use these for invisible controls
	 PPROPINFO_STD_LEFTNORUN,  // "                              "
	 PPROPINFO_STD_PARENT,	   // Required.
	 PPROPINFO_STD_HWND,
	 &Property_RMSABOUT,	  // 10/16/94-jwh
	 &Property_Port,        // 10-16-94-jwh
	 &Property_Hostaddr,
	 &Property_Hostname,
	 &Property_Directory,
	 &Property_Device,
	 &Property_Filename,
	 &Property_Operation,
	 &Property_UIC,
	 &Property_Protection,
	 &Property_RMS_Status,
	 &Property_Connected,
	 &Property_Transport,
	 &Property_DataToSend,
	 &Property_Inbufsize,
	 &Property_Outbufsize,
	 &Property_EOL,
	 &Property_KeyPos,         // Key stuff added 3/3/95
	 &Property_KeyLen,
	 &Property_KeyNum,
	 &Property_Debug,
	 NULL
	 };


//---------------------------------------------------------------------------
// Event list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the events
//---------------------------------------------------------------------------
enum event_indexes{
	 IEVENT_RMS_CONNECTED,
	 IEVENT_RMS_DISCONNECTED,
	 IEVENT_RMS_READYTOSEND,
	 IEVENT_RMS_DATAIN,
	 IEVENT_RMS_DATASENT
	 };


// Declare the new events...

EVENTINFO Event_Connected =
{
  "Connected",				// name
  0,							// number of arguments
  0,							// number of words in arguments
  NULL,						// pointer to type array
  NULL						// argument string
};


EVENTINFO Event_Disconnected =
{
  "Disconnected",			 // name
  0,							// number of arguments
  0,							// number of words in arguments
  NULL,						// pointer to type array
  NULL						// argument string
};

EVENTINFO Event_Readytosend =
{
  "ReadyToSend",				// name
  0,							// number of arguments
  0,							// number of words in arguments
  NULL,						// pointer to type array
  NULL						// argument string
};

WORD Paramtypes_Datain[] = {ET_HLSTR, ET_I4};

EVENTINFO Event_Datain =
{
  "DataIn",				   // name
  2,							// number of arguments
  4,							// number of words in arguments
  Paramtypes_Datain,					// pointer to type array
  "DataIn as String,DataAddr as Long"		// argument string
};


EVENTINFO Event_DataSent =
{
  "DataSent",				// name
  0,							// number of arguments
  0,							// number of words in arguments
  NULL,						// pointer to type array
  NULL						// argument string
};

PEVENTINFO RMS_Events[] =
	 {
	 &Event_Connected,
	 &Event_Disconnected,
	 &Event_Readytosend,
	 &Event_Datain,
	 &Event_DataSent,
	 NULL
	 };


//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------

// Model flags are on pp. 14-227

MODEL modelRMS =
	 {
	 VB_VERSION, 					// VB version being used
	 MODEL_fLoadMsg | MODEL_fInvisAtRun | MODEL_fInitMsg,				// MODEL flags
	 (PCTLPROC)RMSCtlProc,		// Control procedure
	 CS_VREDRAW | CS_HREDRAW,	// Class style
	 WS_BORDER,						// Default Windows style
	 sizeof(RMS),					// Size of RMS structure
	 IDBMP_RMS,						// Palette bitmap ID
	 "RMS",							// Default control name
	 "RMS1",							// Visual Basic class name
	 NULL,							// Parent class name
	 RMS_Properties,				// Property information table
	 RMS_Events,					// Event information table
	 IPROP_RMS_ABOUT,				// Default property
	 IEVENT_RMS_CONNECTED,		// Default event
	 -1								// Property representing value of ctl
	 };

#endif	// RC_INVOKED
//---------------------------------------------------------------------------
