/*
 *  RMSconnect/VBRMS Server.
 *
 *  This server is an alternative ECHO server which lets the MultiNet
 *  MULTINET_SERVER process listen for it. When a connection arrives,
 *  the MULTINET_SERVER will create a process running this image which
 *  processes the connection.
 *
 *  To compile and link this server:
 *
 *    $ CC TCPECHOSERVER
 *    $ LINK TCPECHOSERVER,SYS$INPUT:/OPT
 *    MULTINET:MULTINET_SOCKET_LIBRARY/SHARE
 *    SYS$SHARE:VAXCRTL/SHARE
 *    ^Z
 *
 *  To configure the MULTINET_SERVER process to automatically create
 *  a process running this image when a connection arrives:
 *
 *    $ MULTINET CONFIGURE/SERVER
 *    MultiNet Server Configuration Utility 2.2(19)
 *    [Reading in symbols from SERVER image MULTINET:SERVER.EXE]
 *    [Reading in configuration from MULTINET:SERVICES.MASTER_SERVER]
 *    SERVER-CONFIG>ADD TEST
 *    [Adding new configuration entry for service "TEST"]
 *    Protocol: [TCP] TCP
 *    TCP Port number: 500
 *    Program to run: USERS:[ADELMAN]TCPECHOSERVER.EXE
 *    [Added service TEST to configuration]
 *    [Selected service is now TEST]
 *    SERVER-CONFIG>RESTART
 *
 */

#include "multinet_root:[multinet.include.sys]types.h"
#include "multinet_root:[multinet.include.sys]socket.h"
#include "multinet_root:[multinet.include.netinet]in.h"
#include <stdio.h>
#include <string.h>
#include <descrip.h>
#include <rms.h>
#include "multinet_root:[multinet.include]netdb.h"
#include "vbrms.h"

struct FAB fab, logfab;
struct RAB rab, lograb;
struct NAM nam;
struct XABKEY primary_key, alternate_key;

char rsa[NAM$C_MAXRSS];	       /* The resultant string & input */
char esa[NAM$C_MAXRSS];        /* filename, also the expanded string area */

char return_devnam[30];
char search_devnam[30];
char logfilename[30];

$DESCRIPTOR(return_devnam_descr,return_devnam);
$DESCRIPTOR(search_devnam_descr,search_devnam);

#define BYTE char

typedef struct 
{
 BYTE packet_type;
 char datatosend[500];
 char filename[255];
 char protection[30];
 char UIC[13];
 char device[16];
 char directory[255];
 int keylen;
 int keypos;
} OUT_PACKET;

typedef OUT_PACKET PACKET;

PACKET packet;
char *packet_ptr;
char *ptr;

main()
{
	unsigned short chan;
	int n, Status;
	int x, length;
	char buf[256];
	struct sockaddr_in sin;
	struct hostent *hp;
	static struct {int Size; char *Ptr;} Descr={9 ,"SYS$INPUT"};

	packet_ptr = &packet;

	strcpy(logfilename,"VBRMS_DIR:VBRMS.LOG");

	logfab = cc$rms_fab;
	lograb = cc$rms_rab;
        logfab.fab$b_fac = FAB$M_PUT;
	logfab.fab$l_fna = logfilename;
	logfab.fab$b_fns = strlen(logfilename);
	logfab.fab$b_rfm = FAB$C_VAR;
	logfab.fab$b_rat = FAB$M_CR;
	logfab.fab$b_org = FAB$C_SEQ;

	lograb.rab$l_fab = &logfab;
	lograb.rab$b_rac = RAB$C_SEQ;
	lograb.rab$l_rbf = buf;
	lograb.rab$w_rsz = 80;

	Status = sys$create(&logfab);
	if ((Status & 1) != 1) lib$signal(Status);

	Status = sys$connect(&lograb);
	if ((Status & 1) != 1) lib$signal(Status);



	/*
	 *  $ASSIGN a channel to SYS$INPUT. This channel is the channel
	 *  to the network connection.
	 */

	Status = SYS$ASSIGN(&Descr, &chan, 0, 0);
	if (!(Status&1)) {
		exit(Status);
	}

	/*
	 *  Use getpeername() to find out who made the connection to
	 *  us, so we can act exactly like the example tcpechoserver-standalone.
	 */

	n = sizeof(sin);	   /* Pass in the length */
	if (getpeername(chan, &sin, &n) < 0) {
		socket_perror("tcpechoserver: getpeername");
		exit(0x10000000);
	}

	/*
	 *  `sin' will be a sockaddr_in structure describing the
	 *  remote IP address (and port #) which the connection
	 *  was made from. Before we start to echo data, write a
	 *  string into the network describing this port.
	 */

	hp = gethostbyaddr(&sin.sin_addr, sizeof(sin.sin_addr), AF_INET);
	if (hp) {
	    /*
	     *	We found a corresponding hostname, format the string
	     *	one way...
	     */
/*	    sprintf(buf, "Connection received from %s [%s]\r\n",
		    hp->h_name, inet_ntoa(sin.sin_addr));
*/
	} else {
	    /*
	     *	This host not in the host tables or Domain Name Server.
	     */
	    sprintf(buf, "Connection received from [%s]\r\n",
		    inet_ntoa(sin.sin_addr));
	}
	socket_write(chan, buf, strlen(buf));

	/*
	 *  Now go into a loop, reading data from the network and sending
	 *  it right back...
	 */

	memset(packet_ptr,'\0', sizeof(packet));
        memset(buf,'\0',sizeof(buf));

	while ((n = socket_read(chan, packet_ptr, sizeof(packet))) > 0) {
/*	    socket_write(chan, buf, n);   jwh-10/13/94 */


/* Write out the log file each pass... */

	sprintf(buf,"Packet.packet_type: %d",packet.packet_type);
	Status = sys$put(&lograb);
	if ((Status & 1) != 1) lib$signal(Status);

	sprintf(buf,"Packet.filename: %s",packet.filename);
	Status = sys$put(&lograb);
	if ((Status & 1) != 1) lib$signal(Status);

	sprintf(buf,"Packet.directory: %s",packet.directory);
	Status = sys$put(&lograb);
	if ((Status & 1) != 1) lib$signal(Status);

	sprintf(buf,"Packet.device: %s",packet.device);
	Status = sys$put(&lograb);
	if ((Status & 1) != 1) lib$signal(Status);

	sprintf(buf,"Packet.UIC: %s",packet.UIC);
	Status = sys$put(&lograb);
	if ((Status & 1) != 1) lib$signal(Status);

	sprintf(buf,"Packet.keylen: %d",packet.keylen);
	Status = sys$put(&lograb);
	if ((Status & 1) != 1) lib$signal(Status);

	sprintf(buf,"Packet.keypos: %d",packet.keypos);
	Status = sys$put(&lograb);
	if ((Status & 1) != 1) lib$signal(Status);


	    switch (packet.packet_type)
	    {
                
		sprintf(buf,"Packet type: %d\n",packet.packet_type);
                socket_write(chan,buf,strlen(buf));
		
		sprintf(buf, "Filename: %s\n",packet.filename);
                socket_write(chan,buf,strlen(buf));


		/* Show the users all the disk/tape devices on their system */

		case VBRMS_RETURN_DEVICES:
			socket_write(chan,"$4$dua0:\n",9);
			socket_write(chan,"$1$dia0:\n",9);
			socket_write(chan,"$1$dua1:\n",9);
			socket_write(chan,"$1$dua2:\n",9);
			socket_write(chan,"$1$dua3:\n",9);
			socket_write(chan,"$1$dua4:\n",9);

		break;



		/* User wants to 'type' a file. */

		case VBRMS_TYPE_FILE:

		 /* strcpy(packet.filename,"LOGIN.COM");*/

		  ptr = strstr(packet.directory,"]");
		  if (ptr != NULL)
		  {
		    ptr++;
		    *ptr = '\0';
                  }

		  ptr = strstr(packet.device,":");
		  if (ptr != NULL)
		  {
		    ptr++;
		    *ptr = '\0';
                  }


		  strcpy(buf,packet.device);
 		  strcat(buf,packet.directory);
		  strcat(buf,packet.filename);

		  fab = cc$rms_fab;
		  rab = cc$rms_rab;
                  fab.fab$b_fac = FAB$M_GET;
		  fab.fab$l_fna = buf;
		  fab.fab$b_fns = strlen(buf);
		  fab.fab$b_rfm = FAB$C_VAR;
		  fab.fab$b_rat = FAB$M_CR;
		  fab.fab$b_org = FAB$C_SEQ;

		  rab.rab$l_fab = &fab;
		  rab.rab$b_rac = RAB$C_SEQ;
		  rab.rab$l_ubf = buf;
		  rab.rab$w_usz = 80;

		  Status = sys$open(&fab);
		  if ((Status & 1) != 1) lib$signal(Status);

		  Status = sys$connect(&rab);
		  if ((Status & 1) != 1) lib$signal(Status);


		  Status = sys$get(&rab);
		  if ((Status & 1) != 1) lib$signal(Status);

		  while (Status != RMS$_EOF)
	          {
		    length = rab.rab$w_rsz;
		    buf[length] = '\n';
		    length++;

		    socket_write(chan,buf,length);
		    Status = sys$get(&rab);
                  }

		break;


                                  
	
                case VBRMS_READ_KEYEQ:

		/* For the test case, we're gonna use the kludgy way: open the
		  file, read the record, close it, ad infitinum */

		  ptr = strstr(packet.directory,"]");
		  if (ptr != NULL)
                  {
		    ptr++;
		    *ptr = '\0';
                  }

		  ptr = strstr(packet.device,":");
		  if (ptr != NULL)
                  {
		    ptr++;
		    *ptr = '\0';
                  }


		  strcpy(buf,packet.device);
		  strcat(buf,packet.directory);
		  strcat(buf,packet.filename);

		  fab = cc$rms_fab;
		  rab = cc$rms_rab;
                  fab.fab$b_fac = FAB$M_GET;
		  fab.fab$l_fna = buf;
		  fab.fab$b_fns = strlen(buf);
/*		  fab.fab$w_mrs = 62;  */
		  fab.fab$b_rfm = FAB$C_FIX;
		  fab.fab$b_rat = FAB$M_CR;
		  fab.fab$b_org = FAB$C_IDX;
		  fab.fab$l_xab = &primary_key;

		  primary_key = cc$rms_xabkey;	/* initialize primary */

		  primary_key.xab$b_dtp = XAB$C_STG;
		  primary_key.xab$b_flg = 0;
		  primary_key.xab$w_pos0 = (char *) &packet.datatosend	-	
					   (char *) &packet;
		  primary_key.xab$b_ref = 0;
		  primary_key.xab$b_siz0 = packet.keylen;


		  rab.rab$l_fab = &fab;
		  rab.rab$b_krf = 0;
		  rab.rab$l_kbf = &packet.datatosend;
		  rab.rab$b_ksz = strlen(packet.datatosend);
		  rab.rab$b_rac = RAB$C_KEY;
		  rab.rab$l_ubf = buf;
		  rab.rab$w_usz = 62;

		  Status = sys$open(&fab);
		  if ((Status & 1) != 1) lib$signal(Status);

		  Status = sys$connect(&rab);
		  if ((Status & 1) != 1) lib$signal(Status);


		  Status = sys$get(&rab);
		  if ((Status & 1) != 1) lib$signal(Status);


		    length = strlen(buf);	/* ??? */
		    buf[length] = '\n';
		    length++;
                    buf[length] = '\0';

		    socket_write(chan,buf,length);

		break;



                case VBRMS_WRITE_RECORD:


		  ptr = strstr(packet.directory,"]");
		  if (ptr != NULL)
                  {
		    ptr++;
		    *ptr = '\0';
                  }

		  ptr = strstr(packet.device,":");
		  if (ptr != NULL)
	          {
		    ptr++;
		    *ptr = '\0';
                  }

		  strcpy(buf,packet.device);
		  strcat(buf,packet.directory);
		  strcat(buf,packet.filename);

		  fab = cc$rms_fab;
		  rab = cc$rms_rab;
                  fab.fab$b_fac = FAB$M_PUT;
		  fab.fab$l_fna = buf;
		  fab.fab$b_fns = strlen(buf);
		  fab.fab$w_mrs = 62;
		  fab.fab$b_rfm = FAB$C_FIX;
		  fab.fab$b_rat = FAB$M_CR;
		  fab.fab$b_org = FAB$C_IDX;
		  fab.fab$l_xab = &primary_key;

		  primary_key = cc$rms_xabkey;	/* initialize primary */

		  primary_key.xab$b_dtp = XAB$C_STG;
		  primary_key.xab$b_flg = 0;
		  primary_key.xab$w_pos0 = (char *) &packet.datatosend	-	
					   (char *) &packet;
		  primary_key.xab$b_ref = 0;
		  primary_key.xab$b_siz0 = 10;	/* HARDCODED */


		  rab.rab$l_fab = &fab;
		  rab.rab$b_krf = 0;
		  rab.rab$l_kbf = &packet.datatosend;
		  rab.rab$b_ksz = 10;	/*strlen(packet.datatosend);*/
		  rab.rab$b_rac = RAB$C_KEY;
		  rab.rab$l_rbf = packet.datatosend;
		  rab.rab$w_rsz = 62;

		  Status = sys$open(&fab);
		  if ((Status & 1) != 1) lib$signal(Status);

		  Status = sys$connect(&rab);
		  if ((Status & 1) != 1) lib$signal(Status);


		  Status = sys$put(&rab);
		  if ((Status & 1) != 1) lib$signal(Status);


		  Status = sys$close(&fab);
		  if ((Status & 1) != 1) lib$signal(Status);

		break;



		case VBRMS_DELETE_FILE:

		break;




		case VBRMS_DIRECTORY:

		  fab = cc$rms_fab;
		  rab = cc$rms_rab;
		  nam = cc$rms_nam;

/* See if there's any crap after the ']'; if so, replace it */

		  ptr = strstr(packet.directory,"]");
		  ptr++;
		  *ptr = '\0';
		  
		  ptr = strstr(packet.device,":");
		  ptr++;
		  *ptr = '\0';

		  strcpy(buf,packet.device);
		  strcat(buf,packet.directory);
		  strcat(buf,"*.*");


		  fab.fab$l_dna = &buf;
		  fab.fab$b_dns = strlen(buf);
		  fab.fab$l_nam = &nam;

		  nam.nam$l_esa = &esa;
		  nam.nam$b_ess = sizeof esa;
	          nam.nam$l_rsa = &rsa;
	          nam.nam$b_rss = sizeof rsa;

		  Status = sys$parse(&fab,0,0);
		  if ((Status & 1) != 1) lib$signal(Status);

		  while ((Status = sys$search(&fab,0,0)) == RMS$_NORMAL)
		  {
		    length = nam.nam$b_rsl;

		    strncpy(buf,rsa, length);
		    buf[length] = '\n';
		    length++;
                    buf[length] = '\0';

		    socket_write(chan,buf,length);
		  }


		break;
	    }



	    x = strstr(packet.datatosend,"shakes");
	    if (x != 0)
	    {
             socket_write(chan,"How now you secret black and midnight\n",38);
	     socket_write(chan,"hags? It is come upon the witching hour\n",40);
	     socket_write(chan,"and the cock crows till dusk.Shakespeare\n",42);
	    }

	    x = strstr(packet.datatosend,"Wren");
	    if (x != 0)
	    {
             socket_write(chan,"VAX/VMS\n",8);
             socket_write(chan,"DECforms\n",9);
             socket_write(chan,"Dataheave\n",10);
             socket_write(chan,"VMS/RMS\n",8);
	    }


  	    x = strstr(packet.datatosend,"Randy");
	    if (x != 0)
	    {
             socket_write(chan,"VAX/VMS\n",8);
             socket_write(chan,"Pathworks\n",10);
	    }


  	    x = strstr(packet.datatosend,"Barry");
	    if (x != 0)
	    {
             socket_write(chan,"VAX/VMS\n",8);
             socket_write(chan,"COBOL\n",6);
	    }
  

	    x = strstr(packet.datatosend,"Rich");
	    if (x != 0)
	    {
             socket_write(chan,"UNIX\n",5);
             socket_write(chan,"C++\n",4);
	    }
  
	    x = strstr(packet.datatosend,"Jim");
	    if (x != 0)
	    {
             socket_write(chan,"<Nothing>\n",10);
	    }
  
		/* now that we're done blank it out for next pass */

	   memset(packet_ptr,'\0',sizeof(packet));
	}

	/*
	 *  socket_read() will return 0 on end-of-file, or -1 on error...
	 */

	if (n < 0) {
	    socket_perror("tcpechoserver: read");
	}

	/*
	 *  Now close down the connection...
	 */

	socket_close(chan);

	/*
	 *  Exit successfully.
	 */

	sys$close(&logfab);

	exit(1);
}
