/*
  This sample program determines the correct page size to use for this CPU
  and proceeds to create a 1-page buffer object within a 2-page dynamically
  allocated memory area. It returns the buffer object ID and then HIBERs,
  on the assumption someone wants to look at memory with SDA.

  On image exit the buffer object is automatically run down.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ssdef.h>
#include <syidef.h>

#ifndef SYI$_PAGE_SIZE
#define SYI$_PAGE_SIZE SYI$_IOTA
#endif

int SYS$CREATE_BUFOBJ(long *, long*, int, int, long *);
int SYS$GETSYIW(int, int, int, void *, void *, int, int);
void SYS$HIBER();

static long pagsiz;	/* Page size stored here */
static long retadr[2];	/* Beginning and end address of buffer object */

typedef struct GetPS_itemlist_struct	/* Standard itemlist */
{
short buflen;
short code;	
long bufadr;	
long retlenadr;
} GetPS_itemlist;

void GetPageSize()	/* Routine to get page size for VMS on any CPU */
{
#define NSTlen (32)
char nst[NSTlen];
long retcode, iosb[2];
GetPS_itemlist itmlst[3];

itmlst[0].buflen    = NSTlen;
itmlst[0].code      = SYI$_HW_NAME;
itmlst[0].bufadr    = (long) &nst;
itmlst[0].retlenadr = 0;	/* Don't need to know this */
itmlst[1].buflen    = 4;
itmlst[1].code      = SYI$_PAGE_SIZE;	/* (random parameter if VAX) */
itmlst[1].bufadr    = (long) &pagsiz;
itmlst[1].retlenadr = 0;	/* Don't need to know this */
itmlst[2].buflen    = 0;	/* Terminate item list */
itmlst[2].code      = 0;

retcode = SYS$GETSYIW(0, 0, 0, &itmlst, &iosb, 0, 0);
printf("GETSYIW return code = %d\n",retcode);

/* Now go back and fix up the answer if we're running on a VAX. */
/* Maybe one day OVMS/VAX $GETSYI will also honor the page size item. */
if (strncmp(nst,"VAX",3)==0) pagsiz = 512;
return;
}

int main(int argc, char ** argv[])
{
long status, inadr[2], handle[2];
static char *Pbuf;

GetPageSize();

printf("Page Size = %d = ^X%X\n", pagsiz, pagsiz);

Pbuf = malloc(2 * pagsiz);
printf("2 pages allocated starting at VA %X, ending at %X\n", 
				 (int) Pbuf, (int) Pbuf+2*pagsiz-1);

Pbuf = (char *) ((int)Pbuf + pagsiz);
Pbuf = (char *) ((int)Pbuf & (0xFFFFFFFF ^ (pagsiz-1)));

inadr[0] = (long) Pbuf;
inadr[1] = inadr[0] | (pagsiz-1);

status = SYS$CREATE_BUFOBJ(inadr, retadr, 0, 0, handle);

printf("inadr %X,%X\n", inadr[0], inadr[1]);
printf("status %X; retadr = %X,%X and Buffer Object handle = %X,%X\n", status,
	retadr[0], retadr[1], handle[0], handle[1]);
SYS$HIBER();
SYS$HIBER();	/* Hang around so can look at area with SDA */
}
