 /*J  * Move_File - move a file from one directory to another without deletion.  *C  * Author:   Bob Armstrong (Algonquin College, Nepean, Ont. CANADA)   *  * Written:  May 1989   *  */  /* ** **  INCLUDE FILES  ** **/    #include <stdio.h> #include <descrip.h> #include <ssdef.h> #include <fab.h> #include <rab.h> #include <nam.h> #include <iodef.h> #include <rmsdef.h>  #include <devdef.h>  #include <dvidef.h>  #include <fibdef.h>  #include "hm2def.h"  #include "fiddef.h"  #include "fm2def.h"  #include "fh2def.h"    /*(  * Structure to store device information  */   $ static struct   device_char_struct { 	char	device_name[255] ; 	long	device_char ;  	long	device_class ; 	long	acp ;  	long	cluster ;  	long	maxblock ; 	long	freeblocks ; 	long	mountcnt ; 	long	volcount ; } device_char ;    /*3  * Structure to store current directory information   */   ! static struct   dir_char_struct {  	char    dir_spec[255] ; 	char	dir_file[255] ;  	long	fid[3] ; } dir_char ;   static struct NAM *dir_nam ; static struct FAB *dir_fab ;   static struct NAM *access_nam ;  static struct FAB *access_fab ;  static struct RAB *access_rab ;    static struct NAM *move_nam; static struct FAB *move_fab ;  static struct RAB *move_rab ;    struct directory_struct {      char filespec[255] ;     char device[80] ;      char filename[255] ;     long fid_num ;     long fid_seq ;     long fid_rvn ;     long did_num ;     long did_seq ;     long did_rvn ;+ } source_directory, destination_directory ;  main ()     {       static $DESCRIPTOR(dir,"") ;$     static $DESCRIPTOR(command,"") ;#     static char command_line[255] ; $     static long	    status, length ;     static char filename[255] ;      struct NAM *create_nam() ;     struct FAB *create_fab() ;     struct RAB *create_rab() ;     char *d, *c, *ptr ;      long exit_handler() ;      char *parse_filename() ;  *     command.dsc$a_pointer = command_line ;!     command.dsc$w_length  = 255 ; +     LIB$GET_FOREIGN(&command,0,&length,0) ; !     command_line[length] = '\0' ;        /*.      * Set up Nam and Fab for the file to move      */        access_nam = create_nam() ; +     access_fab = create_fab(access_nam,0) ; )     access_rab = create_rab(access_fab) ;        move_nam = create_nam() ; '     move_fab = create_fab(move_nam,0) ; %     move_rab = create_rab(move_fab) ;        /*#      * Parse source and destination       */        ptr = command_line ;3     ptr = parse_filename(&source_directory,ptr,1) ; 8     ptr = parse_filename(&destination_directory,ptr,0) ;  =     strcpy(device_char.device_name,source_directory.device) ;        /*!      * Find out about this device       */   F     get_device_characteristics(device_char.device_name,&device_char) ;       /*$      * Can we undelete on this disk?      */   ,     if(device_char.acp != DVI$C_ACP_F11V2) {4        printf(" Device is not Files-11 Level 2\n") ;        exit(0) ;     } 0     if(device_char.device_char&DEV$M_MNT == 0) {+        printf(" Device is not mounted\n") ;         exit(0) ;     } 0     if(device_char.device_char&DEV$M_FOR != 0) {/        printf(" Device is mounted foreign\n") ;         exit(0) ;     }   9     move_file(&destination_directory,&source_directory) ;  } , char *parse_filename (directory,spec,abort)$ struct directory_struct *directory ; char *spec ;    {     static char filename[255] ;      char *c, *d ;      long length ;      long status ;        c = spec ;     d = filename ;     while (*c == ' ') c++ ;      while (*c != '\0') {        if(*c == ' ') break ;        *d++ = *c++ ;     }      *d = '\0' ;        /*      * Save original inquiry      */   *     strcpy(directory->filespec,filename) ;  "     access_nam->nam$w_fid[0] = 0 ;"     access_nam->nam$w_fid[1] = 0 ;"     access_nam->nam$w_fid[2] = 0 ;"     access_nam->nam$w_did[0] = 0 ;"     access_nam->nam$w_did[1] = 0 ;"     access_nam->nam$w_did[2] = 0 ;       /*<      * Find out about the file (see if at least one to move)      */   N     status = get_file_id(access_nam,access_fab,filename,&directory->device[0], 		&directory->filename[0]) ;7     if((status == RMS$_NORMAL)||(status == RMS$_FNF)) { 6        directory->fid_num = access_nam->nam$w_fid[0] ;6        directory->fid_seq = access_nam->nam$w_fid[1] ;6        directory->fid_rvn = access_nam->nam$w_fid[2] ;6        directory->did_num = access_nam->nam$w_did[0] ;6        directory->did_seq = access_nam->nam$w_did[1] ;6        directory->did_rvn = access_nam->nam$w_did[2] ;     } *     if((status != RMS$_NORMAL)&&(abort)) {L        printf(" Error while retrieving source or destination status = %d\n",               status) ;         exit(0) ;     }      return(c) ;      } 3 long get_file_id (nam,fab,filename,device,extfile)  struct NAM *nam ;  struct FAB *fab ;  char       *filename ; char	   *device ;  char	   *extfile ; /** K **  get_file_id : This routine determines the file id (embedded in the fab) L **                from a filespec. Optionally the device string is returned.G **                As well an external expanded string area can be used.  **# **  input:   nam       = NAM block. # **           fab       = FAB block. " **           filename  = filespec  **  + **  output:  nam       = NAM block updated. + **           fab       = FAB block updated. / **           device    = device name (optional) 8 **           extfile   = expanded file string (optional) ***/     { (     static $DESCRIPTOR(device_dsc1,"") ;(     static $DESCRIPTOR(device_dsc2,"") ;     static char   *c, *d ;     static char dir_spec[255] ; !     static char device_name[80] ; "     static char extfilename[255] ;"     static char newfilename[255] ;-     static long status, length, mode, table ;        /*      * set up fab and nam       */        fab->fab$l_dna = 0 ;     fab->fab$b_dns = 0 ;     fab->fab$w_ifi = 0 ;  #     nam->nam$b_nop = NAM$V_SYNCHK ; "     nam->nam$l_rsa = newfilename ;     nam->nam$b_rss = 255 ;     fab->fab$l_fna = filename ; '     fab->fab$b_fns = strlen(filename) ;      if(extfile != 0) {!        nam->nam$l_esa = extfile ;         nam->nam$b_ess = 255 ; 	     }     
     else {%        nam->nam$l_esa = extfilename ;         nam->nam$b_ess = 255 ;      } !     status = SYS$PARSE(fab,0,0) ;      if(device != 0) { ;        strncpy(device_name,nam->nam$l_dev,nam->nam$b_dev) ; -        *(device_name+nam->nam$b_dev) = '\0' ; #        if((device_name[0] == '_')|| #           (device_name[0] == '$'))   	  strcpy(device,device_name) ; 
        else {  	  /* &            * Translate the device name  	   */ 3           device_dsc1.dsc$a_pointer = device_name ; =           device_dsc1.dsc$w_length  = strlen(device_name)-1 ; .           device_dsc2.dsc$a_pointer = device ;*           device_dsc2.dsc$w_length  = 80 ;U           status = LIB$SYS_TRNLOG(&device_dsc1,&length,&device_dsc2,&table,&mode,0) ; #           *(device+length) = '\0' ;            /*- 	   * Check that we are not on a logical disk  	   */ 	  if((device[0] != '_')&& 	     (device[0] != '$')) {  	     dir_spec[0] = '\0' ;) 	     while (1) {		/* keep translating */  	        c = device ;  	        d = device_name ; 		while (*c != '\0') {"                    if(*c == ':') { 		      *d++ = *c++ ;  		      break ;  		   } 		   *d++ = *c++ ;                 } 
 		*d = '\0' ;  		strcpy(dir_spec,c) ;& 		strcat(dir_spec,dir_char.dir_spec) ;& 		strcpy(dir_char.dir_spec,dir_spec) ;9                 device_dsc1.dsc$a_pointer = device_name ; C                 device_dsc1.dsc$w_length  = strlen(device_name)-1 ; 4                 device_dsc2.dsc$a_pointer = device ;0                 device_dsc2.dsc$w_length  = 80 ;[                 status = LIB$SYS_TRNLOG(&device_dsc1,&length,&device_dsc2,&table,&mode,0) ; )                 *(device+length) = '\0' ;   	        if(status != 1) break ;; 	        if((device[0] == '_')||(device[0] == '$')) break ;               } 	  }        }     }        /*      * Find the exact filespec      */      "     status = SYS$SEARCH(fab,0,0) ;2     strncpy(filename,newfilename,nam->nam$b_rsl) ;'     *(filename+nam->nam$b_rsl) = '\0' ;      return(status) ; } : long	get_device_characteristics(device_name,device_char)  char	*device_name ; * struct   device_char_struct *device_char ; /** C **  get_device_characteristics : This routine retrieves the device  I **                               characteristics for a particular device.  **+ **  input:   device_name = character string  **  G **  output:  device_char = structure containing device characteristics. ) **                         (by reference)  ***/     { '     static $DESCRIPTOR(device_dsc,"") ; !     static long iosb[2], status ; S     static long class,acp,maxblock,cluster,disk_size,freeblocks,mountcnt,volcount ;      static long devchar ;      struct item_list_struct {  	short	buffer_length ; 	short   item_code ; 	long	buffer_address ; 	long	return_length_address ; 0     } item_list[8] = {4,DVI$_DEVCHAR,&devchar,0,! 		      4,DVI$_DEVCLASS,&class,0, ,                       4,DVI$_ACPTYPE,&acp,0," 		      4,DVI$_CLUSTER,&cluster,0,$ 		      4,DVI$_MAXBLOCK,&maxblock,0,( 		      4,DVI$_FREEBLOCKS,&freeblocks,0,$ 		      4,DVI$_MOUNTCNT,&mountcnt,0,& 		      4,DVI$_VOLCOUNT,&volcount,0} ;       /*&      * Make a call to see what we have      */   ,     device_dsc.dsc$a_pointer = device_name ;4     device_dsc.dsc$w_length  = strlen(device_name) ;K     status = SYS$GETDVI(0,0,&device_dsc,&item_list[0],&iosb[0],0,0,0) ;            /*0      * Copy the characteristics to the structure      */   2     strcpy(device_char->device_name,device_name) ;)     device_char->device_char  = devchar ; '     device_char->device_class = class ; %     device_char->acp          = acp ; )     device_char->cluster      = cluster ; *     device_char->maxblock     = maxblock ;,     device_char->freeblocks   = freeblocks ;*     device_char->mountcnt     = mountcnt ;*     device_char->volcount     = volcount ; }      struct NAM *create_nam ()   /** , **  create_nam : initializes a rms NAM block ** **  input:   none  **  - **  output:  returns address to new NAM block  ** v ***/     {      static struct NAM *nam ;  6     nam = (struct NAM *)calloc(1,sizeof(struct NAM)) ;;     nam->nam$b_bid = NAM$C_BID ;	    /* block identifier */y6     nam->nam$b_bln = NAM$C_BLN ;	    /* size of nam	*/     return(nam) ;> }i! struct FAB *create_fab (nam,xab). struct NAM *nam ;> struct XAB *xab ;  /**u, **  create_nam : initializes a rms FAB block **> **  input:   nam   = address of a previously created NAM block2 **           xab   = address of optional XAB block ** e- **  output:  returns address to new FAB blockr ** e ***/     {i     static struct FAB  *fab ;s  6     fab = (struct FAB *)calloc(1,sizeof(struct FAB)) ;<     fab->fab$b_bid = FAB$C_BID ;		    /* block identifier	*/7     fab->fab$b_bln = FAB$C_BLN ;		    /* size of fab	*/o     fab->fab$l_nam = nam ;     fab->fab$l_xab = xab ;     return(fab) ;u }n struct RAB *create_rab (fab)  struct FAB *fab ;i /**r, **  create_nam : initializes a rms RAB block **> **  input:   fab   = address of a previously created FAB block ** m- **  output:  returns address to new RAB blockc **   ***/     {      static struct RAB  *rab ;   6     rab = (struct RAB *)calloc(1,sizeof(struct RAB)) ;      rab->rab$b_bid = RAB$C_BID ;      rab->rab$b_bln = RAB$C_BLN ;     rab->rab$l_fab = fab ;     return(rab) ;f }s$ long move_file (destination,source)/ struct directory_struct *destination, *source ;o     {s     long status, length ;      struct filelist_struct {        char  *filename ;        long  fid_num ;        long  fid_seq ;        long  fid_rvn ;        long  did_num ;        long  did_seq ;        long  did_rvn ;%        struct filelist_struct *next ;t%        struct filelist_struct *back ;c     }  *filelist, *ptr, *link;"     static char extfilename[255] ;#     static char extfilename2[255] ;r"     static char newfilename[255] ;#     static char newfilename2[255] ;h     char *c, *d ;)     static char file[255] ;e          /*      * Is destination valid?      */   $     if((destination->did_num == 0)&&$        (destination->did_seq == 0)&&%        (destination->did_rvn == 0)) {a6        printf(" Destination directory is invalid\n") ;        return(0) ;     }b          /*9      * Set up Parse and Search for possible wildcard move       */o       access_fab->fab$l_dna = 0 ;f     access_fab->fab$b_dns = 0 ;      access_fab->fab$w_ifi = 0 ;   *     access_nam->nam$b_nop = NAM$V_SYNCHK ;)     access_nam->nam$l_rsa = newfilename ; !     access_nam->nam$b_rss = 255 ;r.     access_fab->fab$l_fna = source->filespec ;6     access_fab->fab$b_fns = strlen(source->filespec) ;)     access_nam->nam$l_esa = extfilename ; !     access_nam->nam$b_ess = 255 ;c         move_fab->fab$l_dna = 0 ;a     move_fab->fab$b_dns = 0 ;a     move_fab->fab$w_ifi = 0 ;        move_nam->nam$b_nop = 0 ;?     move_fab->fab$l_fna = 0 ;r     move_fab->fab$b_fns = 0 ; (     move_nam->nam$l_esa = extfilename2 ;     move_nam->nam$b_ess = 255 ;   (     status = SYS$PARSE(access_fab,0,0) ;       /*$      * Build a list of files to move      */        filelist = link = ptr = 0 ;h        while (status != RMS$_NMF) {& 	access_nam->nam$l_rsa = newfilename ; 	access_nam->nam$b_rss = 255 ;& 	status = SYS$SEARCH(access_fab,0,0) ;, 	newfilename[access_nam->nam$b_rsl] = '\0' ; 	if(status == RMS$_NORMAL) {5 	   link = calloc(1,sizeof(struct filelist_struct)) ; ? 	   length = access_nam->nam$b_name + access_nam->nam$b_type + n$ 	            access_nam->nam$b_ver ;' 	   link->filename = malloc(length+1) ; ; 	   strncpy(link->filename,access_nam->nam$l_name,length) ;)# 	   link->filename[length] = '\0' ; . 	   link->fid_num = access_nam->nam$w_fid[0] ;. 	   link->fid_seq = access_nam->nam$w_fid[1] ;. 	   link->fid_rvn = access_nam->nam$w_fid[2] ;. 	   link->did_num = access_nam->nam$w_did[0] ;. 	   link->did_seq = access_nam->nam$w_did[1] ;. 	   link->did_rvn = access_nam->nam$w_did[2] ; 	   link->back    = ptr ;a 	   link->next    = 0 ;*' 	   if(filelist == 0) filelist = link ;a 	   ptr = link ;	         } 
 	else break ;=     }l          /*      * Copy over devicer      */e       c = move_nam->nam$t_dvi ;06     *c = length = strlen(device_char.device_name) - 1;	     c++ ; /     strncpy(c,device_char.device_name,length) ;;       /*A      * Now Move each file starting from the lowest version numberi      */c    n     while (ptr != 0) {(         move_fab->fab$l_nam = move_nam ;" 	move_fab->fab$l_fop = FAB$M_NAM ;  
         /* 	 * Set up fids  	 */   ( 	move_nam->nam$w_fid[0] = ptr->fid_num ;( 	move_nam->nam$w_fid[1] = ptr->fid_seq ;( 	move_nam->nam$w_fid[2] = ptr->fid_rvn ;  ( 	move_nam->nam$w_did[0] = ptr->did_num ;)  	move_nam->nam$w_did[1] = ptr->did_seq ;)( 	move_nam->nam$w_did[2] = ptr->did_rvn ;  % 	strcpy(extfilename2,ptr->filename) ;t,         move_nam->nam$l_esa = extfilename2 ; 	move_nam->nam$b_ess = 255 ;5         move_nam->nam$b_esl = strlen(ptr->filename) ;i     ,         move_nam->nam$l_rsa = newfilename2 ; 	move_nam->nam$b_rss = 255 ; 	move_nam->nam$b_rsl = 0 ; 	move_nam->nam$l_wcc = 0 ;   	/*  	 * Remove file from directory 	 */  $ 	status = SYS$REMOVE(move_fab,0,0) ; 	if(status != RMS$_NORMAL) {H            printf(" Error removing %s from directory\n",ptr->filename) ; 	   exit(status) ;	         }    	/*b0 	 * Copy over only filename leaving out version  	 */  5 	length = move_nam->nam$b_name+move_nam->nam$b_type ;*  , 	strncpy(file,move_nam->nam$l_name,length) ; 	file[length] = '\0' ;# 	strcpy(move_nam->nam$l_esa,file) ;; 	move_nam->nam$b_ess = 255 ; 	move_nam->nam$b_esl = length ;c   	/*  	 * Reference new directory  	 */  0 	move_nam->nam$w_did[0] = destination->did_num ;0 	move_nam->nam$w_did[1] = destination->did_seq ;0 	move_nam->nam$w_did[2] = destination->did_rvn ;   	/* # 	 * Now enter it into the directory* 	 */  # 	status = SYS$ENTER(move_fab,0,0) ;b 	    	/*  	 * Get new filename 	 */  + 	newfilename2[move_nam->nam$b_rsl] = '\0' ;n   	if(status != RMS$_NORMAL) {  0 	    strcpy(move_nam->nam$l_esa,ptr->filename) ;  	    move_nam->nam$b_ess = 255 ;2 	    move_nam->nam$b_esl = strlen(ptr->filename) ;   	   /*; 	    * Error Entering file - put it back where it came frome 	    */   + 	   move_nam->nam$w_fid[0] = ptr->fid_num ;a+ 	   move_nam->nam$w_fid[1] = ptr->fid_seq ;R+ 	   move_nam->nam$w_fid[2] = ptr->fid_rvn ;   + 	   move_nam->nam$w_did[0] = ptr->did_num ;d,  	   move_nam->nam$w_did[1] = ptr->did_seq ;+ 	   move_nam->nam$w_did[2] = ptr->did_rvn ;   & 	   status = SYS$ENTER(move_fab,0,0) ;  < 	   printf(" Error encountered moving %s\n",ptr->filename) ; 	   exit(status) ; 	} 	c = newfilename2 ;  	while (*c != '\0')  	   if(*c == ':') {m 	      c++ ; 	      break ;            } else c++ ;c? 	printf(" Moved %s to new directory as %s\n",ptr->filename,c) ;  	ptr = ptr->back ;     }g } 