 /*8  * Undelete.c - Program to undelete files on ODS-2 disks  *C  * Author:   Bob Armstrong (Algonquin College, Nepean, Ont. CANADA)   *  * Written:  March 1989   *  * Modification History:F  *  Ver 1.0  April 1989: Fix bug which could leave user at priority 16A  *  Ver 1.1  Nov   1989: Flush Bitmap before opening bitmap file. H  *  Ver 1.2  Dec   1989: Fix small typo causing check bitmap not to failI  *                       sometimes. Enhance enter file to recover file to I  *                       different version if file with same name/version    *                       exists.<  *  Ver 1.3  Jun   1990: Add Wildcard selection to undelete.F  *                       Rework Get_File_Id to correctly determine theC  *                       file id for the root of a logical disk, or <  *                       logical disks within logical disks.C  *  Ver 1.4 Oct 26 1990: Still problems with logical roots, correct E  *                       algorithm, to allow for logical disks 1, 2,  E  *                       or more levels from the real root. Worked ok H  *                       previously for any directory not on the logical  *                       root.  *$  * Thanks to Juicer-2 for some ideas  */  /* ** **  INCLUDE FILES  ** **/    #include <stdio.h> #include <descrip.h> #include <ssdef.h> #include <fab.h> #include <rab.h> #include <nam.h> #include <iodef.h> #include <rmsdef.h>  #include <devdef.h>  #include <dvidef.h>  #include <fibdef.h>  #include <strdef.h>  #include <ctype.h> #include <lnmdef.h>  #include <strdef.h>  #include "hm2def.h"  #include "fiddef.h"  #include "fm2def.h"  #include "fh2def.h"  /*  * Defined constants  */  #define page_size	    512 $ #define indexf_buffer_size  100*512  #define bitmap_buffer_size  512   #define max_extents         1000 /*(  * Structure to store device information  */ $ static struct   device_char_struct { 	char	device_name[255] ; 	long	device_char ;  	long	device_class ; 	long	acp ;  	long	cluster ;  	long	maxblock ; 	long	freeblocks ; 	long	mountcnt ; 	long	volcount ; } device_char ;  /*3  * Structure to store current directory information   */ ! static struct   dir_char_struct {  	char    dir_spec[255] ; 	char	dir_file[255] ;  	char    dir_name[255] ; 	long	fid[3] ; } dir_char ; /*B  * Structure to store information about the file we are undeleting  */  struct fileinfo_struct {*     struct FH2$_FILECHAR_FIELDS	filechar ;     unsigned segnum	: 16 ;     unsigned strucver	: 8 ;      unsigned struclev	: 8 ;      unsigned fidnum	: 16 ;     unsigned fidseq	: 16 ;     unsigned fidrvn	: 16 ;     unsigned fidexnum	: 16 ;     unsigned fidexseq	: 16 ;     unsigned fidexrvn	: 16 ;     unsigned member	: 16 ;     unsigned group	: 16 ;      unsigned bkfidnum	: 16 ;     unsigned bkfidseq	: 16 ;     unsigned bkfidrvn	: 16 ;     char    filename[255] ;  } ;      /*9  * RMS structures for handing the INDEXF and BITMAP files   */  static struct NAM *dir_nam ; static struct FAB *dir_fab ;  # static char   indexf_filename[80] ; ! static unsigned long indexf_vbn ;  static char   indexf_esa[255] ;  static struct NAM *indexf_nam ;  static struct FAB *indexf_fab ;  static struct RAB *indexf_rab ; / static char indexf_buffer[indexf_buffer_size] ; ' static char indexf_buffer2[page_size] ;  static long reserved_blocks ;   static long indexf_file_open=0 ;  # static char   bitmap_filename[80] ; ! static unsigned long bitmap_vbn ;  static char   bitmap_esa[255] ;  static struct NAM *bitmap_nam ;  static struct FAB *bitmap_fab ;  static struct RAB *bitmap_rab ; / static char bitmap_buffer[bitmap_buffer_size] ; ' static char bitmap_buffer2[page_size] ;   static long bitmap_file_open=0 ;   static char   access_esa[255] ;  static struct NAM *access_nam ;  static struct FAB *access_fab ;  static struct RAB *access_rab ; & static char access_buffer[page_size] ;" static char wildcard_string[255] ; /*  * To Save Old Process Priority   *D  * A value of 4 is assumed if this program is interrupted before the  * first call to SYS$SETPRI.  */ ) static unsigned long old_priority=4 ;	    $ static long	     priority_raised=0 ;
 /* */					     static long status_code ;  struct exit_block_struct {      unsigned long forward_link ;)     unsigned long *exit_handler_address ;      unsigned long arg_count ;       unsigned long *status_code ; } exit_handler_block ; main (argc,argv)  long argc ;  char *argv[] ;     {       static $DESCRIPTOR(dir,"") ;$     static long	    status, length ;     static char filename[255] ;      struct NAM *create_nam() ;     struct FAB *create_fab() ;     struct RAB *create_rab() ;     char *d, *c ;      long exit_handler() ;        if(argc == 1) '       strcpy(wildcard_string,"*.*;*") ;      else if(argc >= 2) {       c = argv[1] ;        d = wildcard_string ;        while (1) {           if(*c == '\0') break ; ,          *d = (islower(*c))?toupper(*c):*c ;          c++ ; d++ ;       }        *d = '\0' ;        d = wildcard_string ;        while (*d != '\0')  )          if(*d == '.') break ; else d++ ;        if(*d == '.') {           d++ ; 	 while (*d != '\0')  % 	    if(*d == ';') break ; else d++ ;           if(*d == ';') {
 	    d++ ;1 	    if(*d == '\0') strcat(wildcard_string,"*") ;  	 } % 	 else strcat(wildcard_string,";*") ;        } +       else strcat(wildcard_string,".*;*") ;      }        /*      * Set up an exit handler       */   )     exit_handler_block.forward_link = 0 ; =     exit_handler_block.exit_handler_address = &exit_handler ; &     exit_handler_block.arg_count = 1 ;3     exit_handler_block.status_code = &status_code ;   %     SYS$DCLEXH(&exit_handler_block) ;        /*      * find out where we are      */   *     dir.dsc$a_pointer = dir_char.dir_spec;     dir.dsc$w_length  = 255 ;   *     status = SYS$SETDDIR(0,&length,&dir) ;&     dir_char.dir_spec[length] = '\0' ;       /*?      * Deterimine the file specification for the directory file       */   C     parse_directory_filename(dir_char.dir_file,dir_char.dir_spec) ;        /*0      * Set up Nam and Fab for the directory file      */        dir_nam = create_nam() ;%     dir_fab = create_fab(dir_nam,0) ;        /*-      * What is the File id for the directory?       */   N     get_file_id(dir_nam,dir_fab,dir_char.dir_file,device_char.device_name,0) ;  -     dir_char.fid[0] = dir_nam->nam$w_fid[0] ; -     dir_char.fid[1] = dir_nam->nam$w_fid[1] ; -     dir_char.fid[2] = dir_nam->nam$w_fid[2] ;        /*!      * Find out about this device       */   F     get_device_characteristics(device_char.device_name,&device_char) ;       /*$      * Can we undelete on this disk?      */   ,     if(device_char.acp != DVI$C_ACP_F11V2) {4        printf(" Device is not Files-11 Level 2\n") ;        exit(0) ;     } 0     if(device_char.device_char&DEV$M_MNT == 0) {+        printf(" Device is not mounted\n") ;         exit(0) ;     } 0     if(device_char.device_char&DEV$M_FOR != 0) {/        printf(" Device is mounted foreign\n") ;         exit(0) ;     }        /*?      *  Determine the file spec for the INDEXF.SYS file on this ?      *  disk. NOTE: if we are on a LOGICAL disk, it has already K      *  been translated to device:[directory spec][directory spec]file spec D      *  format, so we just have to pick off the physical device name      */   !     c = device_char.device_name ;      d = indexf_filename ;      while (*c != '\0') {        if(*c == ':') { 	  *d++ = *c++ ;
 	  break ;        }        *d++ = *c++ ;     }      *d = '\0' ; 3     strcat(indexf_filename,"[000000]INDEXF.SYS;") ;        /*1      * Set up Nam and Fab for the indexf.sys file       */        indexf_nam = create_nam() ; +     indexf_fab = create_fab(indexf_nam,0) ; )     indexf_rab = create_rab(indexf_fab) ;        /*3      * What is the file id for the INDEXF.sys file?       */   E     get_file_id(indexf_nam,indexf_fab,indexf_filename,0,indexf_esa) ;        /*?      *  Determine the file spec for the BITMAP.SYS file on this ?      *  disk. NOTE: if we are on a LOGICAL disk, it has already K      *  been translated to device:[directory spec][directory spec]file spec D      *  format, so we just have to pick off the physical device name      */   !     c = device_char.device_name ;      d = bitmap_filename ;      while (*c != '\0') {        if(*c == ':') { 	  *d++ = *c++ ;
 	  break ;        }        *d++ = *c++ ;     }      *d = '\0' ; 3     strcat(bitmap_filename,"[000000]BITMAP.SYS;") ;        /*1      * Set up Nam and Fab for the bitmap.sys file       */        bitmap_nam = create_nam() ; +     bitmap_fab = create_fab(bitmap_nam,0) ; )     bitmap_rab = create_rab(bitmap_fab) ;        /*1      * Determine the file id for the bitmap file.       */   E     get_file_id(bitmap_nam,bitmap_fab,bitmap_filename,0,bitmap_esa) ;        /*9      * Set up Nam and Fab for any recovered files we find       */        access_nam = create_nam() ; +     access_fab = create_fab(access_nam,0) ; )     access_rab = create_rab(access_fab) ;        /*?      * Go scan deleted files and recover any requested to do so       */   )     scan_indexf(&device_char,&dir_char) ;  } . long parse_directory_filename (filename,spec) char *filename ; char *spec ; /** B **  parse_directory : This routine obtains the directory file spec9 **                    from the current directory location  **  ) **  input:   spec      = character string  **  ) **  output:  filename  = character string  ***/    {     char *c, *d ;      long length ;        /*      * Check if at root       */   &     if(strcmp(spec,"[000000]") == 0) {/        strcpy(filename,"[000000]000000.dir;") ;         return(1) ;     }        /*>      * break off the last subdirectory from the directory spec      */        c = spec ;     while (*c != '\0') c++ ;	     c-- ;      while (c > spec) { 	if(*c == '.') break ; 	if(*c == '[') break ; 	c-- ;     }      length = c - spec ;      if(length == 0) $        strcpy(filename,"[000000]") ;
     else {&        strncpy(filename,spec,length) ;        strcat(filename,"]") ;      }   %     d = filename + strlen(filename) ;l	     c++ ;g     while (*c != ']') {O
 	*d = *c ; 	c++ ; 	d++ ;     }m       /*'      * finish up the directory filename*      */t       strcat(filename,".dir;") ; } 3 long get_file_id (nam,fab,filename,device,extfile)d struct NAM *nam ;r struct FAB *fab ;  char       *filename ; char	   *device ;t char	   *extfile ; /**DK **  get_file_id : This routine determines the file id (embedded in the fab) L **                from a filespec. Optionally the device string is returned.G **                As well an external expanded string area can be used.  **# **  input:   nam       = NAM block.A# **           fab       = FAB block.*" **           filename  = filespec  **  + **  output:  nam       = NAM block updated. + **           fab       = FAB block updated.,/ **           device    = device name (optional)i8 **           extfile   = expanded file string (optional) ***/     {r(     static $DESCRIPTOR(device_dsc1,"") ;-     static $DESCRIPTOR(table1,"LNM$SYSTEM") ;*,     static $DESCRIPTOR(table2,"LNM$GROUP") ;*     static $DESCRIPTOR(table3,"LNM$JOB") ;.     static $DESCRIPTOR(table4,"LNM$PROCESS") ;     static struct item_struct {o       short buffer_length ;        short item_code ;        char  *buffer_address ; $       long  *return_length_address ;       long  zero ;     } item ;     static char   *c, *d ;     static char dir_spec[255] ;e$     static char tempfilename1[255] ;$     static char tempfilename2[255] ;     static char oldname[255] ;!     static char device_name[80] ;e"     static char extfilename[255] ;"     static char newfilename[255] ;.     static long status, length, mode, pass=0 ;       /*      * set up fab and namd      */e       fab->fab$l_dna = 0 ;     fab->fab$b_dns = 0 ;     fab->fab$w_ifi = 0 ;  #     nam->nam$b_nop = NAM$V_SYNCHK ;0"     nam->nam$l_rsa = newfilename ;     nam->nam$b_rss = 255 ;     fab->fab$l_fna = filename ;	'     fab->fab$b_fns = strlen(filename) ;      if(extfile != 0) {!        nam->nam$l_esa = extfile ;	        nam->nam$b_ess = 255 ; 	     }    c
     else {%        nam->nam$l_esa = extfilename ;r        nam->nam$b_ess = 255 ;r     }m#     nam->nam$b_nop = NAM$V_SYNCHK ;r"     nam->nam$l_rsa = newfilename ;     nam->nam$b_rss = 255 ;     fab->fab$l_fna = filename ;['     fab->fab$b_fns = strlen(filename) ;t!     status = SYS$PARSE(fab,0,0) ;r"     status = SYS$SEARCH(fab,0,0) ;-     *(nam->nam$l_rsa+nam->nam$b_rsl) = '\0' ;h     /*,      * disassemble the filename interatively      */ &     item.item_code     = LNM$_STRING ;     item.buffer_length = 255;f-     item.buffer_address = &tempfilename2[0] ;n*     item.return_length_address = &length ;     item.zero = 0 ;d     while (1) { 	        /*d"         * copy over the devicename 	*/         c = newfilename ;        d = tempfilename1 ;        while (*c != '\0') {	          if(*c == ':') break ; 	 *d++ = *c++ ;*        }        *d = '\0' ;        c++ ;        if(pass == 0)  &          strcpy(oldname,newfilename) ;	        /*r         * try to translate itf 	*/m2        device_dsc1.dsc$a_pointer = tempfilename1 ;:        device_dsc1.dsc$w_length  = strlen(tempfilename1) ;  <        status = SYS$TRNLNM(0,&table4,&device_dsc1,0,&item) ;  #        if(status == SS$_NOLOGNAM) {b>          status = SYS$TRNLNM(0,&table3,&device_dsc1,0,&item) ; 	 if(status == SS$_NOLOGNAM) {A             status = SYS$TRNLNM(0,&table2,&device_dsc1,0,&item) ; ! 	    if(status == SS$_NOLOGNAM) { D                status = SYS$TRNLNM(0,&table1,&device_dsc1,0,&item) ; 	    } 	 }A        }#        if(status == SS$_NOLOGNAM) {           /*a 	  * copy rest of name 	  */i 	 *d++ = ':' ;" 	 while (*c != '\0') *d++ = *c++ ;
 	 *d = '\0' ;p	 	 break ;0       }t       else {)          *(tempfilename2+length) = '\0' ;a 	 d = tempfilename2 ;  	 while (*d != '\0') d++ ;" 	 while (*c != '\0') *d++ = *c++ ;
 	 *d = '\0' ;e,          strcpy(newfilename,tempfilename2) ;       }        pass++ ;     }t     /*#      * copy over device informationo      */n       c = newfilename ;f     d = tempfilename2 ; ?     while (*c != '\0') if(*c == ':') break ; else *d++ = *c++ ;      *d++ = ':' ; c++ ;      *d++ = *c++ ;			/* copy [ */       /*!      * Now remove ][ if necessaryn      */o       while (1) {n	        /* !         * copy everything until ]n 	*/n        if(*c == '\0') break ;n        if(*c == ']') {0           if((*(c-1) == '.')&&(*(c+1) == '[')) {( 	     if(strncmp(c,"][000000",8) == 0) { 		if(*(c+8) == '.')  		   c = c + 9 ; 		else if(*(c+9) == '[') c 		   c = c + 10 ;                  else {! 		   d-- ;		/* take off last . */b 		   *d++ = ']' ;		/* add ] */ 		   c = c + 9 ; 		}  	     }g 	     else ( 	       c = c + 2; 	  } 	  else if(*(c+1) == '[') {g 	     *d++ = '.' ;		/* add . */  	     c = c + 2 ;v 	  }           else *d++ = *c++ ;        }
        else {            *d++ = *c++ ;         }     }      *d = '\0' ;p     /*,      * If we are on a logical root remove it      */      c = tempfilename2 ;n7     while (*c != '\0') if(*c == ':') break ; else c++ ;b	     c++ ; J     if(strncmp(c,"[000000]000000.DIR",19) != 0) {   /* not at real root */:        while (*c != '\0') if(*c == ']') break ; else c++ ;D        if(strncmp(c,"]000000.DIR",11) == 0) {	    /* logical root */           *c = '\0' ;d 	  if(*(c-1) == '.')   	    strcat(c,"DIR") ; 	  elser 	    strcat(c,".DIR") ;  	  /* ! 	   * now search back to fix name  	   */           d = c-1 ;k 	  while (d > tempfilename2) { 	     if(*d == '.') {e 	       *d = ']' ; 	       break ;t              }1 	     if(*d == '[') {			/* eliminate partial [ */=# 	       strcpy(tempfilename1,d+1) ;x! 	       strcpy(d,tempfilename1) ;  	       break ;  	     }  	     d-- ;            }         }     }r     /*2      * see if we have eliminated the real root ie:      *      Disk$Edp:xxx.dir      */d     c = tempfilename2 ;      d = tempfilename1 ;n@     while (*c != '\0') if(*c == ':') break ; else *d++ = *c++ ;	,     if(*(c+1) != '[') {			/* no real root */        *d = '\0' ;        c++ ;        strcat(d,":[000000]") ;	        /*e         * finish copying namea 	*/m        while (*d != '\0') d++ ;r'        while (*c != '\0') *d++ = *c++ ;F        *d = '\0' ;'        strcpy(filename,tempfilename1) ;a     }a)     else strcpy(filename,tempfilename2) ;,     if(device != 0) {d        c = filename ;d        d = device ;fB        while (*c != '\0') if(*c == ':') break ; else *d++ = *c++ ;        *d++ = ':' ;*        *d = '\0' ;*        strcpy(dir_char.dir_name,oldname) ;     }t     /*      * Find the exact filespec      */ #     nam->nam$b_nop = NAM$V_SYNCHK ;h"     nam->nam$l_rsa = newfilename ;     nam->nam$b_rss = 255 ;     fab->fab$l_fna = filename ; '     fab->fab$b_fns = strlen(filename) ; !     status = SYS$PARSE(fab,0,0) ;h"     status = SYS$SEARCH(fab,0,0) ;-     *(nam->nam$l_rsa+nam->nam$b_rsl) = '\0' ;;     return(status) ; }h: long	get_device_characteristics(device_name,device_char)  char	*device_name ; * struct   device_char_struct *device_char ; /**eC **  get_device_characteristics : This routine retrieves the device OI **                               characteristics for a particular device.o **+ **  input:   device_name = character string  **  G **  output:  device_char = structure containing device characteristics. ) **                         (by reference)  ***/     {l'     static $DESCRIPTOR(device_dsc,"") ; !     static long iosb[2], status ; S     static long class,acp,maxblock,cluster,disk_size,freeblocks,mountcnt,volcount ;x     static long devchar ;S     struct item_list_struct {u 	short	buffer_length ; 	short   item_code ; 	long	buffer_address ; 	long	return_length_address ;=0     } item_list[8] = {4,DVI$_DEVCHAR,&devchar,0,! 		      4,DVI$_DEVCLASS,&class,0, ,                       4,DVI$_ACPTYPE,&acp,0," 		      4,DVI$_CLUSTER,&cluster,0,$ 		      4,DVI$_MAXBLOCK,&maxblock,0,( 		      4,DVI$_FREEBLOCKS,&freeblocks,0,$ 		      4,DVI$_MOUNTCNT,&mountcnt,0,& 		      4,DVI$_VOLCOUNT,&volcount,0} ;       /*&      * Make a call to see what we have      */e  ,     device_dsc.dsc$a_pointer = device_name ;4     device_dsc.dsc$w_length  = strlen(device_name) ;K     status = SYS$GETDVI(0,0,&device_dsc,&item_list[0],&iosb[0],0,0,0) ;            /*0      * Copy the characteristics to the structure      */{  2     strcpy(device_char->device_name,device_name) ;)     device_char->device_char  = devchar ;c'     device_char->device_class = class ; %     device_char->acp          = acp ; )     device_char->cluster      = cluster ;i*     device_char->maxblock     = maxblock ;,     device_char->freeblocks   = freeblocks ;*     device_char->mountcnt     = mountcnt ;*     device_char->volcount     = volcount ; }    * struct NAM *create_nam () n /**t, **  create_nam : initializes a rms NAM block ** **  input:   none  ** a- **  output:  returns address to new NAM block  ** c ***/     {e     static struct NAM *nam ;  6     nam = (struct NAM *)calloc(1,sizeof(struct NAM)) ;;     nam->nam$b_bid = NAM$C_BID ;	    /* block identifier */c6     nam->nam$b_bln = NAM$C_BLN ;	    /* size of nam	*/     return(nam) ;_ }r! struct FAB *create_fab (nam,xab)e struct NAM *nam ;) struct XAB *xab ;  /***, **  create_nam : initializes a rms FAB block **> **  input:   nam   = address of a previously created NAM block2 **           xab   = address of optional XAB block ** =- **  output:  returns address to new FAB block  ** a ***/     {      static struct FAB  *fab ;   6     fab = (struct FAB *)calloc(1,sizeof(struct FAB)) ;<     fab->fab$b_bid = FAB$C_BID ;		    /* block identifier	*/7     fab->fab$b_bln = FAB$C_BLN ;		    /* size of fab	*/;     fab->fab$l_nam = nam ;     fab->fab$l_xab = xab ;     return(fab) ;r }p struct RAB *create_rab (fab)  struct FAB *fab ;0 /**+, **  create_nam : initializes a rms RAB block **> **  input:   fab   = address of a previously created FAB block ** -- **  output:  returns address to new RAB blocki ** e ***/     {;     static struct RAB  *rab ;l  6     rab = (struct RAB *)calloc(1,sizeof(struct RAB)) ;      rab->rab$b_bid = RAB$C_BID ;      rab->rab$b_bln = RAB$C_BLN ;     rab->rab$l_fab = fab ;     return(rab) ;  } ( long scan_indexf(device_char,dir_char) ( struct device_char_struct *device_char ;% struct dir_char_struct    *dir_char ;f /**lB **  scan_indexf : This routine scans the indexf file checking for C **                deleted files that were in the current directory.  **G **  input:   device_char = address to device characteristics structure. D **           dir_char    = address to dir characteristics structure. ** * **  output:  nonew ** n ***/    {    static long status ; !    static char file_header[512] ;=!    static long vbn, block_count ;     static long option ;     static char *file_ptr ;+    static struct fileinfo_struct fileinfo ;d"    static struct hm2 *home_block ;  ]    printf(" UNDELETE - Version 1.4                              R. Armstrong Oct 1990\n\n") ; 1    printf(" Scanning files from %s (%d,%d,%d)\n",E           dir_char->dir_name, 8 	  dir_char->fid[0],dir_char->fid[1],dir_char->fid[2]) ;      /*t-     * Open the INDEXF.SYS file in shared modeb     */  Q    status = open_shared(indexf_fab,indexf_rab,indexf_buffer,indexf_buffer_size) ;c.    home_block = calloc(1,sizeof(struct hm2)) ;      /* @     * start reading from block 2 (block 1 reserved for 750 boot)     */  *    status = read_indexf(2,1,home_block) ;     if(status != RMS$_NORMAL) {P       printf(" Error while reading home block on disk - status = %d\n",status) ;       return(0) ;t    }F    reserved_blocks = home_block->hm2_union.hm2_struct.hm2$w_ibmapvbn +G                      home_block->hm2_union.hm2_struct.hm2$w_ibmapsize ;t!    indexf_vbn = reserved_blocks ;*    if(status == RMS$_NORMAL) {         /*.        * Scan the index file for deleted files	        */f         while (1) {             /*=" 	  * Read a 100 blocks and process 	  */i   	 block_count = 100 ;r? 	 status = read_indexf(indexf_vbn,block_count,indexf_buffer) ; =" 	 vbn = indexf_rab->rab$w_rfa[0] ;+ 	 block_count = indexf_rab->rab$w_rsz/512 ;  	 file_ptr = indexf_buffer ;: 	 while (block_count > 0) {		/* scan through the buffer */( 	    get_file_info(&fileinfo,file_ptr) ;1 	    if((dir_char->fid[0] == fileinfo.bkfidnum)&&n2 	        (dir_char->fid[1] == fileinfo.bkfidseq)&&; 		(dir_char->fid[2] == fileinfo.bkfidrvn)) { /* this dir */e@ 		if(fileinfo.filechar.FH2$V_MARKDEL != 0) { /* deleted files */B 	          option = select_file(&fileinfo,vbn-reserved_blocks+1) ;$ 		  if(option == -1) goto ALL_DONE ; 		    if(option == 1) {    		       /*_ 		        * Ok recover this onem 			*/_  = 		       lock_disk_and_recover_file(&fileinfo,file_ptr,vbn) ;  		    }t
 	        } 	    } 	    block_count-- ;& 	    file_ptr = file_ptr + page_size ; 	    vbn++ ; 	 }e  	 if(status == RMS$_EOF) break ; 	 if(status != RMS$_NORMAL) {fD 	    printf(" Error encountered reading INDEXF.SYS - status = %d\n", 	           status) ;  	    break ; 	 }  	 indexf_vbn = vbn ;       }(	 ALL_DONE: 2       status = close_file(indexf_fab,indexf_rab) ;    }F    else printf(" Unable to open indexf file - status = %d\n",status) ; }l+ long	get_file_info(file_info,file_header) s# struct fileinfo_struct *file_info ;u char	*file_header ;l /**eK **  get_file_info : This routine extracts certain information from the file 4 **                  header, such as dates, filename. **C **  input:    file_header = pointer to page containing file header.c **B **  output:   fileinfo    = structure to contain file information. **   ***/   {MD     char    filename[255] ;	    /* to store filename of header in	*/D     char    date_string[30] ;	    /* to convert binary dates into	*/<     long    timlen ;		    /* return length of time string	*/@     long    gettime() ;		    /* convert time-date into string	*/B     long    revision ;		    /* correspond to respective fields  */+     long    fidnum ;		    /* in header			*/      long    fidseq ;     long    fidrvn ;     long    map_offset ;     long    map_size ;?     long    offset ;		    /* for return size of pointer area	*/      long    count=0, i ;     long    number=1, status ;  3 			   /* various structures used to extract data */d, 			   /* or for convenience	              */  #     struct  FH2$_STRUCT		    *fh2 ; 3     struct  FH2$_STRUCT_FIELDS	    *struct_fields ; 7     struct  FH2$_FILEOWNER_FIELDS   *fileowner_fields ; 6     struct  FH2$_FILECHAR_FIELDS    *filechar_fields ;       /* assign the pointer */       fh2 = file_header ;0  ;     /* decompose structure level and version and file id */i  >   struct_fields = &fh2->FH2$STRUCT_OVERLAY.FH2$STRUCT_FIELDS ;4   file_info->segnum = struct_fields->FH2$W_SEG_NUM ;   file_info->strucver = O       struct_fields->FH2$STRUCTLEV_OVERLAY.FH2$STRUCLEV_FIELDS.FH2$B_STRUCVER ;'   file_info->struclev = O       struct_fields->FH2$STRUCTLEV_OVERLAY.FH2$STRUCLEV_FIELDS.FH2$B_STRUCLEV ; *   file_info->fidnum = fh2->FH2$W_FID_NUM ;*   file_info->fidseq = fh2->FH2$W_FID_SEQ ;>   file_info->fidrvn = fh2->FH2$FID_RVN_OVERLAY.FH2$W_FID_RVN ;.   file_info->fidexnum = fh2->FH2$W_EX_FIDNUM ;.   file_info->fidexseq = fh2->FH2$W_EX_FIDSEQ ;D   file_info->fidexrvn = fh2->FH2$EX_FIDRVN_OVERLAY.FH2$W_EX_FIDRVN ;G   file_info->filechar = fh2->FH2$FILECHAR_OVERLAY.FH2$FILECHAR_FIELDS ;(G   fileowner_fields = &fh2->FH2$FILEOWNER_OVERLAY.FH2$FILEOWNER_FIELDS ;d8   file_info->group  = fileowner_fields->FH2$W_UICGROUP ;9   file_info->member = fileowner_fields->FH2$W_UICMEMBER ;o.   file_info->bkfidnum = fh2->FH2$W_BK_FIDNUM ;.   file_info->bkfidseq = fh2->FH2$W_BK_FIDSEQ ;D   file_info->bkfidrvn = fh2->FH2$BK_FIDRVN_OVERLAY.FH2$W_BK_FIDRVN ;   for (i=0;i<255;i++)p       filename[i] = '\0' ;8   strncpy(filename,fh2->FI2$T_FILENAME,FI2$S_FILENAME) ;   for (i=0;i<255;i++) =       if((filename[i] == '\0')||(filename[i] == ' ')) break ;    filename[i] = '\0' ;<   strncat(filename,fh2->FI2$T_FILENAMEXT,FI2$S_FILENAMEXT) ;   for (i=0;i<255;i++) =       if((filename[i] == '\0')||(filename[i] == ' ')) break ;:   filename[i] = '\0' ;(   strcpy(file_info->filename,filename) ; }r! long select_file (fileinfo,num) c" struct fileinfo_struct *fileinfo ;
 long num ; /** F **  select_file : routine to prompt the user if they want to undelete. **! **  input:   num       = fid num. ? **           fileinfo  = structure containing file information.a **  2 **  output:  returns  1 if user wants to undelete.* **                    0 if skip this file.( **                   -1 if quit utility. ***/    {    static char line[255] ;    static char ans,ans2 ;     static long i, status ;  @    status = check_wildcard(fileinfo->filename,wildcard_string) ;)    if(status == STR$_NOMATCH) return(0) ;M    putchar('\n') ;6    sprintf(line," Recover %-40s",fileinfo->filename) ;    for(i=strlen(line);i>0;i--)        if(line[i] != ' ') break ;    if(i < 50)        for(;i<50;i++) 	 line[i] = ' ' ;s6    sprintf(&line[i],"(%d,%d,%d)",num,fileinfo->fidseq,            fileinfo->fidrvn) ;    for(i=strlen(line);i>0;i--)        if(line[i] != ' ') break ;
    if(i < 65)i       for(;i<65;i++) 	 line[i] = ' ' ;d!    sprintf(&line[i],"[Y,N,Q] ") ;c    printf("%s",line) ;    ans2 = ans = ' ' ;i    while (ans2 != '\0') {        scanf("%c",&ans2) ;f        if(ans2 == ' ') continue ;       if(ans2 == '\n') break ;       if(ans2 == '\r') break ;       ans = ans2 ;    }!    if((ans == 'Y')||(ans == 'y'))        return(1) ; &    else if((ans == 'Q')||(ans == 'q'))       return(-1) ;    else"       return(0) ;    }b/ long check_wildcard(filename,wildcard_string) k char *filename ; char *wildcard_string ;o    {9    static char field1[255], field2[255], *b, *c, *d, *e ;u     static $DESCRIPTOR(str1,"") ;     static $DESCRIPTOR(str2,"") ;    long status ;      /*r     * check name l     */    b = filename ;e    c = field1 ;     while (*b != '\0') {        if(*b == '.') break ;$       *c++ = *b++ ;     }    *c = '\0' ;    d = wildcard_string ;    e = field2 ;,    while (*d != '\0') {O       if(*d == '.') break ;,       *e++ = *d++ ;n    }    *e = '\0' ;    str1.dsc$a_pointer = field1; (    str1.dsc$w_length  = strlen(field1) ;    str2.dsc$a_pointer = field2;i(    str2.dsc$w_length  = strlen(field2) ;)    status = STR$MATCH_WILD(&str1,&str2) ;s.    if(status == STR$_NOMATCH) return(status) ;      /*0     * check type     */    if(*b == '.') b++ ;    c = field1 ;e    while (*b != '\0') {d       if(*b == ';') break ;e       *c++ = *b++ ;c    }    *c = '\0' ;    if(*d == '.') d++ ;    e = field2 ;     while (*d != '\0') {-       if(*d == ';') break ;e       *e++ = *d++ ;     }    *e = '\0' ;    str1.dsc$a_pointer = field1;k(    str1.dsc$w_length  = strlen(field1) ;    str2.dsc$a_pointer = field2; (    str2.dsc$w_length  = strlen(field2) ;)    status = STR$MATCH_WILD(&str1,&str2) ;e.    if(status == STR$_NOMATCH) return(status) ;    /*N     * check version      */    if(*b == ';') b++ ;    c = field1 ;     while (*b != '\0')        *c++ = *b++ ;c    *c = '\0' ;    if(*d == ';') d++ ;    e = field2 ;z    while (*d != '\0')        *e++ = *d++ ;C    *e = '\0' ;    str1.dsc$a_pointer = field1;b(    str1.dsc$w_length  = strlen(field1) ;    str2.dsc$a_pointer = field2;A(    str2.dsc$w_length  = strlen(field2) ;)    status = STR$MATCH_WILD(&str1,&str2) ;m    return(status) ;F }b$ long read_indexf(vbn,blocks,buffer) unsigned long vbn ;t unsigned long blocks ; char	 *buffer ;s /**pM **  read_indexf : Read a specified number of blocks into buffer starting from*" **                a specified vbn. **6 **  input:   vbn       = vbn of where to start reading( **           blocks    = #blocks to read ** b. **  output:  buffer    = contains blocks read. ***/    {    static long status ;-      /*m@     * Calculate number of characters to read then do a block io.     */  9    indexf_rab->rab$l_bkt = vbn ;		/* start block no    */:<    indexf_rab->rab$l_ubf = buffer ;		/* buffer            */@    indexf_rab->rab$w_usz = blocks*512 ;		/* no bytes  to read */&    status = SYS$READ(indexf_rab,0,0) ;    return(status) ;  } $ long read_bitmap(vbn,blocks,buffer) unsigned long vbn ;R unsigned long blocks ; char	 *buffer ;  /**aM **  read_bitmap : Read a specified number of blocks into buffer starting from " **                a specified vbn. **6 **  input:   vbn       = vbn of where to start reading( **           blocks    = #blocks to read ** x. **  output:  buffer    = contains blocks read. ***/    {    static long status ;       /* @     * Calculate number of characters to read then do a block io.     */  9    bitmap_rab->rab$l_bkt = vbn ;		/* start block no    */d<    bitmap_rab->rab$l_ubf = buffer ;		/* buffer            */@    bitmap_rab->rab$w_usz = blocks*512 ;		/* no bytes  to read */&    status = SYS$READ(bitmap_rab,0,0) ;    return(status) ;i }o% long write_bitmap(vbn,blocks,buffer); unsigned long vbn ;l unsigned long blocks ; char	 *buffer ;t /***I **  write_bitmap : Write a specified number of blocks to the bitmap file. % **                at a specified vbn.p **6 **  input:   vbn       = vbn of where to start reading( **           blocks    = #blocks to read7 **           buffer    = contains blocks to be written.t ***/    {    static long status ;       /* -     * Calculate number of characters to writee     */  9    bitmap_rab->rab$l_bkt = vbn ;		/* start block no    */u<    bitmap_rab->rab$l_rbf = buffer ;		/* buffer            */@    bitmap_rab->rab$w_rsz = blocks*512 ;		/* no bytes  to read */'    status = SYS$WRITE(bitmap_rab,0,0) ;)    return(status) ;r }w% long write_indexf(vbn,blocks,buffer)s unsigned long vbn ;  unsigned long blocks ; char	 *buffer ;s /**mI **  write_indexf : Write a specified number of blocks to the bitmap file.l& **                 at a specified vbn. **6 **  input:   vbn       = vbn of where to start reading( **           blocks    = #blocks to read7 **           buffer    = contains blocks to be written.  ***/    {    static long status,i ;       /*d-     * Calculate number of characters to writet     */  9    indexf_rab->rab$l_bkt = vbn ;		/* start block no    */ <    indexf_rab->rab$l_rbf = buffer ;		/* buffer            */@    indexf_rab->rab$w_rsz = blocks*512 ;		/* no bytes  to read */'    status = SYS$WRITE(indexf_rab,0,0) ;g    if(status == RMS$_NORMAL) )       for(i=0;i<blocks;i++) {=A          printf("     Repaired File Header at block %7d\n",vbn) ;d          vbn++ ;       }     return(status) ;) }/: long	lock_disk_and_recover_file(fileinfo,header_ptr,vbn) " struct fileinfo_struct *fileinfo ; char   *header_ptr ; long   vbn ; /**bJ **  lock_disk_and_recover_file : This routine will lock the bitmap file inF **                               exclusive update mode and attempt to M **                               undelete the file. After altering the bitmap}L **                               file, this utility will fix the file headerK **                               to flip the deletion bit, then finally putpB **                               the file into the directory file. **? **  input:   fileinfo  = structure containing file information.(5 **           header_ptr= pointer to file header page.xC **           vbn       = vbn of file header in the INDEXF.sys file.= ***/    {#    static struct FH2$_STRUCT *fh2 ;f    long status, recover ;l      /*u     * Point to the headere     */      fh2 = header_ptr ;f  8    /*  display_file_header(fh2) ;  for debugging only */      /* A     * Close the indexf file and reattach it in shared update modee     */      recover = 0 ;/    status = close_file(indexf_fab,indexf_rab) ;o    if(status == RMS$_NORMAL) {S       status = open_shared_update(indexf_fab,indexf_rab,indexf_buffer2,page_size) ;o!       if(status == RMS$_NORMAL) {r   	 /*= 	  * Reread the file header to verify that it has not changed	 	  */r  . 	 status = read_indexf(vbn,1,indexf_buffer2) ; 	 fh2 = indexf_buffer2 ;   	 /*: 	  * If first header ok - check for multiple headers later 	  */v  / 	 if((fh2->FH2$W_FID_NUM == fileinfo->fidnum)&&r6             (fh2->FH2$W_FID_SEQ == fileinfo->fidseq)&&D 	    (fh2->FH2$FID_RVN_OVERLAY.FH2$W_FID_RVN == fileinfo->fidrvn)) {   	    /*t' 	     * Flush the bitmap before opening 2 	     *   by requesting information on free blocks 	     */  G 	    get_device_characteristics(device_char.device_name,&device_char) ;                /*A 	     * Ok we have the INDEXF.SYS file now in shared update mode *6 	     * Grab the BITMAP file in exclusive update mode  	     */  H             status = open_exclusive(bitmap_fab,bitmap_rab,bitmap_buffer, 				    bitmap_buffer_size) ; '             if(status == RMS$_NORMAL) {c  
 	       /*B 	        * Boost our priority into REAL time to minimize disk lock 		*/   	       raise_priority() ;  
 	       /*D 	        * Ok we have the disk bitmap and index header files locked  		* do our stuff 		*/  3 	       status = recover_file(indexf_buffer2,vbn) ;s" 	       if(status == SS$_NORMAL) {   		  /*4 		   * fileinfo->fidnum = vbn - reserved_blocks + 1  		   */d  @                   fileinfo->fidnum = vbn - reserved_blocks + 1 ;) 		  fix_file_header(indexf_buffer2,vbn) ;O 		  recover = 1 ;N                }K 	       else  printf("     Recovery Aborted - file partly overwritten\n") ;Q4 	       status = close_file(bitmap_fab,bitmap_rab) ;!                lower_priority() ;l 	    }W 	    else printf(" Cannot open bitmap file in exclusive mode - status = %d\n",status) ;R 	 }L9          else printf(" File header has been changed\n") ;_. 	 status = close_file(indexf_fab,indexf_rab) ;       }_    }Q    status = open_shared(indexf_fab,indexf_rab,indexf_buffer,indexf_buffer_size) ;b      /* I     * The last part of the recovery is to put the file into the directoryF     */      if(recover == 1) {56       printf("     Inserting file into directory\n") ;3       status = load_file_into_directory(fileinfo) ;5D       if(status == RMS$_NORMAL) printf("     Recovery Complete\n") ;    } }a- long open_shared(fab,rab,buffer,buffer_size)I struct FAB *fab ;N struct RAB *rab ;0 /**5F **  open_shared : This routine opens a file in read only (for me), and* **                allows others to update. **  **  input:   fab    = fab block  **           rab    = rab blockl# **           buffer = record buffer 0 **           buffer_size = size of record buffer ***/    {    long status ;  +    fab->fab$b_fac = FAB$M_BIO | FAB$M_GET ;     fab->fab$l_fop = FAB$M_SQO ;n@    fab->fab$b_shr = FAB$M_SHRPUT | FAB$M_SHRGET | FAB$M_SHRUPD |.                     FAB$M_SHRDEL | FAB$M_UPI ;    fab->fab$w_ifi = 0 ;     rab->rab$l_rop = RAB$M_BIO ; 9    rab->rab$l_bkt = 1 ;		/* start from the first block */     rab->rab$l_ubf = buffer ;!    rab->rab$w_usz = buffer_size ;-      /*,     * Open the file for I/Ot     */      status = SYS$OPEN(fab,0,0) ;r-    if(status != RMS$_NORMAL) return(status) ;i      /*n!     * Now connect a record stream-     */"    status = SYS$CONNECT(rab,0,0) ;    if(status != RMS$_NORMAL)         SYS$CLOSE(fab,0,0) ;    else        if(fab == indexf_fab)f 	 indexf_file_open = 1 ;
       else 	 bitmap_file_open = 1 ;      return(status) ;] } 4 long open_shared_update(fab,rab,buffer,buffer_size) struct FAB *fab ;  struct RAB *rab ;[ /**]K **  open_shared_update  : This routine opens a file in update mode (for me)'6 **                        and update mode (for others) **  **  input:   fab    = fab block  **           rab    = rab blockk# **           buffer = record buffera0 **           buffer_size = size of record buffer ***/    {    long status ;  7    fab->fab$b_fac = FAB$M_BIO | FAB$M_GET | FAB$M_PUT ;     fab->fab$l_fop = FAB$M_SQO ;,@    fab->fab$b_shr = FAB$M_SHRPUT | FAB$M_SHRGET | FAB$M_SHRUPD |.                     FAB$M_SHRDEL | FAB$M_UPI ;    fab->fab$w_ifi = 0 ;     rab->rab$l_rop = RAB$M_BIO ; 9    rab->rab$l_bkt = 1 ;		/* start from the first block */h    rab->rab$l_ubf = buffer ;!    rab->rab$w_usz = buffer_size ;e      /*\     * Open the file for I/Or     */      status = SYS$OPEN(fab,0,0) ; -    if(status != RMS$_NORMAL) return(status) ;       /*i!     * Now connect a record stream'     */"    status = SYS$CONNECT(rab,0,0) ;    if(status != RMS$_NORMAL) n       SYS$CLOSE(fab,0,0) ;    else        if(fab == indexf_fab)s 	 indexf_file_open = 1 ;
       else 	 bitmap_file_open = 1 ;    return(status) ;C }I0 long open_exclusive(fab,rab,buffer,buffer_size) struct FAB *fab ;  struct RAB *rab ;  /** K **  open_exclusive : This routine opens a file in update mode (for me) and  J **                   no access to others. If open fails, will retry up to . **                   100 times before failing. **  **  input:   fab    = fab block  **           rab    = rab block}# **           buffer = record buffere0 **           buffer_size = size of record buffer ***/    {    long status ;    long retry_count ;_      fab->fab$w_ifi = 0 ; O    fab->fab$b_fac = FAB$M_BIO | FAB$M_BRO | FAB$M_GET | FAB$M_PUT | FAB$M_UPD ;s    fab->fab$l_fop = FAB$M_SQO ;s    fab->fab$b_shr = FAB$M_NIL ;+    rab->rab$l_rop = RAB$M_BIO ;b9    rab->rab$l_bkt = 1 ;		/* start from the first block */=    rab->rab$l_ubf = buffer ;!    rab->rab$w_usz = buffer_size ;+      /*C     * Open the file for I/O$     */    status == SS$_NORMAL ;_    retry_count = 0 ;    while (status != RMS$_FLK) {l"       status = SYS$OPEN(fab,0,0) ;'       if(status == RMS$_NORMAL) break ;t       retry_count++ ;(#       if(retry_count > 100) break ;,    }    if(status != RMS$_NORMAL)         return(status) ;      /*f!     * Now connect a record streamd     */"    status = SYS$CONNECT(rab,0,0) ;    if(status != RMS$_NORMAL)         SYS$CLOSE(fab,0,0) ;    else        if(fab == indexf_fab)t 	 indexf_file_open = 1 ;
       else 	 bitmap_file_open = 1 ;    return(status) ;n }n long close_file(fab,rab)  struct FAB *fab ;u struct RAB *rab ;  /**c- **  close_file :  This routine closes a file.o **  **  input:   fab    = fab block  **           rab    = rab block  ***/    {    long status ;  %    status = SYS$DISCONNECT(rab,0,0) ;i    if(status != RMS$_NORMAL) {E       printf(" Error disconnecting from file status = %d\n",status) ;        return(status) ;    }     status = SYS$CLOSE(fab,0,0) ;    if(status != RMS$_NORMAL) n:       printf(" Error closing file status = %d\n",status) ;    else        if(fab == indexf_fab)  	 indexf_file_open = 0 ;
       else          bitmap_file_open = 0 ;n    return(status) ;  }s! long fix_file_header(header,vbn) 
 long vbn ; char *header ; /**pA **  fix_file_header : This routine patches the file header block.sE **                    It resets the FID NUM field, flips the deletiono8 **                    bit and recalculates the checksum. **! **  input:   header = file header-; **           vbn    = vbn of file header within INDEXF.SYS.- ***/     {b     long first=1 ;'     static char disk_block[page_size] ;t     char *file_header ;(<     long header_num, num, ex_num, seq, ex_seq, rvn, ex_rvn ;     long no_extents ;d     long elbn, ecount ;f     long map_offset, map_size ;W+     long size,ssize,i,format_type, status ;a     unsigned long checksum ;     unsigned short *word ;     char *map_struct ;#     struct  FH2$_STRUCT		    *fh2 ; 3     struct  FH2$_OFFSET_FIELDS	    *offset_fields ;        /*      * Point to the file header       */a       fh2 = header ;       /*      * First Headero      */e  !     num    = fh2->FH2$W_FID_NUM ;-     if(num != 0) {,        printf(" Header has been reused\n") ;        return(SS$_ABORT) ;     }   ,     header_num = vbn - reserved_blocks + 1 ;!     seq    = fh2->FH2$W_FID_SEQ ; 5     rvn    = fh2->FH2$FID_RVN_OVERLAY.FH2$W_FID_RVN ;   *     while (1) {			/* while headers left */        if(first == 1)             file_header = header ;        elset4 	  file_header = disk_block ;	/* alternate header */          fh2 = file_header ;  (        num = vbn - reserved_blocks + 1 ;  	        /*o"         * Reset the FID num from 0 	*/o  $        if(fh2->FH2$W_FID_NUM != 0) {B 	  printf(" Fid NUM not zero aborting file header adjustment\n") ;           return(SS$_ABORT) ;         }  !        fh2->FH2$W_FID_NUM = num ;/  	        /*_         * Next Header  	*/a  &        ex_num = fh2->FH2$W_EX_FIDNUM ;&        ex_seq = fh2->FH2$W_EX_FIDSEQ ;<        ex_rvn = fh2->FH2$EX_FIDRVN_OVERLAY.FH2$W_EX_FIDRVN ;  	        /*          * Flip the deletion bit 
         */  H        fh2->FH2$FILECHAR_OVERLAY.FH2$FILECHAR_FIELDS.FH2$V_MARKDEL = 0 ;  	        /*d          * Calculate the checksum
         */                 checksum = 0 ;/        word = file_header ;_        for(i=255;i>0;i--) { '           checksum = checksum + *word ;r           word++ ;        }%        checksum = checksum & 0xFFFF ;:$        word = &fh2->FH2$W_CHECKSUM ;        *word = checksum ;   	        /*c,         * Write the corrected header to disk 	*/   1        status = write_indexf(vbn,1,file_header) ;e  	        /* +         * If no multiple header continue ont 	*/l          if((ex_num == 0)&&            (ex_seq == 0)&&             (ex_rvn == 0)) break ;          first = 0 ;  	        /*          * Read Alternate Headerf 	*/   +        vbn = ex_num + reserved_blocks - 1 ;n/        status = read_indexf(vbn,1,disk_block) ;i"        if(status != RMS$_NORMAL) {D 	  printf(" Error reading multiple header - vbn = %d status = %d\n", 	         vbn,status) ;_           return(SS$_ABORT) ;         }  	        /* F         * Check to see if Fid's match - if not it has been overwritten 	*/f          fh2 = disk_block ;i(        num = vbn - reserved_blocks + 1 ;D        if(((fh2->FH2$W_FID_NUM == 0)||(fh2->FH2$W_FID_NUM == num))&&*           (fh2->FH2$W_FID_SEQ == ex_seq)&&>           (fh2->FH2$FID_RVN_OVERLAY.FH2$W_FID_RVN == ex_rvn)&&) 	  (fh2->FH2$W_BK_FIDNUM == header_num)&&b" 	  (fh2->FH2$W_BK_FIDSEQ == seq)&&B 	  (fh2->FH2$BK_FIDRVN_OVERLAY.FH2$W_BK_FIDRVN == rvn)) continue ;	        /* -         * Header doesn't match - return errorv 	*/i  @        printf(" Not all headers intact in multiheader file\n") ;        return(SS$_ABORT) ;     }s     return(SS$_NORMAL) ; }F' long	display_file_header(file_header)   char	*file_header ;I /** E **  display_file_header : (for debug only) interpret the file header.  **1 **  input:   file_header = address of file_headerm ***/   {pD     char    filename[255] ;	    /* to store filename of header in	*/D     char    date_string[30] ;	    /* to convert binary dates into	*/<     long    timlen ;		    /* return length of time string	*/@     long    gettime() ;		    /* convert time-date into string	*/B     long    revision ;		    /* correspond to respective fields  */+     long    fidnum ;		    /* in header			*/      long    fidseq ;     long    fidrvn ;     long    map_offset ;     long    map_size ;?     long    offset ;		    /* for return size of pointer area	*/      long    count=0, i ;     long    number=1 ;  3 			   /* various structures used to extract data */ , 			   /* or for convenience	              */  #     struct  FH2$_STRUCT		    *fh2 ; *     struct  FM2$_STRUCT		    *map_struct ;3     struct  FH2$_OFFSET_FIELDS	    *offset_fields ;	3     struct  FH2$_STRUCT_FIELDS	    *struct_fields ;r7     struct  FH2$_FILEOWNER_FIELDS   *fileowner_fields ;v6     struct  FH2$_FILECHAR_FIELDS    *filechar_fields ;     char    *c, *d ;       /* assign the pointer */       fh2 = file_header ;s  !     /* decompose offset fields */;  >   offset_fields = &fh2->FH2$OFFSET_OVERLAY.FH2$OFFSET_FIELDS ;5   printf(" Ident area offset in words          %d\n",n$     offset_fields->FH2$B_IDOFFSET) ;.   map_offset = offset_fields->FH2$B_MPOFFSET ;5   printf(" Map area offset in words            %d\n",}     map_offset) ;s5   printf(" Access Control list offset in words %d\n",_$     offset_fields->FH2$B_ACOFFSET) ;5   printf(" Reserved area offset in words       %d\n",F$     offset_fields->FH2$B_RSOFFSET) ;  ;     /* decompose structure level and version and file id */t  >   struct_fields = &fh2->FH2$STRUCT_OVERLAY.FH2$STRUCT_FIELDS ;5   printf(" File Segment number                 %d\n",a#     struct_fields->FH2$W_SEG_NUM) ;f9   printf(" Structure level and version         %d, %d\n",*L     struct_fields->FH2$STRUCTLEV_OVERLAY.FH2$STRUCLEV_FIELDS.FH2$B_STRUCVER,N     struct_fields->FH2$STRUCTLEV_OVERLAY.FH2$STRUCLEV_FIELDS.FH2$B_STRUCLEV) ;<   printf(" File identification                (%d,%d,%d)\n",     fh2->FH2$W_FID_NUM,i     fh2->FH2$W_FID_SEQ,r-     fh2->FH2$FID_RVN_OVERLAY.FH2$W_FID_RVN) ;_<   printf(" Extension file identification      (%d,%d,%d)\n",     fh2->FH2$W_EX_FIDNUM,$     fh2->FH2$W_EX_FIDSEQ,A1     fh2->FH2$EX_FIDRVN_OVERLAY.FH2$W_EX_FIDRVN) ;B  ,     /* determine the file characteristics */  E   filechar_fields =  &fh2->FH2$FILECHAR_OVERLAY.FH2$FILECHAR_FIELDS ;o,   if (filechar_fields->FH2$V_NOBACKUP != 0) (     printf(" File Marked NOBACKUP \n") ;-   if (filechar_fields->FH2$V_WRITEBACK != 0)  +     printf(" Writeback cached enabled\n") ;R-   if (filechar_fields->FH2$V_READCHECK != 0) n8     printf(" Verify on all read operations enabled\n") ;-   if (filechar_fields->FH2$V_WRITCHECK != 0) Y9     printf(" Verify on all write operations enabled\n") ; *   if (filechar_fields->FH2$V_CONTIGB != 0)&     printf(" Contiguous best try\n") ;*   if (filechar_fields->FH2$V_LOCKED != 0) "     printf(" Deaccess Locked\n") ;)   if (filechar_fields->FH2$V_CONTIG != 0)_%     printf(" File is contiguous\n") ;u)   if (filechar_fields->FH2$V_BADACL != 0) "     printf(" Bad ACL in file\n") ;(   if (filechar_fields->FH2$V_SPOOL != 0)*     printf(" Intermediate spool file\n") ;,   if (filechar_fields->FH2$V_DIRECTORY != 0)$     printf(" File is directory\n") ;+   if (filechar_fields->FH2$V_BADBLOCK != 0)_+     printf(" File contains bad blocks\n") ;_*   if (filechar_fields->FH2$V_MARKDEL != 0),     printf(" File is marked for delete\n") ;+   if (filechar_fields->FH2$V_NOCHARGE != 0) 3      printf(" File space is not to be charged\n") ; )   if (filechar_fields->FH2$V_ERASE != 0) t-     printf(" Erase File before deletion\n") ;;  2     /* get info required for retrieval map area */  #   map_size = fh2->FH2$B_MAP_INUSE ;a4   printf(" Map area words in use:             %d\n",      map_size) ;4   printf(" Access mode:                       %d\n",      fh2->FH2$B_ACC_MODE) ;a     ;     /* determine the owner, protection, name of the file */;  G   fileowner_fields = &fh2->FH2$FILEOWNER_OVERLAY.FH2$FILEOWNER_FIELDS ;l9   printf(" File Owner Uic                     (%o,%o)\n",n%     fileowner_fields->FH2$W_UICGROUP,s(     fileowner_fields->FH2$W_UICMEMBER) ;4   printf(" File Protection                    %x\n",     fh2->FH2$W_FILEPROT) ;!   fidnum = fh2->FH2$W_BK_FIDNUM ;s!   fidseq = fh2->FH2$W_BK_FIDSEQ ;r7   fidrvn = fh2->FH2$BK_FIDRVN_OVERLAY.FH2$W_BK_FIDRVN ; <   printf(" Back link file identification:     (%d,%d,%d)\n",     fidnum,fidseq,fidrvn) ;    c = fh2->FI2$T_FILENAME ;    d = filename ;    for(i=0;i<FI2$S_FILENAME;i++) -      if(*c == ' ') break ; else *d++ = *c++ ;b   c = fh2->FI2$T_FILENAMEXT ;$"   for(i=0;i<FI2$S_FILENAMEXT;i++) -      if(*c == ' ') break ; else *d++ = *c++ ;_
   *d = '\0' ; 4   printf(" Filename                           %s\n",     filename) ; #    revision = fh2->FI2$W_REVISION ;m  3     /* convert the date fields within the header */r  ;   timlen = gettime(fh2->FI2$CREDATE_FIELDS.FI2$W_CREDATE_1,o- 		   fh2->FI2$CREDATE_FIELDS.FI2$W_CREDATE_2,r 		   &date_string) ;B   printf(" Creation Date                      %s\n",date_string) ;;   timlen = gettime(fh2->FI2$REVDATE_FIELDS.FI2$W_REVDATE_1,(- 		   fh2->FI2$REVDATE_FIELDS.FI2$W_REVDATE_2,  		   &date_string) ;B   printf(" Revision Date                      %s\n",date_string) ;;   timlen = gettime(fh2->FI2$EXPDATE_FIELDS.FI2$W_EXPDATE_1,t- 		   fh2->FI2$EXPDATE_FIELDS.FI2$W_EXPDATE_2,) 		   &date_string) ;B   printf(" Expiration Date                    %s\n",date_string) ;;   timlen = gettime(fh2->FI2$BAKDATE_FIELDS.FI2$W_BAKDATE_1,f- 		   fh2->FI2$BAKDATE_FIELDS.FI2$W_BAKDATE_2,  		   &date_string) ;B   printf(" Backup Date                        %s\n",date_string) ;J   printf(" Checksum                           %d\n",fh2->FH2$W_CHECKSUM) ;  $     /* now decompose the map area */     printf("\n   Map Area\n\n") ;n  .     /* calculate the lbn and the size of it */  )   map_struct = file_header+map_offset*2 ;s  #   report_map(map_struct,map_size) ;t }   " long report_map(map_struct,size)  char	*map_struct ; long	size ;uD /*                                                                */D /* This procedure reports the contents of the map area in a       */D /* file header.                                                   */D /*                                                                *// /* map_struct   pointer to map structure			  */l> /* size         length of the map area                   	  */ /*								  */    {     struct  FM2$_STRUCT	*ptr ;@     unsigned long getlbn() ;	    /* function to calculate lbn	*/=     unsigned long   format_type ;   /* type of map format		*/g     long     number=1 ;e"     long     ecount, elbn, ssize ;      size = size*2 ;1    printf("Map Area\n    Retrieval pointers\n") ;b    while (size > 0) {m        ptr = map_struct ; ?        format_type = ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_FORMAT ;s        if(format_type == 0) {;5 	    if(ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_EXACT != 0)*9 		printf("       Exact Placement specified         %d\n", 3 		       ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_EXACT) ;a5 	    if(ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_ONCYL != 0) 9 		printf("       On Cylinder Allocation desired    %d\n",!3 		       ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_ONCYL) ; 3 	    if(ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_LBN != 0)=9 		printf("       LBN flag is                       %d\n",E1 		       ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_LBN) ;I3 	    if(ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_RVN != 0)/9 		printf("       RVN flag is                       %d\n", 1 		       ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_RVN) ;r. 	    map_struct = map_struct + FM2$K_LENGTH0 ;" 	    size = size - FM2$K_LENGTH0 ;        }
        else { / 	    getlbn (map_struct,&elbn,&ecount,&ssize) ;h- 	    printf("        Count:%8d    LBN:%8d\n",o 		   ecount,elbn) ;h 	    size = size - ssize ;& 	    map_struct = map_struct + ssize ;        }     }_ }_3 unsigned long	getlbn (map_struct,elbn,ecount,size)* char	*map_struct ; long	*elbn ; long	*ecount ; long	*size ; /**2A **  getlbn : This routine interprets the map area and returns the_? **           lbn and count and the offset to the next map slot.  **8 **  input:   map_struct = pointer to map structure slot. **+ **  output:  elbn   = output lbn from slot.t- **           ecount = output count from slot.e* **           size   = offset to next slot. ***/     {2     struct  FM2$_STRUCT	*ptr ;     long    format_type ;      union {+ 	unsigned lbn	    : 32 ;	 	struct {s 	    unsigned lolbn  : 16 ;  	    unsigned hilbn  :  8 ;  	} lbn_overlay ;     } lbn ;/     union {  	unsigned count	    : 32 ; 	unsigned count1	    :  8 ;  	unsigned count2	    : 14 ;d	 	struct {  	    unsigned locount: 16 ;t 	    unsigned hicount: 14 ;l         } count_overlay ;&
     } count ;e       ptr = map_struct ;          /* b(      * What format are we talking about?      */   <     format_type = ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_FORMAT ;          /*%      * Decode each type appropriatelyk      */i       if (format_type == 1) {A 	lbn.lbn = 0 ;D 	lbn.lbn_overlay.hilbn = ptr->FM2$WORD_1.FM2$_FORMAT_1.FM2$V_HILBN ;6 	lbn.lbn_overlay.lolbn = ptr->FM2$WORD_2.FM2$W_LOLBN ; 	count.count = 0 ;: 	count.count = ptr->FM2$WORD_1.FM2$_FORMAT_1.FM2$V_COUNT ; 	*size = FM2$K_LENGTH1 ; 	*ecount = count.count+1 ; 	*elbn = lbn.lbn ;     }1!     else if (format_type == 2 ) {= 	lbn.lbn = 0 ;& 	lbn.lbn = ptr->FM2$WORD_2.FM2$L_LBN ; 	count.count = 0 ;, 	count.count = ptr->FM2$WORD_1.FM2$V_COUNT ; 	*size = FM2$K_LENGTH2 ; 	*ecount = count.count+1 ; 	*elbn = lbn.lbn ;     }W
     else { 	lbn.lbn = 0 ;4 	lbn.lbn = ptr->FM2$WORD_2.FM2$_FORMAT_3.FM2$L_LBN ; 	count.count = 0 ; 	count.count_overlay.locount = r;               ptr->FM2$WORD_2.FM2$_FORMAT_3.FM2$W_LOCOUNT ;iE         count.count_overlay.hicount = ptr->FM2$WORD_1.FM2$V_HICOUNT ;n 	*size = FM2$K_LENGTH3 ; 	*ecount = count.count+1 ; 	*elbn = lbn.lbn ;    } } & long gettime(word1,word2,date_string) unsigned long	word1 ;f unsigned long	word2 ;n char		*date_string ;   {sD /*                                                                */G /* This procedure converts a binary date in words word1 and word2 */   vD /* to a character string. Returns length of time string           */D /*                                                                */= /* word1	word1 of binary time                              */eD /* word2        word2 of binary time                              */D /* date_string  address of character field to return ascii date   */ /*								  */F     static  $DESCRIPTOR(date_desc," ") ;    /* dummy descriptor	    */I     unsigned long    dates[2] ;		    /* incase word1 and 2 not aligned */ :     long    timlen=0 ;			    /* return length of string */  ,     /* force alignment of word1 and word2 */       dates[0] = word1 ;     dates[1] = word2 ;  P     /* substitute destination address for string and its length in descriptor */  +     date_desc.dsc$a_pointer = date_string ;R"     date_desc.dsc$w_length  = 30 ;  '     /* go ahead and convert the date */i  0     SYS$ASCTIM(&timlen,&date_desc,&dates[0],0) ;  %     /* force the end of the string */   "     *(date_string+timlen) = '\0' ;  !     /* return length of string */L       return(timlen) ; }r long	recover_file(header,vbn)   char *header ; unsigned long vbn ;F /**II **  recover_file : This routine reads each header for the file and buildsaI **                 a table of the extents. It then checks the bitmap filesJ **                 to see if they are free, if so it goes through the list5 **                 and marks the blocks as allocated.F **N **                 Files up to 1000 extents can be processed.                  **! **  input:   header = file header ; **           vbn    = vbn of file header within INDEXF.SYS.  ***/    {     long first=1 ;'     static char disk_block[page_size] ; 2     static unsigned long extents[2][max_extents] ;     char *file_header ;e     long header_num ;L0     long num, ex_num, seq, ex_seq, rvn, ex_rvn ;     long no_extents ;O     long elbn, ecount ;S     long map_offset, map_size ;l+     long size,ssize,i,format_type, status ;,     char *map_struct ;#     struct  FH2$_STRUCT		    *fh2 ;-#     struct  FM2$_STRUCT		    *ptr ;_3     struct  FH2$_OFFSET_FIELDS	    *offset_fields ;d       /*      * Point to the file headerh      */E       no_extents = 0 ;     fh2 = header ;       /*      * First Headert      */e  !     num    = fh2->FH2$W_FID_NUM ;r     if(num != 0) {,        printf(" Header has been reused\n") ;        return(SS$_ABORT) ;     }=,     header_num = vbn - reserved_blocks + 1 ;  !     seq    = fh2->FH2$W_FID_SEQ ;A5     rvn    = fh2->FH2$FID_RVN_OVERLAY.FH2$W_FID_RVN ;R  *     while (1) {			/* while headers left */        if(first == 1)             file_header = header ;        elsee4 	  file_header = disk_block ;	/* alternate header */          fh2 = file_header ;  (        num = vbn - reserved_blocks + 1 ;  	        /*          * Next Header  	*/t  &        ex_num = fh2->FH2$W_EX_FIDNUM ;&        ex_seq = fh2->FH2$W_EX_FIDSEQ ;<        ex_rvn = fh2->FH2$EX_FIDRVN_OVERLAY.FH2$W_EX_FIDRVN ;  C        offset_fields = &fh2->FH2$OFFSET_OVERLAY.FH2$OFFSET_FIELDS ; 6        map_offset    = offset_fields->FH2$B_MPOFFSET ;3        map_struct    = file_header + map_offset*2 ;o-        map_size      = fh2->FH2$B_MAP_INUSE ;C  	        /* !         * Decode the extent table 
         */          size = map_size*2 ;        while (size > 0) {i 	  ptr = map_struct ; ; 	  format_type = ptr->FM2$WORD_1.FM2$_FORMAT.FM2$V_FORMAT ;s 	  if(format_type == 0) { / 	     map_struct = map_struct + FM2$K_LENGTH0 ;p# 	     size = size - FM2$K_LENGTH0 ;e 	  }	 	  else {i0 	     getlbn (map_struct,&elbn,&ecount,&ssize) ; 	     size = size - ssize ; ' 	     map_struct = map_struct + ssize ;v% 	     extents[0][no_extents] = elbn ;$' 	     extents[1][no_extents] = ecount ;  	     no_extents++ ; 	     if(no_extents > 999) {O 	        printf(" File too fragmented/too many extents - recovery aborted\n") ;  	        return(SS$_ABORT) ; 	     }n 	  }        }  	        /*i+         * If no multiple header continue onF 	*/L          if((ex_num == 0)&&F           (ex_seq == 0)&&             (ex_rvn == 0)) break ;          first = 0 ;  	        /*w         * Read Alternate Header  	*/f  +        vbn = ex_num + reserved_blocks - 1 ; /        status = read_indexf(vbn,1,disk_block) ;K"        if(status != RMS$_NORMAL) {D 	  printf(" Error reading multiple header - vbn = %d status = %d\n", 	         vbn,status) ;            return(SS$_ABORT) ;n        }  	        /*iF         * Check to see if Fid's match - if not it has been overwritten 	*/I          fh2 = disk_block ; G        if(((fh2->FH2$W_FID_NUM == ex_num)||(fh2->FH2$W_FID_NUM == 0))&&;*           (fh2->FH2$W_FID_SEQ == ex_seq)&&>           (fh2->FH2$FID_RVN_OVERLAY.FH2$W_FID_RVN == ex_rvn)&&) 	  (fh2->FH2$W_BK_FIDNUM == header_num)&&e" 	  (fh2->FH2$W_BK_FIDSEQ == seq)&&B 	  (fh2->FH2$BK_FIDRVN_OVERLAY.FH2$W_BK_FIDRVN == rvn)) continue ;	        /*=-         * Header doesn't match - return error1 	*/	  @        printf(" Not all headers intact in multiheader file\n") ;        return(SS$_ABORT) ;     }      /*:      * Ok we have the extent table - scan the bitmap file 4      * to check if file has been partly overwritten       */V  <      status = check_bitmap_file(&extents[0][0],no_extents) ;1      if(status != SS$_NORMAL) return(SS$_ABORT) ;i       /*4      * Ok we made it through pass 1 - file is intact-      * clear selected bits in the bitmap file)      */n  ;     status = clear_bitmap_file(&extents[0][0],no_extents) ;      if(status != SS$_NORMAL) {K        printf(" Error while clearing bitmap file - status = %d\n",status) ;	I        printf(" Have System Manager run ANALYSE/DISK/REPAIR to free up\n\e#  mis-allocated blocks on disk\n") ;         return(SS$_ABORT) ;     }W
     else {,        printf("     Recovered Extents:\n") ;!        for(i=0;i<no_extents;i++)  9           printf("       Lbn: %7d - %7d\n",extents[0][i],t1                  extents[0][i]+extents[1][i]-1) ;s     }a     return(SS$_NORMAL) ; }t, long check_bitmap_file(extents,no_extents) ' unsigned long extents[2][max_extents] ;  long no_extents ;  /** E **  check_bitmap_file : This routine checks the bitmap file to see if E **                      all clusters from a list of extents are free.  **& **  input:   extent = table of extents1 **           no_extents = no of extents in table.  ***/     {p     long     lbn, count, i ;     register long vbn ;r;     register long offset_pages, offset_bytes, offset_bits ;      register char *c ;     long cluster, status ;#     register unsigned long result ;      unsigned long mask ;     long oldvbn ;p  #     cluster = device_char.cluster ;      oldvbn = 0 ;     for(i=0;i<no_extents;i++) {e        lbn = extents[0][i] ;        count = extents[1][i] ;;        while (count > 0) {		/* scan all blocks in extent */_%           offset_bits = lbn/cluster ;V             /*)            * Calculate which page to read2E            * allow 1 for the SCB page (page 0) and 1 for current paget
            */   3           offset_pages= offset_bits/(8*page_size) ;E"           vbn = offset_pages + 2 ;@           offset_bits = offset_bits - offset_pages*8*page_size ;(           offset_bytes = offset_bits/8 ;'           offset_bits = offset_bits%8 ;i             /*L            * Now we know which page, byte and bit within byte is the cluster
            */	             if(oldvbn != vbn) {T1 	     status = read_bitmap(vbn,1,bitmap_buffer) ;.7              if(status != RMS$_NORMAL) return(status) ;            }\%           mask = (1 << offset_bits) ;M*           c = bitmap_buffer+offset_bytes ; 	  result = (long)(*c) & mask ; 4           if(result == 0) 		    /* cluster in use */               return(SS$_ABORT) ;           oldvbn = vbn ;           lbn = lbn + cluster ; #           count = count - cluster ;e        }     }m     return(SS$_NORMAL) ; }e, long clear_bitmap_file(extents,no_extents) ' unsigned long extents[2][max_extents] ;a long no_extents ;l /** K **  clear_bitmap_file : This routine marks clusters within the bitmap file m> **                      as allocated (from a list of extents). **& **  input:   extent = table of extents1 **           no_extents = no of extents in table.* ***/     {b     long     lbn, count, i ;     register long vbn ;p;     register long offset_pages, offset_bytes, offset_bits ;o     register char *c ;     long cluster, status ;     long mask ;t#     register unsigned long result ;      long oldvbn ;s     long modify ;b  #     cluster = device_char.cluster ;      oldvbn = 0 ;     modify = 0 ;     for(i=0;i<no_extents;i++) {         lbn = extents[0][i] ;        count = extents[1][i] ;;        while (count > 0) {		/* scan all blocks in extent */i%           offset_bits = lbn/cluster ;&             /*)            * Calculate which page to read E            * allow 1 for the SCB page (page 0) and 1 for current page 
            */.  3           offset_pages= offset_bits/(8*page_size) ; "           vbn = offset_pages + 2 ;@           offset_bits = offset_bits - offset_pages*8*page_size ;(           offset_bytes = offset_bits/8 ;'           offset_bits = offset_bits%8 ;M             /*L            * Now we know which page, byte and bit within byte is the cluster
            */e             if(oldvbn != vbn) {u: 	     if(modify == 1) {		/* did we modify the old page? */1 		status = write_bitmap(oldvbn,1,bitmap_buffer) ;M 		modify = 0 ; 	     }u1 	     status = read_bitmap(vbn,1,bitmap_buffer) ;V7              if(status != RMS$_NORMAL) return(status) ;t           }=%           mask = (1 << offset_bits) ;n*           c = bitmap_buffer+offset_bytes ; 	  result = (long)(*c) & mask ;04           if(result == 0) 		    /* cluster in use */               return(SS$_ABORT) ;# 	  else {			    /* clear the bit */a 	     *c = *c&(~mask) ;_2 	     modify = 1 ;		    /* mark page as changed */ 	  }           oldvbn = vbn ;           lbn = lbn + cluster ;(#           count = count - cluster ;n        }     }n7     if(modify == 1) 		/* did we modify the old page? */ 6        status = write_bitmap(oldvbn,1,bitmap_buffer) ;     return(SS$_NORMAL) ; }a( long load_file_into_directory(fileinfo)" struct fileinfo_struct *fileinfo ; /**gJ **  load_file_into_directory : This routine loads a file into a directory. **> **  input:   fileinfo = structure containing file information. ***/     {      long status ;      static char filename[255] ; "     static char newfilename[255] ;
     char *c ;c     long length ;e       /*      * Set up fab for this filet      */S  %    access_fab->fab$l_fna = filename ;r     access_fab->fab$b_fns = 255 ;'    strcpy(filename,dir_char.dir_spec) ;t(    strcat(filename,fileinfo->filename) ;  )    access_nam->nam$b_nop = NAM$V_SYNCHK ;e    access_fab->fab$l_dna = 0 ;    access_fab->fab$b_dns = 0 ;%    access_fab->fab$l_fna = filename ; -    access_fab->fab$b_fns = strlen(filename) ;n    access_fab->fab$l_fop = 0 ;    access_fab->fab$w_ifi = 0 ;'    access_nam->nam$l_esa = access_esa ;      access_nam->nam$b_ess = 255 ;%    access_nam->nam$l_rsa = filename ;,     access_nam->nam$b_rss = 255 ;    access_nam->nam$b_nop = 0 ;  '    status = SYS$PARSE(access_fab,0,0) ;r      access_fab->fab$w_ifi = 0 ;0    access_nam->nam$w_fid[0] = fileinfo->fidnum ;0    access_nam->nam$w_fid[1] = fileinfo->fidseq ;0    access_nam->nam$w_fid[2] = fileinfo->fidrvn ;/    access_nam->nam$w_did[0] = dir_char.fid[0] ;o/    access_nam->nam$w_did[1] = dir_char.fid[1] ;*/    access_nam->nam$w_did[2] = dir_char.fid[2] ;t      c = access_nam->nam$t_dvi ;5    *c = length = strlen(device_char.device_name) - 1;     c++ ;.    strncpy(c,device_char.device_name,length) ;      /* %     * Now enter it into the directorya     */  '    status = SYS$ENTER(access_fab,0,0) ;i    if(status == RMS$_FEX) { >       length = access_nam->nam$b_name+access_nam->nam$b_type ;7       strncpy(filename,access_nam->nam$l_name,length) ;*       filename[length] = '\0' ;u.       strcpy(access_nam->nam$l_esa,filename) ;#       access_nam->nam$b_ess = 255 ;o'       access_nam->nam$b_esl = length ;	m+       access_nam->nam$l_rsa = newfilename ;,#       access_nam->nam$b_rss = 255 ; *       status = SYS$ENTER(access_fab,0,0) ;       /*        * Get the new filename 	        */_1       newfilename[access_nam->nam$b_rsl] = '\0' ;t!       if(status == RMS$_NORMAL) {          c = newfilename ; 3 	while (*c != '\0') if(*c == ':') break ; else c++; , 	if(*c == '\0') c = newfilename ; else c++ ;% 	printf(" Recovered file as %s\n",c);b       }d    }    if(status != RMS$_NORMAL) {L       printf(" Error entering file into directory - status = %x\n",status) ;H        printf(" Have System Manager run ANALYSE/DISK/REPAIR to finish\n\  recovering file\n") ;    }	    else { )       status = SYS$OPEN(access_fab,0,0) ; *       status = SYS$CLOSE(access_fab,0,0) ;    }    return(status) ;a }  long exit_handler (status)r long *status ;     {-(     static $DESCRIPTOR(message_dsc,"") ;     static char message[120] ;     static long length ;      static long close_indexf=0 ;      static long close_bitmap=0 ;     static FILE *outfile ;     static long priority ;  )     message_dsc.dsc$a_pointer = message ;S%     message_dsc.dsc$w_length  = 120 ;f     2     SYS$GETMSG(*status,&length,&message_dsc,0,0) ;     message[length] = '\0' ;       /*!      * Do we have to close files?       */        if(indexf_file_open) {$ 	close_file(indexf_fab,indexf_rab) ; 	close_indexf = 1 ;i     }e       if(bitmap_file_open) {$ 	close_file(bitmap_fab,bitmap_rab) ; 	close_bitmap = 1 ;A     }        /*-      * Ok now report the status if not normal       */G;     if((*status != SS$_NORMAL)&&(*status != RMS$_NORMAL)) {i*        outfile = fopen("Sys$Output","w") ;L        fprintf(outfile," Undelete Program Abort - recovery in progress\n") ;        if(close_indexf)e9 	  fprintf(outfile," Forced closing INDEXF.SYS file\n") ;         if(close_bitmap) 9 	  fprintf(outfile," Forced closing BITMAP.SYS file\n") ;e(        fprintf(outfile,"%s\n",message) ;        fclose(outfile) ;	     }          /*      * Reset Process Priority       */n       if(priority_raised) {F        while (1) {4 	  status = SYS$SETPRI(0,0,old_priority,&priority) ; 	  if(status == SS$_NOPRIV) { , 	     status = SYS$SETPRI(0,0,4,&priority) ;  	     if(status == SS$_NORMAL) { 	        priority_raised = 0 ;	 		break ;               } 	     priority_raised = 1 ; 
 	     break ;! 	  } 	  if(status == SS$_NORMAL) {e"              priority_raised = 0 ;
 	     break ;  	  } 	  if(priority_raised) {< 	  /* we couldn't lower it from real time so kill the job */ 	      SYS$DELPRC(0,0) ; 	  } 	  exit(0) ;        }     }  }  long raise_priority ()     {     long status ;D  #     if(priority_raised) return(1) ;      while (1) { 2        status = SYS$SETPRI(0,0,16,&old_priority) ;!        if(status == SS$_NOPRIV) {e           priority_raised = 0 ;M
 	  break ;        }!        if(status == SS$_NORMAL) {            priority_raised = 1 ;W
 	  break ;        }Q        printf(" An impossible error code was returned from SETPRI status = %x\n",                status) ;         exit_handler(&status) ;        exit(0) ;     }) }       	                long lower_priority ()b    {     long status ;      static long priority ;       if(priority_raised) {         while (1) {4 	  status = SYS$SETPRI(0,0,old_priority,&priority) ; 	  if(status == SS$_NOPRIV) {u, 	     status = SYS$SETPRI(0,0,4,&priority) ;  	     if(status == SS$_NORMAL) { 	        priority_raised = 0 ;	 		break ;f              } 	     priority_raised = 1 ;i
 	     break ;0 	  } 	  if(status == SS$_NORMAL) {$"              priority_raised = 0 ;
 	     break ;t 	  }M 	  printf(" An impossible error code was returned from SETPRI status = %x\n",/               status) ;e 	  exit_handler(&status) ; 	  " 	  exit(0) ;        }     }; }       	               