4       SUBROUTINE AKIMA(XIN,YIN,NIN,XOUT,YOUT,NOUT,*) C  C     LIBRARY-ROUTINE  C = C                                                29/JULY/1980 > C                                                C.J. KOST SIN C    C     reqd. routines - NONE  C 8 C======================================================= C / C    CURVE FITTING BASED ON LOCAL PROCEDURES OF 2 C    H. AKIMA (JOURNAL OF ACM VOL 17,4,P589 (1970)= C     INPUT: XIN  REAL*8 array NIN long specifies independent F C                 variable. XIN must be strictly MONOTONIC INCREASING.; C            YIN  REAL*8 array NIN long specifies dependent  C                 variable. < C            XOUT REAL*8 array NOUT long specifies locations< C                 of independent variable where we desire to< C                 have the interpolations. If XOUT monotonic> C                 (RANDOM IS ALLOWED) routine will run faster.2 C            NOUT Number of desired output points.) C            NIN  Number of input points. 7 C     OUTPUT: YOUT REAL*8 array NOUT long returning the @ C                  interpolated value of the dependent variable.4 C     LIMITS:   NIN set for MAXIMUM of 10000   !!!!!B CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC       IMPLICIT REAL*8 (A-H,O-Z) -       DIMENSION XIN(1),YIN(1),XOUT(1),YOUT(1)  C 4 C  FOLLOWING DIMENSIONS SET FOR MAXIMUM NIN OF 10000 C #       DIMENSION YP(10000),DM(10000)  C  C  C   FUNTION STATEMENT FOLLOWS  C 9       FUNC(W,H,Y1,Y2,YP1,YP2)=Y1+W*H*YP1+W*W*(3.*(Y2-Y1)- 6      # H*(YP2+2.*YP1))+(H*(YP2+YP1)-2.*(Y2-Y1))*(W**3) C  C  C    IF NIN < 3 RETURN 15 C   CHECK IF XIN MONOTONIC INCREASING RETURN 1 IF NOT  C        IF(NIN .LT.3) RETURN 1       DO 10 I=2,NIN (       IF(XIN(I)-XIN(I-1).LE.0.) RETURN 1   10  CONTINUE C - C   EVALUATE DERIVATIVES ACCORDING TO "AKIMA"  C        NINM1=NIN-1        NINM2=NIN-2        DO 15 I=1,NINM1 /       DM(I)=(YIN(I+1)-YIN(I))/(XIN(I+1)-XIN(I))    15  CONTINUE       DO 16 I=2,NINM2        DM1=DABS(DM(I+1)-DM(I))        DM2=DABS(DM(I-1)-DM(I-2)) 5       IF( (DM1+DM1) .EQ. 0.) YP(I)=.5*(DM(I-1)+DM(I)) D       IF( (DM1+DM2) .NE. 0.) YP(I)=(DM1*DM(I-1)+DM2*DM(I))/(DM1+DM2)   16  CONTINUE       YP(1)=.5*(3.*DM(1)-DM(2))        DM1=DABS(DM(1)-DM(2))        DM2=DABS(DM(2)-DM(3)) (       IF( (DM1+DM2) .EQ. 0.) YP(2)=DM(1)B       IF( (DM1+DM2) .NE. 0.) YP(2)=(DM1*DM(2)+DM2*DM(1))/(DM1+DM2))       YP(NIN)=.5*(3.*DM(NIN-1)-DM(NIN-2)) #       DM1=DABS(DM(NIN-1)-DM(NIN-2)) #       DM2=DABS(DM(NIN-2)-DM(NIN-3)) ,       IF((DM1+DM2).EQ.0.)YP(NIN-1)=DM(NIN-1)H       IF((DM1+DM2).NE.0.)YP(NIN-1)=(DM1*DM(NIN-2)+DM2*DM(I-1))/(DM1+DM2) C  C 2 C  CHECK IF XOUT MONOTONIC INCREASING (RANDOM XOUT/ C  WILL BE ALLOWED BUT ROUTINE THEN MUCH SLOWER  C        DO 20 J=2,NOUT*       IF(XOUT(J)-XOUT(J-1).LT.0.) GO TO 50   20  CONTINUE C & C   USE FAST ALGORITHM FOR XOUT SEARCH C   (SINCE MONOTONIC)  C  C   I USED FOR INPUT XIN C   J USED FOR OUTPUT XOUT C 	       I=1 	       J=0    22  J=J+1 $       IF(XOUT(J).GE.XIN(I)) GO TO 25 C  C   LOWER EXTRAPOLATION  C        H=XIN(2)-XIN(1)        W=(XOUT(J)-XIN(1))/H5       YOUT(J)=FUNC(W,H,YIN(I),YIN(I+1),YP(I),YP(I+1))        GO TO 22   25  I=I+1        IF(I.GT.NIN) GO TO 40 $   24  IF(XOUT(J).GT.XIN(I)) GO TO 25 C  C  INTERIOR POINT  C        H=XIN(I)-XIN(I-1)        W=(XOUT(J)-XIN(I-1))/H5       YOUT(J)=FUNC(W,H,YIN(I-1),YIN(I),YP(I-1),YP(I))        J=J+1        IF(J.GT.NOUT) GO TO 99       GO TO 24 C  C   UPPER EXTRAPOLATION  C    40  I=NIN        H=XIN(NIN)-XIN(NIN-1)        W=(XOUT(J)-XIN(NIN-1))/H=       YOUT(J)=FUNC(W,H,YIN(NIN-1),YIN(NIN),YP(NIN-1),YP(NIN))        J=J+1        IF(J.GT.NOUT) GO TO 99       GO TO 40 C ! C   XOUT NOT MONOTONIC INCREASING  C 	   50  J=0    51  J=J+1 $       IF(XOUT(J).GE.XIN(1)) GO TO 55 C  C  LOWER EXTRAPOLATION C        H=XIN(2)-XIN(1)        W=(XOUT(J)-XIN(1))/H1       YOUT(J)=FUNC(W,H,YIN(1),YIN(2),YP(1),YP(2))        GO TO 51&   55  IF(XOUT(J).LE.XIN(NIN)) GO TO 60 C  C    UPPER EXTRAPOLATION C        H=XIN(NIN)-XIN(NIN-1)        W=(XOUT(J)-XIN(NIN-1))/H=       YOUT(J)=FUNC(W,H,YIN(NIN-1),YIN(NIN),YP(NIN-1),YP(NIN))        GO TO 51 C  C   INTERIOR POINT C    60  DO 65 I=2,NIN &       IF(YOUT(J) .LE. XIN(I)) GO TO 66   65  CONTINUE   66  H=XIN(I)-XIN(I-1)        W=(XOUT(J)-XIN(I-1))/H=       YOUT(J)=FUNC(W,H,YIN(NIN-1),YIN(NIN),YP(NIN-1),YP(NIN))E       GO TO 51   99  RETURN	       END 