:       SUBROUTINE APLOT(X,Y,CHAR,MASK,NPT,XMIN,XMAX,NLXINC,<      *                 YMIN,YMAX,NLYINC,MINX,MAXX,MINY,MAXY,=      *                 XLAB,NXLAB,YLAB,NYLAB,IAXIS,IDEV,IOUT)  C - C     reqd. KOSTL: routines - BTD,EQUC,REALCH  C A C================================================================ A C================================================================ A C==                                                            == A C==   APLOT: ("ALPHA-NUMERIC PLOTTER"):                        == A C==   PLOTS THE "NPT" POINTS STORED IN THE ARRAYS X & Y,       == A C==   (USING THE "NPT" PLOT CHARACTERS DEFINED BY "CHAR" &     == A C==   "MASK"), ONTO THE DEVICE "IDEV" ATTACHED TO THE OUTPUT   == A C==   UNIT "IOUT", WITHIN THE PLOT COLUMN RANGE: MINX TO MAXX, == A C==   AND THE LINE RANGE: MINY TO MAXY. THE PLOT WINDOW IS     == A C==   MAXX-MINX+1 COLUMNS BY MAXY-MINY+1 LINES. "APLOT" ALSO   == A C==   PRINTS THE X & Y AXES. THE PLOT WINDOW CONTAINS THE X-AXIS= A C==   AND THE Y-AXIS LABELS AND NUMBERS AS WELL AS THE PLOT AND== A C==   ITS AXES. TO OBTAIN THE SMALL INTERNAL PLOT WINDOW       == A C==   DIMENSIONS WHICH GIVE THE LENGTH IN COLUMNS OF THE X-AXIS== A C==   AND THE LENGTH IN LINES OF THE Y-AXIS, ONE CAN USE THE   == A C==   SUBROUTINE "AWIND" (SEE "AWIND" FOR FURTHER INFORMATION)=== A C==                                                            == A C==   NOTE: THE ORIGIN (IX,IY)=(1,1) IS AT THE TOP LEFT-HAND   == A C==   CORNER OF THE DEVICE, I.E. THE COLUMN INDEX IX INCREASES == A C==   FROM LEFT TO RIGHT AND THE LINE INDEX IY INCREASES FROM  == A C==   TOP TO BOTTOM. HENCE MINX,MINY IS AT THE TOP LEFT-HAND   == A C==   CORNER OF THE PLOT WINDOW.                               == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., FEB. 18, 1980.  == A C==                                                            == A C==   INPUT  PARAMETERS: X(NPT),Y(NPT),XMIN,XMAX,YMIN,YMAX (R*4)= A C==                      CHAR(NPT),XLAB(NXLAB),YLAB(NYLAB) (L*1)= A C==                      MASK,NPT,NLXINC,NLYINC,MINX,MAXX,MINY,== A C==                      MAXY,NXLAB,NYLAB,IAXIS,IDEV,IOUT (I*4)== A C==                                                            == A C==   OUTPUT PARAMETERS: XMIN,XMAX,YMIN,YMAX, (R*4).           == A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   X    : ARRAY OF X COORDINATES OF POINTS TO BE PLOTTED.   == A C==                                                            == A C==   Y    : ARRAY OF Y COORDINATES OF POINTS TO BE PLOTTED.   == A C==                                                            == A C==   CHAR : ARRAY OF PLOT CHARACTERS TO BE PRINTED AT EACH    == A C==          X,Y LOCATION.                                     == A C==                                                            == A C==   THE PLOT CHARACTER ARRAY: CHAR(NPT) CAN CONTAIN ANY      == A C==   CHARACTERS. A BLANK CHARACTER IS RECOGNIZED AS A BLANK,  == A C==   I.E. IT CAN BE USED TO BLANK OUT CHARACTERS ON THE PLOT. == A C==   THERE ARE ALSO 2 SPECIAL CHARACTERS WHICH AREN'T PLOTTED:== A C==   "<" : THIS CHARACTER SIGNIFIES THAT A 1/4-CHARACTER      == A C==         VISUAL RESOLUTION CHARACTER IS TO BE USED IN THE   == A C==         CELL, I.E. ONE OF THE 4 CHARACTERS: (.,:').        == A C==   ">" : THIS CHARACTER SIGNIFIES THAT A 1/10-CHARACTER     == A C==         DIGITAL RESOLUTION CHARACTER IS TO BE USED IN THE  == A C==         CELL, I.E. ONE OF THE 10 DIGITS: (0,1,2,3,4,5,6,7, == A C==         8,9).                                              == A C==                                                            == A C==   MASK : FLAG TO INDICATE HOW TO USE THE CHARACTER ARRAY,  == A C==          I.E.:                                             == A C==          IF MASK = 0 --> USE ENTIRE "CHAR" ARRAY OF NPT    ==LA C==                          POINTS FOR PLOTTING CHARACTERS.   ==,A C==                  = 1 --> USE THE SINGLE CHARACTER "CHAR(1)"==,A C==                          FOR PLOTTING ALL THE POINTS, I.E. ==,A C==                          ONLY A SINGLE CHARACTER NEED BE   ===A C==                          PASSED TO "APLOT" IN THIS CASE.   ===A C==                  = N --> USE THE SINGLE CHARACTER "CHAR(1)"== A C==                 (N>=2)   FOR PLOTTING ALL THE POINTS, WITH == A C==                          EVERY N'TH POINT OVERLAID (MASKED)== A C==                          WITH "CHAR(2)". HERE TWO CHARACTERS= A C==                          ONLY NEED BE PASSED TO "APLOT".   == A C==                                                            ==MA C==   NPT  : NUMBER OF POINTS IN THE X,Y,CHAR ARRAYS.          ==WA C==                                                            ==AA C==   XMIN : MINIMUM X-VALUE OF THE X-AXIS SCALE, (NOT CHANGED ==AA C==          IF XMIN < XMAX, I.E. NO X-AUTOMATIC SCALING).     ==SA C==                                                            == A C==   XMAX : MAXIMUM X-VALUE OF THE X-AXIS SCALE, (NOT CHANGED == A C==          IF XMIN < XMAX, I.E. NO X-AUTOMATIC SCALING).     ==CA C==                                                            == A C==          IF XMIN => XMAX, THEN "APLOT" USES SUBROUTINE     == A C==          "AUTO" TO PERFORM AUTOMATIC SCALING OF THE X-AXIS ==PA C==          "XMIN" & "XMAX". IN THIS CASE "XMIN" & "XMAX" ARE == A C==          ASSIGNED NEW VALUES AS OUTPUT PARAMETERS.         ==CA C==          IF XMIN < XMAX, THEN NO X-AXIS AUTOMATIC SCALING  ==PA C==          IS DONE AND "APLOT" USES THE INPUT PARAMETERS     == A C==          "XMIN" & "XMAX" AS DEFINED ON INPUT.              == A C==                                                            ==BA C==   NLXINC: NUMBER OF LARGE X-INCREMENTS ON THE X-AXIS,      == A C==           I.E. THE X-AXIS IS SUB-DIVIDED INTO "NLXINC"     ==YA C==           INCREMENTS AT WHICH THE X-AXIS SCALE NUMBERS ARE ==AA C==           PRINTED.                                         ==IA C==                                                            ==DA C==   YMIN : MINIMUM Y-VALUE OF THE Y-AXIS SCALE, (NOT CHANGED == A C==          IF YMIN < YMAX, I.E. NO Y-AUTOMATIC SCALING).     ==4A C==                                                            == A C==   YMAX : MAXIMUM Y-VALUE OF THE Y-AXIS SCALE, (NOT CHANGED == A C==          IF YMIN < YMAX, I.E. NO Y-AUTOMATIC SCALING).     == A C==                                                            == A C==          IF YMIN => YMAX, THEN "APLOT" USES SUBROUTINE     ==BA C==          "AUTO" TO PERFORM AUTOMATIC SCALING OF THE Y-AXIS == A C==          "YMIN" & "YMAX". IN THIS CASE "YMIN" & "YMAX" ARE ==BA C==          ASSIGNED NEW VALUES AS OUTPUT PARAMETERS.         == A C==          IF YMIN < YMAX, THEN NO Y-AXIS AUTOMATIC SCALING  ==EA C==          IS DONE AND "APLOT" USES THE INPUT PARAMETERS     == A C==          "YMIN" & "YMAX" AS DEFINED ON INPUT.              == A C==                                                            ==TA C==   NLYINC: NUMBER OF LARGE Y-INCREMENTS ON THE Y-AXIS,      == A C==           I.E. THE Y-AXIS IS SUB-DIVIDED INTO "NLYINC"     == A C==           INCREMENTS AT WHICH THE Y-AXIS SCALE NUMBERS ARE ==RA C==           PRINTED.                                         ==HA C==                                                            ==UA C==   MINX : MINIMUM X (COLUMN) OF THE PLOT WINDOW.            ==.A C==                                                            ==CA C==   MAXX : MAXIMUM X (COLUMN) OF THE PLOT WINDOW.            == A C==                                                            ==,A C==   MINY : MINIMUM Y (LINE)   OF THE PLOT WINDOW.            == A C==                                                            == A C==   MAXY : MAXIMUM Y (LINE)   OF THE PLOT WINDOW.            ==AA C==                                                            == A C==   XLAB : NXLAB CHARACTERS WHICH MAKE UP THE X-AXIS LABEL.  ==RA C==                                                            ==CA C==   NXLAB: NUMBER OF CHARACTERS IN XLAB. (MAY BE <= 0 IN     ==CA C==          WHICH CASE NO LABEL IS PRINTED).                  == A C==                                                            ==TA C==   YLAB : NYLAB CHARACTERS WHICH MAKE UP THE Y-AXIS LABEL.  == A C==                                                            ==CA C==   NYLAB: NUMBER OF CHARACTERS IN YLAB. (MAY BE <= 0 IN     == A C==          WHICH CASE NO LABEL IS PRINTED).                  ==RA C==                                                            == A C==   IAXIS: FLAG WHICH CONTROLS THE ORDER IN WHICH THE POINTS ==TA C==          ARE PLOTTED AND THE AXES ARE PRINTED. THE SIGN OF == A C==          IAXIS CONTROLS THE INTERNAL PLOT BUFFER OUTPUT FOR==AA C==          IDEV = 0 OR -1 (NON-ADDRESSABLE DEVICES).         == A C==                                                            == A C==   |IAXIS|=1: THE AXES ARE PRINTED FIRST AND THE POINTS ARE ==SA C==              PLOTTED LAST.                                 == A C==   |IAXIS|=2: THE POINTS ARE PLOTTED WITHOUT PRINTING AXES. == A C==              THIS MODE IS USEFUL FOR OVERLAYING PLOTS.     ==SA C==   |IAXIS|=3: THE POINTS ARE PLOTTED FIRST AND THE AXES ARE == A C==              PRINTED LAST.                                 ==UA C==   |IAXIS|=4: THE AXES ARE PRINTED WITHOUT PLOTTING POINTS. ==OA C==                                                            == A C==   IF IAXIS > 0 THEN APLOT POSITIONS THE CURSOR IN COLUMN 1 ==TA C==   AT THE BOTTOM LINE+1 OF THE PLOT WHEN IDEV > 0, OR IT    ==AA C==   PRINTS OUT THE CORRESPONDING INTERNAL PLOT BUFFER ON UNIT==AA C==   IOUT WHEN IDEV <= 0.                                     == A C==   IF IAXIS < 0 THEN APLOT NEITHER POSITIONS THE CURSOR WHEN== A C==   IDEV > 0, NOR PRINTS OUT THE INTERNAL PLOT BUFFER WHEN   == A C==   IDEV <= 0.                                               == A C==                                                            ==EA C==   IDEV : DEVICE TYPE ONTO WHICH THE PLOT IS TO BE PRINTED. == A C==          TO CLEAR THE DEVICE "IDEV" USE: SUBROUTINE        == A C==          "ACLEAR(IDEV,IOUT)".                              == A C==                                                            ==SA C==   DEVICE TYPES ARE:                                        == A C==                                                            == A C==   IDEV=-1: LARGE INTERNAL PLOT BUFFER ARRAY "LBUFF" IN     ==SA C==            COMMON /LBUFF/. THIS BUFFER IS NXLBUF (=132)    == A C==            COLUMNS BY NYLBUF (=66) LINES, I.E. ONE 15"X11" ==UA C==            PAGE, (USUALLY A PRINTER HARDCOPY).             ==OA C==                                                            == A C==   IDEV=0 : SMALL INTERNAL PLOT BUFFER ARRAY "SBUFF" IN     ==TA C==            COMMON /SBUFF/. THIS BUFFER IS NXSBUF (=80)     ==AA C==            COLUMNS BY NYSBUF (=40) LINES, I.E. ONE SCREEN  ==AA C==            PAGE, (USUALLY A SCREEN COPY ON A NON-CURSOR    == A C==            ADDRESSABLE TERMINAL).                          == A C==                                                            == A C==   THE FOLLOWING DEVICES ARE CURSOR ADDRESSABLE:            == A C==                                                            ==EA C==   IDEV=1 : TEKTRONIX 4023 TERMINAL.                        == A C==   IDEV=2 : ANN ARBOR TERMINAL.                             == A C==   IDEV=3 : SOROC (IQ-120) TERMINAL.                        ==WA C==   IDEV=4 : COMTERM (ADM-1) TERMINAL.                       == A C==   IDEV=5 : LANPARSCOPE 100 TERMINAL.                       ==WA C==   IDEV=6 : VT100 TERMINAL.                                 == A C==                                                            ==WA C==   IOUT : OUTPUT UNIT ATTACHED TO DEVICE IDEV.              == A C==                                                            ==WA C==                                                            == A C==   PARAMETERS FOR CONTROLLING THE FORMAT OF THE AXES:       ==-A C==   ---------- --- ----------- --- ------ -- --- ----        == A C==                                                            ==EA C==   COMMON BLOCK /APLOTC/ ("APLOT COMMON") PARAMETERS:       == A C==   (DEFAULTS SHOWN IN "/ /"'S)                              == A C==                                                            ==-A C==   NXDIG/5/,NXDEC/1/,IPOWX/0/,PXAUTO/.TRUE./,XCROSS/.TRUE./,== A C==   NYDIG/4/,NYDEC/1/,IPOWY/0/,PYAUTO/.TRUE./,YCROSS/.TRUE./,==EA C==   GRID/.FALSE./.                                           == A C==                                                            == A C==   NXDIG,NXDEC,IPOWX (I*4); PXAUTO,XCROSS (L*4);            ==CA C==   NYDIG,NYDEC,IPOWY (I*4); PYAUTO,YCROSS,GRID (L*4).       ==.A C==                                                            ==FA C==   NXDIG : NUMBER OF DIGITS IN THE X-AXIS NUMBER FORMAT.    ==CA C==   NYDIG : NUMBER OF DIGITS IN THE Y-AXIS NUMBER FORMAT.    == A C==   NXDEC : NUMBER OF DECIMALS IN THE X-AXIS NUMBER FORMAT.  ==HA C==   NYDEC : NUMBER OF DECIMALS IN THE Y-AXIS NUMBER FORMAT.  == A C==           IF NXDEC OR NYDEC < 0 THEN THE DECIMAL POINT IS  ==RA C==           SUPPRESSED. IF NXDEC OR NYDEC = 0 THEN THERE ARE ==NA C==           NO DECIMAL PLACES BUT THE DECIMAL POINT IS NOT   == A C==           SUPPRESSED.                                      == A C==   IPOWX : POWER (BASE 10) BY WHICH X-AXIS NUMBERS ARE      ==TA C==           SCALED DOWN, IF PXAUTO = .FALSE..                == A C==   IPOWY : POWER (BASE 10) BY WHICH Y-AXIS NUMBERS ARE      ==RA C==           SCALED DOWN, IF PYAUTO = .FALSE..                ==>A C==           IF THE POWER IPOW (BASE 10), USED TO SCALE DOWN  ==BA C==           THE NUMBERS ON AN AXIS, IS NON-ZERO THEN IT IS   == A C==           PRINTED WITH THE AXIS LABEL AS *10**IPOW, I.E.   ==HA C==           THE AXIS VALUES ARE THE AXIS NUMBERS MULTIPLIED  ==BA C==           BY 10**IPOW.                                     == A C==   PXAUTO: IF PXAUTO=.TRUE. THEN IPOWX WILL BE CHOSEN AUTO- == A C==           MATICALLY SO THAT THE MAXIMUM NUMBER OF SIGNI-   ==OA C==           CANT DIGITS WILL APPEAR IN THE X-AXIS FORMAT.    ==OA C==           IF PXAUTO=.FALSE. THEN THE X-AXIS POWER IS FIXED == A C==           TO THE VALUE OF IPOWX.                           == A C==   PYAUTO: IF PYAUTO=.TRUE. THEN IPOWY WILL BE CHOSEN AUTO- == A C==           MATICALLY SO THAT THE MAXIMUM NUMBER OF SIGNI-   == A C==           CANT DIGITS WILL APPEAR IN THE Y-AXIS FORMAT.    ==LA C==           IF PYAUTO=.FALSE. THEN THE Y-AXIS POWER IS FIXED ==BA C==           TO THE VALUE OF IPOWY.                           ==.A C==   XCROSS: IF XCROSS=.TRUE. THEN THE Y-AXIS (OR AXES IN THE ==.A C==           CASE WHEN GRID=.TRUE.) IS ALLOWED TO CROSS THE   == A C==           INNER TIC MARKS OF THE X-AXIS.                   ==SA C==           IF XCROSS=.FALSE. THEN THE Y-AXIS IS ONLY ALLOWED==BA C==           TO CROSS THE X-AXIS AT THE WINDOW COLUMN LIMITS: ==.A C==           MINX AND MAXX.                                   ==NA C==   YCROSS: IF YCROSS=.TRUE. THEN THE X-AXIS (OR AXES IN THE == A C==           CASE WHEN GRID=.TRUE.) IS ALLOWED TO CROSS THE   == A C==           INNER TIC MARKS OF THE Y-AXIS.                   ==EA C==           IF YCROSS=.FALSE. THEN THE X-AXIS IS ONLY ALLOWED== A C==           TO CROSS THE Y-AXIS AT THE WINDOW LINE LIMITS:   == A C==           MINY AND MAXY.                                   == A C==   GRID  : IF GRID = .FALSE. THEN ONLY THE 2 REGULAR X & Y  == A C==           AXES ARE PRINTED.                                == A C==           IF GRID = .TRUE. THEN A GRID OF X & Y AXES ARE   == A C==           PRINTED WHICH JOIN THE X-TIC AND Y-TIC MARKS     == A C==           DEPENDING ON THE SETTINGS OF XCROSS & YCROSS.    == A C==           ONLY ONE OF EACH OF THE X & Y AXES ARE LABELED.  ==  C==  							       == A C==   EXAMPLES USING XCROSS,YCROSS, AND GRID:                  == A C==                                                            == A C==   1) GRID=.FALSE.: ONLY ONE OF EACH AXIS WILL BE PRINTED.  == A C==     A) XCROSS=.TRUE. & YCROSS=.TRUE.: REGULAR AXES CROSSING== A C==        THROUGH X=0 AND Y=0 IF POSSIBLE.                    == A C==     B) XCROSS=.FALSE.: Y-AXIS PRINTED AT THE LEFT OF THE   == A C==                        PLOT WINDOW.                        == A C==     C) YCROSS=.FALSE.: X-AXIS PRINTED AT THE BOTTOM OF     == A C==                        THE PLOT WINDOW.                    == A C==   2) GRID=.TRUE.: 2 OR MORE OF EACH AXES WILL BE PRINTED.  == A C==     A) XCROSS=.FALSE. & YCROSS=.FALSE.: AXES FORM A BOX    == A C==        AROUND THE PLOT WINDOW. ONLY THE BOTTOM AND FAR LEFT== A C==        AXES WILL BE LABELED.                               == A C==     B) XCROSS=.TRUE.: GRID OF VERTICAL Y-AXES JOINING X-TIC== A C==                       MARKS WILL BE PRINTED.               == A C==     C) YCROSS=.TRUE.: GRID OF HORIZONTAL X-AXES JOINING    == A C==                       Y-TIC MARKS WILL BE PRINTED.         == A C==                                                            == A C================================================================ A C================================================================        REAL X(1),Y(1)'       LOGICAL*1 CHAR(1),XLAB(1),YLAB(1)=.       LOGICAL PXAUTO,PYAUTO,XCROSS,YCROSS,GRIDA C================================================================ A C==   FOR A DESCRIPTION OF /APLOTC/ ("APLOT COMMON BLOCK") SEE ==BA C==   ABOVE.                                                   == A C==   FOR A DESCRIPTION OF /APLOTX/ ("APLOT EXTRA") SEE "AAXIS".=BA C================================================================ 6       COMMON /APLOTC/ NXDIG,NXDEC,IPOWX,PXAUTO,XCROSS,:      *                NYDIG,NYDEC,IPOWY,PYAUTO,YCROSS,GRID1       DATA NXDIG,NXDEC,IPOWX,PXAUTO/5,1,0,.TRUE./ 1       DATA NYDIG,NYDEC,IPOWY,PYAUTO/4,1,0,.TRUE./H4       DATA XCROSS,YCROSS,GRID/.TRUE.,.TRUE.,.FALSE./!       COMMON /APLOTX/ IXLAB,IYLAB*       DATA IXLAB,IYLAB/-1,-1/ A C================================================================HA C==   INITIALIZE "IXLAB" & "IYLAB" TO -1 SO THAT "AAXIS" WILL  ==OA C==   ALWAYS PRINT THE X-AXIS LABELS AND NUMBERS BELOW THE     == A C==   X-AXIS, AND THE Y-AXIS NUMBERS WILL ALWAYS BE PRINTED TO ==EA C==   THE LEFT OF THE Y-AXIS.                                  == A C================================================================H       IXLAB=-1       IYLAB=-1A C================================================================AA C==   CALL "AWIND" ("APLOT WINDOW CONVERSION") WHICH CONVERTS  ==FA C==   XMIN,XMAX,NLXINC,YMIN,YMAX,NLYINC,MINX,MAXX,MINY,MAXY TO ==OA C==   XINC,YINC,NSXINC,NSYINC,MMINX,MMAXX,MMINY,MMAXY, I.E.    ==FA C==   "AWIND" CONVERTS FROM THE LARGE WINDOW (AS PASSED TO     ==AA C==   "APLOT") TO THE SMALLER INTERNAL WINDOW (AS PASSED TO    ==NA C==   "AUTO", "AAXIS", AND "APLT").                            ==FA C================================================================O=       CALL AWIND(XMIN,XMAX,NLXINC,YMIN,YMAX,NLYINC,MINX,MAXX, D      *MINY,MAXY,XINC,YINC,NSXINC,NSYINC,MMINX,MMAXX,MMINY,MMAXY,&60)A C================================================================ A C==   DEFINE "XINCL" & "YINCL", THE LARGE X AND Y INCREMENTS.  == A C==   IF XINC.LE.0 OR YINC.LE.0 PERFORM AUTOMATIC SCALING ON   == A C==   THE LARGE INCREMENTS.                                    == A C================================================================        XINCL=XINC*NSXINC        YINCL=YINC*NSYINC <       CALL AUTO(X,Y,NPT,XMIN,XINCL,YMIN,YINCL,NLXINC,NLYINC)A C================================================================ A C==   IF AUTOMATIC SCALING THEN REDEFINE "XMAX", "YMAX",       ==EA C==   "XINC", AND "YINC".                                      == A C================================================================ *       IF(XINC.LE.0.)XMAX=XMIN+NLXINC*XINCL*       IF(YINC.LE.0.)YMAX=YMIN+NLYINC*YINCL%       IF(XINC.LE.0.)XINC=XINCL/NSXINC,%       IF(YINC.LE.0.)YINC=YINCL/NSYINC A C================================================================ A C==   GO TO THE APPROPRIATE SECTION DEPENDING ON |IAXIS|.      == A C================================================================        IGO=IABS(IAXIS)A       GO TO (10,20,30,40),IGO A C================================================================FA C==   PRINT THE AXES.                                          == A C================================================================ ? 10    CALL AAXIS(XMIN,XINC,NSXINC,YMIN,YINC,NSYINC,MMINX,MMAXX, =      *           MMINY,MMAXY,XLAB,NXLAB,YLAB,NYLAB,IDEV,IOUT) A C================================================================FA C==   PLOT THE POINTS.                                         ==MA C================================================================ B 20    CALL APLT(X,Y,CHAR,MASK,NPT,XMIN,XINC,YMIN,YINC,MMINX,MMAXX,'      *           MMINY,MMAXY,IDEV,IOUT)        GO TO 50A C================================================================OA C==   PLOT THE POINTS.                                         ==IA C================================================================ B 30    CALL APLT(X,Y,CHAR,MASK,NPT,XMIN,XINC,YMIN,YINC,MMINX,MMAXX,'      *           MMINY,MMAXY,IDEV,IOUT)=A C================================================================1A C==   PRINT THE AXES.                                          ==UA C=================================================================? 40    CALL AAXIS(XMIN,XINC,NSXINC,YMIN,YINC,NSYINC,MMINX,MMAXX, =      *           MMINY,MMAXY,XLAB,NXLAB,YLAB,NYLAB,IDEV,IOUT) A C================================================================OA C==   IF IAXIS < 0 THEN NEITHER POSITION THE CURSOR WHEN IDEV>0,==A C==   NOR PRINT OUT THE INTERNAL PLOT BUFFER WHEN IDEV<=0.     ==EA C================================================================U 50    IF(IAXIS.LE.0)RETURNA C================================================================YA C==   IF IDEV<=0 PRINT OUT THE CORRESPONDING INTERNAL PLOT     ==,A C==   BUFFER ON THE OUTPUT UNIT IOUT.                          ==BA C=================================================================8       IF(IDEV.LE.0)CALL APRINTB(1,MAXX,1,MAXY,IDEV,IOUT)A C================================================================SA C==   IF IDEV > 0 THEN POSITION THE CURSOR IN COLUMN 1 AT THE  ==SA C==   BOTTOM LINE+1 OF THE PLOT.                               == A C=================================================================3       IF(IDEV.GT.0)CALL APOSCUR(1,MAXY+1,IDEV,IOUT)= 60    RETURN	       END=F       SUBROUTINE ABUFF(IX,IY,CHAR,NCH,MINX,MAXX,MINY,MAXY,IDEV,IOUT,*)A C================================================================XA C================================================================MA C==                                                            == A C==   ABUFF: BUFFERS THE NCH CHARACTERS STORED IN CHAR(NCH) ONTO=NA C==   THE DEVICE IDEV ATTACHED TO OUTPUT UNIT IOUT.            ==TA C==   EACH CHARACTER CHAR(I) IS POSITIONED AT COLUMN IX(I) AND ===A C==   LINE IY(I) OF THE DEVICE, PROVIDED IX(I) FALLS WITHIN THE==NA C==   WINDOW COLUMN RANGE: MINX TO MAXX, AND IY(I) FALLS WITHIN==YA C==   THE WINDOW LINE RANGE: MINY TO MAXY. ANY CHARACTERS      ===A C==   WHICH FALL OUTSIDE THE WINDOW LIMITS OR DEVICE LIMITS ARE==HA C==   IGNORED.                                                 ==EA C==   NOTE: THE ORIGIN (IX,IY)=(1,1) IS AT THE TOP LEFT-HAND   == A C==   CORNER OF THE DEVICE, I.E. THE COLUMN INDEX IX INCREASES ===A C==   FROM LEFT TO RIGHT AND THE LINE INDEX IY INCREASES FROM  ==IA C==   TOP TO BOTTOM.                                           ==IA C==                                                            ===A C==   DEVICE TYPES ARE:                                        ==,A C==                                                            == A C==   IDEV=-1: LARGE INTERNAL PLOT BUFFER ARRAY "LBUFF" IN     ===A C==            COMMON /LBUFF/. THIS BUFFER IS NXLBUF (=132)    ==NA C==            COLUMNS BY NYLBUF (=66) LINES, I.E. ONE 15"X11" ==NA C==            PAGE, (USUALLY A PRINTER HARDCOPY).             ===A C==                                                            ==IA C==   IDEV=0 : SMALL INTERNAL PLOT BUFFER ARRAY "SBUFF" IN     ===A C==            COMMON /SBUFF/. THIS BUFFER IS NXSBUF (=80)     == A C==            COLUMNS BY NYSBUF (=40) LINES, I.E. ONE SCREEN  ===A C==            PAGE, (USUALLY A SCREEN COPY ON A NON-CURSOR    == A C==            ADDRESSABLE TERMINAL).                          ===A C==                                                            ==MA C==   THE FOLLOWING DEVICES ARE CURSOR ADDRESSABLE:            ==AA C==                                                            ===A C==   IDEV=1 : TEKTRONIX 4023 TERMINAL.                        == A C==   IDEV=2 : ANN ARBOR TERMINAL.                             ===A C==   IDEV=3 : SOROC (IQ-120) TERMINAL.                        ==NA C==   IDEV=4 : COMTERM (ADM-1) TERMINAL.                       == A C==   IDEV=5 : LANPARSCOPE 100 TERMINAL.                       ===A C==   IDEV=6 : VT100 TERMINAL.                                 == A C==                                                            ===A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  ==NA C==                                                            ===A C==   INPUT  PARAMETERS: IX(NCH),IY(NCH),NCH,MINX,MAXX,        ==NA C==                      MINY,MAXY,IDEV,IOUT,  (I*4);          =-=A C==                      CHAR(NCH),  (L*1).                    ==LA C==                                                            == A C==   IX  : IX(I) IS THE COLUMN WHERE CHAR(I) IS TO BE PLACED. ===A C==   IY  : IY(I) IS THE LINE   WHERE CHAR(I) IS TO BE PLACED. ==<A C==   CHAR: ARRAY OF NCH CHARACTERS TO BE BUFFERED.            == A C==   NCH : NUMBER OF CHARACTERS IN CHAR(NCH) TO BE BUFFERED.  ===A C==         IF NCH <= 0 THEN ABUFF SIMPLY RETURNS.             ==LA C==   MINX: MINIMUM X COORDINATE (COLUMN) OF THE BUFFER WINDOW.===A C==   MAXX: MAXIMUM X COORDINATE (COLUMN) OF THE BUFFER WINDOW.==LA C==   MINY: MINIMUM Y COORDINATE (LINE  ) OF THE BUFFER WINDOW.== A C==   MAXY: MAXIMUM Y COORDINATE (LINE  ) OF THE BUFFER WINDOW.===A C==   IDEV: DEVICE TYPE ONTO WHICH THE CHARACTERS ARE BUFFERED.==)A C==   IOUT: OUTPUT UNIT ATTACHED TO DEVICE IDEV. ONLY USED IF  ==SA C==         IDEV > 0.                                          ==SA C==                                                            == A C=================================================================A C================================================================N       DIMENSION IX(1),IY(1)E)       LOGICAL*1 CHAR(1),LINE(100),CCH(10)D       DATA NLENMX/78/=       LOGICAL*1 BLANK/' '/       INTEGER*2 LEN=A C=================================================================A C==   MOD=Z00004008: WRITE@BIN@-TRIM MODIFIER.                 == A C================================================================N       INTEGER MOD/Z00004008/A C================================================================AA C==   IDEV=-1: LARGE INTERNAL PLOT BUFFER (HARDCOPY).          == A C================================================================G       LOGICAL*1 LBUFF(0       COMMON /LBUFF/ NXLBUF,NYLBUF,LBUFF(132,66)        DATA NXLBUF,NYLBUF/132,66/A C=================================================================A C==   IDEV=0: SMALL INTERNAL PLOT BUFFER (SCREEN COPY).        ===A C=================================================================       LOGICAL*1 SBUFF /       COMMON /SBUFF/ NXSBUF,NYSBUF,SBUFF(80,40)=       DATA NXSBUF,NYSBUF/80,40/NA C================================================================ A C==   IF THERE ARE NO CHARACTERS TO BUFFER THEN RETURN.        == A C==   IF IDEV > 0 THEN GO TO 300.                              == A C================================================================        IF(NCH.LE.0)RETURN       IF(IDEV.GT.0)GO TO 300A C================================================================LA C==   IDEV <= 0:                                               ==BA C================================================================S       IGO=IDEV+2       GO TO (100,200),IGO=       RETURNA C================================================================SA C==   IDEV=-1: LARGE INTERNAL PLOT BUFFER (HARDCOPY).          ==CA C================================================================CA C==   TRUNCATE WINDOW TO FIT WITHIN BUFFER DIMENSIONS.         ==PA C================================================================A 100   MMINX=MAX0(MINX,1)       MMAXX=MIN0(MAXX,NXLBUF)        MMINY=MAX0(MINY,1)       MMAXY=MIN0(MAXY,NYLBUF)=A C=================================================================A C==   STORE THE NCH CHARACTERS CHAR(I) WITH COORDINATES:       ===A C==   (IX(I),IY(I)) WHICH ARE WITHIN THE WINDOW LIMITS:        ===A C==   MMINX,MMAXX,MMINY,MMAXY INTO THE PLOT BUFFER: "LBUFF".   ===A C=================================================================       DO 110 I=1,NCH3       IF(IX(I).LT.MMINX.OR.IX(I).GT.MMAXX)GO TO 110 3       IF(IY(I).LT.MMINY.OR.IY(I).GT.MMAXY)GO TO 110         LBUFF(IX(I),IY(I))=CHAR(I) 110   CONTINUE       RETURNA C================================================================ A C==   IDEV=0: SMALL INTERNAL PLOT BUFFER (SCREEN COPY).        ==5A C================================================================ A C==   TRUNCATE WINDOW TO FIT WITHIN BUFFER DIMENSIONS.         ==XA C================================================================  200   MMINX=MAX0(MINX,1)       MMAXX=MIN0(MAXX,NXSBUF)        MMINY=MAX0(MINY,1)       MMAXY=MIN0(MAXY,NYSBUF) A C================================================================HA C==   STORE THE NCH CHARACTERS CHAR(I) WITH COORDINATES:       ==HA C==   (IX(I),IY(I)) WHICH ARE WITHIN THE WINDOW LIMITS:        ==RA C==   MMINX,MMAXX,MMINY,MMAXY INTO THE PLOT BUFFER: "SBUFF".   ==IA C================================================================F       DO 210 I=1,NCH3       IF(IX(I).LT.MMINX.OR.IX(I).GT.MMAXX)GO TO 210 3       IF(IY(I).LT.MMINY.OR.IY(I).GT.MMAXY)GO TO 210I        SBUFF(IX(I),IY(I))=CHAR(I) 210   CONTINUE       RETURNA C================================================================OA C==   IDEV > 0: CURSOR ADDRESSABLE TERMINALS.                  == A C================================================================ A C==   PRINT THE NCH CHARACTERS CHAR(I) WITH COORDINATES:       == A C==   (IX(I),IY(I)) WHICH ARE WITHIN THE WINDOW LIMITS:        == A C==   MINX,MAXX,MINY,MAXY ONTO THE DEVICE.                     ===A C==   IXP,IYP: ARE THE COORDINATES OF THE PREVIOUS CHARACTER   ===A C==            JUST PRINTED ON THE SCREEN.                     ==YA C==   LEN: IS THE LENGTH OF LINE IN CHARACTERS. LINE IS USED TO==/A C==        BUFFER A 100 CHARACTERS (CONTROL CHARACTERS, ETC.)  ===A C==        TO THE SCREEN.                                      ==0A C================================================================= 300   IXP=0=       IYP=0=       LEN=0=       DO 320 I=1,NCH1       IF(IX(I).LT.MINX.OR.IX(I).GT.MAXX)GO TO 320=1       IF(IY(I).LT.MINY.OR.IY(I).GT.MAXY)GO TO 320:A C=================================================================A C==   ACURSOR RETURNS THE OPTIMUM NUMBER OF CONTROL CHARACTERS ==*A C==   FOR THE DEVICE IDEV TO MOVE THE CURSOR FROM A PREVIOUS   ==AA C==   (COLUMN,LINE) POSITION IXP,IYP TO A NEW POSITION         ===A C==   IX(I),IY(I). IF IX(I),IY(I) IS OUTSIDE THE DEVICE LIMITS ==(A C==   GO TO 320.                                               ===A C================================================================F<       CALL ACURSOR(2,CCH,NCCH,IX(I),IY(I),IXP,IYP,IDEV,&320)A C=================================================================A C==   UPDATE IXP,IYP WITH THE NEW POSITION: IX(I),IY(I).       ===A C==   IF THE LINE BUFFER IS FULL WRITE OUT THE LINE ON UNIT    ===A C==   IOUT (ATTACHED TO IDEV).                                 ===A C=================================================================       IXP=IX(I)=       IYP=IY(I)=       NLEN=LEN+NCCH+1 ; C      IF(NLEN.GT.NLENMX)CALL WRITE(LINE,LEN,MOD,LNUM,IOUT) :       IF(NLEN.GT.NLENMX)WRITE(IOUT,305)(LINE(II),II=1,LEN) 305   FORMAT('+',$,255A1)V       IF(NLEN.GT.NLENMX)LEN=0 A C=================================================================A C==   ADD THE NCCH CURSOR CONTROL CHARACTERS CCH TO THE END OF == A C==   LINE BUFFER. ALSO ADD CHAR(I) TO THE END.                ===A C================================================================.       IF(NCCH.LE.0)GO TO 315       DO 310 J=1,NCCH=       LINE(LEN+J)=CCH(J) 310   CONTINUE 315   LEN=LEN+NCCH+1       LINE(LEN)=CHAR(I)  C      CALL EATRAN(LINE(LEN),1)= 320   CONTINUEA C=================================================================A C==   WRITE OUT ANY REMAINING CHARACTERS IN LINE.              ===A C=================================================================5 C      IF(LEN.GT.0)CALL WRITE(LINE,LEN,MOD,LNUM,IOUT) 4       IF(LEN.GT.0)WRITE(IOUT,305)(LINE(II),II=1,LEN)       RETURN	       END="       SUBROUTINE ACLEAR(IDEV,IOUT)A C================================================================.A C================================================================ A C==                                                            ===A C==   ACLEAR: CLEARS THE DEVICE IDEV ATTACHED TO OUTPUT UNIT   ==(A C==           IOUT.                                            ===A C==                                                            ==RA C==   DEVICE TYPES ARE LISTED IN SUBROUTINE ABUFF.             ===A C==                                                            ==0A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  ==BA C==                                                            ===A C==   INPUT  PARAMETERS: IDEV,IOUT,  (I*4).                    == A C==                                                            == A C==   IDEV: DEVICE TYPE TO BE CLEARED, OR BLANKED OUT.         == A C==   IOUT: OUTPUT UNIT ATTACHED TO DEVICE IDEV. ONLY USED IF  ===A C==         IDEV > 0.                                          ==XA C==                                                            == A C=================================================================A C================================================================ "       LOGICAL*1 BLANK/' '/,CCH(10)       INTEGER*2 LEN A C=================================================================A C==   MOD=Z00004008: WRITE@BIN@-TRIM MODIFIER.                 == A C================================================================        INTEGER MOD/Z00004008/A C================================================================CA C==   IDEV=-1: LARGE INTERNAL PLOT BUFFER (HARDCOPY).          ==NA C================================================================H       LOGICAL*1 LBUFF 0       COMMON /LBUFF/ NXLBUF,NYLBUF,LBUFF(132,66)        DATA NXLBUF,NYLBUF/132,66/A C=================================================================A C==   IDEV=0: SMALL INTERNAL PLOT BUFFER (SCREEN COPY).        ===A C================================================================        LOGICAL*1 SBUFFO/       COMMON /SBUFF/ NXSBUF,NYSBUF,SBUFF(80,40)Y       DATA NXSBUF,NYSBUF/80,40/=       IF(IDEV.GT.0)GO TO 300       IGO=IDEV+2       GO TO (100,200),IGOO       RETURNA C================================================================ A C==   CLEAR: IDEV=-1: LARGE INTERNAL PLOT BUFFER (HARDCOPY).   ==IA C================================================================I 100   DO 120 J=1,NYLBUFV       DO 110 I=1,NXLBUFT       LBUFF(I,J)=BLANK 110   CONTINUE 120   CONTINUE       RETURNA C================================================================AA C==   CLEAR: IDEV=0: SMALL INTERNAL PLOT BUFFER (SCREEN COPY). ===A C================================================================I 200   DO 220 J=1,NYSBUF        DO 210 I=1,NXSBUF=       SBUFF(I,J)=BLANK 210   CONTINUE 220   CONTINUE       RETURNA C=================================================================A C==   CLEAR: IDEV > 0: CURSOR ADDRESSABLE TERMINALS.           == A C==   IF IDEV IS INVALID THEN GO TO &310.                      ==LA C==   ACURSOR(0,...) RETURNS THE CLEAR CONTROL CHARACTERS FOR  ==NA C==   THE DEVICE IDEV.                                         ==VA C==   WRITE OUT THE CLEAR CONTROL CHARACTERS ON UNIT IOUT.     ===A C================================================================ 0 300   CALL ACURSOR(0,CCH,NCCH,0,0,0,0,IDEV,&310)       LEN=NCCH( C      CALL WRITE(CCH,LEN,MOD,LNUM,IOUT)$       WRITE(6,305)(CCH(II),II=1,LEN) 305   FORMAT('+',$,255A1)  310   RETURN	       END =       SUBROUTINE ACURSOR(ITYPE,CCH,NCCH,IX,IY,IXP,IYP,IDEV,*)EA C================================================================NA C=================================================================A C==                                                            ==CA C==   ACURSOR: RETURNS THE FOLLOWING ASCII CONTROL CHARACTERS IN==A C==           CCH DEPENDING ON THE VALUE OF ITYPE. NCCH IS THE ==LA C==           NUMBER OF CONTROL CHARACTERS RETURNED IN THE     ==,A C==           LOGICAL*1 ARRAY CCH.                             == A C==                                                            == A C==   ITYPE=0: ACURSOR RETURNS NCCH CLEAR CONTROL CHARACTERS   == A C==            IN CCH FOR CLEARING THE DEVICE IDEV.            == A C==            IX,IY,IXP,IYP ARE IGNORED AND NOT USED.         == A C==            FOR THIS CASE: 1 <= NCCH <=4.                   == A C==                                                            == A C==   ITYPE=1: ACURSOR RETURNS THE OPTIMUM NUMBER (NCCH) OF    == A C==            CURSOR CONTROL CHARACTERS TO MOVE THE CURSOR    == A C==            FROM A PREVIOUS (COLUMN,LINE) POSITION IXP,IYP  == A C==            TO A NEW POSITION IX,IY ON THE DEVICE IDEV.     == A C==            IF IXP,IYP IS OUTSIDE THE DEVICE LIMITS OR IXP  == A C==            IS EQUAL TO THE LAST COLUMN ON THE DEVICE THEN  == A C==            ACURSOR SIMPLY RETURNS THE NORMAL CURSOR        == A C==            CONTROL CHARACTERS FOR ADDRESSING IX,IY ON IDEV.== A C==            IF IX,IY IS OUTSIDE THE DEVICE LIMITS THEN      == A C==            A RETURN1 IS PERFORMED.                         == A C==            FOR THIS CASE: 0 <= NCCH <= 9.                  == A C==                                                            == A C==   ITYPE=2: ACURSOR RETURNS THE NORMAL CURSOR CONTROL       ===A C==            CHARACTERS FOR ADDRESSING THE (COLUMN,LINE)     ===A C==            POSITION IX,IY ON THE DEVICE IDEV.              ===A C==            IF IX,IY IS OUTSIDE THE DEVICE LIMITS THEN      ==EA C==            ACURSOR RETURNS THE CURSOR CONTROL CHARACTERS FOR==A C==            ADDRESSING THE LOCATION IX,IY TRUNCATED TO THE  ==CA C==            DEVICE LIMITS.                                  ===A C==            IXP,IYP ARE IGNORED AND NOT USED.               ==LA C==            FOR THIS CASE: 3 <= NCCH <= 9.                  ===A C==                                                            ==DA C==   DEVICE TYPES (ALL CURSOR ADDRESSABLE) ARE:               ===A C==                                                            ==OA C==   IDEV=1 : TEKTRONIX 4023 TERMINAL.                        == A C==   IDEV=2 : ANN ARBOR TERMINAL.                             == A C==   IDEV=3 : SOROC (IQ-120) TERMINAL.                        ===A C==   IDEV=4 : COMTERM (ADM-1) TERMINAL.                       ==IA C==   IDEV=5 : LANPARSCOPE 100 TERMINAL.                       ===A C==   IDEV=6 : VT100 TERMINAL.                                 ==JA C==                                                            == A C==   IF AN INVALID DEVICE TYPE IS USED THEN WE RETURN1.       ===A C==                                                            ==IA C==   NOTE: THE ORIGIN (IX,IY)=(1,1) IS AT THE TOP LEFT-HAND   ===A C==   CORNER OF THE DEVICE, I.E. THE COLUMN INDEX IX INCREASES == A C==   FROM LEFT TO RIGHT AND THE LINE INDEX IY INCREASES FROM  == A C==   TOP TO BOTTOM.                                           ===A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  == A C==                                                            ==NA C==   INPUT  PARAMETERS: ITYPE,IX,IY,IXP,IYP,IDEV, (I*4).      == A C==                                                            ==EA C==   OUTPUT PARAMETERS: CCH(NCCH), (L*1); NCCH (I*4).         ===A C==                                                            ==VA C================================================================ A C================================================================ %       LOGICAL*1 CCH(1),CC(5),LFEED(4)A       LOGICAL EQUCA C=================================================================A C=================================================================A C==   IN GENERAL EACH DEVICE HAS THE FOLLOWING SPECIFICATIONS: == A C==                                                            ==IA C==   IDEV      : DEVICE NUMBER PASSED TO ACURSOR.             == A C==   ####      : DEVICE NAME, 4 CHARACTERS. (EG. 4023).       == A C==   NX####    : MAXIMUM NUMBER OF COLUMNS ON A ####.         == A C==   NY####    : MAXIMUM NUMBER OF LINES   ON A ####.         == A C==   LC####    : LOAD CURSOR CONTROL CHARACTER(S) ON A ####.  == A C==   CL####    : CLEAR CONTROL CHARACTER(S) FOR A ####.       == A C==   LF####(1) : BACKSPACE ON A ####.                         == A C==   LF####(2) : FORWARD SPACE ON A ####.                     == A C==   LF####(3) : UP FEED ON A ####.                           ==TA C==   LF####(4) : LINE FEED ON A ####.                         == A C==               IF BACKSPACE, FORWARD SPACE, UP FEED, OR LINE==:A C==               FEED DOES NOT EXIST ON A ####, THEN THE      ==:A C==               CORRESPONDING LF####(I) IS SET TO A NULL=Z00.==:A C==   PX####(IX): X CONTROL CHARACTER FOR POSITIONING CURSOR TO==:A C==               COLUMN IX ON A ####.                         ==:A C==   PY####(IY): Y CONTROL CHARACTER FOR POSITIONING CURSOR TO==:A C==               COLUMN IY ON A ####.                         == A C==               FOR POSITIONING THE CURSOR TO THE (COLUMN,   ==NA C==               LINE) POSITION IX,IY THE NORMAL CONTROL      == A C==               CHARACTERS ARE USUALLY:                      ==HA C==               LC####,PX####(IX),PY####(IY), OR             ==OA C==               LC####,PY####(IY),PX####(IX).                ==FA C================================================================BA C================================================================  C A C================================================================AA C==   IDEV=1: 4023, TEKTRONIX 4023 DEVICE SPECIFICATIONS.      == A C================================================================M#       INTEGER NX4023/80/,NY4023/24/).       LOGICAL*1 LC4023/Z1C/,CL4023(2)/Z1B,Z0C/*       LOGICAL*1 LF4023(4)/Z08,Z09,Z00,Z0A/       LOGICAL*1 PX4023(80)H      # /Z20,Z21,Z22,Z23,Z24,Z25,Z26,Z27,Z28,Z29,Z2A,Z2B,Z2C,Z2D,Z2E,Z2F,H      #  Z30,Z31,Z32,Z33,Z34,Z35,Z36,Z37,Z38,Z39,Z3A,Z3B,Z3C,Z3D,Z3E,Z3F,H      #  Z40,Z41,Z42,Z43,Z44,Z45,Z46,Z47,Z48,Z49,Z4A,Z4B,Z4C,Z4D,Z4E,Z4F,H      #  Z50,Z51,Z52,Z53,Z54,Z55,Z56,Z57,Z58,Z59,Z5A,Z5B,Z5C,Z5D,Z5E,Z5F,H      #  Z60,Z61,Z62,Z63,Z64,Z65,Z66,Z67,Z68,Z69,Z6A,Z6B,Z6C,Z6D,Z6E,Z6F/       LOGICAL*1 PY4023(24)'       EQUIVALENCE (PY4023(1),PX4023(1))NA C================================================================ A C==   IDEV=2: ANNA, ANN ARBOR DEVICE SPECIFICATIONS.           ==AA C================================================================ #       INTEGER NXANNA/80/,NYANNA/40/OB       LOGICAL*1 LCANNA/Z0F/,CLANNA/Z0C/,LFANNA(4)/Z08,Z09,Z0E,Z0A/       LOGICAL*1 PXANNA(80)0      # /Z00,Z01,Z02,Z03,Z04,Z05,Z06,Z07,Z08,Z09,0      #  Z10,Z11,Z12,Z13,Z14,Z15,Z16,Z17,Z18,Z19,0      #  Z20,Z21,Z22,Z23,Z24,Z25,Z26,Z27,Z28,Z29,0      #  Z30,Z31,Z32,Z33,Z34,Z35,Z36,Z37,Z38,Z39,0      #  Z40,Z41,Z42,Z43,Z44,Z45,Z46,Z47,Z48,Z49,0      #  Z50,Z51,Z52,Z53,Z54,Z55,Z56,Z57,Z58,Z59,0      #  Z60,Z61,Z62,Z63,Z64,Z65,Z66,Z67,Z68,Z69,0      #  Z70,Z71,Z72,Z73,Z74,Z75,Z76,Z77,Z78,Z79/       LOGICAL*1 PYANNA(40)0      # /Z40,Z41,Z42,Z43,Z44,Z45,Z46,Z47,Z48,Z49,0      #  Z4A,Z4B,Z4C,Z4D,Z4E,Z4F,Z50,Z51,Z52,Z53,0      #  Z60,Z61,Z62,Z63,Z64,Z65,Z66,Z67,Z68,Z69,0      #  Z6A,Z6B,Z6C,Z6D,Z6E,Z6F,Z70,Z71,Z72,Z73/A C=================================================================A C==   IDEV=3: SORO, SOROC (IQ-120) DEVICE SPECIFICATIONS.      ===A C==   IDEV=4: COMT, COMTERM (ADM-1) DEVICE SPECIFICATIONS.     ===A C==           EXACTLY THE SAME AS THE SOROC SPECIFICATIONS!!   ===A C=================================================================#       INTEGER NXSORO/80/,NYSORO/24/D5       LOGICAL*1 LCSORO(2)/Z1B,Z3D/,CLSORO(2)/Z1B,Z2A/ *       LOGICAL*1 LFSORO(4)/Z08,Z0C,Z0B,Z0A/%       LOGICAL*1 PXSORO(80),PYSORO(24)91       EQUIVALENCE (PXSORO(1),PYSORO(1),PX4023(1)) A C================================================================RA C==   IDEV=5: LANP, LANPARSCOPE 100 DEVICE SPECIFICATIONS.     == A C================================================================ #       INTEGER NXLANP/80/,NYLANP/24/ .       LOGICAL*1 LCLANP(2)/Z1B,Z66/,CLLANP/Z0C/*       LOGICAL*1 LFLANP(4)/Z08,Z00,Z00,Z0A/%       LOGICAL*1 PXLANP(80),PYLANP(24)N1       EQUIVALENCE (PXLANP(1),PYLANP(1),PX4023(1)) A C================================================================OA C==   IDEV=6: VT100 DEVICE SPECIFICATIONS.                     ==NA C================================================================C&       INTEGER NXVT100/132/,NYVT100/24/+       LOGICAL*1 LCVT100(4)/Z1B,'[',';','H'/ +       LOGICAL*1 CLVT100(4)/Z1B,'[','2','J'/E!       LOGICAL*1 LFVT100(4)/4*Z00/        IGO=ITYPE+1 A C================================================================ A C==   GO TO THE APPROPRIATE SECTION FOR DEVICE IDEV.           == A C================================================================I*       GO TO (100,200,300,300,500,600),IDEV
       RETURN1 A C================================================================ A C==   IDEV=1: TEKTONIX 4023 TERMINAL.                          == A C================================================================ A C==   GO TO THE APPROPRIATE SECTION FOR THE TYPE ITYPE.        == A C================================================================  100   GO TO (110,120,130),IGOL
       RETURN1 A C================================================================ A C==   ITYPE=0: RETURN THE CLEAR CONTROL CHARACTERS.            == A C================================================================= 110   CCH(1)=CL4023(1)       CCH(2)=CL4023(2)       NCCH=2       RETURNA C=================================================================A C==   ITYPE=1: RETURN THE OPTIMIZED CURSOR CONTROL CHARACTERS. == A C=================================================================( 120   IF(IX.LT.1.OR.IX.GT.NX4023)RETURN1(       IF(IY.LT.1.OR.IY.GT.NY4023)RETURN1.       IF(IX.EQ.NX4023.AND.IY.EQ.NY4023)RETURN1       CCH(1)=LC4023*       CCH(2)=PX4023(IX),       CCH(3)=PY4023(IY)2       NCCH=3.       IF(IXP.GE.NX4023.OR.IYP.GT.NY4023)RETURNA C================================================================,A C==   FILL LFEED AND GO TO 1000 TO CALCULATE THE OPTIMIZED     ==5A C==   CURSOR CONTROL CHARACTERS USING THE LFEED CHARACTERS.    == A C================================================================        DO 125 I=1,4       LFEED(I)=LF4023(I) 125   CONTINUE       GO TO 1000A C================================================================2A C==   ITYPE=2: RETURN THE NORMAL CURSOR CONTROL CHARACTERS.    ===A C================================================================E 130   CCH(1)=LC40230,       CCH(2)=PX4023(MAX0(MIN0(IX,NX4023),1)),       CCH(3)=PY4023(MAX0(MIN0(IY,NY4023),1))       NCCH=3       RETURNA C================================================================1A C==   IDEV=2 : ANN ARBOR TERMINAL.                             ==#A C================================================================,A C==   GO TO THE APPROPRIATE SECTION FOR THE TYPE ITYPE.        ==5A C================================================================7 200   GO TO (210,220,230),IGO7
       RETURN1OA C================================================================,A C==   ITYPE=0: RETURN THE CLEAR CONTROL CHARACTERS.            ==,A C================================================================7 210   CCH(1)=CLANNA=       NCCH=1       RETURNA C================================================================)A C==   ITYPE=1: RETURN THE OPTIMIZED CURSOR CONTROL CHARACTERS. ==1A C================================================================ ( 220   IF(IX.LT.1.OR.IX.GT.NXANNA)RETURN1(       IF(IY.LT.1.OR.IY.GT.NYANNA)RETURN1.       IF(IX.EQ.NXANNA.AND.IY.EQ.NYANNA)RETURN1       CCH(1)=LCANNA*       CCH(2)=PXANNA(IX)R       CCH(3)=PYANNA(IY)I       NCCH=3.       IF(IXP.GE.NXANNA.OR.IYP.GT.NYANNA)RETURNA C=================================================================A C==   FILL LFEED AND GO TO 1000 TO CALCULATE THE OPTIMIZED     == A C==   CURSOR CONTROL CHARACTERS USING THE LFEED CHARACTERS.    ===A C================================================================        DO 225 I=1,4       LFEED(I)=LFANNA(I) 225   CONTINUE       GO TO 1000A C================================================================PA C==   ITYPE=2: RETURN THE NORMAL CURSOR CONTROL CHARACTERS.    == A C================================================================O 230   CCH(1)=LCANNA ,       CCH(2)=PXANNA(MAX0(MIN0(IX,NXANNA),1)),       CCH(3)=PYANNA(MAX0(MIN0(IY,NYANNA),1))       NCCH=3       RETURNA C================================================================'A C==   IDEV=3 : SOROC (IQ-120) TERMINAL.                        ==OA C==   IDEV=4 : COMTERM (ADM-1) TERMINAL.                       ===A C================================================================RA C==   GO TO THE APPROPRIATE SECTION FOR THE TYPE ITYPE.        ===A C================================================================0 300   GO TO (310,320,330),IGOE
       RETURN1=A C================================================================DA C==   ITYPE=0: RETURN THE CLEAR CONTROL CHARACTERS.            ===A C================================================================O 310   CCH(1)=CLSORO(1)       CCH(2)=CLSORO(2)       NCCH=2       RETURNA C================================================================0A C==   ITYPE=1: RETURN THE OPTIMIZED CURSOR CONTROL CHARACTERS. ===A C================================================================T( 320   IF(IX.LT.1.OR.IX.GT.NXSORO)RETURN1(       IF(IY.LT.1.OR.IY.GT.NYSORO)RETURN1.       IF(IX.EQ.NXSORO.AND.IY.EQ.NYSORO)RETURN1       CCH(1)=LCSORO(1)       CCH(2)=LCSORO(2)       CCH(3)=PYSORO(IY)=       CCH(4)=PXSORO(IX)=       NCCH=4.       IF(IXP.GE.NXSORO.OR.IYP.GT.NYSORO)RETURNA C=================================================================A C==   FILL LFEED AND GO TO 1000 TO CALCULATE THE OPTIMIZED     ==FA C==   CURSOR CONTROL CHARACTERS USING THE LFEED CHARACTERS.    ==YA C================================================================        DO 325 I=1,4       LFEED(I)=LFSORO(I) 325   CONTINUE       GO TO 1000A C================================================================,A C==   ITYPE=2: RETURN THE NORMAL CURSOR CONTROL CHARACTERS.    ==5A C================================================================  330   CCH(1)=LCSORO(1)       CCH(2)=LCSORO(2),       CCH(3)=PYSORO(MAX0(MIN0(IY,NYSORO),1)),       CCH(4)=PXSORO(MAX0(MIN0(IX,NXSORO),1))       NCCH=4       RETURNA C================================================================TA C==   IDEV=5: LANPARSCOPE 100 TERMINAL.                        ===A C================================================================2A C==   GO TO THE APPROPRIATE SECTION FOR THE TYPE ITYPE.        ==2A C================================================================= 500   GO TO (510,520,530),IGO=
       RETURN1=A C================================================================ A C==   ITYPE=0: RETURN THE CLEAR CONTROL CHARACTERS.            ===A C================================================================  510   CCH(1)=CLLANP=       NCCH=1       RETURNA C================================================================UA C==   ITYPE=1: RETURN THE OPTIMIZED CURSOR CONTROL CHARACTERS. ===A C================================================================ ( 520   IF(IX.LT.1.OR.IX.GT.NXLANP)RETURN1(       IF(IY.LT.1.OR.IY.GT.NYLANP)RETURN1.       IF(IX.EQ.NXLANP.AND.IY.EQ.NYLANP)RETURN1       CCH(1)=LCLANP(1)       CCH(2)=LCLANP(2)       CCH(3)=PXLANP(IX):       CCH(4)=PYLANP(IY)S       NCCH=4.       IF(IXP.GE.NXLANP.OR.IYP.GT.NYLANP)RETURNA C================================================================RA C==   FILL LFEED AND GO TO 1000 TO CALCULATE THE OPTIMIZED     ==AA C==   CURSOR CONTROL CHARACTERS USING THE LFEED CHARACTERS.    ==AA C================================================================X       DO 525 I=1,4       LFEED(I)=LFLANP(I) 525   CONTINUE       GO TO 1000A C================================================================OA C==   ITYPE=2: RETURN THE NORMAL CURSOR CONTROL CHARACTERS.    ==HA C================================================================= 530   CCH(1)=LCLANP(1)       CCH(2)=LCLANP(2),       CCH(3)=PXLANP(MAX0(MIN0(IX,NXLANP),1)),       CCH(4)=PYLANP(MAX0(MIN0(IY,NYLANP),1))       NCCH=4       RETURNA C=================================================================A C==   IDEV=6: VT100 TERMINAL.                                  ==3A C================================================================  600   GO TO (610,620,630),IGON
       RETURN1 A C=================================================================A C==   ITYPE=0: RETURN THE CLEAR CONTROL CHARACTERS.            == A C================================================================  610   DO 615 I=1,4       CCH(I)=CLVT100(I)= 615   CONTINUE       NCCH=4       RETURNA C=================================================================A C==   ITYPE=1: RETURN THE CURSOR CONTROL CHARACTERS WHEN (IX,IY)=0A C==            ARE WITHIN THE SCREEN LIMITS. IF (IX,IY) IS     ===A C==            OUTSIDE THE SCREEN LIMITS THEN RETURN1.         ==TA C=================================================================) 620   IF(IX.LT.1.OR.IX.GT.NXVT100)RETURN1=)       IF(IY.LT.1.OR.IY.GT.NYVT100)RETURN1C       CCH(1)=LCVT100(1)        CCH(2)=LCVT100(2)=$       CALL BTD(IY,CCH(3),0,NSIG,'0')       CCH(3+NSIG)=LCVT100(3)*       CALL BTD(IX,CCH(4+NSIG),0,NSIG2,'0')"       CCH(4+NSIG+NSIG2)=LCVT100(4)       NCCH=4+NSIG+NSIG2=       RETURNA C================================================================GA C==   ITYPE=2: RETURN THE CURSOR CONTROL CHARACTERS WITH (IX,IY)= A C==            TRUNCATED TO THE DEVICE LIMITS.                 ==YA C================================================================O 630   CCH(1)=LCVT100(1)=       CCH(2)=LCVT100(2)=8       CALL BTD(MAX(MIN(IY,NYVT100),1),CCH(3),0,NSIG,'0')       CCH(3+NSIG)=LCVT100(3)>       CALL BTD(MAX(MIN(IX,NXVT100),1),CCH(4+NSIG),0,NSIG2,'0')"       CCH(4+NSIG+NSIG2)=LCVT100(4)       NCCH=4+NSIG+NSIG2=       RETURNA C================================================================ A C==   ITYPE=1: DETERMINE THE OPTIMUM NUMBER OF CURSOR CONTROL  ===A C==            CHARACTERS REQUIRED TO MOVE THE CURSOR FROM A   == A C==            (COLUMN,LINE) POSITION IXP,IYP TO A NEW POSITION===A C==            IX,IY ON THE DEVICE IDEV, USING THE BACKSPACE,  ==SA C==            FORWARD SPACE, UP FEED, AND LINE FEED CHARACTERS==PA C==            IN THE ARRAY LFEED(4).                          ===A C================================================================D$ 1000  IF(IXP.LT.1.OR.IYP.LT.1)RETURN       IDX=IX-IXP-1       IDY=IY-IYPA C================================================================ A C==   NIDX IS THE NUMBER OF BACKSPACES     REQUIRED IF IDX < 0.===A C==   NIDX IS THE NUMBER OF FORWARD SPACES REQUIRED IF IDX > 0.==0A C==   NIDY IS THE NUMBER OF UP FEEDS       REQUIRED IF IDY < 0.===A C==   NIDY IS THE NUMBER OF LINE FEEDS     REQUIRED IF IDY > 0.==TA C=================================================================       NIDX=IABS(IDX)       NIDY=IABS(IDY)A C=================================================================A C==   IF NCCH IS LESS THAN OR EQUAL TO THE NUMBER OF LFEED     ==IA C==   CHARACTERS REQUIRED TO MOVE THE CURSOR, THEN WE RETURN   ===A C==   WITH THE NORMAL CURSOR CONTROL CHARACTERS.               ==AA C================================================================Q!       IF(NIDX+NIDY.GE.NCCH)RETURN        IF(IDX.EQ.0)GO TO 1020A C================================================================ A C==   WE NEED NIDX=|IDX| BACKSPACES OR FORWARD SPACES.         ===A C================================================================ 
       INDEX=1G       IF(IDX.GT.0)INDEX=2OA C================================================================HA C==   IF THE APPROPRIATE CHARACTER IS NULL, I.E. DOES NOT      ===A C==   EXIST ON THE DEVICE, THEN WE RETURN WITH THE NORMAL      == A C==   CONTROL CHARACTERS.                                      ===A C================================================================O$       IF(EQUC(LFEED(INDEX),0))RETURNA C================================================================CA C==   FILL THE TEMPORARY CONTROL CHARACTER ARRAY CC, WITH      ==NA C==   BACKSPACES OR FORWARD SPACES.                            == A C=================================================================       DO 1010 I=1,NIDX       CC(I)=LFEED(INDEX) 1010  CONTINUE 1020  IF(IDY.EQ.0)GO TO 1040A C================================================================ A C==   WE NEED NIDY=|IDY| UP FEEDS OR LINE FEEDS.               ===A C================================================================H
       INDEX=3        IF(IDY.GT.0)INDEX=4 A C================================================================ A C==   IF THE APPROPRIATE CHARACTER IS NULL, I.E. DOES NOT      == A C==   EXIST ON THE DEVICE, THEN WE RETURN WITH THE NORMAL      ===A C==   CONTROL CHARACTERS.                                      ==AA C================================================================I$       IF(EQUC(LFEED(INDEX),0))RETURNA C=================================================================A C==   FILL THE TEMPORARY CONTROL CHARACTER ARRAY CC, WITH      ==1A C==   UP FEEDS OR LINE FEEDS.                                  ==NA C================================================================B       DO 1030 I=1,NIDY       CC(I+NIDX)=LFEED(INDEX)  1030  CONTINUEA C================================================================ A C==   RETURN THE OPTIMIZED CONTROL CHARACTER ARRAY CC IN CCH.  ===A C================================================================R 1040  NCCH=NIDX+NIDY       IF(NCCH.LE.0)RETURN        DO 1050 I=1,NCCH       CCH(I)=CC(I) 1050  CONTINUE       RETURN	       END=        FUNCTION DEXP10(REAL,IPOW)A C================================================================DA C================================================================0A C==                                                            ==)A C==   DEXP10 = REAL/10.D0**IPOW.                               == A C==                                                            ===A C==   DEXP10 MEANS "DIVIDE BY EXPONENTIATION OF BASE 10".      ==TA C==                                                            ==MA C==   DEXP10 RETURNS A VALUE FOR THOSE CASES WHEN              ==SA C==   REAL/10.D0**IPOW IS DEFINED BUT |IPOW| IS TOO LARGE FOR  ==AA C==   THE EXPONENT EVALUATION OF 10.D0**IPOW.                  ==AA C==                                                            == A C==   EXAMPLE: IF REAL=1.E-70 AND IPOW=-100 THEN               ===A C==            10.D0**IPOW IS UNDEFINED (UNDERFLOW), BUT       == A C==            DEXP10(REAL,IPOW) = 1.E-70/10**-100 = 1.E30 IS  ===A C==            WELL DEFINED.                                   ==EA C==                                                            ==EA C==   NOTE: DEXP10 DOES NOT TAKE SPECIAL NOTE OF THOSE CASES   ==EA C==         WHEN REAL/10.D0**IPOW IS UNDEFINED DUE TO AN       ==EA C==         UNDERFLOW OR OVERFLOW. THESE CASES ARE HANDLED BY  ===A C==         THE SYSTEM.                                        ===A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  == A C==                                                            == A C==   INPUT  PARAMETERS: REAL (R*8), IPOW (I*4).               ===A C==   OUTPUT PARAMETERS: DEXP10 (R*8 FUNCTION VALUE).          == A C==                                                            ===A C================================================================EA C=================================================================       IMPLICIT REAL*8 (A-H,O-Z)=       IPOWA=IABS(IPOW)       IF(IPOWA.GT.70)GO TO 10GA C=================================================================A C==   SIMPLE CASE: |IPOW| <= 70.                               == A C================================================================R       DEXP10=REAL/10.D0**IPOWR       RETURNA C=================================================================A C==   CASE WHEN |IPOW| > 70.                                   ==EA C==   DIVIDE BY REAL BY 10**(ISIGN(1,IPOW)*70) AND SUBTRACT 70 ===B C==   OFF OF |IPOW| UNTIL |IPOW| IS <= 70.                     ==@A C================================================================  10    DEXP10=REAL=       IPOWS=ISIGN(1,IPOW)=       IPS70=IPOWS*70 20    IF(IPOWA.LE.70)GO TO 30         DEXP10=DEXP10/10.D0**IPS70       IPOWA=IPOWA-70       GO TO 20A C================================================================ A C==   DIVIDE BY THE REMAINING POWER.                           ===A C================================================================ ( 30    DEXP10=DEXP10/10.D0**(IPOWS*IPOWA)       RETURN	       END=)       SUBROUTINE APOSCUR(IX,IY,IDEV,IOUT) A C================================================================ A C================================================================ A C==                                                            ===A C==   APOSCUR: POSITIONS THE CURSOR, WITHOUT PRINTING ANYTHING,== A C==   AT THE COLUMN IX AND THE LINE IY OF THE DEVICE IDEV      ===A C==   ATTACHED TO THE OUTPUT UNIT IOUT. IF IX OR IY IS OUTSIDE ==CA C==   THE DEVICE LIMITS THEN THE CURSOR WILL POSITIONED AT THE == A C==   CLOSEST DEVICE LIMIT.                                    ===A C==                                                            ==IA C==   NOTE: THE ORIGIN (IX,IY)=(1,1) IS AT THE TOP LEFT-HAND   ===A C==   CORNER OF THE DEVICE, I.E. THE COLUMN INDEX IX INCREASES ==NA C==   FROM LEFT TO RIGHT AND THE LINE INDEX IY INCREASES FROM  ===A C==   TOP TO BOTTOM.                                           ==FA C==                                                            ==0A C==   VALID DEVICE TYPES (IDEV > 0: CURSOR ADDRESSABLE         ==OA C==   TERMINALS) ARE LISTED IN SUBROUTINES CURSOR AND ABUFF.   ===A C==                                                            ===A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C, MARCH 5, 1979.   ===A C==                                                            ===A C==   INPUT  PARAMETERS: IX,IY,IDEV,IOUT, (I*4).               ===A C==                                                            ===A C=================================================================A C=================================================================       LOGICAL*1 CCH(10)W       INTEGER*2 LEN|A C================================================================WA C==   MOD=Z00004008: WRITE@BIN@-TRIM MODIFIER.                 == A C================================================================        INTEGER MOD/Z00004008/       IF(IDEV.LE.0)RETURNEA C=================================================================A C==   ACURSOR(2,...) RETURNS THE CURSOR CONTROL CHARACTERS CCH == A C==   FOR POSITIONING THE CURSOR AT THE (COLUMN,LINE) POSITION == A C==   IX,IY ON THE DEVICE IDEV. IF THE DEVICE IS INVALID THEN  ==SA C==   GO TO &10.                                               == A C==   WRITE OUT THE CURSOR CONTROL CHARACTERS ON UNIT IOUT.    ==.A C================================================================ 1       CALL ACURSOR(2,CCH,NCCH,IX,IY,0,0,IDEV,&10)        LEN=NCCH( C      CALL WRITE(CCH,LEN,MOD,LNUM,IOUT)'       WRITE(IOUT,305)(CCH(II),II=1,LEN)R 305   FORMAT('+',$,255A1)  10    RETURN	       END 7       SUBROUTINE APRINTB(MINX,MAXX,MINY,MAXY,IDEV,IOUT)RA C================================================================DA C================================================================ A C==                                                            ===A C==   APRINTB: PRINTS THE LARGE (IDEV=-1) OR SMALL (IDEV=0)    ===A C==   INTERNAL PLOT BUFFER ONTO UNIT IOUT. THE WINDOW REGION   ==HA C==   OF THE BUFFER PRINTED BY APRINTB IS DEFINED BY THE COLUMN===A C==   RANGE: MINX TO MAXX AND THE LINE RANGE: MINY TO MAXY.    == A C==   NOTE: THE ORIGIN (IX,IY)=(1,1) IS AT THE TOP LEFT-HAND   ===A C==   CORNER OF THE BUFFER, I.E. THE COLUMN INDEX IX INCREASES == A C==   FROM LEFT TO RIGHT AND THE LINE INDEX IY INCREASES FROM  ===A C==   TOP TO BOTTOM.                                           ==7A C==                                                            ==0A C==                                                            == A C==   DEVICE TYPES ARE:                                        ===A C==                                                            == A C==   IDEV=-1: LARGE INTERNAL PLOT BUFFER ARRAY "LBUFF" IN     == A C==            COMMON /LBUFF/. THIS BUFFER IS NXLBUF (=132)    == A C==            COLUMNS BY NYLBUF (=66) LINES, I.E. ONE 15"X11" ===A C==            PAGE, (USUALLY A PRINTER HARDCOPY).             == A C==                                                            ===A C==   IDEV=0 : SMALL INTERNAL PLOT BUFFER ARRAY "SBUFF" IN     == A C==            COMMON /SBUFF/. THIS BUFFER IS NXSBUF (=80)     ===A C==            COLUMNS BY NYSBUF (=40) LINES, I.E. ONE SCREEN  ===A C==            PAGE, (USUALLY A SCREEN COPY ON A NON-CURSOR    == A C==            ADDRESSABLE TERMINAL).                          ==UA C==                                                            ==EA C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  ==HA C==                                                            ==EA C==   INPUT  PARAMETERS: MINX,MAXX,MINY,MAXY,IDEV,IOUT, (I*4). ==SA C==                                                            == A C==   OUTPUT PARAMETERS: NONE.                                 == A C==                                                            ==RA C==   MINX: MINIMUM X COORDINATE (COLUMN) OF THE BUFFER WINDOW ==LA C==         TO BE PRINTED.                                     ==OA C==   MAXX: MAXIMUM X COORDINATE (COLUMN) OF THE BUFFER WINDOW == A C==         TO BE PRINTED.                                     == A C==   MINY: MINIMUM Y COORDINATE (LINE  ) OF THE BUFFER WINDOW ==NA C==         TO BE PRINTED.                                     == A C==   MAXY: MAXIMUM Y COORDINATE (LINE  ) OF THE BUFFER WINDOW ==EA C==         TO BE PRINTED.                                     == A C==   IDEV: DEVICE TYPE (=-1 OR 0).                            == A C==   IOUT: OUTPUT UNIT ON WHICH THE PLOT "BUFFER" WINDOW WILL == A C==         BE PRINTED.                                        ===A C==                                                            ===A C================================================================AA C================================================================= C=A C================================================================MA C==   IDEV=-1: LARGE INTERNAL PLOT BUFFER (HARDCOPY).          ===A C================================================================        LOGICAL*1 LBUFF=0       COMMON /LBUFF/ NXLBUF,NYLBUF,LBUFF(132,66)        DATA NXLBUF,NYLBUF/132,66/A C================================================================NA C==   IDEV=0: SMALL INTERNAL PLOT BUFFER (SCREEN COPY).        ==EA C================================================================        LOGICAL*1 SBUFF /       COMMON /SBUFF/ NXSBUF,NYSBUF,SBUFF(80,40)S       DATA NXSBUF,NYSBUF/80,40/T       IGO=IDEV+2       GO TO (100,200),IGO=       RETURNA C================================================================ A C==   IDEV=-1: LARGE INTERNAL PLOT BUFFER (HARDCOPY).          ==RA C================================================================ A C==   TRUNCATE WINDOW TO FIT WITHIN BUFFER DIMENSIONS.         ==EA C================================================================= 100   MMINX=MAX0(MINX,1)       MMAXX=MIN0(MAXX,NXLBUF)=       MMINY=MAX0(MINY,1)       MMAXY=MIN0(MAXY,NYLBUF)        IF(MMINX.GT.MMAXX)RETURN       IF(MMINY.GT.MMAXY)RETURN       DO 120 J=MMINY,MMAXY/       WRITE(IOUT,110)(LBUFF(I,J),I=MMINX,MMAXX)T 110   FORMAT('9',132A1)= 120   CONTINUE       RETURNA C================================================================HA C==   IDEV=0: SMALL INTERNAL PLOT BUFFER (SCREEN COPY).        ==(A C================================================================.A C==   TRUNCATE WINDOW TO FIT WITHIN BUFFER DIMENSIONS.         ==EA C================================================================  200   MMINX=MAX0(MINX,1)       MMAXX=MIN0(MAXX,NXSBUF)        MMINY=MAX0(MINY,1)       MMAXY=MIN0(MAXY,NYSBUF)        IF(MMINX.GT.MMAXX)RETURN       IF(MMINY.GT.MMAXY)RETURN       DO 220 J=MMINY,MMAXY/       WRITE(IOUT,210)(SBUFF(I,J),I=MMINX,MMAXX)  210   FORMAT('9',132A1)  220   CONTINUE       RETURN	       ENDR?       SUBROUTINE SCALE2(XMIN,XMAX,N,XMINS,XMAXS,DIST,SVAL,NVAL)CA C================================================================CA C================================================================PA C==                                                            == A C==   SCALE2: GIVEN XMIN AND XMAX (XMIN <= XMAX) AND N > 1, THE==SA C==          DESIRED RANGE AND NUMBER OF INTERVALS OF THE SCALE,=CA C==          SCALE2 DETERMINES XMINS, XMAXS, AND DIST THE NEW  ==CA C==          RANGE AND INTERVAL OF THE SCALE. XMINS, XMAXS,    ==PA C==          AND DIST HAVE THE FOLLOWING PROPERTIES:           ==AA C==                                                            == A C==          1) XMINS <= XMIN <= XMAX <= XMAXS = XMINS+N*DIST. ==YA C==          2) XMINS AND XMAXS ARE INTEGRAL MULTIPLES OF DIST.== A C==          3) DIST = SVAL(I)*10**M FOR SOME EXPONENT M, WHERE==RA C==             1 <= I <= NVAL, AND SVAL(I) IS A NICE NUMBER   == A C==             BETWEEN 1 AND 10 (1. <= SVAL(I) < 10.).        ==RA C==             (SEE BELOW FOR MORE ABOUT SVAL.)               == A C==                                                            ==IA C==   ALGORITHM USED FOR SCALING IS FROM: PAGE 640 OF          ==BA C==   COMMUNICATIONS OF THE ACM, OCT. 1973, VOL. 16, NUMBER 10.==IA C==                                                            ==BA C==   REWRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., SEPT 19, 1978.==IA C==                                                            ==BA C==   INPUT  PARAMETERS: XMIN,XMAX,N,SVAL,NVAL.                ==IA C==                                                            ==BA C==   OUTPUT PARAMETERS: XMINS,XMAXS,DIST.                     ==IA C==                                                            ==PA C==   XMIN  : (R*4) MINIMUM X-VALUE OF THE DESIRED RANGE OF THE==PA C==                 SCALE.                                     == A C==   XMAX  : (R*4) MAXIMUM X-VALUE OF THE DESIRED RANGE OF THE===A C==                 SCALE.                                     ===A C==   N     : (I*4) NUMBER OF SCALE INTERVALS, (N > 1).        ===A C==   XMINS : (R*4) MINIMUM X-VALUE OF THE NEW SCALE.          ==-A C==   XMAXS : (R*4) MAXIMUM X-VALUE OF THE NEW SCALE.          ===A C==   DIST  : (R*4) INTERVAL SIZE OF THE NEW SCALE (DIST > 0). ==AA C==   SVAL  : (R*4) ARRAY OF NVAL                              == A C==                 "NICE" SCALE VALUES BETWEEN 1 & 10 IN      ===A C==                 ASCENDING ORDER (1 <= SVAL(I) < 10,        ==RA C==                 SVAL(I) < SVAL(I+1)).                      ===A C==   NVAL  : (I*4) NUMBER OF "NICE" SCALE                     ==BA C==                 VALUES IN SVAL. IF NVAL <= 0 THEN SCALE    == A C==                 USES ITS OWN DEFAULT SET OF "NICE" VALUES: ===A C==                 1, 1.2, 1.5, 2, 2.5, 3, 4, 5, 6, 8.        ==DA C==                                                            ===A C================================================================RA C================================================================="       DIMENSION SVAL(1),SVALUE(10):       DATA SVALUE/1.0,1.2,1.5,2.0,2.5,3.0,4.0,5.0,6.0,8.0/       DATA NVALUE/10/ )       IF(XMIN.LE.XMAX.AND.N.GT.1)GO TO 30X       WRITE(6,25)FC 25    FORMAT(' ***ERROR*** IN CALL TO SCALE2: XMIN MUST BE <= XMAX'J!      *      ,' & N MUST BE > 1.')(       RETURNA C================================================================NA C==   FIND APPROXIMATE INTERVAL SIZE A.                        ==HA C================================================================( 30    XMAXX=XMAX-       IF(XMAXX.EQ.XMIN)XMAXX=XMIN+N*ABS(XMIN)=       A=(XMAXX-XMIN)/N       IF(A.LE.0.)XMAXX=XMIN+NN       IF(A.LE.0.)A=1.=       NAL=ALOG10(A)=       IF (A.LT.1.) NAL=NAL-1A C================================================================ A C==   SCALE A INTO A VARIABLE B BETWEEN 1 AND 10 (1 <= B <= 10)==IA C================================================================M       B=A/10.**NALA C================================================================ A C==   FIND THE CLOSEST "NICE" VALUE => B.                      ==MA C=================================================================       DEL=.00002       IF(NVAL.GT.0)GO TO 50=       DO 40 I=1,NVALUE$       IF(B.LE.SVALUE(I)+DEL)GO TO 60 40    CONTINUE       GO TO 55 50    DO 52 I=1,NVAL"       IF(B.LE.SVAL(I)+DEL)GO TO 60 52    CONTINUE	 55    I=1D       NAL=NAL+1=A C=================================================================A C==   COMPUTE THE INTERVAL SIZE: DIST.                         ===A C================================================================= 60    IF(NVAL.GT.0)GO TO 65F       DIST=SVALUE(I)*10.**NAL=       GO TO 68 65    DIST=SVAL(I)*10.**NAL A C================================================================XA C==   FIND THE NEW MAXIMUM AND MINIMUM SCALE LIMITS:           ==RA C==   XMINS AND XMAXS.                                         ==SA C================================================================I 68    FMIN=XMIN/DIST       MIN=FMIN       IF(FMIN.LT.0.)MIN=MIN-1L*       IF(ABS(MIN+1.-FMIN).LE.DEL)MIN=MIN+1       XMINS=MIN*DIST       FMAX=XMAXX/DIST        MAX=FMAX       IF(FMAX.GT.0.)MAX=MAX+1 *       IF(ABS(MAX-1.-FMAX).LE.DEL)MAX=MAX-1       XMAXS=MAX*DISTA C================================================================ A C==   CHECK WHETHER ANOTHER PASS IS REQUIRED                   == A C================================================================B       NS=MAX-MIN       IF(NS.LE.N)GO TO 80        I=I+1        IF(NVAL.GT.0)GO TO 70B       IF(I.LE.NVALUE)GO TO 60,       GO TO 55 70    IF(I.LE.NVAL)GO TO 60        GO TO 55 80    ND=(N-NS)/2        XMINS=XMINS-ND*DIST )       IF(XMIN.GE.0.)XMINS=AMAX1(XMINS,0.)        XMAXS=XMINS+N*DIST*       IF(XMAXX.LE.0.)XMAXS=AMIN1(XMAXS,0.)       XMINS=XMAXS-N*DISTA C================================================================ A C==   ADJUST LIMITS TO ACCOUNT FOR ROUND-OFF IF NECESSARY.     ==MA C================================================================ !       IF(XMINS.GT.XMIN)XMINS=XMIN #       IF(XMAXS.LT.XMAXX)XMAXS=XMAXX        RETURN	       ENDE>       SUBROUTINE AUTO(X,Y,NPT,XMIN,XINC,YMIN,YINC,NXINC,NYINC)A C================================================================ A C================================================================FA C==                                                            == A C==   AUTO: PERFORMS AUTOMATIC SCALING ON THE NPT (X,Y) POINTS ==LA C==   PROVIDED XINC <= 0 OR YINC <= 0. IF BOTH XINC & YINC ARE == A C==   LESS THAN OR EQUAL TO 0, THEN AUTO RETURNS XMIN,XINC,    ==IA C==   YMIN,YINC SUCH THAT: XINC & YINC ARE NICE NUMBERS, XMIN  =="A C==   & YMIN ARE MULTIPLES OF XINC & YINC, AND                 == A C==   XMIN <= X(I) <= XMIN+NXINC*XINC, I=1,...,NPT,            ==FA C==   YMIN <= Y(I) <= YMIN+NYINC*YINC, I=1,...,NPT.            == A C==   IF XINC > 0 AND YINC <= 0, THEN AUTO PERFORMS AUTOMATIC  == A C==   SCALING OF THE Y-AXIS, I.E. IT RETURNS YMIN,YINC SUCH    ===A C==   THAT YINC IS A NICE NUMBER AND                           ===A C==   YMIN <= Y(I) <= YMIN+NYINC*YINC, FOR ALL Y(I) WHOSE      == A C==   CORRESPONDING X(I) FALLS WITHIN THE FIXED RANGE:         ==AA C==   XMIN <= X(I) <= XMIN+NXINC*XINC (I.E. Y-SCALING IS DONE  ==RA C==   ONLY ON THOSE POINTS WHICH FALL WITHIN THE FIXED X-RANGE).= A C==   IF THERE ARE NO X(I) POINTS WITHIN THIS RANGE THEN YMIN, ===A C==   YINC ARE NOT CHANGED AND AUTO SIMPLE RETURNS. IT ALSO    == A C==   PERFORMS SIMILAR AUTOMATIC SCALING OF THE X-AXIS IF THE  ===A C==   REVERSE IS TRUE: XINC <= 0 AND YINC > 0. IF XINC AND YINC== A C==   ARE BOTH > 0 THEN AUTO RETURNS WITHOUT DOING ANYTHING.   == A C==                                                            ==AA C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  ===A C==                                                            ==LA C==   INPUT  PARAMETERS: X(NPT),Y(NPT),XMIN,XINC,YMIN,YINC (R*4)==A C==                      NPT,NXINC,NYINC, (I*4).               ==/A C==                                                            ===A C==   OUTPUT PARAMETERS: XMIN,XINC,YMIN,YINC, (R*4).           == A C==                                                            ===A C==   X    : ARRAY OF X COORDINATES TO BE USED IN SCALING.     ==4A C==   Y    : ARRAY OF Y COORDINATES TO BE USED IN SCALING.     == A C==   NPT  : NUMBER OF POINTS IN THE X,Y ARRAYS.               ==TA C==   XMIN : MINIMUM X-VALUE OF THE X-AXIS SCALE, (NOT CHANGED ===A C==          IF XINC > 0).                                     ==HA C==   XINC : X-INCREMENT OR INTERVAL SIZE OF THE X-AXIS SCALE, ===A C==          (NOT CHANGED IF XINC > 0).                        ==TA C==   YMIN : MINIMUM Y-VALUE OF THE Y-AXIS SCALE, (NOT CHANGED == A C==          IF YINC > 0).                                     ===A C==   YINC : Y-INCREMENT OR INTERVAL SIZE OF THE Y-AXIS SCALE, ==EA C==          (NOT CHANGED IF YINC > 0).                        == A C==   NXINC: NUMBER OF X-AXIS SCALE INCREMENTS OR INTERVALS.   ===A C==   NYINC: NUMBER OF Y-AXIS SCALE INCREMENTS OR INTERVALS.   == A C==                                                            ==1A C================================================================ A C================================================================X       DIMENSION X(1),Y(1)=       LOGICAL POINT=A C================================================================TA C==   IF THERE ARE NO POINTS RETURN.                           ===A C================================================================        IF(NPT.LE.0)RETURNA C================================================================6A C==   TAKE CARE OF LIMITING CASES WHEN NXINC OR NYINC < 2.     ==0A C================================================================M       NXINCS=MAX0(NXINC,2)       NYINCS=MAX0(NYINC,2)       NXINC1=MAX0(NXINC,1)       NYINC1=MAX0(NYINC,1)       XINCS=XINC       YINCS=YINC       IF(XINCS.GT.0.)GO TO 20=A C================================================================ A C==   X-AXIS AUTOMATIC SCALING:                                ===A C================================================================M       XMIN=X(1)        XMAX=X(1)E       YMAX=YMIN+NYINC1*YINCS       POINT=.FALSE.,       DO 10 I=1,NPT=@       IF(YINCS.GT.0..AND.(Y(I).LT.YMIN.OR.Y(I).GT.YMAX))GO TO 10       POINT=.TRUE.       IF(X(I).LT.XMIN)XMIN=X(I)=       IF(X(I).GT.XMAX)XMAX=X(I)  10    CONTINUEA C================================================================ A C==   IF THERE ARE NO Y(I) POINTS TO BE FOUND WITHIN THE FIXED == A C==   Y RANGE: YMIN <= Y(I) <= YMIN+NYINC*YINC WHEN YINC > 0,  ==RA C==   THEN RETURN WITHOUT DOING ANYTHING (I.E. XINC WILL STILL ==EA C==   BE <= 0 ON RETURN TO THE CALLING PROGRAM).               ==,A C================================================================1       IF(.NOT.POINT)RETURNA C=================================================================A C==   PERFORM AUTOMATIC SCALING OF THE X-AXIS.                 ===A C=================================================================;       CALL SCALE2(XMIN,XMAX,NXINCS,XMINS,XMAXS,XINC,SVAL,0)=       XMIN=XMINS        IF(NXINC.LE.1)XINC=2.*XINC 20    IF(YINCS.GT.0.)RETURNRA C================================================================NA C==   Y-AXIS AUTOMATIC SCALING:                                ==YA C================================================================T       YMIN=Y(1)P       YMAX=Y(1)        XMAX=XMIN+NXINC1*XINCS       POINT=.FALSE.D       DO 30 I=1,NPT @       IF(XINCS.GT.0..AND.(X(I).LT.XMIN.OR.X(I).GT.XMAX))GO TO 30       POINT=.TRUE.       IF(Y(I).LT.YMIN)YMIN=Y(I)D       IF(Y(I).GT.YMAX)YMAX=Y(I)= 30    CONTINUEA C================================================================ A C==   IF THERE ARE NO X(I) POINTS TO BE FOUND WITHIN THE FIXED ==AA C==   X RANGE: XMIN <= X(I) <= XMIN+NXINC*XINC WHEN XINC > 0,  == A C==   THEN RETURN WITHOUT DOING ANYTHING (I.E. YINC WILL STILL ==MA C==   BE <= 0 ON RETURN TO THE CALLING PROGRAM).               == A C================================================================        IF(.NOT.POINT)RETURNA C================================================================ A C==   PERFORM AUTOMATIC SCALING OF THE Y-AXIS.                 == A C================================================================D;       CALL SCALE2(YMIN,YMAX,NYINCS,YMINS,YMAXS,YINC,SVAL,0)B       YMIN=YMINS        IF(NYINC.LE.1)YINC=2.*YINC       RETURN	       END C       SUBROUTINE AAXIS(XMIN,XINC,NSXINC,YMIN,YINC,NSYINC,MINX,MAXX,=A      *                 MINY,MAXY,XLAB,NXLAB,YLAB,NYLAB,IDEV,IOUT) A C=================================================================A C================================================================ A C==                                                            ===A C==   AAXIS: PRINTS X & Y (HORIZONTAL & VERTICAL) AXES ONTO THE== A C==   DEVICE IDEV ATTACHED TO THE OUTPUT UNIT IOUT WITHIN THE  ==.A C==   PLOT WINDOW COLUMN RANGE MINX TO MAXX, AND THE LINE      ===A C==   RANGE:: MINY TO MAXY. THE LENGTH OF THE X-AXIS IS        ==TA C==   MAXX-MINX+1 CHARACTERS AND THE LENGTH OF THE Y-AXIS IS   ==YA C==   MAXY-MINY+1 CHARACTERS.                                  == A C==                                                            ==CA C==   NOTE: THE ORIGIN (IX,IY)=(1,1) IS AT THE TOP LEFT-HAND   ===A C==   CORNER OF THE DEVICE, I.E. THE COLUMN INDEX IX INCREASES ===A C==   FROM LEFT TO RIGHT AND THE LINE INDEX IY INCREASES FROM  == A C==   TOP TO BOTTOM. HENCE MINX,MINY IS AT THE TOP LEFT-HAND   ===A C==   CORNER OF THE PLOT WINDOW.                               == A C==                                                            ==NA C==   DEVICE TYPES ARE LISTED IN SUBROUTINE ABUFF.             ==RA C==                                                            ===A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  ===A C==                                                            ===A C==   INPUT  PARAMETERS: XMIN,XINC,YMIN,YINC (R*4); MINX,MAXX, ==SA C==                      MINY,MAXY,NXLAB,NYLAB,IDEV,IOUT (I*4);==AA C==                      XLAB(NXLAB),YLAB(NYLAB) (L*1);        == A C==                      NSXINC,NSYINC (I*4).                  == A C==                                                            ===A C==   XMIN : MINIMUM X-VALUE OF THE X-AXIS (AT COLUMN MINX).   ==EA C==   XINC : X-INCREMENT PER COLUMN. XINC MUST BE > 0.         ==CA C==          NOTE: XMAX = XMIN+(MAXX-MINX)*XINC.               ==LA C==   NSXINC: EVERY NSXINC'TH CHARACTER ON THE X-AXIS IS A TIC,== A C==           I.E. NUMBER OF SMALL INCREMENTS (CHARACTERS) PER ===A C==           LARGE INCREMENT (TIC-MARK) ON X-AXIS.            ===A C==   YMIN : MINIMUM Y-VALUE OF THE Y-AXIS (AT LINE   MAXY).   ==LA C==   YINC : Y-INCREMENT PER LINE.   YINC MUST BE > 0.         ===A C==          NOTE: YMAX = YMIN+(MAXY-MINY)*YINC.               ==,A C==   NSYINC: EVERY NSYINC'TH CHARACTER OF THE Y-AXIS IS A TIC,==LA C==           I.E. NUMBER OF SMALL INCREMENTS (CHARACTERS) PER ==MA C==           LARGE INCREMENT (TIC-MARK) ON Y-AXIS.            == A C==   MINX : MINIMUM X (COLUMN) OF THE PLOT WINDOW.            ==IA C==   MAXX : MAXIMUM X (COLUMN) OF THE PLOT WINDOW.            == A C==   MINY : MINIMUM Y (LINE)   OF THE PLOT WINDOW.            ==MA C==   MAXY : MAXIMUM Y (LINE)   OF THE PLOT WINDOW.            == A C==   XLAB : NXLAB CHARACTERS WHICH MAKE UP THE X-AXIS LABEL.  ==IA C==   NXLAB: NUMBER OF CHARACTERS IN XLAB. (MAY BE <= 0 IN     == A C==          WHICH CASE NO LABEL IS PRINTED).                  ==XA C==   YLAB : NYLAB CHARACTERS WHICH MAKE UP THE Y-AXIS LABEL.  ==YA C==   NYLAB: NUMBER OF CHARACTERS IN YLAB. (MAY BE <= 0 IN     == A C==          WHICH CASE NO LABEL IS PRINTED).                  ===A C==   IDEV : DEVICE TYPE ONTO WHICH THE AXES ARE TO BE PRINTED.===A C==   IOUT : OUTPUT UNIT ATTACHED TO DEVICE IDEV. ONLY USED IF ==IA C==          IDEV > 0.                                         ===A C==                                                            ==NA C==   PARAMETERS FOR CONTROLLING THE FORMAT OF THE AXES:       ===A C==                                                            == A C==   COMMON BLOCK /APLOTC/ ("APLOT COMMON") PARAMETERS:       == A C==   (DEFAULTS SHOWN IN "/ /"'S)                              == A C==                                                            == A C==   NXDIG/5/,NXDEC/1/,IPOWX/0/,PXAUTO/.TRUE./,XCROSS/.TRUE./,==1A C==   NYDIG/4/,NYDEC/1/,IPOWY/0/,PYAUTO/.TRUE./,YCROSS/.TRUE./,==UA C==   GRID/.FALSE./.                                           ==SA C==                                                            ==NA C==   NXDIG,NXDEC,IPOWX (I*4); PXAUTO,XCROSS (L*4);            ===A C==   NYDIG,NYDEC,IPOWY (I*4); PYAUTO,YCROSS,GRID (L*4).       ===A C==                                                            == A C==   NXDIG : NUMBER OF DIGITS IN THE X-AXIS NUMBER FORMAT.    == A C==   NYDIG : NUMBER OF DIGITS IN THE Y-AXIS NUMBER FORMAT.    ==TA C==   NXDEC : NUMBER OF DECIMALS IN THE X-AXIS NUMBER FORMAT.  ==TA C==   NYDEC : NUMBER OF DECIMALS IN THE Y-AXIS NUMBER FORMAT.  ==XA C==           IF NXDEC OR NYDEC < 0 THEN THE DECIMAL POINT IS  ==EA C==           SUPPRESSED. IF NXDEC OR NYDEC = 0 THEN THERE ARE == A C==           NO DECIMAL PLACES BUT THE DECIMAL POINT IS NOT   == A C==           SUPPRESSED.                                      ==PA C==   IPOWX : POWER (BASE 10) BY WHICH X-AXIS NUMBERS ARE      == A C==           SCALED DOWN, IF PXAUTO = .FALSE..                ==CA C==   IPOWY : POWER (BASE 10) BY WHICH Y-AXIS NUMBERS ARE      ==PA C==           SCALED DOWN, IF PYAUTO = .FALSE..                == A C==           IF THE POWER IPOW (BASE 10), USED TO SCALE DOWN  == A C==           THE NUMBERS ON AN AXIS, IS NON-ZERO THEN IT IS   ==.A C==           PRINTED WITH THE AXIS LABEL AS *10**IPOW, I.E.   == A C==           THE AXIS VALUES ARE THE AXIS NUMBERS MULTIPLIED  ==RA C==           BY 10**IPOW.                                     == A C==   PXAUTO: IF PXAUTO=.TRUE. THEN IPOWX WILL BE CHOSEN AUTO- ==)A C==           MATICALLY SO THAT THE MAXIMUM NUMBER OF SIGNI-   ==EA C==           CANT DIGITS WILL APPEAR IN THE X-AXIS FORMAT.    ==(A C==           IF PXAUTO=.FALSE. THEN THE X-AXIS POWER IS FIXED == A C==           TO THE VALUE OF IPOWX.                           == A C==   PYAUTO: IF PYAUTO=.TRUE. THEN IPOWY WILL BE CHOSEN AUTO- ==LA C==           MATICALLY SO THAT THE MAXIMUM NUMBER OF SIGNI-   == A C==           CANT DIGITS WILL APPEAR IN THE Y-AXIS FORMAT.    == A C==           IF PYAUTO=.FALSE. THEN THE Y-AXIS POWER IS FIXED ==AA C==           TO THE VALUE OF IPOWY.                           ==AA C==   XCROSS: IF XCROSS=.TRUE. THEN THE Y-AXIS (OR AXES IN THE ==SA C==           CASE WHEN GRID=.TRUE.) IS ALLOWED TO CROSS THE   ==NA C==           INNER TIC MARKS OF THE X-AXIS.                   == A C==           IF XCROSS=.FALSE. THEN THE Y-AXIS IS ONLY ALLOWED== A C==           TO CROSS THE X-AXIS AT THE WINDOW COLUMN LIMITS: ==AA C==           MINX AND MAXX.                                   ==AA C==   YCROSS: IF YCROSS=.TRUE. THEN THE X-AXIS (OR AXES IN THE ==SA C==           CASE WHEN GRID=.TRUE.) IS ALLOWED TO CROSS THE   ==WA C==           INNER TIC MARKS OF THE Y-AXIS.                   ==WA C==           IF YCROSS=.FALSE. THEN THE X-AXIS IS ONLY ALLOWED==WA C==           TO CROSS THE Y-AXIS AT THE WINDOW LINE LIMITS:   ==WA C==           MINY AND MAXY.                                   ==-A C==   GRID  : IF GRID = .FALSE. THEN ONLY THE 2 REGULAR X & Y  ==EA C==           AXES ARE PRINTED.                                == A C==           IF GRID = .TRUE. THEN A GRID OF X & Y AXES ARE   ==-A C==           PRINTED WHICH JOIN THE X-TIC AND Y-TIC MARKS     ==EA C==           DEPENDING ON THE SETTINGS OF XCROSS & YCROSS.    == A C==           ONLY ONE OF EACH OF THE X & Y AXES ARE LABELED.  ==TA C==                                                            == A C==   COMMON BLOCK /APLOTX/ ("APLOT EXTRA") PARAMETERS:        == A C==   (DEFAULTS SHOWN IN "/ /"'S)                              == A C==                                                            ==EA C==   IXLAB/-1/,IYLAB/-1/, (I*4).                              == A C==                                                            ==MA C==   IXLAB : IF IXLAB=-1 THEN THE X-AXIS LABELS AND NUMBERS   == A C==           WILL ALWAYS BE PRINTED BELOW THE X-AXIS, EVEN IF == A C==           THE X-AXIS IS ON THE MAXIMUM LINE: MAXY. IN THIS ==CA C==           CASE THE X-AXIS NUMBERS AND LABEL WILL BE PRINTED==CA C==           ON THE 2 LINES BELOW THE WINDOW LINE LIMIT: MAXY.== A C==           IF IXLAB=+1 THEN THE X-AXIS LABELS AND NUMBERS   == A C==           WILL ALWAYS BE PRINTED ABOVE THE X-AXIS, EVEN IF ==)A C==           THE X-AXIS IS ON THE MINIMUM LINE: MINY.         == A C==           IF IXLAB=0  THEN THE X-AXIS LABELS AND NUMBERS   == A C==           WILL BE PRINTED BELOW THE X-AXIS, UNLESS THE     ==EA C==           X-AXIS IS ON THE BOTTOM TWO LINES, IN WHICH CASE ==EA C==           THEY WILL BE PRINTED ABOVE THE X-AXIS.           ==MA C==   IYLAB:  IF IYLAB=-1 THEN THE Y-AXIS NUMBERS WILL ALWAYS  ==MA C==           BE PRINTED TO THE LEFT OF THE Y-AXIS, EVEN IF THE==MA C==           Y-AXIS IS ON THE MINIMUM COLUMN: MINX. IN THIS   ==HA C==           ONE SHOULD SET MINX => NYDIG+1 SO THAT THE Y-AXIS==OA C==           NUMBERS WILL APPEAR ON THE DEVICE OR BUFFER.     == A C==           IF IYLAB=+1 THEN THE Y-AXIS NUMBERS WILL ALWAYS  ==BA C==           BE PRINTED TO THE RIGHT OF THE Y-AXIS, EVEN IF   == A C==           THE Y-AXIS IS ON THE MAXIMUM COLUMN: MAXX.       ==BA C==           IF IYLAB=0 THEN THE Y-AXIS NUMBERS WILL BE       == A C==           PRINTED TO THE LEFT OF THE Y-AXIS, UNLESS THERE  ==OA C==           IS NOT ENOUGH ROOM BETWEEN MINX AND THE Y-AXIS   == A C==           FOR THE NYDIG DIGITS OF THE Y-FORMAT, IN WHICH   ==*A C==           CASE THEY WILL BE PRINTED TO THE RIGHT.          ==SA C==                                                            == A C==   EXAMPLES USING XCROSS,YCROSS, AND GRID:                  == A C==                                                            ==RA C==   1) GRID=.FALSE.: ONLY ONE OF EACH AXIS WILL BE PRINTED.  ==IA C==     A) XCROSS=.TRUE. & YCROSS=.TRUE.: REGULAR AXES CROSSING==OA C==        THROUGH X=0 AND Y=0 IF POSSIBLE.                    == A C==     B) XCROSS=.FALSE.: Y-AXIS PRINTED AT THE LEFT OF THE   == A C==                        PLOT WINDOW.                        ==RA C==     C) YCROSS=.FALSE.: X-AXIS PRINTED AT THE BOTTOM OF     ==IA C==                        THE PLOT WINDOW.                    ==OA C==   2) GRID=.TRUE.: 2 OR MORE OF EACH AXES WILL BE PRINTED.  == A C==     A) XCROSS=.FALSE. & YCROSS=.FALSE.: AXES FORM A BOX    ==RA C==        AROUND THE PLOT WINDOW. ONLY THE BOTTOM AND FAR LEFT==OA C==        AXES WILL BE LABELED.                               == A C==     B) XCROSS=.TRUE.: GRID OF VERTICAL Y-AXES JOINING X-TIC==SA C==                       MARKS WILL BE PRINTED.               ==OA C==     C) YCROSS=.TRUE.: GRID OF HORIZONTAL X-AXES JOINING    == A C==                       Y-TIC MARKS WILL BE PRINTED.         ==RA C==                                                            ==OA C================================================================ A C================================================================S/       LOGICAL*1 XLAB(1),YLAB(1),CHARB,CHVAL(20)I3       LOGICAL PXAUTO,PYAUTO,XCROSS,YCROSS,GRID,EQUCY6       COMMON /APLOTC/ NXDIG,NXDEC,IPOWX,PXAUTO,XCROSS,:      *                NYDIG,NYDEC,IPOWY,PYAUTO,YCROSS,GRID1       DATA NXDIG,NXDEC,IPOWX,PXAUTO/5,1,0,.TRUE./ 1       DATA NYDIG,NYDEC,IPOWY,PYAUTO/4,1,0,.TRUE./E4       DATA XCROSS,YCROSS,GRID/.TRUE.,.TRUE.,.FALSE./!       COMMON /APLOTX/ IXLAB,IYLABR       DATA IXLAB,IYLAB/-1,-1/D/       COMMON /CHARB/ IX(100),IY(100),CHARB(100)=       DATA NBMX/100/2       LOGICAL*1 BAR,BAR1/'|'/,BAR2/'I'/,MINUS/'-'/4       LOGICAL*1 POWLAB(8)/'*','1','0','*','*',3*' '/A C================================================================ A C==   USE THE REGULAR BAR (|), UNLESS ON A IDEV=4: COMTERM     == A C==   (ADM-1) TERMINAL (WHICH DOESN'T HAVE A "|"), IN WHICH    == A C==   CASE USE AN "I" FOR THE BAR.                             == A C================================================================        BAR=BAR1       IF(IDEV.EQ.4)BAR=BAR2IA C================================================================LA C==   CHECK THE INPUT PARAMETERS.                              ==MA C==   NXPOS = NUMBER OF X-AXIS CHARACTERS.                     ==NA C==   NYPOS = NUMBER OF Y-AXIS CHARACTERS.                     ==WA C==   LIMIT NXDIG TO: 0 <= NXDIG <= 20.                        ==IA C==   LIMIT NYDIG TO: 0 <= NYDIG <= 20.                        ==OA C================================================================M       IF(XINC.LE.0.)RETURN       IF(YINC.LE.0.)RETURN       NXPOS=MAXX-MINX+1N       NYPOS=MAXY-MINY+1        IF(NXPOS.LE.0)RETURN       IF(NYPOS.LE.0)RETURN       NSXNC=NSXINC       NSYNC=NSYINC       IF(NSXNC.LE.0)NSXNC=10       IF(NSYNC.LE.0)NSYNC=5T"       NXDIG=MAX0(MIN0(NXDIG,20),0)"       NYDIG=MAX0(MIN0(NYDIG,20),0)       NXDEC=MAX0(NXDEC,-1)       NYDEC=MAX0(NYDEC,-1)A C================================================================ A C==   IXZERO: COLUMN LOCATION OF THE X-AXIS ZERO.              ==DA C==   IXCROS: COLUMN LOCATION WHERE THE Y-AXIS CROSSES THE     ==IA C==           X-AXIS.                                          ==+A C==   NXMIN : NUMBER OF AXIS COLUMNS BEFORE THE FIRST TIC MARK ==DA C==           ON THE X-AXIS.                                   ==SA C==   NXMAX : NUMBER OF AXIS COLUMNS AFTER THE LAST TIC MARK ON==0A C==           THE X-AXIS.                                      ==OA C==   NXVAL : NUMBER OF TIC MARKS ON THE X-AXIS = NUMBER OF    ==OA C==           X-VALUES USED TO LABEL THE X-AXIS.               ==YA C==   IXVAL : COLUMN LOCATION OF THE FIRST TIC MARK ON THE     == A C==           X-AXIS.                                          == A C================================================================R       ZERO=MINX-XMIN/XINC        IXZERO=ZERO+SIGN(.5,ZERO) )       IXCROS=MAX0(MIN0(IXZERO,MAXX),MINX) (       IF(.NOT.XCROSS.OR.GRID)IXCROS=MINX"       NXMIN=MOD(IXZERO-MINX,NSXNC)%       IF(NXMIN.LT.0)NXMIN=NXMIN+NSXNCE"       NXMAX=MOD(MAXX-IXZERO,NSXNC)%       IF(NXMAX.LT.0)NXMAX=NXMAX+NSXNC )       NXVAL=(NXPOS-NXMIN-NXMAX-1)/NSXNC+1Y       IXVAL=MINX+NXMIN(       IF(IXVAL.EQ.MINX)IXVAL=IXVAL+NSXNCA C================================================================:A C==   IYZERO: LINE LOCATION OF THE Y-AXIS ZERO.                == A C==   IYCROS: LINE LOCATION WHERE THE X-AXIS CROSSES THE       ==RA C==           Y-AXIS.                                          == A C==   NYMIN : NUMBER OF AXIS LINES BEFORE THE TOP TIC MARK     ==TA C==           ON THE Y-AXIS.                                   ==AA C==   NYMAX : NUMBER OF AXIS LINES AFTER THE BOTTOM TIC MARK ON== A C==           THE Y-AXIS.                                      == A C==   NYVAL : NUMBER OF TIC MARKS ON THE Y-AXIS = NUMBER OF    == A C==           Y-VALUES USED TO LABEL THE Y-AXIS.               == A C==   IYVAL : LINE LOCATION OF THE FIRST (BOTTOM) TIC MARK ON  == A C==           THE Y-AXIS.                                      ===A C=================================================================       ZERO=MAXY+YMIN/YINC=       IYZERO=ZERO+SIGN(.5,ZERO)B)       IYCROS=MAX0(MIN0(IYZERO,MAXY),MINY) (       IF(.NOT.YCROSS.OR.GRID)IYCROS=MAXY"       NYMIN=MOD(IYZERO-MINY,NSYNC)%       IF(NYMIN.LT.0)NYMIN=NYMIN+NSYNC "       NYMAX=MOD(MAXY-IYZERO,NSYNC)%       IF(NYMAX.LT.0)NYMAX=NYMAX+NSYNC,)       NYVAL=(NYPOS-NYMIN-NYMAX-1)/NSYNC+1P       IYVAL=MAXY-NYMAX(       IF(IYVAL.EQ.MAXY)IYVAL=IYVAL-NSYNCA C================================================================BA C==   PRINT THE X-AXIS (OR AXES IF GRID=.TRUE.) ON THE DEVICE. ==AA C================================================================ A C==   NB: IS THE CHARACTER BUFFER (IX,IY,CHARB) INDEX <= NBMX. ===A C================================================================E
       NB=0
       NAXIS=1I       IF(GRID)NAXIS=2 F       IF(GRID.AND.YCROSS)NAXIS=NYVAL+2+MIN0(NYMIN-1,0)+MIN0(NYMAX-1,0)       DO 120 J=1,NAXIS       IXC=MINX-1       IF(J.EQ.NAXIS)IYC=MINY       IF(J.EQ.1)IYC=IYCROS4       IF(J.GT.1.AND.J.LT.NAXIS)IYC=IYVAL-(J-2)*NSYNC       DO 110 I=1,NXPOSD       IF(NB.GE.NBMX)CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       IF(NB.GE.NBMX)NB=0
       NB=NB+1        IX(NB)=IXC+I       IY(NB)=IYC       CHARB(NB)=MINUST:       IF(MOD(IABS(IX(NB)-IXZERO),NSXNC).EQ.0)CHARB(NB)=BAR 110   CONTINUE 120   CONTINUEA C================================================================ A C==   PRINT THE Y-AXIS (OR AXES IF GRID=.TRUE.) ON THE DEVICE. == A C=================================================================
       NAXIS=1X       IF(GRID)NAXIS=2 F       IF(GRID.AND.XCROSS)NAXIS=NXVAL+2+MIN0(NXMIN-1,0)+MIN0(NXMAX-1,0)       DO 220 J=1,NAXIS       IF(J.EQ.NAXIS)IXC=MAXX       IF(J.EQ.1)IXC=IXCROS4       IF(J.GT.1.AND.J.LT.NAXIS)IXC=IXVAL+(J-2)*NSXNC       IYC=MAXY+1       DO 210 I=1,NYPOSD       IF(NB.GE.NBMX)CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       IF(NB.GE.NBMX)NB=0
       NB=NB+1=       IX(NB)=IXC       IY(NB)=IYC-I       CHARB(NB)=BAR=<       IF(MOD(IABS(IY(NB)-IYZERO),NSYNC).EQ.0)CHARB(NB)=MINUS 210   CONTINUE 220   CONTINUE       IF(NXDIG.LE.0)GO TO 335SA C================================================================ A C==   PRINT THE X-AXIS NUMBERS AT EACH TIC MARK ON THE X-AXIS. == A C================================================================ A C==   IXVAL: INITIAL COLUMN OF THE FIRST X-AXIS NUMBER.        ==IA C==   XMINV: MINIMUM X-VALUE AT THE FIRST TIC MARK.            == A C==   XINCS: X-INCREMENT PER A TIC MARK.                       ==BA C==   IPX  : POWER (BASE 10) BY WHICH THE X-AXIS NUMBERS ARE   == A C==          SCALED DOWN.                                      ==NA C================================================================ $       IXVAL=MINX+NXMIN-NXDIG+NXDEC+1       XMINV=XMIN+NXMIN*XINC=       XINCS=XINC*NSXNC       IPX=IPOWX        IF(.NOT.PXAUTO)GO TO 310A C================================================================OA C==   DETERMINE THE POWER IPX (BASE 10) BY WHICH TO SCALE THE  ==MA C==   X-AXIS NUMBERS SO THAT THE MAXIMUM NUMBER OF SIGNIFICANT == A C==   DIGITS ARE DISPLAYED.                                    ==1A C==   XMAXV : MAXIMUM X-VALUE AT THE LAST TIC MARK.            ==VA C==   AXMINV: POSITIVE NUMBER WHICH CONTAINS THE SAME NUMBER OF===A C==           DIGITS AS XMINV.                                 == A C==   AXMAXV: POSITIVE NUMBER WHICH CONTAINS THE SAME NUMBER OF== A C==           DIGITS AS XMAXV.                                 == A C==   AXMAX : MAX(AXMINV,AXMAXV).                              ==KA C================================================================ !       XMAXV=XMINV+(NXVAL-1)*XINCSX       AXMINV=ABS(XMINV)*1.0001&       IF(XMINV.LT.0.)AXMINV=10.*AXMINV       AXMAXV=ABS(XMAXV)*1.0001&       IF(XMAXV.LT.0.)AXMAXV=10.*AXMAXV        AXMAX=AMAX1(AXMINV,AXMAXV)A C================================================================ A C==   DETERMINE THE POWER IPX SO THAT AXMAX WILL FIT IN THE    == A C==   FORMAT SPECIFICATION: F(NXDIG).(NXDEC) WITH THE MAXIMUM  == A C==   NUMBER OF SIGNIFICANT DIGITS. THE FINAL RESULT IS A      == A C==   CHARACTER STRING CHVAL, WHERE AXMAX=CHVAL*10**IPX.       == A C================================================================I1       CALL REALCH(AXMAX,-1,IPX,NXDIG,NXDEC,CHVAL) A C================================================================NA C==   PRINT THE X-AXIS NUMBERS AT EACH TIC MARK ON THE X-AXIS. ==NA C================================================================I 310   IYC=IYCROS+1@       IF(IXLAB.GT.0.OR.(IXLAB.EQ.0.AND.IYC.GE.MAXY))IYC=IYCROS-1       DO 330 I=1,NXVAL       XVALUE=XMINV+(I-1)*XINCS.       IF(ABS(XVALUE/XINCS).LE.1.E-4)XVALUE=0.01       CALL REALCH(XVALUE,1,IPX,NXDIG,NXDEC,CHVAL)A       IXC=IXVAL+(I-1)*NSXNC-1E       DO 320 J=1,NXDIGD       IF(NB.GE.NBMX)CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       IF(NB.GE.NBMX)NB=0
       NB=NB+1        IX(NB)=IXC+J       IY(NB)=IYC       CHARB(NB)=CHVAL(J) 320   CONTINUE 330   CONTINUEA C=================================================================A C==   PRINT THE X-AXIS LABEL AND POWER (BASE 10) IF IPX NE 0.  == A C==   NXLAB1: NUMBER OF CHARACTERS IN X-LABEL: XLAB.           ==9A C==   NXLAB2: NUMBER OF CHARACTERS IN POWER LABEL: POWLAB.     == A C==           POWER LABEL HAS THE FORM: *10**IPX.              ==DA C================================================================  335   NXLAB1=MAX0(NXLAB,0)       NXLAB2=0A C================================================================ A C==   IF IPX=0 THEN DO NOT PRINT THE POWER LABEL: *10**IPX.    ===A C================================================================A       IF(IPX.EQ.0)GO TO 350OA C================================================================NA C==   IPX NE 0: PRINT THE POWER LABEL: *10**IPX.               == A C==   CONVERT THE POWER IPX TO AN I3 FORMAT CHARACTER STRING IN== A C==   CHVAL.                                                   ==NA C================================================================        RIPX=IPX&       CALL REALCH(RIPX,1,0,3,-1,CHVAL)       NXLAB2=5A C================================================================2A C==   STORE THE NON-BLANK CHARACTERS OF THE POWER (IPX) STRING ===A C==   INTO THE POWER LABEL ARRAY: POWLAB.                      ==SA C=================================================================       DO 340 I=1,3%       IF(EQUC(CHVAL(I),' '))GO TO 340I       NXLAB2=NXLAB2+1R       POWLAB(NXLAB2)=CHVAL(I)= 340   CONTINUEA C================================================================CA C==   PRINT THE 2 LABELS: XLAB AND POWLAB.                     ==RA C================================================================E( 350   IXC=MINX+(NXPOS-NXLAB1-NXLAB2)/2-1       IYC=IYCROS+2@       IF(IXLAB.GT.0.OR.(IXLAB.EQ.0.AND.IYC.GT.MAXY))IYC=IYCROS-2       IF(NXLAB1.LE.0)GO TO 370A C================================================================ A C==   PRINT XLAB.                                              ===A C================================================================        DO 360 I=1,NXLAB1 D       IF(NB.GE.NBMX)CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       IF(NB.GE.NBMX)NB=0
       NB=NB+1        IX(NB)=IXC+I       IY(NB)=IYC       CHARB(NB)=XLAB(I)T 360   CONTINUE 370   IF(NXLAB2.LE.0)GO TO 400A C================================================================ A C==   PRINT THE POWER LABEL: POWLAB = *10**IPX.                == A C================================================================        IXC=IXC+NXLAB1       DO 380 I=1,NXLAB2 D       IF(NB.GE.NBMX)CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       IF(NB.GE.NBMX)NB=0
       NB=NB+1=       IX(NB)=IXC+I       IY(NB)=IYC       CHARB(NB)=POWLAB(I)  380   CONTINUE 400   IXC=IXCROS       IF(NYDIG.LE.0)GO TO 435XA C================================================================0A C==   PRINT THE Y-AXIS NUMBERS AT EACH TIC MARK ON THE Y-AXIS. ===A C================================================================EA C==   IYVAL: INITIAL LINE OF THE FIRST (BOTTOM) Y-AXIS NUMBER. ==IA C==   YMINV: MINIMUM Y-VALUE AT THE FIRST (BOTTOM) TIC MARK.   ==CA C==   YINCS: Y-INCREMENT PER A TIC MARK.                       ==CA C==   IPY  : POWER (BASE 10) BY WHICH THE Y-AXIS NUMBERS ARE   ===A C==          SCALED DOWN.                                      ==,A C=================================================================       IYVAL=MAXY-NYMAX       YMINV=YMIN+NYMAX*YINCM       YINCS=YINC*NSYNC       IPY=IPOWY        IF(.NOT.PYAUTO)GO TO 410A C================================================================LA C==   DETERMINE THE POWER IPY (BASE 10) BY WHICH TO SCALE THE  ==IA C==   Y-AXIS NUMBERS SO THAT THE MAXIMUM NUMBER OF SIGNIFICANT ==)A C==   DIGITS ARE DISPLAYED.                                    ==VA C==   YMAXV : MAXIMUM Y-VALUE AT THE LAST (TOP) TIC MARK.      == A C==   AYMINV: POSITIVE NUMBER WHICH CONTAINS THE SAME NUMBER OF== A C==           DIGITS AS YMINV.                                 ==NA C==   AYMAXV: POSITIVE NUMBER WHICH CONTAINS THE SAME NUMBER OF===A C==           DIGITS AS YMAXV.                                 ===A C==   AYMAX : MAX(AYMINV,AYMAXV).                              ===A C=================================================================!       YMAXV=YMINV+(NYVAL-1)*YINCS        AYMINV=ABS(YMINV)*1.0001&       IF(YMINV.LT.0.)AYMINV=10.*AYMINV       AYMAXV=ABS(YMAXV)*1.0001&       IF(YMAXV.LT.0.)AYMAXV=10.*AYMAXV        AYMAX=AMAX1(AYMINV,AYMAXV)A C=================================================================A C==   DETERMINE THE POWER IPY SO THAT AYMAX WILL FIT IN THE    ==EA C==   FORMAT SPECIFICATION: F(NYDIG).(NYDEC) WITH THE MAXIMUM  ===A C==   NUMBER OF SIGNIFICANT DIGITS. THE FINAL RESULT IS A      ===A C==   CHARACTER STRING CHVAL, WHERE AYMAX=CHVAL*10**IPY.       == A C================================================================ 1       CALL REALCH(AYMAX,-1,IPY,NYDIG,NYDEC,CHVAL)IA C================================================================ A C==   PRINT THE Y-AXIS NUMBERS AT EACH TIC MARK ON THE Y-AXIS. ===A C================================================================  410   IXC=IXCROS-NYDIG-1@       IF(IYLAB.GT.0.OR.(IYLAB.EQ.0.AND.IXC+1.LT.MINX))IXC=IXCROS       DO 430 I=1,NYVAL       YVALUE=YMINV+(I-1)*YINCS.       IF(ABS(YVALUE/YINCS).LE.1.E-4)YVALUE=0.01       CALL REALCH(YVALUE,1,IPY,NYDIG,NYDEC,CHVAL)=       IYC=IYVAL-(I-1)*NSYNC=       DO 420 J=1,NYDIGD       IF(NB.GE.NBMX)CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       IF(NB.GE.NBMX)NB=0
       NB=NB+1N       IX(NB)=IXC+J       IY(NB)=IYC       CHARB(NB)=CHVAL(J) 420   CONTINUE 430   CONTINUEA C=================================================================A C==   PRINT THE Y-AXIS LABEL AND POWER (BASE 10) IF IPY NE 0.  ==XA C==   NYLAB1: NUMBER OF CHARACTERS IN Y-LABEL: YLAB.           ==.A C==   NYLAB2: NUMBER OF CHARACTERS IN POWER LABEL: POWLAB.     == A C==           POWER LABEL HAS THE FORM: *10**IPY.              == A C================================================================  435   NYLAB1=MAX0(NYLAB,0)       NYLAB2=0A C================================================================MA C==   IF IPY=0 THEN DO NOT PRINT THE POWER LABEL: *10**IPY.    ==NA C================================================================        IF(IPY.EQ.0)GO TO 450OA C=================================================================A C==   IPY NE 0: PRINT THE POWER LABEL: *10**IPY.               ==:A C==   CONVERT THE POWER IPY TO AN I3 FORMAT CHARACTER STRING IN===A C==   CHVAL.                                                   == A C================================================================,       RIPY=IPY&       CALL REALCH(RIPY,1,0,3,-1,CHVAL)       NYLAB2=5A C================================================================TA C==   STORE THE NON-BLANK CHARACTERS OF THE POWER (IPY) STRING ===A C==   INTO THE POWER LABEL ARRAY: POWLAB.                      == A C=================================================================       DO 440 I=1,3%       IF(EQUC(CHVAL(I),' '))GO TO 440        NYLAB2=NYLAB2+1F       POWLAB(NYLAB2)=CHVAL(I)E 440   CONTINUEA C================================================================IA C==   PRINT THE 2 LABELS: YLAB AND POWLAB.                     ==PA C================================================================   450   IF(IXC.EQ.IXCROS)GO TO 452&       IXC=IXCROS-NYDIG-NYLAB1-NYLAB2-2#       IF(IXC+1.LT.MINX)IXC=IXCROS+1=       GO TO 455   452   IXC=IXCROS-NYLAB1-NYLAB2-2)       IF(IXC+1.LT.MINX)IXC=IXCROS+NYDIG+1  455   IYC=MINY       IF(GRID)IYC=MINY+1       IF(NYLAB1.LE.0)GO TO 470A C================================================================ A C==   PRINT YLAB.                                              ==HA C================================================================D       DO 460 I=1,NYLAB1 D       IF(NB.GE.NBMX)CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       IF(NB.GE.NBMX)NB=0
       NB=NB+1E       IX(NB)=IXC+I       IY(NB)=IYC       CHARB(NB)=YLAB(I)  460   CONTINUE 470   IF(NYLAB2.LE.0)GO TO 500A C================================================================ A C==   PRINT THE POWER LABEL: POWLAB = *10**IPY.                == A C=================================================================       IXC=IXC+NYLAB1       DO 480 I=1,NYLAB2=D       IF(NB.GE.NBMX)CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       IF(NB.GE.NBMX)NB=0
       NB=NB+1=       IX(NB)=IXC+I       IY(NB)=IYC       CHARB(NB)=POWLAB(I)A 480   CONTINUEA C=================================================================A C==   BUFFER OUT ANY OF THE REMAINING CHARACTERS IN CHARB.     ==OA C================================================================Y6 500   CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       RETURN	       END <       SUBROUTINE APLT(X,Y,CHAR,MASK,NPT,XMIN,XINC,YMIN,YINC,4      *                MINX,MAXX,MINY,MAXY,IDEV,IOUT)A C================================================================1A C=================================================================A C==                                                            ==CA C==   APLT: PLOTS THE NPT POINTS STORED IN THE ARRAYS X & Y,   ===A C==   (USING THE NPT PLOT CHARACTERS IN CHAR), ONTO THE DEVICE ==GA C==   IDEV ATTACHED TO THE OUTPUT UNIT IOUT, WITHIN THE PLOT   ==NA C==   WINDOW COLUMN RANGE: MINX TO MAXX, AND THE LINE RANGE:   ==.A C==   MINY TO MAXY. THE PLOT WINDOW IS MAXX-MINX+1 COLUMNS BY  ===A C==   MAXY-MINY+1 LINES.                                       ==.A C==                                                            ==NA C==   IF  XINC = 0 OR  YINC = 0 THEN THE SUBROUTINE APLT       ==CA C==   USES SUBROUTINE AUTO TO PERFORM AUTOMATIC SCALING OF     ===A C==   XMIN,XINC OR YMIN,YINC (SEE SUBROUTINE AUTO FOR DETAILS).==RA C==                                                            ==YA C==   THE PLOT CHARACTER ARRAY: CHAR(NPT) CAN CONTAIN ANY      ==YA C==   CHARACTERS. A BLANK CHARACTER IS RECOGNIZED AS A BLANK,  == A C==   I.E. IT CAN BE USED TO BLANK OUT CHARACTERS ON THE PLOT. ===A C==   THERE ARE ALSO 2 SPECIAL CHARACTERS WHICH AREN'T PLOTTED:==YA C==   "<" : THIS CHARACTER SIGNIFIES THAT A 1/4-CHARACTER      ===A C==         VISUAL RESOLUTION CHARACTER IS TO BE USED IN THE   ==TA C==         CELL, I.E. ONE OF THE 4 CHARACTERS: (.,:').        ===A C==   ">" : THIS CHARACTER SIGNIFIES THAT A 1/10-CHARACTER     ===A C==         DIGITAL RESOLUTION CHARACTERS IS TO BE USED IN THE ===A C==         CELL, I.E. ONE OF THE 10 DIGITS: (0,1,2,3,4,5,6,7, ===A C==         8,9).                                              ===A C==                                                            ===A C==   NOTE: THE ORIGIN (IX,IY)=(1,1) IS AT THE TOP LEFT-HAND   == A C==   CORNER OF THE DEVICE, I.E. THE COLUMN INDEX IX INCREASES ==5A C==   FROM LEFT TO RIGHT AND THE LINE INDEX IY INCREASES FROM  ==TA C==   TOP TO BOTTOM. HENCE MINX,MINY IS AT THE TOP LEFT-HAND   ===A C==   CORNER OF THE PLOT WINDOW.                               == A C==                                                            ===A C==   DEVICE TYPES ARE LISTED IN SUBROUTINE ABUFF.             == A C==                                                            ===A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  ===A C==                                                            ===A C==   INPUT  PARAMETERS: X(NPT),Y(NPT),XMIN,XINC,YMIN,YINC (R*4)=5A C==                      CHAR(NPT), (L*1); NPT,MINX,MAXX,MINY, ==2A C==                      MAXY,IDEV,IOUT, (I*4).                ==XA C==                                                            == A C==   OUTPUT PARAMETERS: XMIN,XINC,YMIN,YINC, (R*4).           == A C==                                                            ===A C==   X    : ARRAY OF X COORDINATES OF POINTS TO BE PLOTTED.   == A C==   Y    : ARRAY OF Y COORDINATES OF POINTS TO BE PLOTTED.   ===A C==   CHAR : ARRAY OF PLOT CHARACTERS TO BE PRINTED AT EACH    ==,A C==          X,Y LOCATION.                                     == A C==   MASK : FLAG TO INDICATE CHOICE OF CHARACTER ARRAY, I.E.  ==BA C==          IF MASK = 0 --> USE ENTIRE "CHAR" ARRAY OF NPT    ===A C==                          POINTS FOR PLOTTING CHARACTERS.   ==HA C==                  = 1 --> USE THE SINGLE CHARACTER "CHAR(1)"===A C==                          FOR PLOTTING ALL THE POINTS, I.E. ==+A C==                          ONLY A SINGLE CHARACTER NEED BE   ==,A C==                          PASSED TO "APLT" IN THIS CASE.    == A C==                  = N --> USE THE SINGLE CHARACTER "CHAR(1)"==LA C==                 (N>=2)   FOR PLOTTING ALL THE POINTS, WITH ===A C==                          EVERY N'TH POINT OVERLAID (MASKED)==CA C==                          WITH "CHAR(2)". HERE TWO CHARACTERS==A C==                          ONLY NEED BE PASSED TO "APLT".    ==,A C==                                                            ==RA C==   NPT  : NUMBER OF POINTS IN THE X,Y,CHAR ARRAYS.          ==YA C==   XMIN : MINIMUM X-VALUE OF THE X-AXIS SCALE, (NOT CHANGED ===A C==          IF XINC > 0).                                     ===A C==   XINC : X-INCREMENT PER COLUMN. (NOT CHANGED IF XINC > 0).== A C==   YMIN : MINIMUM Y-VALUE OF THE Y-AXIS SCALE, (NOT CHANGED ==RA C==          IF YINC > 0).                                     ==TA C==   YINC : Y-INCREMENT PER LINE. (NOT CHANGED IF YINC > 0).  ==IA C==   MINX : MINIMUM X (COLUMN) OF THE PLOT WINDOW.            ==LA C==   MAXX : MAXIMUM X (COLUMN) OF THE PLOT WINDOW.            ==1A C==   MINY : MINIMUM Y (LINE)   OF THE PLOT WINDOW.            == A C==   MAXY : MAXIMUM Y (LINE)   OF THE PLOT WINDOW.            == A C==   IDEV : DEVICE TYPE ONTO WHICH THE POINTS ARE TO BE PLOTTED=NA C==   IOUT : OUTPUT UNIT ATTACHED TO DEVICE IDEV. ONLY USED IF ==CA C==          IDEV > 0.                                         == A C==                                                            == A C================================================================TA C================================================================        DIMENSION X(1),Y(1).       LOGICAL*1 CHAR(1),CHARBA/       COMMON /CHARB/ IX(100),IY(100),CHARB(100)S       DATA NBMX/100/2       LOGICAL*1 CHAR4/'<'/,CH4(4)/1H.,1H,,1H:,1H'/       LOGICAL*1 CHAR10/'>'/,A      *          CH10(10)/'0','1','2','3','4','5','6','7','8','9'/E       LOGICAL EQUCA C================================================================ A C==   PERFORM AUTOMATIC SCALING IF XINC <= 0 OR YINC <= 0.     == A C================================================================ @       CALL AUTO(X,Y,NPT,XMIN,XINC,YMIN,YINC,MAXX-MINX,MAXY-MINY)A C================================================================ A C==   CHECK THE INPUT PARAMETERS.                              ==EA C================================================================N       IF(NPT.LE.0)RETURN       IF(XINC.LE.0.)RETURN       IF(YINC.LE.0.)RETURNA C================================================================NA C==   PLOT THE NPT POINTS: (X(I),Y(I),CHAR(I)), I=1,NPT.       ==TA C================================================================ A C==   NB: IS THE CHARACTER BUFFER (IX,IY,CHARB) INDEX <= NBMX. ==LA C================================================================ 
       NB=0       DO 10 I=1,NPT A C================================================================9A C==   IIX: COLUMN CORRESPONDING TO X(I). COLUMN MINX CORRESPONDS= A C==        TO X = XMIN.                                        ==CA C==   IIY: LINE CORRESPONDING TO Y(I). LINE MAXY CORRESPONDS TO==MA C==        Y = YMIN.                                           == A C================================================================ "       IIX=MINX+(X(I)-XMIN)/XINC+.5,       IF(IIX.LT.MINX.OR.IIX.GT.MAXX)GO TO 10"       IIY=MAXY-(Y(I)-YMIN)/YINC+.5,       IF(IIY.LT.MINY.OR.IIY.GT.MAXY)GO TO 10D       IF(NB.GE.NBMX)CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       IF(NB.GE.NBMX)NB=0
       NB=NB+1        IX(NB)=IIX       IY(NB)=IIY       IF(MASK-1)1,2,3T     1 CHARB(NB)=CHAR(I)        GOTO 5     2 CHARB(NB)=CHAR(1)        GOTO 5     3 CHARB(NB)=CHAR(1)D.       IF(MOD(I-1,MASK).EQ.0) CHARB(NB)=CHAR(2)A C================================================================ A C==   NDIV = NUMBER OF CELL SUB-DIVISIONS.                     == A C================================================================      5 NDIV=1%       IF(EQUC(CHARB(NB),CHAR4))NDIV=4 '       IF(EQUC(CHARB(NB),CHAR10))NDIV=10L       IF(NDIV.EQ.1)GO TO 10 A C================================================================ A C==   IYF = NUMBER OF THE SUB-DIVISION WHERE Y(I) FALLS IN THE ==)A C==         IIY'TH CELL.                                       ==HA C================================================================D7       IYF=(Y(I)-((MAXY-IIY-.5)*YINC+YMIN))/YINC*NDIV+1.W        IYF=MAX0(MIN0(IYF,NDIV),1)%       IF(NDIV.EQ.4)CHARB(NB)=CH4(IYF)"'       IF(NDIV.EQ.10)CHARB(NB)=CH10(IYF)  10    CONTINUEA C================================================================RA C==   BUFFER OUT REMAINING PLOT CHARACTERS.                    ==EA C================================================================ 6       CALL ABUFF(IX,IY,CHARB,NB,1,999,1,999,IDEV,IOUT)       RETURN	       END)D       SUBROUTINE UPDATE(X,Y,XP,YP,IP,CHAR,MASK,NPT,XDIFF,YDIFF,XMIN,5      *                  XMAX,NLXINC,YMIN,YMAX,NLYINC, 6      *                  MINX,MAXX,MINY,MAXY,IDEV,IOUT)A C================================================================PA C================================================================PA C==                                                            ==PA C==   UPDATE: SELECTIVELY UPDATES THE OLD (XP,YP) POINTS WHICH ==PA C==   WERE PREVIOUSLY PLOTTED ON THE SCREEN WITH THE NEW (X,Y) == A C==   POINTS, PROVIDED THAT EITHER:                            ==VA C==   |X(I)-XP(I)| => XDIFF OR |Y(I)-YP(I)| => YDIFF.          == A C==   THE XP,YP ARRAYS ARE ALSO SELECTIVELY UPDATED WITH THE   == A C==   NEW X,Y VALUES PROVIDED THAT THE ABOVE INEQUALITIES HOLD.===A C==   NOTE: WHEN AN OLD POINT (XP,YP) IS UPDATED WITH THE NEW  ===A C==         POINT (X,Y) THEN THE OLD POINT WILL BE BLANKED OUT ==AA C==         PROVIDED THAT NO OTHER POINT LANDS IN THE OLD      ==SA C==         POINT'S CELL.                                      ==HA C==                                                            =='A C==   THE PROCEDURE TO FOLLOW IN USING UPDATE IS AS FOLLOWS:   ===A C==                                                            ==FA C==   1) FILL THE X,Y, AND CHAR ARRAYS WITH NPT POINTS.        ===A C==      (ONE CAN ALSO USE "MASK" WITH "CHAR").                ==LA C==   2) PLOT THESE POINTS ON THE SCREEN USING APLOT (WITH OR  ===A C==      WITHOUT AXES).                                        == A C==   3) SET THE XP,YP ARRAYS EQUAL TO THE X,Y ARRAYS.         ===A C==                                                            ==TA C==   THE UPDATE CYCLE STARTS HERE:                            ==NA C==                                                            ==NA C==   4) UPDATE THE X,Y,CHAR ARRAYS WITH THE NEW VALUES.       ==TA C==      (ONE CAN ALSO USE "MASK" WITH "CHAR").                == A C==   5) CALL UPDATE(X,Y,XP,YP,IP,CHAR,MASK,NPT,XDIFF,YDIFF,...)=LA C==      THE OTHER "..." PARAMETERS MUST BE EXACTLY THE SAME AS== A C==      THOSE USED IN THE CALL TO APLOT IN STEP 2.            ===A C==   6) IF YOU WISH TO CONTINUE THE UPDATE CYCLE GO TO STEP 4.== A C==                                                            == A C==   NOTE: THE USER DOESN'T HAVE TO TOUCH THE XP,YP ARRAYS    ==OA C==         ONCE THE UPDATE CYCLE HAS STARTED SINCE UPDATE     == A C==         AUTOMATICALLY CHANGES THEM WHEN NECESSARY.         ===A C==   NOTE: THE IP(NPT) ARRAY IS SUPPLIED BY THE USER, BUT IS  ==+A C==         ONLY USED INTERNALLY BY UPDATE.                    ==(A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  == A C==                                                            ==NA C==   INPUT  PARAMETERS: X(NPT),Y(NPT),XP(NPT),YP(NPT),XDIFF,  ==OA C==                      YDIFF,XMIN,XMAX,YMIN,YMAX, (R*4);     ==DA C==                      CHAR(NPT), (L*1); IP(NPT),MASK,NPT,   ===A C==                      NLXINC,NLYINC,MINX,MAXX,MINY,MAXY,    ==EA C==                      IDEV,IOUT (I*4).                      ===A C==                                                            == A C==   OUTPUT PARAMETERS: XP(NPT),YP(NPT),IP(NPT).              ==)A C==                                                            ===A C==   X    : ARRAY OF X COORDINATES OF NEW POINTS TO BE PLOTTED.=UA C==   Y    : ARRAY OF Y COORDINATES OF NEW POINTS TO BE PLOTTED.= A C==   XP   : ARRAY OF X COORDINATES OF OLD POINTS TO BE UPDATED.==A C==   YP   : ARRAY OF Y COORDINATES OF OLD POINTS TO BE UPDATED.=.A C==   IP   : TEMPORARY INTEGER ARRAY USED INTERNALLY BY UPDATE.== A C==   CHAR : ARRAY OF PLOT CHARACTERS TO BE USED IN UPDATING   ==HA C==          THE (XP,YP) POINTS WITH THE (X,Y) POINTS.         ===A C==   MASK : FLAG TO INDICATE CHOICE OF CHARACTER ARRAY, I.E.  ==SA C==          IF MASK = 0 --> USE ENTIRE "CHAR" ARRAY OF NPT    ===A C==                          POINTS FOR PLOTTING CHARACTERS.   ==)A C==                  = 1 --> USE THE SINGLE CHARACTER "CHAR(1)"==PA C==                          FOR PLOTTING ALL THE POINTS, I.E. == A C==                          ONLY A SINGLE CHARACTER NEED BE   ==EA C==                          PASSED TO "APLT" IN THIS CASE.    == A C==                  = N --> USE THE SINGLE CHARACTER "CHAR(1)"==,A C==                 (N>=2)   FOR PLOTTING ALL THE POINTS, WITH ==OA C==                          EVERY N'TH POINT OVERLAID (MASKED)==XA C==                          WITH "CHAR(2)". HERE TWO CHARACTERS=.A C==                          ONLY NEED BE PASSED TO "APLT".    ==NA C==   NPT  : NUMBER OF POINTS IN THE X,Y,XP,YP,IP,CHAR ARRAYS. ==TA C==   XDIFF: IF |X(I)-XP(I)| => XDIFF, THEN (XP(I),YP(I)) WILL == A C==          BE UPDATED WITH THE NEW POINT: (X(I),Y(I)).       ==DA C==   YDIFF: IF |Y(I)-YP(I)| => YDIFF, THEN (XP(I),YP(I)) WILL ==UA C==          BE UPDATED WITH THE NEW POINT: (X(I),Y(I)).       ==AA C==   XMIN : MINIMUM X-VALUE OF THE X-AXIS SCALE.              ==TA C==   XMAX : MAXIMUM X-VALUE OF THE X-AXIS SCALE.              == A C==          XMIN MUST BE < XMAX.                              == A C==   NLXINC: NUMBER OF LARGE X-INCREMENTS ON THE X-AXIS,      ==UA C==           I.E. THE X-AXIS IS SUB-DIVIDED INTO "NLXINC"     == A C==           INCREMENTS AT WHICH THE X-AXIS SCALE NUMBERS ARE ==RA C==           PRINTED.                                         == A C==   YMIN : MINIMUM Y-VALUE OF THE Y-AXIS SCALE.              == A C==   YMAX : MAXIMUM Y-VALUE OF THE Y-AXIS SCALE.              == A C==          YMIN MUST BE < YMAX.                              == A C==   NLYINC: NUMBER OF LARGE Y-INCREMENTS ON THE Y-AXIS,      == A C==           I.E. THE Y-AXIS IS SUB-DIVIDED INTO "NLYINC"     ==RA C==           INCREMENTS AT WHICH THE Y-AXIS SCALE NUMBERS ARE == A C==           PRINTED.                                         == A C==   MINX : MINIMUM X (COLUMN) OF THE PLOT WINDOW.            == A C==   MAXX : MAXIMUM X (COLUMN) OF THE PLOT WINDOW.            == A C==   MINY : MINIMUM Y (LINE)   OF THE PLOT WINDOW.            == A C==   MAXY : MAXIMUM Y (LINE)   OF THE PLOT WINDOW.            ==YA C==   IDEV : DEVICE TYPE ONTO WHICH THE PLOT IS TO BE PRINTED. == A C==   IOUT : OUTPUT UNIT ATTACHED TO DEVICE IDEV. ONLY USED IF ==YA C==          IDEV => 0.                                        ==IA C==                                                            ===A C================================================================ A C================================================================U0       REAL X(1),Y(1),XP(1),YP(1),XT(100),YT(100)       INTEGER IP(1)F9       LOGICAL*1 CHAR(NPT),CHART(100),BLANK/' '/,XLAB,YLAB,       DATA NTMAX/100/ A C=================================================================A C==   CHECK THE INPUT PARAMETERS.                              ===A C================================================================        IF(NPT.LE.0)RETURNA C================================================================OA C==   CALL "AWIND" ("APLOT WINDOW CONVERSION") WHICH CONVERTS  ==EA C==   XMIN,XMAX,NLXINC,YMIN,YMAX,NLYINC,MINX,MAXX,MINY,MAXY TO == A C==   XINC,YINC,NSXINC,NSYINC,MMINX,MMAXX,MMINY,MMAXY, I.E.    ==FA C==   "AWIND" CONVERTS FROM THE LARGE WINDOW (AS PASSED TO     == A C==   "APLOT") TO THE SMALLER INTERNAL WINDOW (AS PASSED TO    ==LA C==   "AUTO", "AAXIS", AND "APLT").                            ==TA C================================================================B=       CALL AWIND(XMIN,XMAX,NLXINC,YMIN,YMAX,NLYINC,MINX,MAXX,IE      * MINY,MAXY,XINC,YINC,NSXINC,NSYINC,MMINX,MMAXX,MMINY,MMAXY,&60)        IF(XINC.LE.0.)RETURN       IF(YINC.LE.0.)RETURNA C================================================================UA C==   STORE THE FINAL (COLUMN,LINE) POSITIONS IIX,IIY OF ALL   == A C==   THE POINTS IN THE CELL INDEX ARRAY IP AS IIX+150*IIY.    ==WA C==   IT IS ASSUMED THAT THE SCREEN DIMENSIONS ARE < 150.      =="A C==   IF IIX OR IIY IS OUTSIDE OF THESE DIMENSIONS THEN IP(I)  ==NA C==   IS SET TO 0.                                             == A C==   THE CELL INDEX ARRAY IP IS USED BELOW TO DETERMINE       == A C==   WHETHER OR NOT TO BLANK OUT AN OLD CELL LOCATION OF A    == A C==   POINT WHICH HAS BEEN UPDATED.                            == A C================================================================        DO 20 I=1,NPTSA C================================================================TA C==   CHECK TO SEE IF THE NEW POINT (X,Y) IS WITHIN THE        ==TA C==   TOLERANCE LIMITS XDIFF,YDIFF OF THE OLD POINT (XP,YP).   ==AA C==   IF IT IS GO TO 10.                                       ==DA C================================================================X?       IF(ABS(X(I)-XP(I)).LT.XDIFF.AND.ABS(Y(I)-YP(I)).LT.YDIFF)F      *   GO TO 10)A C================================================================.A C==   THE OLD POINT (XP,YP) IS TO BE UPDATED WITH THE NEW POINT==)A C==   (X,Y). HENCE CALCULATE THE (COLUMN,LINE) POSITION:       ==.A C==   IIX,IIY OF (X,Y).                                        == A C================================================================ #       IIX=MMINX+(X(I)-XMIN)/XINC+.5 #       IIY=MMAXY-(Y(I)-YMIN)/YINC+.5=       GO TO 15A C================================================================ A C==   (XP,YP) IS NOT TO BE UPDATED. HENCE CALCULATE THE        == A C==   (COLUMN,LINE) POSITION: IIX,IIY OF (XP,YP).              == A C================================================================:$ 10    IIX=MMINX+(XP(I)-XMIN)/XINC+.5$       IIY=MMAXY-(YP(I)-YMIN)/YINC+.5A C================================================================UA C==   STORE (IIX,IIY) IN IP(I) AS IP(I)=IIX+150*IIY.           ==RA C================================================================T# 15    IF(IIX.LT.0.OR.IIY.LT.0)IIX=0"'       IF(IIX.GE.150.OR.IIY.GE.150)IIX=0C       IF(IIX.EQ.0)IIY=0S       IP(I)=IIX+150*IIYR 20    CONTINUEA C================================================================ A C==   NT: IS THE PLOT BUFFER (XT,YT,CHART) INDEX <= NTMAX.     == A C================================================================ 
       NT=0       DO 50 I=1,NPT A C================================================================YA C==   CHECK TO SEE IF THE NEW POINT (X,Y) IS WITHIN THE        == A C==   TOLERANCE LIMITS XDIFF,YDIFF OF THE OLD POINT (XP,YP).   ==YA C==   IF IT IS GO TO 50.                                       ==IA C=================================================================?       IF(ABS(X(I)-XP(I)).LT.XDIFF.AND.ABS(Y(I)-YP(I)).LT.YDIFF)=      *   GO TO 50=A C================================================================,A C==   THE OLD POINT (XP,YP) IS TO BE UPDATED WITH THE NEW POINT==AA C==   (X,Y). CALCULATE THE (COLUMN,LINE) POSITION: IIXP,IIYP   ==0A C==   OF (XP,YP) AND COMPARE ITS CORRESPONDING CELL INDEX IIP  ===A C==   = IIXP+150*IIYP WITH THE CELL INDICES IP(J), J=1,NPT, TO ===A C==   SEE IF THE CELL HAS TO BE BLANKED.                       ===A C==   IF IIP=IP(J) FOR SOME J, THEN THE CELL SHOULD NOT BE     ===A C==   BLANKED BECAUSE THIS INDICATES THAT ONE OF THE FINAL     ==VA C==   POINTS IS IN THIS CELL LOCATION.                         ==NA C================================================================M%       IIXP=MMINX+(XP(I)-XMIN)/XINC+.5I%       IIYP=MMAXY-(YP(I)-YMIN)/YINC+.5P       IIP=IIXP+150*IIYPA       DO 30 J=1,NPT        IF(IIP.EQ.IP(J))GO TO 40 30    CONTINUEA C=================================================================A C==   BLANK OUT THE OLD POINT (XP,YP).                         ==LA C==   NOTE: IN THE CALL TO APLOT, IAXIS=-2 WHICH TELLS APLOT   ==AA C==   TO OVERLAY THE PLOT (NO AXES) WITHOUT REPOSITIONING THE  ==XA C==   CURSOR AFTER THE PLOT.                                   ===A C================================================================ E       IF(NT.GE.NTMAX)CALL APLOT(XT,YT,CHART,0,NTMAX,XMIN,XMAX,NLXINC,EG      * YMIN,YMAX,NLYINC,MINX,MAXX,MINY,MAXY,XLAB,0,YLAB,0,-2,IDEV,IOUT)R       IF(NT.GE.NTMAX)NT=0 
       NT=NT+1F       XT(NT)=XP(I)       YT(NT)=YP(I)       CHART(NT)=BLANK A C================================================================ A C==   PLOT THE NEW POINT (X,Y), AND UPDATE (XP,YP).            == A C================================================================ E 40    IF(NT.GE.NTMAX)CALL APLOT(XT,YT,CHART,0,NTMAX,XMIN,XMAX,NLXINC,=G      * YMIN,YMAX,NLYINC,MINX,MAXX,MINY,MAXY,XLAB,0,YLAB,0,-2,IDEV,IOUT)=       IF(NT.GE.NTMAX)NT=0=
       NT=NT+1=       XT(NT)=X(I)=       YT(NT)=Y(I)H       IF(MASK-1)41,42,43 41    CHART(NT)=CHAR(I)        GO TO 45 42    CHART(NT)=CHAR(1)F       GO TO 45 43    CHART(NT)=CHAR(1)F-       IF(MOD(I-1,MASK).EQ.0)CHART(NT)=CHAR(2)  45    XP(I)=X(I)       YP(I)=Y(I) 50    CONTINUEA C================================================================BA C==   PLOT THE REMAINDER OF POINTS IN XT,YT,CHART.             ===A C================================================================XD       CALL APLOT(XT,YT,CHART,0,NT,XMIN,XMAX,NLXINC,YMIN,YMAX,NLYINC,5      * MINX,MAXX,MINY,MAXY,XLAB,0,YLAB,0,2,IDEV,IOUT)I 60    RETURN	       END 9       SUBROUTINE AWIND(XMIN,XMAX,NLXINC,YMIN,YMAX,NLYINC,=?      * MINX,MAXX,MINY,MAXY,XINC,YINC,NSXINC,NSYINC,MMINX,MMAXX,/      * MMINY,MMAXY,*)XA C=================================================================A C================================================================UA C==                                                            ==N@ C==   AWIND: ("WINDOW CONVERTER") CONVERTS XMIN,XMAX,NLXINC,  ==A C==           YMIN,YMAX,NLYINC,MINX,MAXX,MINY,MAXY TO XINC,YINC,=IA C==           NSXINC,NSYINC,MMINX,MMAXX,MMINY,MMAXY, I.E.      ===@ C==           "AWIND" CONVERTS FROM THE LARGE WINDOW (AS PASSED=A C==           TO "APLOT") TO THE SMALLER INTERNAL WINDOW (AS   ===A C==           PASSED TO "AUTO", "AAXIS", AND "APLT").          ==.A C==           NOTE: THE LARGE PLOT WINDOW CONTAINS THE X-AXIS  == A C==           AND Y-AXIS LABELS AND NUMBERS AS WELL AS THE PLOT===A C==           AND ITS AXES, WHILE THE SMALL INTERNAL PLOT      == A C==           WINDOW ONLY CONTAINS THE PLOT AXES, WITH AXIS    ===A C==           LABELS AND NUMBERS SOMETIMES OUTSIDE THE         == A C==           SMALL PLOT WINDOW. IN OTHER WORDS, THE LARGE PLOT===A C==           WINDOW IS MAXX-MINX+1 COLUMNS BY MAXY-MINY+1 LINES=XA C==           WHICH CONTAINS EVERYTHING ON THE PLOT, WHILE THE == A C==           SMALL PLOT WINDOW IS MMAXX-MMINX+1 COLUMNS BY    == A C==           MMAXY-MMINY+1 LINES WHICH CONTAINS THE PLOT AXES,===A C==           I.E. THE X-AXIS IS MMAXX-MMINX+1 COLUMNS LONG,   ==.A C==           AND  THE Y-AXIS IS MMAXY-MMINY+1 LINES LONG.     ===A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., FEB. 21, 1980.  ==AA C==                                                            ==DA C==   INPUT  PARAMETERS: XMIN,XMAX,YMIN,YMAX (R*4); NLXINC,    ==YA C==                      NLYINC,MINX,MAXX,MINY,MAXY (I*4).     ==LA C==                                                            ==FA C==   OUTPUT PARAMETERS: XINC,YINC (R*4); NSXINC,NSYINC,MMINX, ==SA C==                      MMAXX,MMINY,MMAXY (I*4).              ==TA C==                                                            ===A C==   PARAMETER DEFINITIONS:                                   ==PA C==   --------- -----------                                    ==IA C==                                                            == A C==   XMIN  : MINIMUM X-VALUE OF THE X-AXIS SCALE.             ===A C==                                                            == A C==   XMAX  : MAXIMUM X-VALUE OF THE X-AXIS SCALE.             ==HA C==                                                            ==OA C==   NLXINC: NUMBER OF LARGE X-INCREMENTS ON THE X-AXIS,      == A C==           I.E. THE X-AXIS IS SUB-DIVIDED INTO "NLXINC"     ===A C==           INCREMENTS AT WHICH THE X-AXIS SCALE NUMBERS ARE ==TA C==           PRINTED.                                         ==,A C==                                                            ==NA C==   YMIN  : MINIMUM Y-VALUE OF THE Y-AXIS SCALE.             == A C==                                                            == A C==   YMAX  : MAXIMUM Y-VALUE OF THE Y-AXIS SCALE.             == A C==                                                            == A C==   NLYINC: NUMBER OF LARGE Y-INCREMENTS ON THE Y-AXIS,      ==IA C==           I.E. THE Y-AXIS IS SUB-DIVIDED INTO "NLYINC"     ==IA C==           INCREMENTS AT WHICH THE Y-AXIS SCALE NUMBERS ARE ==)A C==           PRINTED.                                         ==TA C==                                                            ==5A C==   MINX  : MINIMUM X (COLUMN) OF THE LARGE PLOT WINDOW.     ==HA C==                                                            ===A C==   MAXX  : MAXIMUM X (COLUMN) OF THE LARGE PLOT WINDOW.     ==LA C==                                                            ===A C==   MINY  : MINIMUM Y (LINE)   OF THE LARGE PLOT WINDOW.     ==AA C==                                                            ==*A C==   MAXY  : MAXIMUM Y (LINE)   OF THE LARGE PLOT WINDOW.     == A C==                                                            == A C==   XINC  : X-INCREMENT PER COLUMN.                          == A C==           XINC = (XMAX-XMIN)/NLXINC/NSXINC                 ===A C==                = (XMAX-XMIN)/(MMAXX-MMINX)                 ===A C==                                                            == A C==   YINC  : Y-INCREMENT PER LINE.                            ==IA C==           YINC = (YMAX-YMIN)/NLYINC/NSYINC                 ==AA C==                = (YMAX-YMIN)/(MMAXY-MMINY)                 ==MA C==                                                            ==IA C==   NSXINC: NUMBER OF SMALL X-INCREMENTS (CHARACTERS) PER    == A C==           LARGE X-INCREMENT (TIC-MARK) ON THE X-AXIS.      ==TA C==           NSXINC = (MMAXX-MMINX)/NLXINC                    ==SA C==                                                            ==LA C==   NSYINC: NUMBER OF SMALL Y-INCREMENTS (LINES)      PER    ==NA C==           LARGE Y-INCREMENT (TIC-MARK) ON THE Y-AXIS.      == A C==           NSYINC = (MMAXY-MMINY)/NLYINC                    ==EA C==                                                            ==TA C==   MMINX : MINIMUM X (COLUMN) OF THE SMALL PLOT WINDOW.     ==XA C==                                                            ==OA C==   MMAXX : MAXIMUM X (COLUMN) OF THE SMALL PLOT WINDOW.     ==CA C==                                                            ==TA C==   MMINY : MINIMUM Y (LINE)   OF THE SMALL PLOT WINDOW.     ==LA C==                                                            ==NA C==   MMAXY : MAXIMUM Y (LINE)   OF THE SMALL PLOT WINDOW.     == A C==                                                            ==BA C==   RETURN1: OCCURS IF "NLXINC" <= 0 OR "NLYINC" <= 0 OR     == A C==            "NSXINC" <= 0 OR "NSYINC" <= 0.                 ==)A C==                                                            ==XA C================================================================ A C================================================================N.       LOGICAL PXAUTO,PYAUTO,XCROSS,YCROSS,GRIDA C================================================================ A C==   FOR A DESCRIPTION OF /APLOTC/ ("APLOT COMMON BLOCK")     == A C==   SEE "AAXIS".                                             == A C================================================================ 6       COMMON /APLOTC/ NXDIG,NXDEC,IPOWX,PXAUTO,XCROSS,:      *                NYDIG,NYDEC,IPOWY,PYAUTO,YCROSS,GRID1       DATA NXDIG,NXDEC,IPOWX,PXAUTO/5,1,0,.TRUE./ 1       DATA NYDIG,NYDEC,IPOWY,PYAUTO/4,1,0,.TRUE./C4       DATA XCROSS,YCROSS,GRID/.TRUE.,.TRUE.,.FALSE./A C================================================================-A C==   LIMIT NXDIG TO: 0 <= NXDIG <= 20.                        ==SA C==   LIMIT NYDIG TO: 0 <= NYDIG <= 20.                        ==CA C================================================================ "       NXDIG=MAX0(MIN0(NXDIG,20),0)"       NYDIG=MAX0(MIN0(NYDIG,20),0)       NXDEC=MAX0(NXDEC,-1)A C=================================================================A C==   SET MMINX & MMAXX TO ALLOW THE X-AXIS & Y-AXIS SCALE     ===A C==   NUMBERS TO FIT WITHIN THE WINDOW LIMITS: MINX TO MAXX.   ===A C=================================================================*       MMINX=MINX+MAX0(NYDIG,NXDIG-NXDEC-1)       MMAXX=MAXX-MAX0(NXDEC,0)A C================================================================ A C==   IF THE NUMBER OF LARGE X-INCREMENTS IS <= 0 RETURN1.     == A C==   DEFINE "NSXINC", THE NUMBER OF SMALL INCREMENTS OR       == A C==   CHARACTERS PER LARGE INCREMENT.                          == A C==   IF NSXINC <= 0 THEN RETURN1.                             == A C================================================================        IF(NLXINC.LE.0)RETURN1!       NSXINC=(MMAXX-MMINX)/NLXINC=       IF(NSXINC.LE.0)RETURN1A C================================================================ A C==   DEFINE "XINC" AS (XMAX-XMIN)/NLXINC/NSXINC.              == A C==   IF XINC <= 0, THEN AUTOMATIC SCALING OF THE X-AXIS WILL  == A C==   BE PERFORMED. THIS OCCURS IF XMIN => XMAX.               == A C================================================================O$       XINC=(XMAX-XMIN)/NLXINC/NSXINCA C=================================================================A C==   REDEFINE "MMAXX" TO BE THE NEW MAXIMUM COLUMN OF THE     ===A C==   PLOT WINDOW CORRESPONDING TO "NLXINC" & "NSXINC".        ===A C=================================================================       MMAXX=MMINX+NLXINC*NSXINCYA C================================================================MA C==   SET MMAXY TO ALLOW THE X-AXIS LABEL AND SCALE VALUES TO  == A C==   FIT WITHIN THE WINDOW LIMITS: MINY TO MAXY.              ==RA C================================================================C       MMAXY=MAXY-2A C================================================================ A C==   IF THE NUMBER OF LARGE Y-INCREMENTS IS <= 0 RETURN1.     == A C==   DEFINE "NSYINC", THE NUMBER OF SMALL INCREMENTS OR       == A C==   CHARACTERS PER LARGE INCREMENT.                          ==SA C==   IF NSYINC <= 0 THEN RETURN1.                             == A C================================================================        IF(NLYINC.LE.0)RETURN1        NSYINC=(MMAXY-MINY)/NLYINC       IF(NSYINC.LE.0)RETURN1A C================================================================ A C==   DEFINE "YINC" AS (YMAX-YMIN)/NLYINC/NSYINC.              == A C==   IF YINC <= 0, THEN AUTOMATIC SCALING OF THE Y-AXIS WILL  == A C==   BE PERFORMED. THIS OCCURS IF YMIN => YMAX.               == A C================================================================ $       YINC=(YMAX-YMIN)/NLYINC/NSYINCA C================================================================ A C==   REDEFINE "MMINY" TO BE THE NEW MINIMUM LINE OF THE       ==<A C==   PLOT WINDOW CORRESPONDING TO "NLYINC" & "NSYINC".        == A C================================================================        MMINY=MMAXY-NLYINC*NSYINC=       RETURN	       END=