>       SUBROUTINE ARC_CO(N,X,Y,W,ALP,BET,GAM,CUR,A,B,R,VAR,RES,2      ,                   RMAX,NOPAR,NOSTAT,KODERR) C D C ******************************************************************D C *                                                                *D C *  FAST PROGRAM FOR FITTING A SMALL CIRCULAR ARC (<40 DEGREES)   *D C *              (WEIGHTED LEAST SQUARE METHOD)                    * C J C ************************************************************************J C *    From "Fast Program for Circle Fitting" by N.I. Chernov and        *J C *         G.A. Ososkov. TRIUMF PP 87-1408                              *J C *     Collection of Scientific Papers in Collaboration with Joint      *J C *     Institute for Nuclear Research, Dubna, USSR and Central Research *J C *     Institute for Physics, Budapest, Hungary.                        *J C *     Algorithms and Programs for solution of some problems in Physics *J C *                        Fifth Volume                                  *D C *                                                                *D C *  INPUT DATA:  THE SET OF MEASURED POINTS AND THEIR WEIGHTS.    *D C *  N - THE NUMBER OF POINTS, X(I),Y(I) -THEIR COORDINATES,       *D C *  W(I) - THEIR WEIGHTS.                                         *D C *                                                                *D C *  OUTPUT DATA:  THE CIRCLE PARAMETERS AND THE RESIDUAL VECTOR.  *D C *  ALP,BET,GAM,CUR - THE NEW CIRCLE PARAMETERS FOR THE CASE OF   *D C *  HORIZONTAL ARC:  THE DISTANCE OF A POINT (X,Y) TO THE ARC IS  *D C *  DIST = CUR*(X**2+Y**2) + ALP*X + BET*Y + GAM ;                *D C *  A,B,R - THE NATURAL CIRCLE PARAMETERS:                        *D C *  A,B - THE COORDINATES OF THE CENTER, R - THE RADIUS;          *D C *  RES(I) - THE RESIDUAL VECTOR, VAR - THE ESTIMATE OF VARIANCE  *D C *                                                                *D C *  SETUP NOPAR=1 STOPS EVALUATING THE PARAMETERS A,B,R IF AN     *D C *  ARC WITH TOO LOW CURVATURE IS EXPECTED.  OTHERWISE THE        *D C *  MAXIMAL ADMISSABLE VALUE OF RADIUS RMAX MUST BE FIXED.        *D C *  SETUP NOSTAT=1 STOPS EVALUATING THE STATISTICS VAR,RES        *D C *                                                                *D C *  ERROR DIAGNOSTIC:  KODERR=0 IF NO ERRORS HAVE BEEN DETECTED;  *D C *  KODERR=1 IF THE NUMBER OF POINTS WITH POSITIVE WEIGHTS IS     *D C *           LESS THAN 3 (THE CIRCLE CANNOT BE RESTORED);         *D C *  KODERR=2 IF NEITHER A CIRCLE NOR A STRAIGHT LINE CAN BE       *D C *           FITTED TO THE GIVEN POINT SET (A DEGENERATION);      *D C *  KODERR=3 IF THE VALUE OF RADIUS IS GREATER THAN RMAX, SO THE  *D C *           PART OF PARAMETERS (R,A,B) WILL NOT BE ESTIMATED.    *D C ****************************************************************** C -       DIMENSION X(N),Y(N),W(N),RES(N),SUM(12) D       EQUIVALENCE (SUMW,SUM(1)),(X1,SUM(2)),(Y1,SUM(3)),(XY,SUM(4)),B      ,            (X2,SUM(5)),(Y2,SUM(6)),(XX,SUM(7)),(YY,SUM(8)),E      ,            (P,SUM(9)),(Q,SUM(10)),(T,SUM(11)),(SUMRES,SUM(12))        DATA EPS/1.E-10/ C        KODERR=0E C------------------ CLEAR THE ACCUMULATORS --------------------------        NPOS=0       DO 1 K=1,12     1  SUM(K)=0. E C------------------ FIT A STRAIGHT LINE TO THE DATA POINTS ----------        DO 2 I=1,N          X1=X1+X(I)*W(I)          Y1=Y1+Y(I)*W(I)          XY=XY+X(I)*Y(I)*W(I)           X2=X2+X(I)**2*W(I)           Y2=Y2+Y(I)**2*W(I)           SUMW=SUMW+W(I) %          IF (W(I).GT.EPS) NPOS=NPOS+1     2  CONTINUE C        IF (NPOS.LE.2) KODERR=1        IF (NPOS.LE.2) GOTO 10 C        DO 3 K=2,6    3  SUM(K)=SUM(K)/SUMW C        CXX=X2-X1*X1       CYY=Y2-Y1*Y1       CXY=XY-X1*Y1B C---------------- THE LINE AX*X+AY*Y+AC=0 (AX**2+AY**2=1) --------5 C                    ("ORTHOGONAL LINEAR REGRESSION")  C %       IF (ABS(CXX-CYY).GT.EPS) GOTO 4        AX=SQRT(2.)/2.       IF (CXY.GT.0.) AX=-AX        GOTO 5 C     4  COR=CXY/(CXX-CYY)        RCO=1./SQRT(4.*COR**2+1.)        IF (CXX.GT.CYY) RCO=-RCO       AX=SQRT(0.5*(1.+RCO))        IF (CXY.GE.0) AX=-AX C     5  AY=SQRT(1.-AX**2)        AC=-AX*X1-AY*Y1 C C------------- CALCULATE THE GAUSS-BRACKET VALUES -----------------        DO 6 I=1,N%          XI=AY*(X(I)-X1)-AX*(Y(I)-Y1) %          YI=AX*(X(I)-X1)+AY*(Y(I)-Y1)           DI=XI**2+YI**2           XX=XX+XI**2*W(I)           YY=YY+YI**2*W(I)           P=P+XI*DI*W(I)           Q=Q+YI*DI*W(I)           T=T+DI**2*W(I)     6  CONTINUE C        DO 7 K=7,11     7  SUM(K)=SUM(K)/SUMW C "       IF (ABS(XX).LT.EPS) KODERR=2!       IF (ABS(XX).LT.EPS) GOTO 10        DEN=T-P*P/XX-(XX+YY)**2 #       IF (ABS(DEN).LT.EPS) KODERR=2 "       IF (ABS(DEN).LT.EPS) GOTO 10 C F C---------------- CALCULATE THE NEW CIRCLE PARAMETERS ----------------       CUR=Q/DEN        ALN=CUR*P/XX       GAN=-CUR*(XX+YY)       DEN=1.+ALN**2-4.*GAN*CUR       IF (DEN.LT.EPS) KODERR=2       IF (DEN.LT.EPS) GOTO 10        BDR=1./SQRT(DEN)       IF (CUR.LT.0.) BDR=-BDR  C $       ALP=(-2.*CUR*X1-AY*ALN-AX)*BDR$       BET=(-2.*CUR*Y1+AX*ALN-AY)*BDRE       GAM=(CUR*(X1**2+Y1**2)+ALN*(AY*X1-AX*Y1)+(AX*X1+AY*Y1)+GAN)*BDR        CUR=CUR*BDR  C        IF (NOPAR.EQ.1) GOTO 8%       IF (2.*RMAX*CUR.LT.1.) KODERR=3 #       IF (2.*RMAX*CUR.LT.1.) GOTO 8  C H C---------------- CALCULATE THE NATURAL CIRCLE PARAMETERS --------------       R=1./(2.*CUR)        A=-R*ALP       B=-R*BET       IF (NOSTAT.EQ.1) GOTO 10 C H C--------------- CALCULATE THE RESIDUAL VECTOR -------------------------    8  DO 9 I=1,N;          RES(I)=X(I)*(X(I)*CUR+ALP)+Y(I)*(Y(I)*CUR+BET)+GAM %          SUMRES=SUMRES+RES(I)**2*W(I)     9  CONTINUEH C-------------- ESTIMATE THE VARIANCE ----------------------------------       VAR=SUMRES/SUMW    10  RETURN	       END 