@       SUBROUTINE ARCV(XV,YV,NV,XC,YC,X1,Y1,X2,Y2,AINC,IMAT,TMAT)H C======================================================================CH C                                                                      CH C  ARCV                                            F.W. Jones, TRIUMF  CH C                                                                      CH C  Companion routine to ARC -- returns the series of vector endpoints  CH C  used to approximate an arc.  The NV points are returned in arrays   CH C  XV and YV, which must be dimensioned at least 181.  These points    CH C  can then be used in polygon fill routines to fill the interior      CH C  of the arc.  At most 181 points will be generated, which is         CH C  sufficient for an accurate area fill.  The chord angle, AINC,       CH C  determines the actual number of points generated.  The minimum      CH C  operative value of the chord angle is 2 degrees, which corresponds  CH C  to 181 points for a closed arc.  Thus, if AINC < 2, the chord       CH C  used will be 2 degrees.                                             CH C                                                                      CH C======================================================================C C        REAL XV(181),YV(181)       REAL TMAT(6) C        DX=X1-XC       DY=Y1-YC       R=SQRT(DX**2 + DY**2)        IF(R.EQ.0.)RETURN 7       IF(ABS(AINC).LT.1.E-4.OR.ABS(AINC).GE.180.)RETURN        AINC1=MAX(2.,ABS(AINC))         IF(AINC.LT.0.)AINC1=-AINC1 C        A1=ATAN2D(DY,DX)       A2=ATAN2D(Y2-YC,X2-XC)3       IF((A2-A1)*AINC1.LE.0.)A2=A2+SIGN(360.,AINC1)  C        IF(IMAT.NE.0)THEN          T1=TMAT(1)         T2=TMAT(2)         T3=TMAT(3)         T4=TMAT(4)         T5=TMAT(5)         T6=TMAT(6)       ENDIF  C        IF(IMAT.EQ.0)THEN  CC        CALL PLOT_R(X1,Y1,3)         XV(1)=X1         YV(1)=Y1
       ELSE6 CC        CALL PLOT_R(T1*X1+T2*Y1+T3,T4*X1+T5*Y1+T6,3)         XV(1)=T1*X1+T2*Y1+T3         YV(1)=T4*X1+T5*Y1+T6       ENDIF 
       NV=1
       A=A1       IEND=0 C  20    A=A+AINC1         IF((A-A2)*AINC1.GE.0.)THEN         A=A2         IEND=2       ENDIF        X=XC+R*COSD(A)       Y=YC+R*SIND(A)       IF(IMAT.NE.0)THEN          XT=X         YT=Y         X=T1*XT+T2*YT+T3         Y=T4*XT+T5*YT+T6       ENDIF  CC      IF(ILINE.LE.1)THEN CC        CALL PLOT_R(X,Y,2) CC      ELSE$ CC        CALL DLINE(X,Y,ILINE,IEND)
 CC      ENDIF 
       NV=NV+1        XV(NV)=X       YV(NV)=Y       IF(A.NE.A2)GO TO 20  C        RETURN	       END 