J C*************************************************************************J C                                                                        *J C    25-aug-87  Both ST1D and ST2D were extensively modified.  Format    *J C  of passing the data to the terminal has now changed - these routines  *J C  only work on version 0.9j or later of ST640.  The old routines will   *J C  not work on version 0.9j or later!!!                                  *J C    Basic changes are:                                                  *J C         a) you now specify a window that you want the plot to fit      *J C            into.  You still must specify the corners of the plot       *J C            itself.  This allows me to position the labels in a simple  *J C            manner and allows selective erasing of parts of the screen. *J C         b) The y-axis on a 1-d plot can now be linear, sqrt, or log.   *J C         c) You can choose whether grids are displayed over the plot.   *J C         d) Choice of dashed or solid lines on 1-d plots (for           *J C            overlaying two plots.                                       *J C                                                                        *J C************************************************************************* C H C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; C        SUBROUTINE  ST1D( 1      +            IWXMIN, IWYMIN, IWXMAX, IWYMAX, 1      +            IDXMIN, IDYMIN, IDXMAX, IDYMAX, F      +            DAT, NDAT, XMIN, XRED, YMIN, YMAX, CLR_IT, CLR_ANSI,9      +            CLR_WINDOW, GRIDS, YSQRT, YLOG, DASHED, )      +            XLABEL, YLABEL, TITLE )  C E C   This routine passes the required data to an Atari ST terminal for C C   display of a histogram. This should be slightly faster than the D C   usual histogram displays since (a) I know that I want to displayC C   things as histogram bars so I only pass the height of the bars, B C   (b) I will be using a compression technique where each channel4 C   requires one and a quarter bytes to transmit it.D C   and (c) the tics on the axes and the labels for the tics are all> C   done by the Atari - you just pass the limits for the plot., C     The following parameters are required: C F C   IWXMIN, IWYMIN  -  Tektronix screen coords [(0,0) - (1023,779)] ofB C                      where you want the lower left corner of theA C                      display window to be.  All elements of the E C                      display, data points, labels, etc will be con- , C                      fined to this window.E C   IWXMAX, IWYMAX  -  Tektronix screen coords of where you want the  E C                      upper right corner of the display window to be I C                      (see notes on display window under IWXMIN, IWXMAX) F C   IDXMIN, IDYMIN  -  Tektronix screen coords [(0,0) - (1023,779)] ofG C                      where you want the lower left corner of the plot ; C                      to be.  MUST BE GREATER THAN (15,10) J C   IDXMAX, IDYMAX  -  Tektronix screen coords of where you want the upperI C                      right corner of the plot to be.  MUST BE LESS THAN 7 C                      (1008,769) so tics can be drawn. E C   DAT             -  array containing the data to be displayed. At  K C                      present this is REAL*4 since that is what LISA uses. F C   NDAT            -  number of data points to display, i.e. display / C                      from DAT(1) to DAT(NDAT) K C   XMIN            -  ordinate value corresponding to the first bin in DAT I C   XRED            -  reduction factor for DAT spectrum, i.e. the DAT(1) H C                      element contains counts for x-values in the range. C                      XMIN to XMIN+XRED, etc.E C   YMIN, YMAX      -  min and max values for the y-axis on the plot. 6 C                      IMPORTANT: see note under YLOG!F C   CLR_IT          -  if TRUE then the entire screen will be cleared B C                      before the histogram is plotted. (see also " C                      CLR_WINDOW)D C   CLR_ANSI        -  if true the ANSI screen will also be cleared.E C   CLR_WINDOW      -  if TRUE, then the region specified by (IWXMIN, H C                      IWYMIN) -> (IWXMAX,IWYMAX) will be cleared before. C                      the graph is displayed.E C   GRIDS           -  if TRUE then a grid will be displayed over the E C                      plot.  This grid will appear the the tic marks H C                      selected by ST640 and will be drawn with a dotted C                      line E C   YSQRT           -  if TRUE and YLOG=FALSE then the y-axis will be 9 C                      the square root of the coordinate. H C   YLOG            -  if TRUE the y-axis will be logrithmic. IMPORTANT:D C                      I only support limits YMIN and YMAX that are 7 C                      10**i  where i is some INTEGER!! E C   DASHED          -  if TRUE then the lines making up the histogram @ C                      display will be dashed rather than solid. C   XLABEL, YLABEL, TITLE J C                   -  character arrays for labelling the axes and giving L C                      a title.  Max characters for any string is 80.  Note J C                      that for convenience I put the labels right at the M C                      edge of the screen - this effectly forces the display  I C                      to be full screen unless you do your own labelling K C                      (remember that normal T4010 commands still work with % C                      the emulator.)  C ,       REAL DAT(NDAT), YMIN, YMAX, XMIN, XRED2       INTEGER NDAT, IDXMIN, IDXMAX, IDYMIN, IDYMAX,       INTEGER IWXMIN, IWYMIN, IWXMAX, IWYMAXF       LOGICAL CLR_IT, CLR_ANSI, CLR_WINDOW, GRIDS, YSQRT, YLOG, DASHED)       CHARACTER*(*) XLABEL, YLABEL, TITLE  C B C  initialize the TIPRULL routines and clear screens if requested. C        CALL TICTL(1)        IF ( CLR_ANSI ) THEN!         CALL TISTOR( 24 )   ! CAN '         CALL TISTOR( 27 )   ! ESC [ 2 J          CALL TISTOR( 91 )          CALL TISTOR( 50 )          CALL TISTOR( 74 ) %         CALL TISTOR( 27 )   ! ESC [ H          CALL TISTOR( 91 )          CALL TISTOR( 72 ) 3         CALL TISTOR( 31 )   ! US - enter alpha mode         ENDIF!       IF ( CLR_IT ) CALL TICTL(2)  C  C  enter user mode # 1 C &       CALL TISTOR( 27 )    ! ESC " 1 g       CALL TISTOR( 34 )        CALL TISTOR( 49 )        CALL TISTOR( 103 ) C  C  send the options word   C G       CALL SENDINT( IOPTIONS( CLR_WINDOW, GRIDS, YSQRT, YLOG, DASHED) )  C ( C  send the limits of the display window C 3       CALL SENDINT( IWXMIN )    ! lower left corner        CALL SENDINT( IWYMIN )3       CALL SENDINT( IWXMAX )    ! upper left corner        CALL SENDINT( IWYMAX ) C ' C  send the limits for the graph window  C 4       CALL SENDINT( IDXMIN )     ! lower left corner       CALL SENDINT( IDYMIN )5       CALL SENDINT( IDXMAX )     ! upper right corner        CALL SENDINT( IDYMAX )       DHT = IDYMAX - IDYMIN        DYMIN = IDYMIN C / C  send the real world limits for the plot axes  C        CALL SENDREAL( XMIN ) '       CALL SENDREAL( XMIN + XRED*NDAT )        CALL SENDREAL( YMIN )        CALL SENDREAL( YMAX )  C D C  send the data itself - data is packed into 1.25 bytes per channelB C  and a series of adjacent channels with no counts is sent as a 0E C  followed by a count of the number of adjacent zero count channels.  C -       CALL SENDINT( NDAT )   ! number of bins ;       CALL INIPCK             ! clear the packed card array        DELTAY = YMAX - YMIN       IZEROS = 0       DO 200 I = 1, NDAT         YDAT = DAT(I) "         IF ( YDAT .LT. YMIN ) THEN           YDAT = YMIN '         ELSE IF ( YDAT .GT. YMAX ) THEN            YDAT = YMAX 
         ENDIF 2 C        ; scale the data to Tektronix coordinates+         NY = NINT( (YDAT-YMIN)/DELTAY*DHT )          IF ( NY .EQ. 0 ) THEN            IZEROS = IZEROS + 1 J           IF ( IZEROS .EQ. 1023 ) THEN ! SENDPCARD can not handle # > 1023             CALL SENDPCARD( 0 ) $             CALL SENDPCARD( IZEROS )             IZEROS = 0            ENDIFG          ELSE  ! need to send data - get rid of accumulated zeros first #           IF ( IZEROS .NE. 0 ) THEN              CALL SENDPCARD( 0 ) $             CALL SENDPCARD( IZEROS )             IZEROS = 0            ENDIF'           CALL SENDPCARD( NY + IDYMIN ) 
         ENDIF    200 CONTINUE C # C  get rid of the rest of the zeros  C        IF ( IZEROS .NE. 0 ) THEN          CALL SENDPCARD( 0 )           CALL SENDPCARD( IZEROS )        ENDIFB       CALL CLRPCK             ! flush the packed card array buffer C " C  send the strings for the labels C        CALL SENDSTR( XLABEL )       CALL SENDSTR( YLABEL )       CALL SENDSTR( TITLE )  C  C  clear the buffer and return C        CALL TICTL(5)        RETURN	       END   H C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; C        SUBROUTINE  ST2D( 1      +            IWXMIN, IWYMIN, IWXMAX, IWYMAX, 1      +            IDXMIN, IDYMIN, IDXMAX, IDYMAX, $      +            DAT, NXDIM, NYDIM,1      +            IXSTRT, IXSTOP, IYSTRT, IYSTOP, )      +            XMIN, XRED, YMIN, YRED,       +            ZMIN, ZMAX, 6      +            CLR_IT, CLR_ANSI, CLR_WINDOW, GRIDS,)      +            XLABEL, YLABEL, TITLE )  C E C   This routine passes the required data to an Atari ST terminal for F C   display of a 2D histogram. This should be slightly faster than theD C   usual histogram displays since (a) I know that I want to displayG C   things as boxes so I only pass the number of counts scaled to 0-15, > C   (b) I will be using a compression technique where each bin( C   requires half a byte to transmit it.D C   and (c) the tics on the axes and the labels for the tics are all> C   done by the Atari - you just pass the limits for the plot., C     The following parameters are required: CeF C   IWXMIN, IWYMIN  -  Tektronix screen coords [(0,0) - (1023,779)] ofB C                      where you want the lower left corner of theA C                      display window to be.  All elements of the E C                      display, data points, labels, etc will be con- , C                      fined to this window.E C   IWXMAX, IWYMAX  -  Tektronix screen coords of where you want the  E C                      upper right corner of the display window to be I C                      (see notes on display window under IWXMIN, IWXMAX) F C   IDXMIN, IDYMIN  -  Tektronix screen coords [(0,0) - (1023,779)] ofG C                      where you want the lower left corner of the plot.; C                      to be.  MUST BE GREATER THAN (15,10)tJ C   IDXMAX, IDYMAX  -  Tektronix screen coords of where you want the upperI C                      right corner of the plot to be.  MUST BE LESS THAN 7 C                      (1008,769) so tics can be drawn.*E C   DAT             -  array containing the data to be displayed. At ;K C                      present this is REAL*4 since that is what LISA uses. @ C   NXDIM, NYDIM    -  dimensions of the array DAT, declared as ' C                      DAT(NXDIM,NYDIM) " C   IXSTRT, IXSTOP, IYSTRT, IYSTOPI C                   -  starting and stopping indices in the array for the . C                      subregion to be plottedI C   XMIN            -  ordinate value corresponding to DAT(IXSTRT,IYSTRT) K C   XRED            -  reduction factor for DAT spectrum, i.e. the DAT(1,1) H C                      element contains counts for x-values in the range. C                      XMIN to XMIN+XRED, etc.K C   YMIN            -  coordinate value corresponding to DAT(IXSTRT,IYSTRT) K C   YRED            -  reduction factor for DAT spectrum, i.e. the DAT(1,1) H C                      element contains counts for y-values in the range. C                      YMIN to YMIN+YRED, etc.K C   ZMIN, ZMAX      -  bins with counts less than or equal to ZMIN will not J C                      be displayed on the plot.  Bins with counts greaterK C                      than or equal to ZMAX will be displayed as full size J C                      boxes on the plot (size of box depends on number ofJ C                      bins).  Bins with counts between ZMIN and ZMAX willH C                      be displayed as boxes of size proportional to the3 C                      number of counts in the bin. F C   CLR_IT          -  if TRUE then the entire screen will be cleared B C                      before the histogram is plotted. (see also " C                      CLR_WINDOW)D C   CLR_ANSI        -  if true the ANSI screen will also be cleared.E C   CLR_WINDOW      -  if TRUE, then the region specified by (IWXMIN, H C                      IWYMIN) -> (IWXMAX,IWYMAX) will be cleared before. C                      the graph is displayed.E C   GRIDS           -  if TRUE then a grid will be displayed over the E C                      plot.  This grid will appear the the tic marks H C                      selected by ST640 and will be drawn with a dotted C                      line  C   XLABEL, YLABEL, TITLE J C                   -  character arrays for labelling the axes and giving L C                      a title.  Max characters for any string is 80.  Note J C                      that for convenience I put the labels right at the M C                      edge of the screen - this effectly forces the display  I C                      to be full screen unless you do your own labelling K C                      (remember that normal T4010 commands still work with % C                      the emulator.)  C ?       REAL DAT(NXDIM,NYDIM), XMIN, XRED, YMIN, YRED, ZMIN, ZMAX ,       INTEGER IWXMIN, IWYMIN, IWXMAX, IWYMAX,       INTEGER IDXMIN, IDXMAX, IDYMIN, IDYMAX,       INTEGER IXSTRT, IXSTOP, IYSTRT, IYSTOP1       LOGICAL CLR_IT, CLR_ANSI, CLR_WINDOW, GRIDS )       CHARACTER*(*) XLABEL, YLABEL, TITLE        BYTE IZ, BZEROS(2)!       EQUIVALENCE (IZEROS,BZEROS)  C E C  initialize the TIPRULL routines and clear the screens if requested  C        CALL TICTL(1)        IF ( CLR_ANSI ) THEN!         CALL TISTOR( 24 )   ! CAN '         CALL TISTOR( 27 )   ! ESC [ 2 J          CALL TISTOR( 91 )          CALL TISTOR( 50 )          CALL TISTOR( 74 ) %         CALL TISTOR( 27 )   ! ESC [ H          CALL TISTOR( 91 )          CALL TISTOR( 72 ) 3         CALL TISTOR( 31 )   ! US - enter alpha mode         ENDIF!       IF ( CLR_IT ) CALL TICTL(2)  C  C  enter user mode # 2 C &       CALL TISTOR( 27 )    ! ESC " 2 g       CALL TISTOR( 34 )        CALL TISTOR( 50 )        CALL TISTOR( 103 ) C  C  send the options word   C G       CALL SENDINT( IOPTIONS(CLR_WINDOW,GRIDS,.FALSE.,.FALSE.,.FALSE.))  C ( C  send the limits of the display window C 3       CALL SENDINT( IWXMIN )    ! lower left corner        CALL SENDINT( IWYMIN )3       CALL SENDINT( IWXMAX )    ! upper left corner        CALL SENDINT( IWYMAX ) C ' C  send the limits for the graph window  C 4       CALL SENDINT( IDXMIN )     ! lower left corner       CALL SENDINT( IDYMIN )5       CALL SENDINT( IDXMAX )     ! upper right corner        CALL SENDINT( IDYMAX )       DHT = IDYMAX - IDYMIN        DYMIN = IDYMIN C 4 C  send the number of bins in both x and y direction C %       CALL SENDINT( IXSTOP-IXSTRT+1 ) %       CALL SENDINT( IYSTOP-IYSTRT+1 )  C 5 C  send the real world coord limits for the plot axes  C        CALL SENDREAL( XMIN ) 4       CALL SENDREAL( XMIN + XRED*(IXSTOP-IXSTRT+1) )       CALL SENDREAL( YMIN ) 4       CALL SENDREAL( YMIN + YRED*(IYSTOP-IYSTRT+1) ) C > C  initialize the routine that packs the data for transmission C        CALL INIT2D  C  C  send the data itself  C        DELTAZ = ZMAX - ZMIN       IZEROS = 0        DO 200 IY = IYSTRT, IYSTOP"         DO 100 IX = IXSTRT, IXSTOP           ZDAT = DAT(IX,IY) $           IF ( ZDAT .GE. ZMAX ) THEN             IZ = 15 )           ELSE IF ( ZDAT .LE. ZMIN ) THEN              IZ = 0           ELSE,             IZ = (ZDAT-ZMIN) / DELTAZ * 15.9           ENDIF  C            CALL SEND2D( IZ )    100   CONTINUE   200 CONTINUE C & C  get rid of anything left to be sent C        CALL EMPTY2D C " C  send the strings for the labels C        CALL SENDSTR( XLABEL )       CALL SENDSTR( YLABEL )       CALL SENDSTR( TITLE )  C  C  clear the buffer and return C        CALL TICTL(5)        RETURN	       END   G C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  C @       FUNCTION IOPTIONS( CLR_WINDOW, GRIDS, YSQRT, YLOG, DASHED) C C C   take the passed logical variables and pack them into an INTEGER A C   by setting a bit if the variable is TRUE.  The following bits 1 C   are assigned to each variable (0 is the lsb):  C  C        0 - CLR_WINDOW  C        1 - GRIDS C        2 - YSQRT C        3 - YLOG  C        4 - DASHED  C 4       LOGICAL CLR_WINDOW, GRIDS, YSQRT, YLOG, DASHED C        ITEMP = 0 1       IF ( CLR_WINDOW ) ITEMP = IBSET( ITEMP, 0 ) 1       IF ( GRIDS      ) ITEMP = IBSET( ITEMP, 1 ) 1       IF ( YSQRT      ) ITEMP = IBSET( ITEMP, 2 ) 1       IF ( YLOG       ) ITEMP = IBSET( ITEMP, 3 ) 1       IF ( DASHED     ) ITEMP = IBSET( ITEMP, 4 )        IOPTIONS = ITEMP       RETURN	       END   G C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;        SUBROUTINE SENDINT( I )  C        INTEGER*2 ITMP       BYTE BTMP(2)       EQUIVALENCE (ITMP,BTMP)  C        ITMP = I       CALL TISTOR( BTMP(2) )       CALL TISTOR( BTMP(1) ) CC      WRITE(*,1000) I $  1000 FORMAT( ' INT  SENT = ', I10 )       RETURN	       END   G C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;        SUBROUTINE SENDREAL( X ) C A C  Here we hope that the VAX representation of a single precision C C  number is the same as that in the Atari under TDI Modula-2 whichC C  uses the IEEE standard. C_       REAL XTMPQ       INTEGER*4 ITMP       BYTE BTMP(4)*       EQUIVALENCE (XTMP,BTMP), (XTMP,ITMP) Ce       XTMP = X C B C  mantissa in TDI Modula-2/ST has to be two less than that on VAX Ce       IF ( X .NE. 0.0 ) THEN.         mantissa = iand( itmp, '0000077600'o ),         mantissa = mantissa - '0000000400'o *         itmp = iand(itmp, '37777700177'o )$         itmp = ior( itmp, mantissa )        ENDIF Ca C  now send the things C        CALL TISTOR( BTMP(2) )       CALL TISTOR( BTMP(1) )       CALL TISTOR( BTMP(4) )       CALL TISTOR( BTMP(3) ) CC      WRITE(*,1000) Xe'  1000 FORMAT( ' REAL  SENT = ', G13.6 )        RETURN	       END   G C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  C        SUBROUTINE INIPCKn Cs> C  initialize the routine that outputs packed cardinal numbers Cy       BYTE BCHR(4)(       COMMON /PACK97/ NPACK, IHIGH, BCHR Cl       NPACK = 0        IHIGH = 0h       DO 100 I = 1, 4          BCHR(I) = 0t   100 CONTINUE       RETURN	       END   F C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Cr       SUBROUTINE SENDPCARD( I )  C D C  send the integer I (0 <= I <= 1023) out to the terminal in packedE C  format - four cardinals in five characters.  First four characters E C  are just the lower bytes of the four cardinals.  The last byte has D C  the two high bits for each cardinal packed into it.  Bits 7,6 areA C  for the first word, bits 5,4 are for the second cardinal, etc.D CX       INTEGER*2 ITMP       BYTE BTMP(2), BCHR(4)a       EQUIVALENCE (ITMP,BTMP) (       COMMON /PACK97/ NPACK, IHIGH, BCHR C        NPACK = NPACK + 1        ITMP = I       BCHR(NPACK) = BTMP(1) $       IHIGH = 4*IHIGH + MOD(I/256,4) CC      WRITE(*,1000) I, NPACK?  1000 FORMAT( '  SEND PACKED CARD = ', I8, '    NPACK = ', I3 )L%       IF ( NPACK .EQ. 4 ) CALL CLRPCKn       RETURN	       ENDe  H C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; CT       SUBROUTINE CLRPCK  C = C   send the buffer with the packed cardinals to the terminal  C        INTEGER*2 ITMP       BYTE BCHR(4), BTMP(2)        EQUIVALENCE (ITMP,BTMP)d(       COMMON /PACK97/ NPACK, IHIGH, BCHR C         IF ( NPACK .EQ. 0 ) RETURN       IF ( NPACK .EQ. 1 ) THEN         IHIGH = 64*IHIGH#       ELSE IF ( NPACK .EQ. 2 ) THENn         IHIGH = 16*IHIGH#       ELSE IF ( NPACK .EQ. 3 ) THEN          IHIGH = 4*IHIGHu       ENDIFn Co       ITMP = IHIGH       DO 100 I = 1, 4          CALL TISTOR( BCHR(I) )   100 CONTINUE       CALL TISTOR( BTMP(1) ). CC      WRITE(*,1000) (BCHR(I),I=1,4), BTMP(1)  1000 FORMAT( 5X, 5I6 )  CI       NPACK = 0t       IHIGH = 0X       RETURN	       END   H C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Ce"       SUBROUTINE SENDSTR( STRING ) C E C  Send the string STRING to the terminal until we find end of string ( C  or until 80 characters have been sent Ce       CHARACTER*(*) STRING       BYTE TEMP  C        DO 100 I = 1, 80!         TEMP = ICHAR(STRING(I:I))          CALL TISTOR( TEMP )e#         IF ( TEMP .EQ. 0 ) GOTO 110e   100 CONTINUE C &   110 CONTINUE   ! found end of string       RETURN	       ENDE  J C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Cg       SUBROUTINE  INIT2D C   C  Set up for the routine SEND2D C        LOGICAL FIRST, GETZEROSA       INTEGER ZCOUNT, SAVE3       COMMON /PACK98/ FIRST, GETZEROS, SAVE, ZCOUNT  Cc       FIRST = .TRUE.       GETZEROS = .FALSE.       ZCOUNT = 0       RETURN	       ENDe  J C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Ct       SUBROUTINE SEND2D( NEW ) ChE C  Take the byte NEW and prepare it for transmission to the Atari.  Ak C  number of cases can exist:c C G C    1) FIRST = TRUE, then save NEW in SAVE, set FIRST FALSE and return E C       since we are packing two array locations per byte sent to thea
 C       Ataris CdE C    2) FIRST = FALSE and GETZEROS = FALSE.  Find the next byte to begF C       sent to the Atari using SAVE = 16*SAVE + NEW.  Now, if SAVE isD C       non-zero then send the byte using TISTOR and set FIRST TRUE.B C       BUT if it is zero, then set GETZEROS TRUE and ZCOUNT to 2. CuI C    3) FIRST = FALSE and GETZEROS = TRUE.  If NEW is zero then incrementmH C       ZCOUNT and RETURN (If ZCOUNT >= 250 then send a zero followed byG C       the count and set FIRST to TRUE and GETZEROS to FALSE).  If NEW E C       is nonzero then send a zero followed by ZCOUNT, then set SAVEX) C       to NEW and set GETZEROS to FALSE.T C        LOGICAL FIRST, GETZEROSL       INTEGER ZCOUNT, SAVE       BYTE NEW, BCOUNT, BSAVEB3       COMMON /PACK98/ FIRST, GETZEROS, SAVE, ZCOUNTQ!       EQUIVALENCE (BCOUNT,ZCOUNT)i       EQUIVALENCE (BSAVE,SAVE) Cc       IF ( FIRST ) THENs         SAVE = NEW         FIRST = .FALSE.R       ELSE IF ( GETZEROS ) THEN(         IF ( NEW .EQ. 0 ) THEN           ZCOUNT = ZCOUNT + 1 %           IF ( ZCOUNT .GE. 250 ) THENO             CALL TISTOR( 0 )!             CALL TISTOR( BCOUNT )              GETZEROS = .FALSE.             FIRST = .TRUE.            ENDIF         ELSE          CALL TISTOR( 0 )           CALL TISTOR( BCOUNT )          GETZEROS = .FALSE.t          SAVE = NEW 
         ENDIFO
       ELSE         SAVE = 16 * SAVE + NEW         IF ( SAVE .EQ. 0 ) THEN            GETZEROS = .TRUE.            ZCOUNT = 2         ELSE           CALL TISTOR( BSAVE )           FIRST = .TRUE.
         ENDIF        ENDIFi Co       RETURN	       END   I C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;M C)       SUBROUTINE  EMPTY2DX C A C  flush any zeros that remain to be sent from the SEND2D routineh Ci       LOGICAL FIRST, GETZEROS        INTEGER ZCOUNT, SAVE       BYTE BCOUNT, BSAVE3       COMMON /PACK98/ FIRST, GETZEROS, SAVE, ZCOUNTM!       EQUIVALENCE (BCOUNT,ZCOUNT)        EQUIVALENCE (BSAVE,SAVE) C        IF ( FIRST ) RETURNY C else we have more to send        IF ( GETZEROS ) THEN         CALL TISTOR( 0 )         CALL TISTOR( BCOUNT ) 
       ELSE         SAVE = 16 * SAVE         IF ( SAVE .EQ. 0 ) THENd           CALL TISTOR( 0 )           CALL TISTOR( 1 )         ELSE           CALL TISTOR( BSAVE )
         ENDIF        ENDIFR       RETURN	       ENDS CR? C    25-aug-87  added a flag so that multiple calls to TICTL don# C  not keep assigning system stuff.n C F C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; C  C SUBROUTINE TICTL (IFC) C  CO8 C SUBROUTINE PERFORMS VARIOUS GRAPHICS DISPLAY FUNCTIONS6 C ON THE ATARI ST EMULATING A VT640.  DIFFERS SLIGHTLY8 C FROM STRAIGHT 4010 IN THAT SOME CHARACTERS ARE ENCODED
 C SEE TISTOR.) CE C 7 C      IFC SPECIFIES A PLOTTING FUNCTION  1.LE.IFC.LE.5T CI C/ CL: C      SUBROUTINE "TICTL" IS A FORTRAN CALLABLE SUBROUTINE> C          USED WITH THE TEKTRONIX GRAPHICS DISPLAY TERMINALS.: C          THE SUBROUTINE CAN INITIALIZE THE TERMINAL FOR = C          GRAPHICS PLOTTING, SET THE TERMINAL TO ALPHA MODE,A? C          EMPTY THE OUTPUT BUFFER AND SEND IT TO THE TERMINAL,t< C          AND ERASE THE SCREEN.  ONCE THE TERMINAL HAS BEEN< C          INITIALIZED FOR GRAPHICS PLOTTING, USE SUBROUTINE> C          "TI4010" TO DIRECT THE TERMINAL INTO GRAPHICS MODE 6 C          AND SEND GRAPHICS COORDINATES FOR PLOTTING. Ci C 9 C          AN INITIAL CALL TO TICTL(1) IS REQUIRED BEFOREb9 C          USING ANY OTHER FUNCTIONS OF THE SUBROUTINE ORs/ C          BEFORE CALLING "TI4010" OR "TICURS".  C  C- CR CN? C    IFC = 1   INITIALIZE THE TERMINAL INPUT AND OUTPUT BUFFERS ? C              FOR GRAPHICS DISPLAY.  (THE TERMINAL WILL REMAIN = C              IN ALPHA MODE UNTIL A CALL TO TI4010 IS MADE.)M C < C    IFC = 2   EMPTY THE OUTPUT BUFFER AND ERASE THE SCREEN.> C              (ERASING THE SCREEN WILL RETURN THE TERMINAL TO C              ALPHA MODE.)  CE9 C    IFC = 3   RESET THE TERMINAL TO ALPHA MODE AND EMPTYP! C              THE OUTPUT BUFFER.  CE' C    IFC = 4   EMPTY THE OUTPUT BUFFER.; C;< C    IFC = 5   RESET THE TERMINAL TO ANSI MODE AND EMPTY THE C              OUTPUT BUFFER CE: C      TICTL USES LUN 5 FOR THE GRAPHICS TERMINAL GRAPHICS C      ASSIGNMENTS.  C  CA CT       SUBROUTINE TICTL (IFC) CO       CHARACTER*5 DELTASECS,C       INTEGER*4 SYS$ASSIGN,SYS$BINTIM,SYS$SETIMR,SYS$WAITFR,TT_CHANN       REAL*8 WAITSEC4       LOGICAL  FIRSTC     ! first call to TICTL(1) ?       INCLUDE '($IODEF)' C(       BYTE BSTORE,BBUFF <       COMMON /TIXXTI/MODE,BSTORE(4),IPOINT,BBUFF(72),TT_CHAN       DATA FIRSTC /.TRUE./ Ci Cd        GOTO (10,20,30,40,50), IFC CE Cs: C IFC=1; INITIALIZE  --  GET BUFFER ADDRESS, CLEAR ARRAYS, C        SET THE POINTERSE C     10 CONTINUE!       IF ( .NOT. FIRSTC ) GOTO 15 ,         ISTAT = SYS$ASSIGN ('TT', TT_CHAN,,)    12   DO 14 I=1,4e    14     BSTORE(I)='377'O         IPOINT=0         FIRSTC = .FALSE. Co    15 CONTINUE       MODE=0       CALL TISTOR( 31 )        RETURN Cp C39 C IFC=2; PUT CHARACTERS TO ERASE THE SCREEN IN THE OUTPUT 8 C        BUFFER AND SEND THE BUFFER.  WAIT 2 SECONDS FOR C        SCREEN TO ERASE.c Ch    20 CALL TISTOR(27)t       CALL TISTOR(12)a       CALL TIMPTY  CRGJ      DELTASECS='0 ::2' ? CRGJ      ISTAT = SYS$BINTIM (%DESCR(DELTASECS),%REF(WAITSECS)):7 CRGJ      ISTAT = SYS$SETIMR (%VAL(2),%REF(WAITSECS),,)0& CRGJ      ISTAT = SYS$WAITFR (%VAL(2))
       GOTO 12n Ch Co< C IFC=3; SET TERMINAL TO ALPHA MODE, EMPTY THE OUTPUT BUFFER Cb C MODE = 0 FOR ALPHA MODE  C     30 CALL TISTOR(31)y       CALL TIMPTYl       MODE = 0
       GOTO 12  C  C   C IFC=4; EMPTY THE OUTPUT BUFFER CX    40 CALL TIMPTYn       RETURN Co Ch; C IFC=5; SET TERMINAL TO ANSI MODE, EMPTY THE OUTPUT BUFFER  Ct    50 CALL TISTOR(24)        CALL TIMPTY        MODE = 0       RETURN	       ENDW  D C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; C2 C SUBROUTINE TISTOR (BCHR) C + C                         I M P O R T A N Te+ C                         =================E CEA C       This routine TRANSLATES the characters ^Q, ^S, and ^C!!!!o Ch C 9 C SUBROUTINE STORES BYTE DATA FOR GRAPHICS TERMINALS INTOt0 C A BUFFER AND SENDS THE BUFFER TO THE TERMINAL. C < C TO FORCE THE BUFFER TO BE EMPTIED, CALL THIS ROUTINE WITH  C THE ENTRY POINT TIMPTY C     ****************** C  C  C : C     BCHR  = CHARACTER TO BE STORED IN THE OUTPUT BUFFER. C  C < C      TISTOR STORES THE CHARACTER SENT IN THE ARGUMENT INTO? C         THE OUTPUT BUFFER. THE BUFFER IS SENT TO THE TERMINAL = C         WHEN 70 CHARACTERS HAVE BEEN PUT INTO THE BUFFER ORA C         WHEN TIMPTY IS CALLEDi Cf Co       SUBROUTINE TISTOR (BCHR) C        INTEGER*2 ISTATB(4)e!       INTEGER*4 SYS$QIOW,WRITEALLn       INCLUDE '($IODEF)' C  C        BYTE BSTORE,BBUFF,BCHR       INTEGER*4 TT_CHANd<       COMMON /TIXXTI/MODE,BSTORE(4),IPOINT,BBUFF(72),TT_CHAN       DATA ICARR/'000'O/ CY C!5 C ADD BCHR TO BUFFER AND RETURN IF BUFFER IS NOT FULL C C  With the atari we have to be careful about sending control-S andtB C  control-Q since these will be intercepted by the RS232 driver. F C  Therefore, instead of passing this characters I will pass a specialE C  flag character, ^C, followed by the character I want to pass ADDED E C  to '@'.  So, to pass a control-S I send ^C'S', to pass a control-Q : C  I send ^C'Q' and to pass a control-C (^C) I send ^C'C'.F C  This will all be transparent to someone sending characters out with C  the TISTOR routine. C A       IF ( (BCHR.EQ.17) .OR. (BCHR.EQ.19) .OR. (BCHR.EQ.3) ) THENe         IPOINT=IPOINT+1          BBUFF(IPOINT) = 3          IPOINT=IPOINT+1R!         BBUFF(IPOINT) = BCHR + 64i        ELSE          IPOINT=IPOINT+1r         BBUFF(IPOINT)=BCHR        ENDIF       IF(IPOINT.LT.70) RETURNl C        ENTRY TIMPTY C  C EMPTY THE BUFFER CI    10 IF(IPOINT.LT.1) RETURN/       WRITEALL = IO$_WRITEVBLK.OR.IO$M_NOFORMATr?       ISTAT = SYS$QIOW( ,%VAL(TT_CHAN),%VAL(WRITEALL),ISTATB,,,iA      $                   %REF(BBUFF),%VAL(IPOINT),,%VAL(ICARR),,)e Cs C  C  RESET POINTER C        IPOINT=0 CI C        RETURN	       ENDc  B C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; C $ C SUBROUTINE TIPONT (IIX,IIY,LWRITE) Ci C08 C VECTOR PLOTTING ON THE TEKTRONIX 4010 OR 4025 GRAPHICS. C DISPLAY TERMINALS WITH INTEGER COORDINATES : Ce C      0.LE.IIX.LE.1023e C      0.LE.IIY.LE.780 C  C C C   SUBROUTINE "TIPONT" DRAWS A DARK VECTOR TO (IIX,IIY) IF LWRITE=n; C   .FALSE. OR A LIGHT VECTOR TO (IIX,IIY) IF LWRITE=.TRUE.d Ct C (       SUBROUTINE TIPONT (IIX,IIY,LWRITE) Co       LOGICAL LWRITE       BYTE BSTORE,BBUFFN6       BYTE HIY,LOY,HIX,LOX,HIYSTR,LOYSTR,HIXSTR,LOXSTR C  C        INTEGER*4 TT_CHAN <       COMMON /TIXXTI/MODE,BSTORE(4),IPOINT,BBUFF(72),TT_CHAN C, CQ$       EQUIVALENCE (HIYSTR,BSTORE(1))$       EQUIVALENCE (LOYSTR,BSTORE(2))$       EQUIVALENCE (HIXSTR,BSTORE(3))$       EQUIVALENCE (LOXSTR,BSTORE(4)) C12 C CHECK FOR GRAPHICS MODE:  (LWRITE)=LIGHT VECTOR; C  (.NOT.LWRITE)=DARK VECTOR CO' C MODE=1 FOR GRAPHICS, MODE=0 FOR ALPHAO C9       IF(.NOT. LWRITE) GOTO 5        IF(MODE.EQ.1) GOTO 10      5 CALL TISTOR(29)        MODE=1 C  C  C CHECK FOR VALID INTEGERS CA    10 IX=IIX       IY=IIY       IF(IX.LT.0) IX=0       IF(IY.LT.0) IY=0       IF(IX.GT.1023) IX=1023       IF(IY.GT.780) IY=779 Ce Co' C CALCULATE HIGH AND LOW BYTE VALUES --E C"&       HIY=((IY/32.AND.'37'O).OR.'40'O)$       LOY=((IY.AND.'37'O).OR.'140'O)&       HIX=((IX/32.AND.'37'O).OR.'40'O)$       LOX=((IX.AND.'37'O).OR.'100'O) CW CR8 C COMPARE NEW BYTES WITH STORED BYTES FROM THE PREVIOUS 8 C COORDINATES AND SEND THE NECESSARY BYTES FOR NEW DATA. C (       IF(HIY.NE.HIYSTR) CALL TISTOR(HIY)       IF(HIX.EQ.HIXSTR) GOTO 20        CALL TISTOR(LOY)       CALL TISTOR(HIX)
       GOTO 30 :    20 IF (HIY.EQ.HIYSTR.OR.LOY.NE.LOYSTR) CALL TISTOR(LOY)    30 CALL TISTOR(LOX) Cn C  C PUT NEW BYTES INTO COMMON  C        HIYSTR=HIY       LOYSTR=LOY       HIXSTR=HIX       LOXSTR=LOX CM C)       RETURN	       ENDY  I C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;e C  C SUBROUTINE TICURS (X,Y,BCHR) C 9 C SUBROUTINE DISPLAYS CURSORS ON THE SCREEN AND READS THE(= C CHARACTER AND CURSOR COORDINATES WHEN A CHARACTER IS TYPED.s C  Ca: C          "TICURS" IS A FORTRAN CALLABLE SUBROUTINE WHICH9 C      HANDLES THE CURSOR INPUT AND OUTPUT OF A TEKTRONIXe6 C      4010 OR 4025 GRAPHICS TERMINAL.  THE SUBROUTINE: C      INITIALLY DISPLAYS THE CURSORS ON THE SCREEN.  WHEN= C      THE USER TYPES A CHARACTER AFTER THE CURSORS HAVE BEEN 9 C      POSITIONED, THE CHARACTER AND THE POINT WHERE THE 19 C      CURSORS INTERSECT ARE READ FROM THE TERMINAL.  THE 9 C      COORDINATES ARE RETURNED FROM "TICURS" AS X AND Y, 3 C      AND THE CHARACTER TYPED IS RETURNED AS BCHR.  C  C  Cs: C       X = THE X COORDINATE OF THE POINT ( 0.0 - 1023.0 ) CT9 C       Y = THE Y COORDINATE OF THE POINT ( 0.0 - 779.0 )  C 3 C       BCHR = THE CHARACTER TYPED ON THE TERMINAL.  CH C! CN> C       "TICURS" USES LUN 5 FOR GRAPHICS TERMINAL ASSIGNMENTS. C  C  C D C   23-jul-87 (rgj) Got rid of the no_echo option on the read.  WithD C             only a single control character in the trailer for theC C             ST640 I was not getting out of the ByPass mode of the @ C             VT640 since that control character was not echoed! C 2 C   12-aug-87 (rgj) BCHR is now always upper case. C "       SUBROUTINE TICURS (X,Y,BCHR) C        INTEGER*2 ISTATB(4)         INTEGER*4 SYS$QIOW,PASSALL       BYTE BSTORE,BBUFF,BCHR        BYTE HIX,LOX,HIY,LOY,NBYTE       INCLUDE '($IODEF)' C  CA       INTEGER*4 TT_CHANl<       COMMON /TIXXTI/MODE,BSTORE(4),IPOINT,BBUFF(72),TT_CHAN C "       EQUIVALENCE (NBYTE,BBUFF(1))        EQUIVALENCE (HIX,BBUFF(2))        EQUIVALENCE (LOX,BBUFF(3))        EQUIVALENCE (HIY,BBUFF(4))        EQUIVALENCE (LOY,BBUFF(5)) CN6 C  SEND THE CURSOR COMMAND SEQUENCE TO DISPLAY CURSORS- C  ON THE SCREEN AND EMPTY THE OUTPUT BUFFER.R CI       CALL TISTOR(27)        CALL TISTOR(26)W       CALL TIMPTY        PASSALL = IO$_TTYREADALL M>       ISTAT = SYS$QIOW( ,%VAL(TT_CHAN),%VAL(PASSALL),ISTATB,,,1      $                   %REF(BBUFF),%VAL(6),,,,)  C  CM- C  STORE THE FIRST BYTE (THE CHARACTER TYPED)  CX       BCHR=NBYTE.AND.'177'O .       IF ( (BCHR.GE.'a').AND. (BCHR.LE.'z') )        +   BCHR = BCHR - 'a' + 'A' Cs Cu< C  MASK OFF THE EXTRA BITS OF THE 2ND-5TH BYTES AND CONVERT  C  TO X & Y COORDINATES. CT       IX=HIX.AND.'37'O       IX=IX*32+(LOX.AND.'37'O)       IY=HIY.AND.'37'O       IY=IY*32+(LOY.AND.'37'O)
       X=IX
       Y=IY C  C  CLEAR COMMONf Cu       BSTORE(1)='377'O       BSTORE(2)='377'O       BSTORE(3)='377'O       BSTORE(4)='377'O CO CB       MODE = 0       RETURN	       ENDC  