       SUBROUTINE ATTACH(*)H C======================================================================CH C                                                                      CH C  ATTACH                                       F.W. Jones, TRIUMF     CH C                                                                      CH C  Similar to PUT_DCL.  ATTACH tries to find a subprocess and attach   CH C  the user to it.  If this fails, PUT_DCL is called, which tries to   CH C  attach/spawn in the usual way.                                      CH C                                                                      CH C  ATTACH can access subprocesses that were spawned by DCL or by a     CH C  previous image.  This is usually not possible with PUT_DCL, which   CH C  spawns a new subprocess each time it is invoked in a new image.     CH C  (PUT_DCL requires a PID for attachment, and this is generally       CH C  not known to the current image unless the subprocess was spawned    CH C  in the current image.)                                              CH C                                                                      CH C  Notes:                                                              CH C                                                                      CH C  1) Subprocesses owned by a user are always named {username}_1,      CH C     {username}_2, {username}_3, etc., in order of spawning,          CH C     even if they were spawned by different parent processes          CH C     (e.g. if the user is logged in at more than one terminal).       CH C                                                                      CH C  2) Special privilege is required to attach to subprocesses          CH C     spawned by another parent.                                       CH C                                                                      CH C  3) ATTACH looks for subprocesses _1 through _4 so at least one      CH C     of these must exist and have been spawned from the current       CH C     parent process for ATTACH to find it.                            CH C                                                                      CH C  4) ATTACH can be invoked from a subprocess to find another          CH C     subprocess.                                                      CH C                                                                      CH C  5) PUT_DCL defines a symbol RETURN for attaching to the parent      CH C     process again.  If ATTACH attaches to a subprocess that          CH C     was not originally spawned by PUT_DCL, this symbol will          CH C     not in general be defined, and the DCL ATTACH command            CH C     must be used to return to the invoking process.                  CH C                                                                      CH C======================================================================C C   #       CHARACTER*15 PRCNAM,SUBPRCNAM        CHARACTER*12 USRNAM -       CHARACTER*2 APP(4)/'_1','_2','_3','_4'/        INTEGER*4 ITEMLIST(4)        INTEGER*2 LENCOD(2) (       EQUIVALENCE(ITEMLIST(1),LENCOD(1))!       INTEGER*4 LPRC,LSUBPRC,LUSR        INCLUDE '($JPIDEF)' %       INTEGER*4 SYS$GETJPI,SYS$WAITFR  C  C  C==Get user name:        LENCOD(1)=12       LENCOD(2)=JPI$_USERNAME        ITEMLIST(2)=%LOC(USRNAM)       ITEMLIST(3)=%LOC(LUSR)       ITEMLIST(4)=0 &       ISTAT=SYS$GETJPI(,,,ITEMLIST,,,)       IF(.NOT.ISTAT)GO TO 603 C==USRNAM is padded with trailing blanks by GETJPI.        DO 20 I=12,1,-1 $       IF(USRNAM(I:I).NE.' ')GO TO 30 20    CONTINUE       GO TO 60 C  30    LUSR=I C # C==Loop to try to get a subprocess:        DO 40 I=1,4  C  C==Construct subprocess name: &       SUBPRCNAM=USRNAM(1:LUSR)//APP(I)       LSUBPRC=LUSR+2 C  C==Try to get PID:       ISUBPID=0        LENCOD(1)=4        LENCOD(2)=JPI$_PID       ITEMLIST(2)=%LOC(ISUBPID)        ITEMLIST(3)=%LOC(LPID)       ITEMLIST(4)=0 :       ISTAT=SYS$GETJPI(,,SUBPRCNAM(1:LSUBPRC),ITEMLIST,,,)       IF(.NOT.ISTAT)GO TO 403 C==Call is asynchronous ... wait for PID to be set.A       DO 35 K=1,10       CALL SLEEP(0.1)=       IF(ISUBPID.NE.0)GO TO 37 35    CONTINUE       GO TO 40 C  C==Try to attach:  37    ISTAT=LIB$ATTACH(ISUBPID)C       IF(ISTAT)GO TO 99  C  40    CONTINUE Cs C==No go: call PUT_DCL 60    CALL PUT_DCL(&999) C  99    RETURN C  C==Error return: 999   RETURN 1 CC	       ENDt