,       SUBROUTINE CHREAL(CH,NCH,REAL,NREAL,*) C  C  reqd. routines - NONE C < C THIS ROUTINE MUST BE IN PRV2:[KOST]LIB2.OLB AND IN LIB.OLB C D C===================================================================D C== This version of CHREAL uses the CHREAL_SCAN lexical scanner to==D C== perform the I/O conversion of an ASCII numeric string to a    ==D C== (single or double precision) real number. Due to the efficieny==D C== of operations used, this routine is approximately 30% faster  ==D C== than the CHREAL routine written by A. Haynes.                 ==D C== REAL*4 returned in REAL if NREAL=1                            ==D C== REAL*8 returned in REAL if NREAL=2                            ==D C===================================================================       IMPLICIT REAL*8 (A-H,O-Z)        LOGICAL*1 CH(1)        LOGICAL INIT/.TRUE./       REAL REAL4(2),REAL(2)        REAL*8 REAL8       EQUIVALENCE (REAL4,REAL8) D C===================================================================D C== Lexical scanner definitions (and actions) follow:             ==D C==                                                               ==D C== The following OUTPUT states are recognized:(CHREAL_CHIP array)==D C==   -2: Successful read, ILAST left alone                       ==D C==   -1: Successful read, ILAST= ILAST-1                         ==D C==    0: Conversion error on read                                ==D C==                                                               ==D C== The following ACTION states are recognized:(CHREAL_ACTION array)D C==    0(all even numbers): No action taken                       ==D C==    1: Accumulate integer portion of number                    ==D C==    3: Set sign                                                ==D C==    5: Accumulate decimal portion of number                    ==D C==    7: Accumulate integer exponent                             ==D C==    9: Set exponent sign                                       ==D C===================================================================        INTEGER*2 CHREAL_CHIP(8,8)<      # /-1,  0, -1,  0,  0, -1, -1,  0,   !End of line (EOL)=      #   0,  0,  0,  0,  0,  0,  0,  0,   !Invalid characters 0      #   1,  0, -1,  0,  0, -1, -1,  0,   !Blank2      #   0,  0,  5,  0,  0,  5,  0,  0,   !d,e,D,E.      #   3,  3,  3,  6,  7,  6,  7,  7,   !0-9<      #   4,  4,  6,  0,  0,  0,  0,  0,   !. (decimal point)-      #   2,  0,  0,  0,  8,  0,  0,  0,   !+- A      #  -2,  0, -2,  0,  0, -2, -2,  0/   !,TAB (non-blank deli.) "       INTEGER*2 CHREAL_ACTION(8,8)<      # / 0,  0,  0,  0,  0,  0,  0,  0,   !End of line (EOL)=      #   0,  0,  0,  0,  0,  0,  0,  0,   !Invalid characters 0      #   0,  0,  0,  0,  0,  0,  0,  0,   !Blank2      #   0,  0,  0,  0,  0,  0,  0,  0,   !d,e,D,E.      #   1,  1,  1,  5,  7,  5,  7,  7,   !0-9<      #   0,  0,  0,  0,  0,  0,  0,  0,   !. (decimal point)-      #   3,  0,  0,  0,  9,  0,  0,  0,   !+- A      #   0,  0,  0,  0,  0,  0,  0,  0/   !,TAB (non-blank deli.)  C       & C        S   S   I   D   S   R   R   E& C        t   i   n   e   t   e   e   x& C        a   g   t   c   a   a   a   p& C        r   n   e   i   r   l   l   o& C        t       g   m   t       +   n& C                e   a       n   e   e& C                r   l   e   u   x   n& C                        x   m   p   t" C                    p   p   b   o& C                    o   o   e   n   s& C                    i   n   r   e   i& C                    n   e       n   g& C                    t   n       t   n C                        tD C===================================================================       INTEGER*2 CTABLE(128) (       IF(INIT) CALL CHREAL_TABLE(CTABLE)       INIT= .FALSE. 2       CALL CHREAL_SCAN(CH,NCH,1,LEN,ISTATE,CTABLE,-      # CHREAL_CHIP,CHREAL_ACTION,8,REAL8,&90)        REAL(1)= REAL4(1) &       IF(NREAL.GE.2) REAL(2)= REAL4(2)       RETURN    90 RETURN 1	       END >       SUBROUTINE CHREAL_SCAN(INPUT,NINPUT,IFIRST,ILAST,ISTATE,=      #                  CTABLE,STABLE,ACTION,NSTATE,RESULT,*) A C================================================================ A C================================================================ A C==                                                            == A C==   CHREAL_SCAN: PERFORMS A LEXICAL SCAN OF THE "INPUT" ARRAY,= A C==         STARTING AT THE "IFIRST" LOCATION IN "INPUT", USING== A C==         THE TRANSITION TABLE "STABLE(NSTATE,NCLASS)".      == A C==         THE TOKEN WHICH SCAN RETURNS LIES WITHIN THE       == A C==         LOCATIONS "IFIRST" AND "ILAST" OF "INPUT".         == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.== A C==   Modified by Phil Bennett and Joe Chuma, August 7, 1984,  == A C==   to efficiently handle real number I/O conversion.        == A C==                                                            == A C==   INPUT  PARAMETERS: INPUT(NINPUT) (L*1,I*2,I*4,R*4,OR R*8);= A C==                      NINPUT,IFIRST,NSTATE (I*4);           == A C==                      CTABLE (USUALLY A 128 I*2 ARRAY);     == A C==                      STABLE(NSTATE,NCLASS) (I*2);          == A C==                      ACTION(NSTATE,NCLASS) (I*2).          == A C==                                                            == A C==   OUTPUT PARAMETERS: ILAST,ISTATE (I*4);                   == A C==                      RESULT (the REAL*8 converted number). == A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   INPUT : A L*1,I*2,I*4,R*4, OR R*8 ARRAY OF ELEMENTS TO BE== A C==           SCANNED FOR TOKENS (OR TERMS).                   == A C==                                                            == A C==   NINPUT: NUMBER OF ELEMENTS TO BE SCANNED IN "INPUT".     == A C==                                                            == A C==   IFIRST: FIRST LOCATION IN "INPUT" AT WHICH THE SCAN IS TO== A C==           START.                                           == A C==                                                            == A C==   ILAST : LAST LOCATION IN "INPUT" AT WHICH THE SCAN IS    == A C==           TERMINATED. THE TOKEN RETURNED BY SCAN LIES      == A C==           WITHIN THE LOCATIONS "IFIRST" AND "ILAST" OF     == A C==           "INPUT".                                         == A C==                                                            == A C==   ISTATE: OUTPUT STATE RETURNED BY SCAN WHICH CORRESPONDS  == A C==           TO THE TYPE OF TOKEN RETURNED. SEE "STABLE".     == A C==                                                            == A C==                                                            == A C==   CTABLE: IS USUALLY AN INTEGER*2 CLASS TABLE "CTABLE(128)".= A C==           IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A  == A C==           NUMERIC VALUE "ICHAR" IN THE RANGE               == A C==           0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS      == A C==           GIVEN BY "CTABLE(ICHAR+1)".                      == A C==                                                            == A C==   STABLE: LEXICAL SCANNER TRANSITION TABLE DIMENSIONED AS: == A C==           STABLE(NSTATE,NCLASS) WHERE "NSTATE" IS THE NUMBER= A C==           OF TRANSITION STATES AND "NCLASS" IS THE NUMBER  == A C==           OF "INPUT" ELEMENT CLASSES.                      == A C==           IF 1 <= "STABLE(ISTATE,ICLASS)" <= NSTATE THEN IT== A C==           IS A TRANSITION STATE.                           == A C==           IF "STABLE(ISTATE,ICLASS)" < 1 THEN IT IS AN     == A C==           OUTPUT STATE AND THE SCAN POINTER "ILAST" IS     == A C==           SHIFTED BY "CLASS" BACK BY 1.                    == A C==           IF "STABLE(ISTATE,ICLASS)" > NSTATE THEN IT IS AN== A C==           OUTPUT STATE AND THE SCAN POINTER IS NOT CHANGED.== A C==           THE VALUE OF THE OUTPUT STATE IS RETURNED BY     == A C==           "SCAN" IN "ISTATE".                              == A C==                                                            == A C==   NSTATE: NUMBER OF TRANSITION STATES.                     == A C==                                                            == A C==   ACTION: INTEGER*2 array of actions corresponding to the  == A C==           transitions in the table STABLE. If no action is == A C==           desired upon a particular transition (the usual  == A C==           situation) then a zero value should appear in the== A C==           corresponding position in the ACTION table.      == A C==           Actions to be taken should be indexed by positive== A C==           ODD numbers in the ACTION table (i.e. 1,3,5,7...).= A C==                                                            == A C==   RESULT: REAL*8 number returned as the converted value of == A C==           the input numeric string INPUT.                  == A C==                                                            == A C==   ALGORITHM USED BY "SCAN":                                == A C==   --------- ---- -- ------                                 == A C==                                                            == A C==   1) ILAST  <-- IFIRST - 1                                 == A C==                                                            == A C==   2) ISTATE <-- 1                                          == A C==                                                            == A C==   3) IF "ISTATE" IS AN OUTPUT STATE THEN RETURN.           ==UA C==      IF "ISTATE" IS AN ACTION STATE THEN PERFORM THE ACTION.= A C==                                                            ===A C==   4) ILAST  <-- ILAST + 1                                  == A C==                                                            ===A C==   5) ICLASS <-- CLASS("INPUT(ILAST)")                      == A C==                                                            ==eA C==   6) IF ACTION(ISTATE,ICLASS)  --> INDEX  --> do action    ==tA C==                                                            == A C==   7) ISTATE <-- STABLE(ISTATE,ICLASS)                      == A C==                                                            == A C==   8) GO TO 3).                                             ===A C==                                                            ==HA C================================================================ A C=================================================================       IMPLICIT REAL*8 (A-H,O-Z)=       REAL*8 RESULT,DIVi=       INTEGER*2 STABLE(NSTATE,1),ACTION(NSTATE,1),CTABLE(128)=+       INTEGER ICHAR/0/,EXP,SIGN,EXPSGN,IDIG        LOGICAL EXPRD !       LOGICAL*1 LCHAR(4),INPUT(1) "       EQUIVALENCE (ICHAR,LCHAR(1))A C================================================================ A C== Initialize the various accumulators needed for I/O conversion=A C================================================================        RESULT= 0.0D0        REAL= 0.0D0        DIV= 1.0D0       EXP= 0
       SIGN= 1n       EXPSGN= 1        EXPRD= .FALSE.A C================================================================ A C== Initialize end of field pointer ILAST and state flag ISTATE== A C================================================================        ILAST=IFIRST-1       ISTATE=1A C================================================================ A C== Main loop: check the current state and if this is a        == A C== transition state (i.e. the current field is not yet finished) A C== then proceed with the next input character; else end the   == A C== field and return.                                          == A C== If this is an output state, then the conversion of the     == A C== number is complete and so the final evaluation is done.    == A C================================================================ ,    10 WRITE(6,12) IFIRST,ILAST,ISTATE,ICLASS/    12 FORMAT(' CHREAL: IF,IL,STATE,CLASS=',4I5) B       IF(ISTATE.LT.0) THEN    !Output state: conversion completed +           IF(ISTATE .EQ. -1) ILAST= ILAST-1            IF(EXPRD) THEN:               RESULT= FLOAT(SIGN)*REAL*10.D0**(EXPSGN*EXP)           ELSE&               RESULT= FLOAT(SIGN)*REAL           ENDIF            WRITE(6,14) RESULT1    14     FORMAT(' CHREAL: *** RESULT= ',1PD12.4)            RETURN?       ELSE IF(ISTATE.EQ.0) THEN     !Error in converting number            WRITE(6,16) 1    16     FORMAT(' CHREAL: *** Conversion error')            RETURN 1       ENDIF A C================================================================ A C== If 1 <= ISTATE < NSTATE, then ISTATE is a transition state,== A C== and so the scan pointer ILAST is incremented by 1.         == A C================================================================        ILAST= ILAST+1A C================================================================ A C== If we've exceeded the length of the input line , i.e.      == A C== ILAST > NINPUT, then ICLASS=1 (EOL), otherwise deduce the  == A C== class of the current input character from the CTABLE array.== A C================================================================        IF(ILAST.GT.NINPUT) THEN           ICLASS=1
       ELSE            LCHAR(1)= INPUT(ILAST)!           ICLASS= CTABLE(ICHAR+1)        ENDIF A C================================================================ A C== Use the action table to flag necessary arithmetic actions  == A C== during the real number conversion.                         == A C== Note that the even integer values of ACTION (in particular == A C== the value 0) have a FALSE logical value, while the odds are== A C== TRUE. Therefore, actions corresponding to certain table    == A C== entries should be entered as 1,3,5... in the ACTION array, == A C== while a 0 should be entered if no action is desired.       == A C================================================================ ,       IF(.NOT.ACTION(ISTATE,ICLASS)) GOTO 50*       INDEX= (ACTION(ISTATE,ICLASS) + 1)/2       IDIG= ICHAR - 48&       GOTO (100,200,300,400,500),INDEXA C================================================================ A C== The appropriate actions necessary for the I/O conversion of== A C== the real number follow.                                    == A C================================================================ %   100 REAL= REAL*10.0D0 + FLOAT(IDIG) 
       GOTO 50 C   200 IF(ICHAR.EQ.45) SIGN=-1    !CHANGE SIGN IF "-"(ASCII 45)FOUND 
       GOTO 50    300 DIV= DIV*0.1D0"       REAL= REAL + FLOAT(IDIG)*DIV
       GOTO 50    400 EXP= EXP*10 + IDIG       EXPRD= .TRUE. 
       GOTO 50 6   500 IF(ICHAR.EQ.45) EXPSGN=-1    !CHANGE SIGN IF "-"       EXPRD= .TRUE. 
       GOTO 50 A C================================================================ A C== Use the transition table STABLE to evaluate the new state  == A C== given the present state ISTATE and class ICLASS.           == A C================================================================ "    50 ISTATE=STABLE(ISTATE,ICLASS)       GO TO 10	       END %       SUBROUTINE CHREAL_TABLE(CTABLE) A C================================================================ A C================================================================ A C==                                                            == A C== CHREAL_CTABLE: sets up the INTEGER*2 class table CTABLE(128)= A C==    for use with the CHREAL routine to convert numeric      == A C==    to REAL*8 (or REAL*4) values. This is performed using   == A C==    the lexical scanner CHREAL_CHIP with appropriate actions== A C==    performed during the scan to achieve the actual         == A C==    conversion.                                             == A C==                                                            == A C== INPUT PARAMETERS: NONE                                     == A C==                                                            == A C== OUTPUT PARAMETERS: CTABLE(128) (I*2)                       == A C==                                                            == A C== CTABLE IS RETURNED WITH THE FOLLOWING CLASS VALUES:        == A C==                                                            == A C==       CLASS       CHARACTERS                               == A C==                                                            == A C==          1      END OF LINE (off end of input record)      == A C==          2      invalid characters                         == A C==          3      BLANK                                      == A C==          4      D,E,d,e                                    == A C==          5      0-9                                        == A C==          6      .                                          == A C==          7      +-                                         == A C==          8      , TAB (non-blank delimiters)               == A C==                                                            == A C================================================================ A C================================================================        INTEGER*2 CTABLE(128)        LOGICAL*1 ARRAY(10)        CHARACTER*10 CHARR       EQUIVALENCE (CHARR,ARRAY) A C================================================================ A C== Initialize the CTABLE array to CLASS 2 which corresponds to== A c== any arbitrary character not included in the other classes. == A C================================================================        DO 20 I=1,128        CTABLE(I)=2     20 CONTINUEA C================================================================ A C== CLASS 3: BLANK                                             == A C================================================================        CHARR=' 'z       CTABLE(ARRAY(1)+1)=3A C================================================================ A C== CLASS 4: D,E,d,e                                           ===A C================================================================        CHARR='DEde'       DO 40 I=1,4n       CTABLE(ARRAY(I)+1)=4    40 CONTINUEA C================================================================9A C== CLASS 5: 0-9                                               ===A C================================================================        CHARR='0123456789'       DO 50 I=1,10       CTABLE(ARRAY(I)+1)=5    50 CONTINUEA C================================================================ A C== CLASS 6: .                                                 == A C================================================================P       CHARR='.'        CTABLE(ARRAY(1)+1)=6A C================================================================)A C== CLASS 7: +-                                                == A C================================================================)       CHARR='+-'       DO 70 I=1,2        CTABLE(ARRAY(I)+1)=7    70 CONTINUEA C================================================================ A C== CLASS 8: , TAB (non-blank delimiters)                      == A C=================================================================.       CTABLE(9+1)= 8             !TAB is X'09'       CHARR= ','       CTABLE(ARRAY(1)+1)= 8=       RETURN	       ENDM