.       SUBROUTINE CHSIZE(IOFF,NOLD,NEW,LTYPE,*)G C**********************************************************************  C 4 C  To assign storage space in the MAIN_STORAGE array C 	 C  INPUT:  C 7 C  IOFF:  The pointer to the existing location (if any)  C G C  NOLD:   The length (in "elements") of the array at the old location. 3 C          If NOLD=0, we assume this is a NEW array  C A C  NEW:    The length of the new array.  If NEW=0, then free this ( C          space but do not get any more C ? C  LTYPE:  The number of bytes/elements (eg LTYPE=4 for REAL*4)  C E C  ERROR RETURN: Various errors; descriptive messages will be printed  C                out.  C G C**********************************************************************        COMMON /X$/ R$8 A       COMMON /TABLE$/ MAXTABLE,NTABLE,IEXIST,IVEC,IADDRESS,IBYTES        LOGICAL*1 L$1(1)       INTEGER I$4(1)       REAL*8 R$8(1) (       EQUIVALENCE (I$4(1),L$1(1),R$8(1))G C********************************************************************** F C  Check Master Table if IOFF passed with old size NOLD > 0, to verifyE C  that a consistent Table entry exists. If NOLD = 0 then a new array 4 C  is being created and this check is not necessary.G C**********************************************************************        IF(NOLD.GT.0) THEN           DO 10 I=1,NTABLE
           K=I *           IF(.NOT.(L$1(IEXIST+I))) GOTO 10+           IF(IOFF .EQ. I$4(IVEC+I)) GOTO 20     10     CONTINUE? C************************************ Can't find the entry IOFF            WRITE(6,15) D    15     FORMAT('0*** Error in CHSIZE: this array is not recorded')           RETURN 1E C*********************** Found the entry: check size agrees with NOLD      20     NBYTES_OLD= NOLD*LTYPE0           IF(NBYTES_OLD .NE. I$4(IBYTES+K)) THEN               WRITE(6,30) H    30         FORMAT('0*** Error in CHSIZE: Table entry, NOLD disagree')               RETURN 1           END IF       END IF       IF(NOLD-NEW)100,200,300 G C********************************************************************** 
 C  NEW > NOLD G C********************************************************************** % C  If NOLD = 0, this is a NEW entry.  6 C  If NOLD > 0, then destroy the old and create a new.G C**********************************************************************  100   IF(NOLD.EQ.0)THEN -           CALL GET_ARRAY(IOFF,LTYPE,NEW,&900)            RETURN
       ELSE1           CALL GET_ARRAY(IOFF_NEW,LTYPE,NEW,&900)             IOFF_BYTES= IOFF*LTYPE(           IOFF_NEW_BYTES= IOFF_NEW*LTYPE           NBYTES= NOLD*LTYPED           CALL COPY_ARRAY( L$1(IOFF_BYTES+1), L$1(IOFF_NEW_BYTES+1),      #     NBYTES)#           CALL DEL_ARRAY(IOFF,&900)            IOFF= IOFF_NEW           RETURN       END IFG C**********************************************************************  C  NEW = NOLD  Do nothing G C**********************************************************************  200   RETURNG C********************************************************************** 
 C  NEW < NOLD G C**********************************************************************  C  If NEW = 0, just destroy ! C  If NEW > 0, destroy and create G C**********************************************************************  300   IF(NEW.EQ.0)THEN#           CALL DEL_ARRAY(IOFF,&900)            RETURN
       ELSE1           CALL GET_ARRAY(IOFF_NEW,LTYPE,NEW,&900)             IOFF_BYTES= IOFF*LTYPE(           IOFF_NEW_BYTES= IOFF_NEW*LTYPE           NBYTES= NEW*LTYPE D           CALL COPY_ARRAY( L$1(IOFF_BYTES+1), L$1(IOFF_NEW_BYTES+1),      #     NBYTES)#           CALL DEL_ARRAY(IOFF,&900)            IOFF= IOFF_NEW           RETURN       END IF
 900   RETURN1 	       END 