@        SUBROUTINE CIRCLE_CO(N,X,Y,W,A,B,R,VAR,RES,NOSTAT,KODERR) C J C ************************************************************************J C *    From "Fast Program for Circle Fitting" by N.I. Chernov and        *J C *         G.A. Ososkov. TRIUMF PP 87-1408                              *J C *     Collection of Scientific Papers in Collaboration with Joint      *J C *     Institute for Nuclear Research, Dubna, USSR and Central Research *J C *     Institute for Physics, Budapest, Hungary.                        *J C *     Algorithms and Programs for solution of some problems in Physics *J C *                        Fifth Volume                                  *J C *                                                                      *J C *    FAST PROCRAM FOR CIRCLE FITTING WEIGHTED LEAST SQUARE METHOD      *J C *                                                                      *J C *    INPUT DATA:  THE SET OF MEASURED POINTS AND THEIR WEIGHTS.        *J C *    N - THE NUMBER OF POINTS, X(I),Y(I) - THEIR COORDINATES,          *J C *    W(I) - THEIR WEIGHTS.                                             *J C *                                                                      *J C *    OUTPUT DATA:  THE CIRCLE PARAMETERS AND THE RESIDUAL VECTOR.      *J C *    A,B - THE COORDINATES OF THE CENTER, R - THE RADIUS,              *J C *    RES(I) - THE RESIDUAL VECTOR, VAR - THE ESTIMATE OF VARIANCE.     *J C *                                                                      *J C *    SETUP NOSTAT=1 STOPS EVALUATING THE STATISTICS VAR, RES.          *J C *    FOR 32-BIT COMPUTERS EXCLUDE ALL DOUBLE PRECISION DECLARA-        *J C *    TIONS AND REPLACE DSQRT BY SQRT, DABS BY ABS AND FORMAT D         *J C *    BY FORMAT E IN THE DATA STATEMENT.                                *J C *                                                                      *J C *    ERROR DIAGNOSTIC: KODERR=0 IF NO ERRORS HAVE BEEN DETECTED,       *J C *    KODERR=1 IF THE NUMBER OF POINTS WITH POSITIVE WEIGHTS IS         *J C *             LESS THAN 3 (THE CIRCLE CANNOT BE RESTORED),             *J C *    KODERR=2 IF THE POINTS LIE ALONG A STRAIGHT LINE, I.E. R          *J C *             MUST BE INFINITE, SO YOU MAY TRY TO APPROXIMATE          *J C *             THESE POINTS BY A LINEAR FUNCTION Y=P*X+Q,               *J C *    KODERR=3 IF NEWTON'S ITERATIONAL PROCESS FOR SOLVING THE          *J C *             EQUATION HAVE DIVERGED (IN THIS CASE THE PARAMETERS      *J C *             A,B,R WILL BE ESTIMATED TOO, BUT WITH LOSS OF ACCURACY). *J C ************************************************************************ C D        DOUBLE PRECISION XX,YY,XY,F,G,H,P,Q,T,GAMIN,GAM,FACT,DET,EPS,C      ,                 A0,A1,A2 A22 XA,YA,XB,DY,C1,C2,C3,C4,C12,SUM -        DIMENSION X(N),Y(N),W(N),RES(N),SUM(6) 7        EQUIVALENCE (XX,SUM(1)),(YY,SUM(2)),(XY,SUM(3)), 2      ,            (P,SUM(4)),(Q,SUM(5)),(T,SUM(6))0        DATA C1/1.D0/,C2/2.D0/,C3/3.D0/,C4/4.D0/,       ,     EPS/1.D-12/,ITMAX/20/ C        KODERR=0I C----------------------- CLEAR ACCUMULATORS -----------------------------        NPOS=0
       SUMW=0. 
       XCEN=0. 
       YCEN=0.        SUMRES=0.        DO 1 K=1,6    1  SUM(K)=0I C------------------ CALCULATE THE CENTER OF GRAVITY ---------------------        DO 2 I=1,N          XCEN=XCEN+X(I)*W(I)          YCEN=YCEN+Y(I)*W(I)          SUMW=SUMW+W(I) %          IF (W(I).GT.EPS) NPOS=NPOS+1     2  CONTINUE       XCEN=XCEN/SUMW       YCEN=YCEN/SUMW C        IF (NPOS.LE.2) KODERR=1        IF (NPOS.LE.2) GO TO 9 C J C---------------- CALCULATE THE GAUSS-BRACKET VALUES ---------------------       DO 3 I=1,N          XI=X(I)-XCEN           YI=Y(I)-YCEN           DI=XI**2+YI**2           XX=XX+XI*XI*W(I)           YY=YY+YI*YI*W(I)           XY=XY+XI*YI*W(I)           P=P+XI*DI*W(I)           Q=Q+YI*DI*W(I)           T=T+DI*DI*W(I)     3  CONTINUE C        DO 4 K=1,6    4  SUM(K)=SUM(K)/SUMW C K C--------------- CALCULATE THE EQUATION COEFFICIENTS ----------------------        F=C3*XX+YY       G=C3*YY+XX
       H=XY+XY        GAMIN=XX+YY         IF (GAMIN.LT.EPS) KODERR=2       IF (GAMIN.LT.EPS) GO TO 9  C        FACT=GAMIN*GAMIN       A2=(F*G-H*H-T)/FACT        A22=A2+A2        FACT=FACT*GAMIN $       A1=(T*(F+G)-C2*(P*P+Q*Q))/FACT       FACT=FACT*GAMIN 5       A0=(T*(H*H-F*G)+C2*(P*P*G+Q*Q*F)-C4*P*Q*H)/FACT  C K C-------------- SOLVE THE EQUATION BY NEWTON'S METHOD ---------------------        XA=C1        ITER=0    5  ITER=ITER+1 &       YA=A0+XA*(A1+XA*(A2+XA*(XA-C4)))#       DY=A1+XA*(A22+XA*(C4*XA-C12)) "       IF (DABS(DY).LT.EPS) GO TO 6       XB=XA-YA/DY        IF (XB.LT.EPS) GO TO 6%       IF (DABS(XA-XB).LT.EPS) GO TO 7        XA=XB         IF (ITER.LT.ITMAX) GO TO 5    6  XB=C1        KODERR=3K C---------------- CALCULATE THE CIRCLE PARAMETERS -------------------------     7  GAM=GAMIN*XB       DET=(F-GAM)*(G-GAM)-H*H $       IF (DABS(DET).LT.EPS) KODERR=2#       IF (DABS(DET).LT.EPS) GO TO 9  C        A=(P*(G-GAM)-Q*H)/DET        B=(Q*(F-GAM)-P*H)/DET        R=DSQRT(GAM+A*A+B*B)       A=A+XCEN       B=B+YCEN       IF (NOSTAT.EQ.1) GO TO 9 C K C----------------- CALCULATE THE RESIDUAL VECTOR --------------------------        RR=R*R
       R2=R*C2        DO 8 I=1,N/          RES(I)=((X(I)-A)**2+(Y(I)-B)**2-RR)/R2 %          SUMRES=SUMRES+RES(I)**2*W(I)     8  CONTINUE C K C-------------------- ESTIMATE THE VARIANCE -------------------------------        VAR=SUMRES/SUMW     9  RETURN	       END 