1       SUBROUTINE CLASS(INPUT,NINPUT,ILAST,ISTATE, 3      *                 NSTATE,CTABLE,ICLASS,RETURN) A C================================================================ A C================================================================ A C==                                                            == A C==   CLASS: ROUTINE USED BY "SCAN" WHICH TAKES ACTION ON EACH == A C==          STATE "ISTATE" ENCOUNTERED DURING THE LEXICAL SCAN== A C==          AND WHICH RETURNS THE CLASS "ICLASS" OF THE NEXT  == A C==          CHARACTER (ILAST+1'TH CHARACTER) IN "INPUT".      == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.== A C==                                                            == A C==   INPUT  PARAMETERS: INPUT(NINPUT) (L*1); NINPUT,ILAST,    == A C==                      ISTATE,NSTATE (I*4); CTABLE(256) (I*2).= A C==                                                            == A C==   OUTPUT PARAMETERS: ILAST,ICLASS (I*4); RETURN (L*1).     == A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   INPUT : LOGICAL*1 ARRAY OF CHARACTERS TO BE SCANNED FOR  == A C==           TOKENS (OR TERMS).                               == A C==                                                            == A C==   NINPUT: TOTAL NUMBER OF CHARACTERS IN "INPUT".           == A C==                                                            == A C==   ILAST : IS AN I/O PARAMETER WHICH KEEPS TRACK OF THE     == A C==           CURRENT CHARACTER IN "INPUT" BEING SCANNED. ON   == A C==           INPUT TO "CLASS" "ILAST" POINTS TO THE LAST      == A C==           CHARACTER LOOKED AT BY "CLASS". "CLASS" WILL THEN== A C==           INCREMENT "ILAST" BY 1.                          == A C==                                                            == A C==   ISTATE: IS AN INPUT PARAMETER WHICH TELLS "CLASS" THE    == A C==           CURRENT STATE OF THE SCAN.                       == A C==           IF 1 <= ISTATE <= NSTATE THEN IT IS A TRANSITION == A C==           STATE AND "CLASS" INCREMENTS THE SCAN POINTER    == A C==           "ILAST" BY 1 AND RETURNS THE CLASS "ICLASS" OF   == A C==           THE NEXT CHARACTER IN "INPUT".                   == A C==           IF ISTATE < 1 THEN IT IS AN OUTPUT STATE AND THE == A C==           SCAN POINTER "ILAST" IS SHIFTED BY "CLASS" BACK  == A C==           BY 1, "ICLASS" IS NOT RETURNED, AND "RETURN" IS  == A C==           SET ".TRUE.".                                    == A C==           IF ISTATE > NSTATE THEN IT IS AN OUTPUT STATE AND== A C==           THE SCAN POINTER "ILAST" IS NOT CHANGED, "ICLASS"== A C==           IS NOT RETURNED, AND "RETURN" IS SET ".TRUE.".   == A C==                                                            == A C==   NSTATE: NUMBER OF TRANSITION STATES.                     == A C==                                                            == A C==   CTABLE: IS AN INTEGER*2 CLASS TABLE "CTABLE(256)".       == A C==           IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A  == A C==           NUMERIC VALUE "ICHAR" IN THE RANGE               == A C==           0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS      == A C==           GIVEN BY "CTABLE(ICHAR+1)".                      == A C==                                                            == A C==   ICLASS: CLASS OF THE NEXT CHARACTER IN "INPUT" RETURNED  == A C==           BY SUBROUTINE "CLASS" WHEN 1 <= ISTATE <= NSTATE.== A C==           THE CLASS VALUES ARE GOVERNED BY THE CLASS TABLE == A C==           "CTABLE(256)". SEE "CTABLE" ABOVE.               == A C==                                                            == A C==   RETURN: IS A L*1 FLAG WHICH TELLS THE ROUTINE (SCAN)     == A C==           CALLING "CLASS" TO RETURN IF "RETURN"=.TRUE.     == A C==           "RETURN" IS SET .TRUE. WHEN "ISTATE" IS AN OUTPUT==AA C==           STATE, OTHERWISE IT IS SET .FALSE.               ==EA C==                                                            ===A C=================================================================A C================================================================        INTEGER*2 CTABLE(256):       INTEGER   ICHAR/0/(       LOGICAL*1 INPUT(1),LCHAR(4),RETURN"       EQUIVALENCE (ICHAR,LCHAR(1))       RETURN=.FALSE.A C=================================================================A C==   IF "ISTATE" < 1 THEN GO TO 40.                           ===A C==   IF "ISTATE" > NSTATE THEN GO TO 50.                      ===A C=================================================================       IF(ISTATE)40,40,10" 10    IF(ISTATE.GT.NSTATE)GO TO 50A C=================================================================A C==   1 <= ISTATE <= NSTATE: I.E. ISTATE IS A TRANSITION STATE.==.A C==   INCREMENT THE SCAN POINTER "ILAST" BY 1.                 ===A C==   IF WE'VE ENCOUNTERED THE END OF THE INPUT STRING, I.E.   ===A C==   "ILAST" > "NINPUT" THEN GO TO 30.                        ===A C==   OTHERWISE RETURN THE CLASS OF THE CHARACTER "INPUT(ILAST)"==A C==   IN "ICLASS".                                             ===A C==   GIVEN THE 1 BYTE CHARACTER: INPUT(ILAST) WE CAN DETERMINE===A C==   ITS NUMERIC VALUE "ICHAR" WHICH LIES WITHIN THE RANGE:   ===A C==   0 <= ICHAR <= 255. THE CLASS OF THE CHARACTER            ===A C==   "INPUT(ILAST)" IS THEN GIVEN BY "CTABLE(ICHAR+1)".       ===A C==                                                            ===A C==   REQD. ROUTINES - NONE                                    ===A C=================================================================       ILAST=ILAST+1R!       IF(ILAST.GT.NINPUT)GO TO 30N       LCHAR(1)=INPUT(ILAST)N       ICLASS=CTABLE(ICHAR+1)       RETURNA C================================================================TA C==   "ILAST" > "NINPUT".                                      == A C================================================================  30    ICLASS=1       RETURNA C================================================================ A C==   ISTATE < 1: OUTPUT STATE. DECREMENT "ILAST" BY 1.        == A C================================================================N 40    ILAST=ILAST-1TA C================================================================CA C==   ISTATE > NSTATE: RETURN.                                 ==.A C================================================================U 50    RETURN=.TRUE.        RETURN	       ENDT