(       SUBROUTINE CLEAR_LINE_R(X,Y,NCHAR) C $ C  reqd. KOSTL: routines - PLTALPHAR C C C================================================================== C C================================================================== C C==                                                              == C C==   CLEAR_LINE_R: clears a line of "NCHAR" characters starting == C C==               at the plot coordinates (X,Y) on the screen.   == C C==               This subroutine only works for the VT640 alpha == C C==               graphics mode, since the VT640 has a deletive  == C C==               backspace. (The "BS" option should be set in   == C C==               the VT640 local mode before using this routine).= C C==               If (X,Y) is off the screen then the last       == C C==               location referenced by either "CLEAR_LINE" or  == C C==               "PLOT_ALPHA" will be used, (if neither have    == C C==               been referenced then (0,0) will be used).      == C C==               Once the line has been cleared, the graphics   == C C==               cursor is left at the location (X,Y), i.e. at  == C C==               the beginning of the line. The user can then   == C C==               write text to this location provided he uses   == C C==               a "+" fortran carriage control at the beginning== C C==               of his text.                                   == C C==               Note: CLEAR_LINE does not behave properly (i.e.== C C==               will not clear the line and will not end up at == C C==               the beginning of the line (X,Y)) if "NCHAR"    == C C==               causes the line to extend off the end of the   == C C==               screen. If (X,Y) is on the left hand margin    == C C==               of a VT640 terminal then "NCHAR" = 70 will fit == C C==               on the screen.                                 == C C==                                                              == C C==   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.     == C C==                                                              == C C==   Input  Parameters: X,Y,NCHAR (R*4).                        == C C==                                                              == C C================================================================== C C================================================================== *       COMMON /PLOT_MONITOR/ IMONITOR,IOUTM       DATA IMONITOR,IOUTM/1,6/-       COMMON /PLOT_MONITOR2/ IMONITOR2,IOUTM2         DATA IMONITOR2,IOUTM2/0,6/ C      LOGICAL*1 BS/Z08/       LOGICAL*1 BS/Z7F/ C C================================================================== C C==   If the monitor is non-existent or a VS11 then GO TO 100.   == C C================================================================== .       IF((IMONITOR.EQ.0.OR.IMONITOR.EQ.3).AND.2      *   (IMONITOR2.EQ.0.OR.IMONITOR2.EQ.3))RETURNC C================================================================== C C==   Position the graphics cursor at (X,Y).                     == C C==================================================================        CALL PLOT_ALPHA_R(X,Y)C C================================================================== C C==   Write out "NCHAR" blanks starting at location (X,Y).       == C C==   This does not clear the line. It only positions the        == C C==   graphics cursor at the end of the line.                    == C C================================================================== )       IF(IMONITOR.NE.0.AND.IMONITOR.NE.3) '      *   WRITE(IOUTM,10)(' ',I=1,NCHAR)  10    FORMAT('+',$,255A1) +       IF(IMONITOR2.NE.0.AND.IMONITOR2.NE.3) (      *   WRITE(IOUTM2,10)(' ',I=1,NCHAR)C C================================================================== C C==   Write out "NCHAR" deletive backspaces. This clears the     == C C==   preceding "NCHAR" characters of the line and positions the == C C==   graphics cursor at the beginning of the line.              == C C================================================================== )       IF(IMONITOR.NE.0.AND.IMONITOR.NE.3) &      *   WRITE(IOUTM,20)(BS,I=1,NCHAR) 20    FORMAT('+',255A1) +       IF(IMONITOR2.NE.0.AND.IMONITOR2.NE.3) '      *   WRITE(IOUTM2,20)(BS,I=1,NCHAR) C C================================================================== C C==   Position the graphics cursor at (X,Y).                     == C C==================================================================        CALL PLOT_ALPHA_R(X,Y)       RETURN	       END 